# -*- coding: UTF-8 -*-
import cliUtil
import common

LANG = common.getLang(py_java_env)
LOGGER = common.getLogger(PY_LOGGER, __file__)

def execute(cli):
    '''
        远程LUN状态检查： 
        Health Status为Normal表示正常，其它情况均属于不正常状态。
    '''
    flag = True
    cliRet = ""
    errMsg = ""

    try:
        cmd = "show remote_lun status|filterRow column=Health\sStatus predict=not predict2=equal_to value=Normal"
        LOGGER.logExecCmd(cmd)
        checkRet = cliUtil.excuteCmdInDeveloperMode(cli, cmd, True, LANG)
        if checkRet[0] != True:
            LOGGER.logSysAbnormal()
            return checkRet
        
        cliRet = checkRet[1]
        if cliUtil.queryResultWithNoRecord(cliRet):
            return (True, cliRet, errMsg)
        
        cliRetLinesList = cliUtil.getHorizontalCliRet(cliRet)
        if len(cliRetLinesList) == 0:
            flag = False
            errMsg = common.getMsg(LANG, "cannot.get.remote.lun.info")
            LOGGER.logNoPass("Cannot get information about remote LUN")
            
        elif len(cliRetLinesList) > 0:
            flag = False
            errMsg = common.getMsg(LANG, "remote.lun.status.abnormal")
            LOGGER.logNoPass("The status of remote LUN is abnormal")
            
        if flag:
            LOGGER.logPass()
            
        return (flag, cliRet, errMsg)
        
    except Exception, exception:
        LOGGER.logException(exception)
        return (cliUtil.RESULT_NOCHECK, cliRet, common.getMsg(LANG, "query.result.abnormal"))
