# -*- coding: UTF-8 -*-
import cliUtil
import common
from cbb.frame.cli.cli_with_cache import execute_cmd_in_cli_mode_with_cache

LANG = common.getLang(py_java_env)
LOGGER = common.getLogger(PY_LOGGER, __file__)

def execute(cli):
    '''
        快照健康状态检查：
        1 如果快照不存在表示正常；
        2 Health Status为Normal表示正常；
        3 其它情况均属于不正常状态。
    '''
    flag = True
    cliRet = ""
    errMsg = ""

    try:
        cmd = "show snapshot general"
        flag, cli_ret, err_msg = execute_cmd_in_cli_mode_with_cache(
            py_java_env, cli, cmd, LOGGER)

        if flag is not True:
            return flag, cli_ret, err_msg
        
        if cliUtil.queryResultWithNoRecord(cli_ret):
            return True, cli_ret, errMsg
        
        cli_ret_list = cliUtil.getHorizontalNostandardCliRet(cli_ret)
        if len(cli_ret_list) == 0:
            err_msg = common.getMsg(LANG, "cannot.get.snapshot.info")
            LOGGER.logNoPass("Cannot get information about snapshot")
            # 修改备注：解析回显失败导致列表长度为0
            return cliUtil.RESULT_NOCHECK, cli_ret, err_msg

        err_msg_list = []
        for line in cli_ret_list:
            id = line.get("ID")
            heal_status = line.get("Health Status")
            if heal_status != common.STATUS_NORMAL:
                err_msg_list.append(
                    common.getMsg(LANG, "snapshot.health.status.abnormal",
                                  (id, heal_status)))
                LOGGER.logNoPass("snapshot [%s] is abnormal Status:%s)"
                                 % (id, heal_status))
                
        if err_msg_list:
            return False, cli_ret, "".join(err_msg_list)
            
        return True, cli_ret, ""
        
    except Exception, exception:
        LOGGER.logException(exception)
        return (cliUtil.RESULT_NOCHECK, cliRet, common.getMsg(LANG, "query.result.abnormal"))
