# -*- coding: UTF-8 -*-
import cliUtil
import common
from common import UnCheckException
import common_cache
from cbb.frame.cli import cliUtil as cbb_cliUtil

LANG = common.getLang(py_java_env)
LOGGER = common.getLogger(PY_LOGGER, __file__)
PY_JAVA_ENV = py_java_env

CHECK_REPHC_PAIR_CONSISTENCE = {
    "6.0.0": "",
    "6.0.1": "",
    "6.1.0": "",
    "6.1.2": "",
}


def execute(cli):
    """
    @summary:
        步骤1 以admin用户登录设备；
        步骤2 在本端执行 show hyper_metro_pair general|filterColumn include columnList=ID,Consistency\\sGroup\\sID，
             获取本端双活Pair的归属一致性组信息；
        步骤3 在远端执行 show hyper_metro_pair general|filterColumn include columnList=ID,Consistency\\sGroup\\sID，
             获取双活Pair的归属一致性组信息；
        步骤4 对比本端和远端双活Pair的一致性组归属情况。

        1、若步骤2中不存在双活Pair信息，则检查结果为通过，否则继续检查；
        2、若步骤2中双活Pair的归属一致性组与步骤3中双活pair的归属一致性组完全一致，则检查结果为通过，否则检查结果为不通过。
    """
    all_cli_ret = []
    notpasserrmsg = []

    tmp_msg = common.getMsg(LANG, "check.pass")
    try:
        # 校验当前补丁版本是否需要检查
        flag, p_version, p_patch, cli_ret = cbb_cliUtil.get_system_version_with_ret(cli, LANG)
        if not is_lun_check_version_and_patch(p_version):
            return True, cli_ret, tmp_msg
        all_cli_ret.append(cli_ret)
        local_dev_sn = PY_JAVA_ENV.get("devInfo").getDeviceSerialNumber()

        # 检查是否有双活Domain域
        domain_dict, all_cli_ret = get_domain_info(local_dev_sn, all_cli_ret)
        LOGGER.logInfo("isRisk domain_dict: %s, " % domain_dict)
        if not domain_dict:
            return True, "\n".join(all_cli_ret), ''

        # 检查是否添加了远端设备
        flag, addedsnlist, errmsg = common.checkAddedRemoteDevSn(PY_JAVA_ENV, LANG)
        if flag is not True:
            return cliUtil.RESULT_NOCHECK, "\n".join(all_cli_ret), errmsg
        LOGGER.logInfo("checkAddedRemoteDevSn addedsnlist:%s" % addedsnlist)

        domain_remote_dev_dict, all_cli_ret = get_remote_device_info(local_dev_sn, domain_dict, all_cli_ret)
        LOGGER.logInfo("domain_remote_dev_dict :%s" % domain_remote_dev_dict)
        for domain_id in domain_remote_dev_dict:
            remote_dev_sn = domain_remote_dev_dict[domain_id]
            all_cli_ret.append("ON LOCAL DEVICE(SN:%s)" % local_dev_sn)
            pair_id_list, all_cli_ret = gethypermetropairidlist(local_dev_sn, domain_id, all_cli_ret)
            if not pair_id_list:
                continue

            pair_local_to_remote = get_consistency_list(pair_id_list)

            all_cli_ret.append("ON REMOTE DEVICE(SN:%s)" % remote_dev_sn)
            remote_pair_id_list, all_cli_ret = gethypermetropairidlist(remote_dev_sn, domain_id, all_cli_ret)
            pair_remote_to_local = get_consistency_list(remote_pair_id_list)

            LOGGER.logInfo("get_consistency_list addedsnlist:%s" % pair_local_to_remote)
            err_consistance, err_pair_id = check_pair_consistency(pair_local_to_remote, pair_remote_to_local)
            if err_consistance:
                notpasserrmsg += err_pair_id

        if notpasserrmsg:
            LOGGER.logInfo(notpasserrmsg)
            tmp_msg = common.getMsg(LANG, "check_rephc_pair_consistence", ','.join(notpasserrmsg))
            LOGGER.logInfo(tmp_msg)
            return False, "\n".join(all_cli_ret), tmp_msg

        # 检查通过
        return True, "\n".join(all_cli_ret), tmp_msg

    except Exception as exception:
        LOGGER.logException(exception)
        return (cliUtil.RESULT_NOCHECK, "\n".join(all_cli_ret),
                common.getMsg(LANG, "query.result.abnormal"))


def check_pair_consistency(pair_local_to_remote, pair_remote_to_local):
    err_consistance = []
    err_pair_id = []
    if not pair_remote_to_local or not pair_local_to_remote:
        return err_consistance, err_pair_id

    for pair_id in pair_local_to_remote:
        if pair_id in pair_remote_to_local:
            local_consistency = pair_local_to_remote.get(pair_id)
            remote_consistency = pair_remote_to_local.get(pair_id)
            if local_consistency != remote_consistency:
                err_consistance.append(local_consistency)
                err_pair_id.append(pair_id)
    LOGGER.logInfo("check_pair_consistency addedsnlist:%s" % err_pair_id)
    return err_consistance, err_pair_id


def is_lun_check_version_and_patch(software_version):
    return software_version in CHECK_REPHC_PAIR_CONSISTENCE.keys()


def get_consistency_list(pair_info_list):
    """
    获取文件系统pair
    :return:
    """
    pair_local_to_remote = {}

    for pair_info in pair_info_list:
        pair_id = pair_info.get("ID")
        cnsistency = pair_info.get("Consistency Group ID")
        pair_local_to_remote[pair_id] = cnsistency

    LOGGER.logInfo("get_consistency_list addedsnlist:%s" % pair_local_to_remote)
    return pair_local_to_remote


def get_domain_info(local_dev_sn, all_cli_ret):
    """
    获取domain信息
    :param devSn:
    :return:
    """
    domain_dict = {}
    cmd = "show hyper_metro_domain general"
    flag, cliret, errmsg = common.getObjFromFile(py_java_env, LOGGER, local_dev_sn,
                                                 cmd)
    all_cli_ret.append(cliret)
    if flag is not True:
        LOGGER.logError("Failed to get information about HyperMetro domain. errMsg:%s" % errmsg)
        raise UnCheckException(
            common.getMsg(LANG, "cannot.get.info", {"zh": u"双活域", "en": "HyperMetro domain"}.get(LANG)),
                          '\n'.join(all_cli_ret))

    hyper_metro_domain_list = cliUtil.getHorizontalCliRet(cliret)
    for domain_info in hyper_metro_domain_list:
        domain_id = domain_info.get("ID", '')
        remote_device_id = domain_info.get("Remote Device ID", '')
        domain_dict[domain_id] = remote_device_id

    return domain_dict, all_cli_ret


def get_remote_device_info(devsn, domaindict, all_cli_ret):
    """
    获取远端设备
    :param devSn:
    :param domaindict:
    :return:
    """
    remote_device_dict = {}
    cmd = "show remote_device general"
    flag, cliret, errmsg = common.getObjFromFile(py_java_env, LOGGER, devsn, cmd)
    all_cli_ret.append(cliret)
    if flag is not True:
        LOGGER.logError("Failed to get information about remote device. errMsg:%s" % errmsg)
        raise UnCheckException(
            common.getMsg(LANG, "cannot.get.info", {"zh": u"远端设备", "en": "remote device"}.get(LANG)),
            '\n'.join(all_cli_ret))

    remote_device_list = cliUtil.getHorizontalCliRet(cliret)
    for remote_dev in remote_device_list:
        remotedeviceid = remote_dev.get("ID", '')
        remotedevicesn = remote_dev.get("SN", '')
        for domain_id in domaindict:
            if remotedeviceid == domaindict[domain_id]:
                remote_device_dict[domain_id] = remotedevicesn
    LOGGER.logInfo("Success to get information about remote device. errMsg:%s" % remote_device_dict)
    return remote_device_dict, all_cli_ret


def gethypermetropairidlist(devsn, domain_id, all_cli_ret):
    """
    @summary: 获取双活pair
    @return: hyperMetroPairIdList 双活pair ID列表
    """
    LOGGER.logInfo("gethypermetropairidlist addedsnlist:%s" % devsn)

    flag, ret, msg = common_cache.get_san_pair_from_cache_cg(
        py_java_env, LOGGER, devsn, LANG)
    san_pair_list = cliUtil.getHorizontalNostandardCliRet(ret)
    LOGGER.logInfo("gethypermetropairidlist addedsnlist:%s" % san_pair_list)
    all_cli_ret.append(ret)
    if flag is not True:
        LOGGER.logError("Failed to get information about HyperMetro Pair")
        raise UnCheckException(msg)

    san_pair_list = [
        pair_info
        for pair_info in san_pair_list
        if pair_info.get("Domain ID") == domain_id
    ]
    LOGGER.logInfo("gethypermetropairidlist addedsnlist:%s" % san_pair_list)

    return san_pair_list, all_cli_ret
