# -*- coding: UTF-8 -*-
import cliUtil
import common

LANG = common.getLang(py_java_env)
LOGGER = common.getLogger(PY_LOGGER, __file__)


def execute(cli):
    """
        硬盘域热备策略检查: 
       1） 当硬盘域不存在时，则检查通过；
       2） 当硬盘域中三层tier的热备策略为--或者High时，则检查通过；
       3） 当硬盘域中存在热备策略为Low的tier时，则检查结果为建议优化；
       4） 当硬盘域中存在热备策略为None的tier时，则检查不通过；
       5） 其他情况检查不通过；

    """
    cli_ret = ''
    try:
        cmd = (
            "show disk_domain general |filterColumn include columnList=ID,Tier0\\sHot\\sSpare"
            "\\sStrategy,Tier1\\sHot\\sSpare\\sStrategy,Tier2\\sHot\\sSpare\\sStrategy"
        )
        LOGGER.logExecCmd(cmd)
        flag, cli_ret, msg = cliUtil.excuteCmdInCliMode(cli, cmd, True, LANG)
        if not cliUtil.hasCliExecPrivilege(cli_ret):
            cmd = (
                "show disk_domain general |filterColumn include colunmList=ID,Tier0\\sHot\\sSpare"
                "\\sStrategy,Tier1\\sHot\\sSpare\\sStrategy,Tier2\\sHot\\sSpare\\sStrategy"
            )
            LOGGER.logExecCmd(cmd)
            flag, cli_ret, msg = cliUtil.excuteCmdInCliMode(
                cli, cmd, True, LANG
            )
        if flag is not True:
            LOGGER.logSysAbnormal()
            return flag, cli_ret, msg

        if cliUtil.queryResultWithNoRecord(cli_ret):
            return True, cli_ret, msg

        res_list = cliUtil.getHorizontalCliRet(cli_ret)
        not_pass_msg_list, warning_msg_list = check_hotspare_strategy(res_list)

        if not_pass_msg_list:
            return False, cli_ret, "".join(not_pass_msg_list + warning_msg_list)
        if warning_msg_list:
            return (
                cliUtil.RESULT_WARNING,
                cli_ret,
                "".join(warning_msg_list) + common.getMsg(LANG, "disk.domain.hotspare.strategy.warning.sugg")
            )
        return True, cli_ret, ""

    except Exception as exception:
        LOGGER.logException(exception)
        return (
            cliUtil.RESULT_NOCHECK,
            cli_ret,
            common.getMsg(LANG, "query.result.abnormal"),
        )


def check_hotspare_strategy(res_list):
    """

    :param cliRetLinesList:
    :return:
    """
    warning_msg_list = []
    not_pass_msg_list = []
    for line in res_list:
        domain_id = line.get("ID")
        tier0_strategy = line.get("Tier0 Hot Spare Strategy")
        tier1_strategy = line.get("Tier1 Hot Spare Strategy")
        tier2_strategy = line.get("Tier2 Hot Spare Strategy")
        if (
            tier0_strategy in ["--", "High"]
            and tier1_strategy in ["--", "High"]
            and tier2_strategy in ["--", "High"]
        ):
            continue
        if (
            tier0_strategy == "Low"
            or tier1_strategy == "Low"
            or tier2_strategy == "Low"
        ):
            warning_msg_list.append(
                common.getMsg(
                    LANG,
                    "diskdomain.hotspare.strategy.info",
                    (domain_id, tier0_strategy, tier1_strategy, tier2_strategy),
                )
            )
            LOGGER.logNoPass("diskdomain Hot Spare Strategy check fail!")
        if (
            tier0_strategy == "None"
            or tier1_strategy == "None"
            or tier2_strategy == "None"
        ):
            not_pass_msg_list.append(
                common.getMsg(
                    LANG,
                    "diskdomain.hotspare.strategy.info",
                    (domain_id, tier0_strategy, tier1_strategy, tier2_strategy),
                )
            )
    return not_pass_msg_list, warning_msg_list
