# -*- coding: UTF-8 -*-

import re

from com.huawei.ism.tool.obase.exception import ToolException

from cbb.frame.cli.execute_on_all_controllers import (
    ExeOnAllCtrlContext,
)
from cbb.business.checkitems.nginx_service_status_check import (
    NginxCheckAndRepair,
)
from cbb.business.checkitems.nginx_service_status_check import (
    _execute_on_all_controllers,
)
from cbb.frame.context import contextUtil

import cliUtil
import common
from common import AsynProgress
import common_cache

PY_JAVA_ENV = py_java_env
LANG = common.getLang(PY_JAVA_ENV)
LOGGER = common.getLogger(PY_LOGGER, __file__)


def execute(cli):
    """
    DeviceManager服务可用性检查
    check_item_software_dm_access.py.py
    :param cli:
    :return:
    """
    all_cli_ret_list = []
    no_check_msg = ''
    progress_thread = AsynProgress(PY_JAVA_ENV, LOGGER)
    progress_thread.start_thread()
    try:
        context = contextUtil.getContext(PY_JAVA_ENV)
        context["ssh"] = cli
        context["logger"] = PY_LOGGER
        context["lang"] = LANG
        nginx_service = NginxCheckAndRepair(context)
        # 设置是否需要修复问题
        nginx_service.set_need_repair(False)
        context["nginx_service"] = nginx_service

        if not is_need_check(cli, all_cli_ret_list):
            # 非SPH7，不再执行
            return cliUtil.RESULT_NOSUPPORT, "\n".join(all_cli_ret_list), ''

        # 初始化管理IP和控制器节点信息
        nginx_service.init_manage_ip_and_node_relation_for_inspection()
        engine_ctrl_dict = nginx_service.get_engine_ctrl_dict()
        LOGGER.logInfo("engine_ctrl_dict:{}".format(engine_ctrl_dict))
        node_id_and_ip_dict = nginx_service.get_node_id_and_ip_dict()

        # 在所有控制器检查
        exe_context = ExeOnAllCtrlContext(context)
        exe_context.set_target_ctrl_dict(engine_ctrl_dict)

        context["ctrl_id2ip_dict"] = node_id_and_ip_dict
        _execute_on_all_controllers(exe_context)
        all_cli_ret_list.extend(nginx_service.all_cli_ret)
        LOGGER.logInfo(
            "nginx_service.failed_ctrls".format(nginx_service.failed_ctrls)
        )
        # 如果是进入minisystem失败，判断是否是权限不足。
        if check_failed_minisystem_permissions(
                str(nginx_service.all_cli_ret)):
            msg = common.getMsg(
                LANG, "loginUser.name.level.must.be.super.admin"
            )
            return cliUtil.RESULT_NOCHECK, "\n".join(all_cli_ret_list), msg

        if nginx_service.failed_ctrls:
            err_key = "nginx.service.check.failed"
            no_check_msg = common.getMsg(
                LANG, err_key, ",".join(nginx_service.failed_ctrls)
            )

        if nginx_service.not_pass_ctrls:
            err_key = "nginx.service.check.not.pass"
            not_pass_msg = common.getMsg(
                LANG, err_key, ",".join(nginx_service.not_pass_ctrls)
            )
            return (
                False,
                "\n".join(all_cli_ret_list),
                not_pass_msg + no_check_msg
            )

        if no_check_msg:
            return (
                cliUtil.RESULT_NOCHECK,
                "\n".join(all_cli_ret_list),
                no_check_msg
            )

        return True, "\n".join(all_cli_ret_list), ""

    except (ToolException, Exception) as e:
        LOGGER.logError(str(e))
        return (
            cliUtil.RESULT_NOCHECK,
            "\n".join(all_cli_ret_list),
            common.getMsg(LANG, "query.result.abnormal"),
        )
    finally:
        progress_thread.setStopFlag(True)
        # 退出到cli模式
        ret = cliUtil.enterCliModeFromSomeModel(cli, LANG)
        LOGGER.logInfo("enter cli mode from some model is %s" % str(ret))
        # 退出失败后为不影响后续检查项重新连接cli
        if not ret[0]:
            common.reConnectionCli(cli, LOGGER)


def is_need_check(cli, cli_ret_list):
    (
        flag,
        p_version,
        p_patch,
        ret,
        err_msg,
    ) = common_cache.get_version_and_patch_cache(PY_JAVA_ENV, cli, LOGGER)
    cli_ret_list.append(ret)

    regx = re.compile(r"SPH(\d+)")
    res = regx.search(p_patch)
    if res:
        patch_num = int(res.group(1))
        return all([
            "6.0.0" in p_version,
            patch_num > 3,
            patch_num < 9]
        )

    return False


def check_failed_minisystem_permissions(ret):
    """
    dorado v6 非超级管理员,进入minisystem失败。
    :param ret:
    :return:
    """
    err_info = "The minisystem mode is allowed for a super user only"
    return err_info in ret
