# -*- coding:utf-8 -*-
import cliUtil
import common
from common_utils import get_err_msg
from cbb.business.checkitems.cli_domain_config_check import (
    CliDomainConfigCheck,
)
from cbb.frame.base.exception import UnCheckException

LANG = common.getLang(py_java_env)
LOGGER = common.getLogger(PY_LOGGER, __file__)


def execute(cli):
    all_err_msg = list()
    cli_domain_config_check = CliDomainConfigCheck(cli, LANG, LOGGER)
    try:
        flag = cli_domain_config_check.execute_check()
        for each_err_msg in cli_domain_config_check.err_msg_notice:
            all_err_msg.append(
                get_err_msg(
                    LANG,
                    "cli.domain.config.check.not.pass",
                    tuple(each_err_msg),
                )
            )

        for each_err_msg in cli_domain_config_check.err_msg_notice_no_smart:
            all_err_msg.append(
                get_err_msg(
                    LANG,
                    "cli.domain.config.check.not.pass.no.smart",
                    tuple(each_err_msg),
                )
            )
        LOGGER.logInfo("check ret {}".format(flag))
        return (
            flag,
            "\n".join(cli_domain_config_check.all_cli_ret),
            "".join(all_err_msg),
        )
    except UnCheckException as e:
        return (
            cliUtil.RESULT_NOCHECK,
            "\n".join(cli_domain_config_check.all_cli_ret),
            e.errorMsg,
        )
    except Exception as e:
        LOGGER.logException(e)
        return (
            cliUtil.RESULT_NOCHECK,
            "\n".join(cli_domain_config_check.all_cli_ret),
            common.getMsg(LANG, "query.result.abnormal"),
        )
