import cliUtil
import common
from cbb.frame.base import baseUtil
from common_utils import is_flush_through_mode

LANG = common.getLang(py_java_env)
LOGGER = common.getLogger(PY_LOGGER, __file__)
PY_JAVA_ENV = py_java_env

def execute(cli):
    '''
    DSM 分区状态检查：
                检查方法
                    步骤1 以admin用户登录设备。
                    步骤2 执行如下命令：show dsm partition_status 查询分区状态。

                检查标准
                    如果查询结果显示Partition Status为Normal，检查通过，否则为异常情况，检查不通过。
    '''
    cliRetAll = ""
    errMsg = ""
    try:
        product_model = str(PY_JAVA_ENV.get("devInfo").getDeviceType())
        if baseUtil.is_micro_dev(product_model) and is_flush_through_mode(cli, LANG, LOGGER):
            return (cliUtil.RESULT_NOSUPPORT, "System mode: pass-through mode.", errMsg)
        cmd = "show dsm partition_status"
        LOGGER.logExecCmd(cmd)
        checkRet = cliUtil.excuteCmdInCliMode(cli, cmd, True, LANG)
        if checkRet[0] != True:
            LOGGER.logSysAbnormal()
            return checkRet

        cliRet = checkRet[1]
        cliRetAll = cliRet

        cliRetLinesList = cliUtil.getVerticalCliRet(cliRet)
        if len(cliRetLinesList) == 0:
            errMsg = common.getMsg(LANG, "cannot.get.dsm.info")
            LOGGER.logNoPass("Cannot get information about dsm partition_status: empty cli result")
            return (False, cliRetAll, errMsg)

        for dict in cliRetLinesList:
            if "Partition Status" in dict:
                partitionStatus = dict.get("Partition Status")
                LOGGER.logInfo("DSM Partition Status=%s" % partitionStatus)
                if partitionStatus == "Normal .":
                    return (True, cliRetAll, errMsg)
                else:
                    errMsg = common.getMsg(LANG, "check.dsm.status.error")
                    return (False, cliRetAll, errMsg)

        errMsg = common.getMsg(LANG, "cannot.get.dsm.info")
        LOGGER.logNoPass("Cannot get information about dsm partition_status: no Partition Status")
        return (False, cliRetAll, errMsg)

    except Exception, exception:
        LOGGER.logException(exception)
        return (cliUtil.RESULT_NOCHECK, cliRetAll, common.getMsg(LANG, "query.result.abnormal"))