# -*- coding: UTF-8 -*-
import cliUtil
import common

LANG = common.getLang(py_java_env)
LOGGER = common.getLogger(PY_LOGGER, __file__)

def execute(cli):
    
    flag = True
    cliRet = ""
    errMsg = ""
    allCliRet = ""
    notPassLunFlag = True
    infoLunFlag = True
    errorLunFlag = True
    notPassEdevLunList = [] 
    errorLunList = []
    try:
        #步骤2，查询存在异构Lun,若没有配置相关业务，这返回通过
        cmd = "show lun general usage_type=External"
        LOGGER.logExecCmd(cmd)
        flag, cliRet, errMsg = cliUtil.excuteCmdInCliMode(cli, cmd, True, LANG)
        allCliRet += cliRet
        
        #判断是否含异常场景
        if flag != True:
            errMsg += common.getMsg(LANG, "lun.edev.total.infofaile")
            return (cliUtil.RESULT_NOCHECK,allCliRet, errMsg)
        #判断不含异构场景的情况，返回通过
        if cliUtil.queryResultWithNoRecord(cliRet):
            return (True, allCliRet, errMsg)

        #收集处理的异构Lun id
        cliList = cliUtil.getHorizontalNostandardCliRet(cliRet)
        for line in cliList :
            lunId = line.get("ID")
            if not lunId or ('--' in lunId):
                infoLunFlag = False
                continue
            
            cmd = "show lun general lun_id=%s" % lunId
            flag, cliRet, errMsgLunId = cliUtil.excuteCmdInCliMode(cli, cmd, False, LANG) 
            #如果单条Lun发送失败 则只记录，并且越过
            if flag != True:
                allCliRet += cliRet
                errorLunList.append(lunId)
                errorLunFlag = False
                continue
                
            dictList = cliUtil.getVerticalCliRet(cliRet)
   
            isLunVocationaFlag = checkVocationalInfo(dictList)
            if not isLunVocationaFlag:
                allCliRet += cliRet
                notPassEdevLunList.append(lunId)
                notPassLunFlag = False
                            
        if len(notPassEdevLunList) > 0 :
            errMsg += common.getMsg(LANG, "lun.edev.total.infolist",", ".join(notPassEdevLunList))
        if len(errorLunList) > 0:
            errMsg += common.getMsg(LANG, "lun.edev.total.inerrorist",", ".join(errorLunList))
        
        if notPassLunFlag != True :
            flag = False
        elif errorLunFlag != True :
            flag = cliUtil.RESULT_NOCHECK
        else:
            if infoLunFlag:
                flag = True
            else:
                errMsg += common.getMsg(LANG, "lun.edev.total.infofaile")
                return (cliUtil.RESULT_NOCHECK,allCliRet, errMsg)                  
                                     
        return (flag, allCliRet, errMsg)
    except:
        return (cliUtil.RESULT_NOCHECK, allCliRet, common.getMsg(LANG, "query.result.abnormal"))
# **************************************************************************** #
# 函数名称: checkVocationalInfo
# 功能说明: 查询单个异构Lun的相关业务配置
# 输入参数: dictList 异构lun 详细信息回显
# 输出参数: 无
# 返 回 值: flag
# **************************************************************************** # 
def checkVocationalInfo(dictList):
    keyList = ["HyperMetro ID(s)","Remote Replication ID(s)","Snapshot ID(s)"]
    if dictList and dictList[0].has_key("Write Policy"):
        writePolValue = dictList[0].get("Write Policy").strip().lower()
        if "write through" == writePolValue:
            for key in keyList :
                value = dictList[0].get(key)
                if (value != None) and value.isdigit():
                   return False
    return True