# -*- coding: UTF-8 -*-
import cliUtil
import common

LANG = common.getLang(py_java_env)
LOGGER = common.getLogger(PY_LOGGER, __file__)

def execute(cli):
    '''
        预拷贝开关检查: 
        PreCopy Enabled值Yes或No表示正常，其它情况均属于不正常状态。
    '''
    flag = True
    cliRet = ""
    errMsg = ""

    try:
        cmd = "show disk precopy"
        LOGGER.logExecCmd(cmd)
        checkRet = cliUtil.excuteCmdInCliMode(cli, cmd, True, LANG)
        if checkRet[0] != True: 
            LOGGER.logSysAbnormal()
            return checkRet
        
        cliRet = checkRet[1]
        cliRetLinesList = cliUtil.getVerticalCliRet(cliRet)
        if len(cliRetLinesList) == 0:
            errMsg = common.getMsg(LANG, "cannot.get.disk.precopy.info")
            LOGGER.logNoPass("Cannot get information about Disk Precopy")
            return (False, cliRet, errMsg)
        
        retDict = cliRetLinesList[0]
        precopyEnabled = retDict.get("PreCopy Enabled")
        if not precopyEnabled in [common.STATUS_YES, common.STATUS_NO]:
            errMsg = common.getMsg(LANG, "disk.precopy.status.abnormal", precopyEnabled)
            LOGGER.logNoPass("The Precopy Enabled status of Disk is abnormal (Precopy Enabled:%s)" % precopyEnabled)
            return (False, cliRet, errMsg)

        if flag:
            LOGGER.logPass()
            
        return (flag, cliRet, errMsg) 

    except Exception, exception:
        LOGGER.logException(exception)
        return (cliUtil.RESULT_NOCHECK, cliRet, common.getMsg(LANG, "query.result.abnormal"))
    
