# -*- coding: UTF-8 -*-
import traceback
import re
import common
import cliUtil
import config 
from com.huawei.ism.tool.obase.exception import ToolException
PY_JAVA_ENV = py_java_env
LANG = common.getLang(py_java_env)
LOGGER = common.getLogger(PY_LOGGER, __file__)
allCliRet = ""

def execute(cli):
    """
        检查项名称：
        NVMe升级风险排查
            
         检查方法：
                
                    步骤1 以admin用户登录设备；
                    步骤2 执行命令show system general，查询当前阵列产品型号；
                    步骤3 执行命令show upgrade package，查询当前阵列产品软件版本；
                    步骤4 执行命令show controller general，在Electronic Label：Description中，查看当前产品设备形态。
                
        检查标准：
            
        1、若当前阵列软件版本为Dorado V300R001C01SPC100，且产品型号为Dorado5000 V3，则继续检查设备形态；否则检查通过；
        2、如果步骤4中电子标签Description中存在“NVME”字样，则检查结果为建议优化；否则检查通过。
            
        修复建议：
            
                    请收集阵列日志，联系技术工程师协助处理。
    """
    global allCliRet
    errMsg = ""
    
    try:
        #获取设备型号和SN
        result, productModel, errMsg = getProductModel(cli)
        if result != True:
            return (cliUtil.RESULT_NOCHECK, allCliRet, errMsg)
        LOGGER.logInfo("Get product model [%s]" % productModel)
        #获取设备当前产品版本
        checkRet, curProductVersionDictList, _ = common.parse_upgradePackage(cli, LANG)
        allCliRet = common.joinLines(allCliRet, checkRet[1])
        if checkRet[0] != True:
            return (cliUtil.RESULT_NOCHECK, allCliRet , checkRet[2])
        result, curProductVersion, errMsg = common.getCurrentVersion(curProductVersionDictList, LANG)
        if not result:
            return (cliUtil.RESULT_NOCHECK, allCliRet , errMsg)
        LOGGER.logInfo("Get product version [%s]" % curProductVersion)
        if productModel != "Dorado5000 V3" or curProductVersion != "V300R001C01SPC100":
            return (True, allCliRet, "")
        (checkFlag, checkResult, errMsg) = checkIsNVMeDevice(cli)
        if checkFlag != True:
            return (cliUtil.RESULT_NOCHECK, allCliRet , errMsg)
        if checkResult:
            errMsg = common.getMsg(LANG, "check.item.upgrade.risk.check.for.nvme.nopass")
            return (cliUtil.RESULT_WARNING, allCliRet, errMsg)
        return (True, allCliRet, "")
            
    except ToolException:
        LOGGER.logError(str(traceback.format_exc()))
        raise
    except:
        LOGGER.logError(str(traceback.format_exc()))
        return (cliUtil.RESULT_NOCHECK, allCliRet, common.getMsg(LANG, "query.result.abnormal"))

def getProductModel(cli):
    global allCliRet
    productModel = ""
    cmd = "show system general"
    (flag, cliRet, errMsg) = cliUtil.excuteCmdInCliMode(cli, cmd, True, LANG)
    allCliRet = common.joinLines(allCliRet, cliRet)
    if flag != True: 
        return (False, productModel, errMsg)
    cliRetDictList = cliUtil.getVerticalCliRet(cliRet)
    if len(cliRetDictList) == 0:
        return (False, productModel, common.getMsg("query.result.abnormal"))
    cliRetDict = cliRetDictList[0]
    productModel = cliRetDict.get("Product Model")
    if not productModel:
        return (False, productModel, common.getMsg("query.result.abnormal"))
    return (True, productModel , "")

def checkIsNVMeDevice(cli):
    global allCliRet
    cmd = "show controller general"
    (flag, cliRet, errMsg) = cliUtil.excuteCmdInCliMode(cli, cmd, True, LANG)
    allCliRet = common.joinLines(allCliRet, cliRet)
    if flag != True: 
        return (False, False, errMsg)
    cliRetDictList = cliUtil.getVerticalCliRetFilterElabel(cliRet)
    if len(cliRetDictList) == 0:
        return (False, False, common.getMsg("query.result.abnormal"))
    for cliRetDict in cliRetDictList:
        descriptionValue = cliRetDict.get("Description")
        LOGGER.logInfo("Get description value is:%s" % descriptionValue)
        if descriptionValue and "nvme" in descriptionValue.lower():
            return (True, True, "")
    return (True, False, "")
            
    
