# -*- coding: UTF-8 -*-
import cliUtil
import common
from cli_util_cache import is_upgrading
LANG = common.getLang(py_java_env)
LOGGER = common.getLogger(PY_LOGGER, __file__)

MIN_VER_C61 = 'V500R007C61'
MIN_VER_C70 = 'V500R007C70'
def execute(cli):
    '''
    BBU版本检查: 
                所有BBU的Firmware Version均存在且一致表示正常，其它情况均属于不正常状态。
    '''
    flag = True
    cli_ret_all = ""
    errMsg = ""

    try:
        # 融合存储 V5R7C61和V5R7C70开始支持查询后台升级任务的命令
        up_flag, cli_ret = is_upgrading(cli, LANG)
        cli_ret_all = common.joinLines(cli_ret_all, cli_ret)
        LOGGER.logInfo("isUpgrading:{up_flag}".format(up_flag=up_flag))
        if up_flag:
            key = "firmware.version.of.bbu.inconsistent.upgrading"
            return (cliUtil.RESULT_NOCHECK, cli_ret_all,
                    common.getMsg(LANG, key))

        cmd = "show version all"
        LOGGER.logExecCmd(cmd)
        checkRet = cliUtil.excuteCmdInCliMode(cli, cmd, True, LANG)
        cliRet = checkRet[1]
        cli_ret_all = common.joinLines(cli_ret_all, cliRet)
        if checkRet[0] != True: 
            LOGGER.logSysAbnormal()
            return checkRet[0], cli_ret_all, checkRet[2]

        bbuRet = cliUtil.getSplitedCliRet(cliRet, "BBU:")
        cliRetLinesList = cliUtil.getHorizontalCliRet(bbuRet)
        
        if len(bbuRet) == 0 or len(cliRetLinesList) == 0:
            errMsg = common.getMsg(LANG, "cannot.get.firmware.version.info")
            LOGGER.logNoPass("Cannot get information about Firmware Version of BBU")
            return (False, cli_ret_all, errMsg)
        
        bbuVersionSet = set()
        for line in cliRetLinesList:
            bbuId = line.get("ID")
            bbuVersion = line.get("Firmware Version")
            if len(bbuVersion) > 0 and bbuVersion != "--":
                bbuVersionSet.add(bbuVersion)
            else:
                flag = False
                errMsg += common.getMsg(LANG, "cannot.get.firmware.version.of.bbu", bbuId)
                LOGGER.logNoPass("Cannot get information about Firmware Version of BBU [%s]" % bbuId)
        
        if len(bbuVersionSet) > 1:
            flag = False
            errMsg += common.getMsg(LANG, "firmware.version.of.bbu.inconsistent", ", ".join(bbuVersionSet))
            LOGGER.logNoPass("The firmware versions of all BBUs are inconsistent")
        
        if flag:
            LOGGER.logPass()
            
        return (flag, cli_ret_all, errMsg)
    
    except Exception, exception:
        LOGGER.logException(exception)
        return (cliUtil.RESULT_NOCHECK, cli_ret_all,
                common.getMsg(LANG, "query.result.abnormal"))
