# -*- coding:utf-8 -*-
import common
import cliUtil
import traceback
import config
from config import recommend_version_patch_for_v3, recommend_version_patch_for_v5, recommend_version_patch_for_dorado

LANG = common.getLang(py_java_env)
LOGGER = common.getLogger(PY_LOGGER, __file__)
PY_JAVA_ENV = py_java_env
CLI_RET_ALL = ''


def execute(cli):
    """
    V3系列的开局全部推送V300R006C20 +SPH008
    V5系列开局全部推送V500R007C10+SPH008
    Dorado V3 开局全部推V300R001C21SPC100 +SPH108
    1、如果产品型号或者系统软件版本不在检查范围内，或者系统已安装推荐产品版本+热补丁，则检查通过。
    2、如果系统当前版本低于推荐版本则检查结果为建议优化。
    :param cli:
    :return:
    """
    global CLI_RET_ALL
    try:
        # 获取设备型号
        is_qry_ok, device_type, cli_ret, err_msg = cliUtil.getProductModelWithCliRet(cli, LANG)
        CLI_RET_ALL = common.joinLines(CLI_RET_ALL, cli_ret)
        if not is_qry_ok:
            return cliUtil.RESULT_NOCHECK, CLI_RET_ALL, err_msg
        # 获取设备当前产品版本和补丁信息
        (is_qry_ok, cli_ret,
         err_msg), current_version_dict_list, hot_patch_version_dict_list = common.parse_upgradePackage(
            cli, LANG)
        CLI_RET_ALL = common.joinLines(CLI_RET_ALL, cli_ret)
        if is_qry_ok is not True:
            LOGGER.logSysAbnormal()
            return cliUtil.RESULT_NOCHECK, CLI_RET_ALL, err_msg
        result, current_version, err_msg = common.getCurrentVersion(current_version_dict_list, LANG)
        if not result:
            return cliUtil.RESULT_NOCHECK, CLI_RET_ALL, err_msg
        result, cur_hot_patch_ver, err_msg = common.getCurrentVersion(hot_patch_version_dict_list, LANG)
        if not result:
            return cliUtil.RESULT_NOCHECK, CLI_RET_ALL, err_msg
        # 判断当前设备是否需要推荐升级
        flag, err_msg = check_version(device_type, current_version, cur_hot_patch_ver)
        if flag is not True:
            return flag, CLI_RET_ALL, err_msg

        return flag, CLI_RET_ALL, err_msg
    except Exception as exception:
        LOGGER.logException(exception)
        LOGGER.logError(traceback.format_exc())
        return cliUtil.RESULT_NOCHECK, CLI_RET_ALL, common.getMsg(LANG, "query.result.abnormal")


def check_version(device_type, current_version, cur_hot_patch_ver):
    """
    判断当前设备是否需要推荐升级
    :param device_type: 设备型号
    :param current_version: 产品版本
    :param cur_hot_patch_ver: 当前热补丁版本
    :return:
    """
    flag = True
    err_msg = ''
    recommend_version_for_dorado = recommend_version_patch_for_dorado.get('version')
    recommend_patch_for_dorado = recommend_version_patch_for_dorado.get('patch')
    recommend_version_for_v3 = recommend_version_patch_for_v3.get('version')
    recommend_patch_for_v3 = recommend_version_patch_for_v3.get('patch')
    recommend_version_for_v5 = recommend_version_patch_for_v5.get('version')
    recommend_patch_for_v5 = recommend_version_patch_for_v5.get('patch')
    LOGGER.logInfo('device_type : %s, current_version : %s, cur_hot_patch_ver : %s' % (
        device_type, current_version, cur_hot_patch_ver))
    if device_type in config.DORADO_DEVS and current_version.startswith(
            'V300R00') and current_version <= recommend_version_for_dorado:
        LOGGER.logInfo('version for dorado:{}, patch for dorado:{}'.format(
            recommend_version_for_dorado, recommend_patch_for_dorado)
        )
        return check_patch_version(
            cur_hot_patch_ver, current_version, device_type,
            recommend_patch_for_dorado, recommend_version_for_dorado
        )
    if device_type not in config.DORADO_DEVS and current_version.startswith(
            'V300R00') and current_version <= recommend_version_for_v3:
        LOGGER.logInfo('version_for_v3:{}, patch for v3:{}'.format(
            recommend_version_for_v3, recommend_patch_for_v3)
        )
        return check_patch_version(
            cur_hot_patch_ver, current_version, device_type,
            recommend_patch_for_v3, recommend_version_for_v3
        )
    if device_type not in config.DORADO_DEVS and current_version.startswith(
            'V500R00') and current_version <= recommend_version_for_v5:
        LOGGER.logInfo("version for v5:{}, patch for v5:{}".format(
            recommend_version_for_v5, recommend_patch_for_v5)
        )
        return check_patch_version(
            cur_hot_patch_ver, current_version, device_type,
            recommend_patch_for_v5, recommend_version_for_v5
        )

    return flag, err_msg


def check_patch_version(
    cur_hot_patch_ver,
    current_version,
    device_type,
    recommend_patch,
    recommend_version,
):
    flag = True
    err_msg = ""
    if current_version == recommend_version:
        if cur_hot_patch_ver < recommend_patch:
            flag = (
                False
                if common.is_opening_delivery_inspect(PY_JAVA_ENV)
                else cliUtil.RESULT_WARNING
            )
            err_msg = common.getMsg(
                LANG, "unInstall.patch",
                (device_type, current_version, recommend_patch),
            )
    else:
        flag = (
            False
            if common.is_opening_delivery_inspect(PY_JAVA_ENV)
            else cliUtil.RESULT_WARNING
        )
        err_msg = common.getMsg(
            LANG,
            "system.version.low",
            (
                device_type, current_version,
                recommend_version, recommend_patch,
            ),
        )
    return flag, err_msg
