# coding=UTF-8
import java.lang.Exception as JException

import common
import cliUtil
import re
from cbb.frame.cli import cliUtil as frameCliUtil
from cbb.frame.base import baseUtil
from common_utils import get_err_msg
from cbb.frame.base.config import ARM_HIGH_END_NEW

PY_JAVA_ENV = py_java_env
LANG = common.getLang(PY_JAVA_ENV)
LOGGER = common.getLogger(PY_LOGGER, __file__)

ERR_HOT_PATCH = {"V500R007C71SPH105", "V500R007C71SPH106"}


def execute(cli):
    """
    扩控版本检查
    :return: (检查结果，CLI回显，错误提示信息）
    """
    return VersionCheck(cli).run()


class VersionCheck(object):

    def __init__(self, cli):
        self.cli = cli
        self.all_cli_ret = ""

    def _run_check(self):
        flag, prd_ver, hot_patch_version, cli_ret = \
            frameCliUtil.get_system_version_with_ret(self.cli, LANG)
        self.all_cli_ret = cli_ret
        LOGGER.logInfo("---------------------Expansion Evaluation Result As Below------------------")
        LOGGER.logInfo(
            "flag:{}, prd_ver:{}, hot_patch_version:{}".format(
                flag, prd_ver, hot_patch_version
            )
        )
        if flag is not True:
            return flag, self.all_cli_ret, ""
        err_msg = common.getMsg(
            LANG,
            "whether_the_patch_versions_are_the_same_error",
            args=((prd_ver + "." + hot_patch_version) if hot_patch_version else prd_ver)
        )
        # 高端引擎内扩控，直接通过
        if self.is_high_end_expansion_2_to_4():
            return True, self.all_cli_ret, ""

        if prd_ver.startswith("6.0.1"):
            if VersionCheck.get_path_version_num(hot_patch_version) < 10:
                return False, self.all_cli_ret, err_msg
            else:
                return cliUtil.RESULT_WARNING, self.all_cli_ret, err_msg
        if prd_ver.startswith("6.0.0"):
            return cliUtil.RESULT_WARNING, self.all_cli_ret, err_msg

        dev_info = common.getCurDeviceInfo(PY_JAVA_ENV)
        dev_type = str(dev_info.getDeviceType())
        if dev_type not in ARM_HIGH_END_NEW and hot_patch_version in ERR_HOT_PATCH:
            return False, self.all_cli_ret, get_err_msg(
                LANG,
                "check.expansion.ctrl.hotpatch",
                hot_patch_version,
            )
        return True, self.all_cli_ret, ""

    @staticmethod
    def is_high_end_expansion_2_to_4():
        """
        是否为高端2扩4
        :return:
        """
        dev_info = py_java_env.get("devInfo")
        product_model = str(dev_info.getDeviceType())
        # 非DoradoV6高端，通过
        if not baseUtil.isDoradoV6HighEnd(product_model):
            return False

        exp_info = py_java_env.get("expInfo")
        # 原集群控制器数量
        dev_ctrl_num = int(exp_info.getDevCtrlsNum())
        # 扩容后控制器数量
        exp_ctrl_num = int(exp_info.getExpCtrlsNum())
        return dev_ctrl_num == 2 and exp_ctrl_num == 4

    def run(self):
        try:
            return self._run_check()
        except (Exception, JException) as exception:
            LOGGER.logException(exception)
            return cliUtil.RESULT_NOCHECK, self.all_cli_ret, ""
        finally:
            ret = cliUtil.enterCliModeFromSomeModel(self.cli, LANG)
            LOGGER.logInfo(
                "Controller expansion version check end."
                "Enter cli mode from some model, ret: %s" % str(ret)
            )
            # 退出失败后为不影响后续检查项重新连接cli
            if not ret[0]:
                common.reConnectionCli(self.cli, LOGGER)

    @staticmethod
    def get_path_version_num(patch_ver):
        """
            获取热补丁版本号int类型
            :param patch_ver: 补丁
            :return: int的版本号
            """
        pattern_hot_patch = re.compile(r"SPH(\d+)", flags=re.IGNORECASE)
        match_hot_path = pattern_hot_patch.search(patch_ver)
        if match_hot_path:
            path_version_num = int(match_hot_path.group(1))
        else:
            path_version_num = 0
        return path_version_num
