# -*- coding: UTF-8 -*-
import re
import time
import decimal
import resource
import config
import cliUtil
import os
import logger
from defusedxml import ElementTree
import com.huawei.ism.tool.obase.entity.DevNode as DevNode
import com.huawei.ism.tool.obase.utils.DeviceTypeUtil as DeviceTypeUtil
from cbb.frame.cli.cli_with_cache import execute_cmd_in_cli_mode_with_cache

import traceback
import datetime
from com.huawei.ism.tool.obase.connection import SshConnectionManager
from com.huawei.ism.tool.obase.exception import ToolException
import threading
from cbb.frame.rest import restUtil
from cbb.frame.rest import restData
from cbb.frame.context import contextUtil
from cbb.frame.context import sqlite_context
from cbb.frame.cli.cli_with_cache import query_one_cmd
from cbb.frame.base import product

import com.huawei.ism.tool.obase.db.SqliteManager as SqliteManager

STATUS_NORMAL = "Normal"
STATUS_ABNORMAL = "Abnormal"
STATUS_FAULT = "Fault"
STATUS_ONLINE = "Online"
STATUS_RUNNING = "Running"
STATUS_BALANCING = "Balancing"
STATUS_CHARGING = "Charging"
STATUS_DISCHARGING = "Discharging"
STATUS_ENABLED = "Enabled"
STATUS_INTERRUPT = "Interrupt"
STATUS_YES = "Yes"
STATUS_NO = "No"
STATUS_LINK_UP = "Link Up"
STATUS_LINK_DOWN = "Link Down"
STATUS_ON = "On"
STATUS_OFF = "Off"
STATUS_START = "Start"
STATUS_SYNCHRONIZING = "Synchronizing"
STATUS_UNSYNCHRONIZED = "Unsynchronized"
STATUS_PAUSE = "Paused"
STATUS_FORCE_STARTED = "Force Started"
STATUS_LOW_BATTERY = "Low Battery"
DISK_TYPE_SATA ="SATA"
HYPERMETRO_DATA = "{}hypermetroData".format(os.sep)
FLAG_KEY = 'flag'
CLI_RET_KEY = 'cliRet'
ERROR_MSG_KEY = 'errMsg'
DIR_RELATIVE_CMD = "."
CHECK_FLAG_CONTINUE = "ContinueInspectionBelow"
CHECK_FLAG_NOT_CONTINUE = "NocontinueInspectionBelow"
# 每个引擎只巡检一个控制器
CHECK_FLAG_ONLY_ONE_CTRL = "NocontinueOnlyOneCtrl"
HYPER_METRO_INFO_KEY = "hyper_metro_info_key{0}"
HYPER_DEV_STATUS = "HY_DEV_NODE_STATUS{0}"
HYPER_DEV_STATUS_COLLECTING = "dev status collecting"
HYPER_DEV_STATUS_INTERRUPTED = "dev status interrupted"
HYPER_DEV_STATUS_COLLECT_END = "dev status end"
SLEEP_TIMES = 30
PORTS_BIT_ERROR_SPEC = 60
PORTS_BIT_ERROR_INTERVAL = 30
SERIAL_NUMBER_LENGTH = 20
THRESHOLD_BBU_REMAINING_LIFETIME = 90
THRESHOLD_CONTRL_CPU_USAGE = 80
LEVEL2_THRESHOLD_CONTRL_CPU_USAGE = 60
TOOL_BOX_SYSTEM_CFG_PATH = "..{0}..{0}configuration".format(os.sep)
INSPECT_TOOL_SYSTEM_CFG_PATH = "configuration"
SYSTEM_PROPERTIES_NAME = "system.properties"
DEVICE_INNER_IPS_FEILD = "app.specific.device.v3r3.inner.ips"
SVP_INNER_IPS_FEILD = "app.specific.device.v3r3.ip"
defauleInterIPList = ["172.17.126.11", "172.16.192.200", "172.16.193.200", "172.16.192.201", "172.16.193.201", "172.16.192.202", "172.16.193.202"]
HYPERMETRO_BEGIN_VERSION = "V300R003C00"

FILE_SUFFIX = "."

FLAG_YES = 0
FLAG_NO = 1
FLAG_FAIL = 2
# 扩空池时，需要将diskNum传入-2，产品特殊处理。
EMPTY_POOL_FLAG = "-2"

NEW_HIGH_ENC_TYPE = "12G 4U 75 Slot 3.5 SAS Disks Enclosure"
OLD_HIGH_ENC_TYPE = "4U 75 Slot 3.5 SAS Disks Enclosure"

SPECIAL_ENGINE_JUMP_PRODUCT_MODEL_LIST = ["6800 V3"]
QUERY_CLOUDBACKUP_ERROR_STATE = 2

def getLang(py_java_env):
    '''
    @summary: 从上下文中获取lang
    @param py_java_env: 上下文对象
    @return: lang
    '''
    return py_java_env.get("lang")

def getCurDeviceInfo(py_java_env):
    """
    @summary: query the device info from java env context
    """
    dev = py_java_env.get("devInfo")
    
    return dev
    
def getPatchWarningDevs(py_java_env):
    '''
    @summary:  query the PatchWarningDev  from java env context
    @param py_java_env: context
    @return: patchWarningDevs:Map object in java
    '''
    return py_java_env.get("patchWarningDevs")
    
def getMsg(lang, msg, args=""):
    '''
    @summary: 消息国际化
    @param lang: 语言lang
    @param msg: 消息
    @param args: 消息参数
    @return: 经过国际化处理后的消息
    '''
    return cliUtil.getMsg(lang, msg, args, resource.MESSAGES_DICT)

def getSymmetricalPort(port):
    '''
    @summary: 获取端口的对称端口
    @param port: 端口
    '''
    for item in [(".A", ".B"), (".B", ".A"), (".L", ".R"), (".R", ".L")]:
        item0 = item[0]
        item1 = item[1]
        if item0 in port:
            symmetricalPort = port.replace(item0, item1)
            return symmetricalPort
    return ""

def getDiskGeneralList(cli, lang):
    '''
    @summary: 获取所有硬盘信息集合
    @param cli: cli对象
    @param lang: 语言lang
    '''
    cmd = "show disk general"
    checkRet = cliUtil.excuteCmdInCliMode(cli, cmd, True, lang)
    if checkRet[0] != True: 
        return checkRet
    cliRet = checkRet[1]
    
    if cliUtil.queryResultWithNoRecord(cliRet):
        return (True, [], "")
    
    cliRetLinesList = cliUtil.getHorizontalCliRet(cliRet)
    if len(cliRetLinesList) == 0:
        errMsg = getMsg(lang, "cannot.get.disk.info")
        return (False, cliRet, errMsg)
    
    return (True, cliRetLinesList, "")

def getDiskSectorSize(cli, lang):
    '''
    @summary: 执行show disk general |filterColumn include columnList=ID,Sector\sSize命令，获取扇区大小
    '''
    sectorSizeDictList = []
    cmd = "show disk general |filterColumn include columnList=ID,Sector\sSize"
    checkRet = cliUtil.excuteCmdInCliMode(cli, cmd, True, lang)
    
    #兼容产品命令Bug
    if not cliUtil.hasCliExecPrivilege(checkRet[1]):
        cmd = "show disk general |filterColumn include colunmList=ID,Sector\sSize"
        checkRet = cliUtil.excuteCmdInCliMode(cli, cmd, True, lang)
    
    cliRet = checkRet[1]   
    if checkRet[0] != True: 
        return (checkRet[0], cliRet, checkRet[2], sectorSizeDictList)
    
    sectorSizeDictList = cliUtil.getHorizontalCliRet(cliRet)
    return (True, cliRet, "", sectorSizeDictList)

def is4KDiskWithSectorSize(diskSectorSizeDictList, lang):
    '''
    @summary: 根据扇区大小判断是否为4K盘
    '''
    is4KDiskList = []
    for diskSectorSizeDict in diskSectorSizeDictList:
        diskId = diskSectorSizeDict.get("ID")
        sectorSizeStr = diskSectorSizeDict.get("Sector Size")
        
        #忽略无法获取扇区大小的盘
        if sectorSizeStr == "--" or not sectorSizeStr:
            continue
        
        #4196B=4.0625KB，显示为4.062KB，需要处理
        if sectorSizeStr == "4.062KB":
            sectorSizeStr = "4.0625KB"
        result, sectorSizeNum = changUnit2B(sectorSizeStr)
        if not result:
            errMsg = getMsg(lang, "Change.unit.failed")
            return (True, [], errMsg)
        
        if sectorSizeNum == 4096.0 or sectorSizeNum == 4160.0:
            is4KDiskList.append(diskId)
        
    if is4KDiskList:
        errMsg = getMsg(lang, "exist.4K.disk", ', '.join(is4KDiskList))
        return (True, is4KDiskList, errMsg)
    
    return(False, [], "")


def changUnit2B(strValue, base=1024):
    """ 根据传入的值转换单位为B
    :param strValue:
    :param base: 1000 or 1024
    :return:
    """
    floatValue = 0.0
    try:
        if not strValue:
            return (False, floatValue)
        if re.search("PB", strValue):
            floatValue = float(strValue.split('P')[0].strip()) * base * base * base * base * base
        elif re.search("TB", strValue):
            floatValue = float(strValue.split('T')[0].strip()) * base * base * base * base
        elif re.search("GB", strValue):
            floatValue = float(strValue.split('G')[0].strip()) * base * base * base
        elif re.search("MB", strValue):
            floatValue = float(strValue.split('M')[0].strip()) * base * base
        elif re.search("KB", strValue):
            floatValue = float(strValue.split('K')[0].strip()) * base
        elif re.search("B", strValue):
            floatValue = float(strValue.split('B')[0].strip())
        else:
            return (False, floatValue)

        return(True, floatValue)
    
    except Exception:
        return (False, floatValue)


def changUnit2KB(strValue, base=1024):
    """ 根据传入的值转换单位为B
    :param strValue:
    :param base: 1000 or 1024
    :return:
    """
    floatValue = 0.0
    try:
        if not strValue:
            return (False, floatValue)

        if re.search("PB", strValue):
            floatValue = float(strValue.split('P')[0].strip()) * base * base * base * base * base
        elif re.search("TB", strValue):
            floatValue = float(strValue.split('T')[0].strip()) * base * base * base * base
        elif re.search("GB", strValue):
            floatValue = float(strValue.split('G')[0].strip()) * base * base * base
        elif re.search("MB", strValue):
            floatValue = float(strValue.split('M')[0].strip()) * base * base
        elif re.search("KB", strValue):
            floatValue = float(strValue.split('K')[0].strip())
        elif re.search("B", strValue):
            floatValue = float(strValue.split('B')[0].strip()) / base
        else:
            return (False, floatValue)

        return (True, floatValue)

    except Exception:
        return (False, floatValue)

def changUnit2GB(strValue, isLabelCap=False):
    """ 根据传入的值转换单位为GB
    :param strValue:
    :param isLabelCap: 是否为标称容量
    :return:
    """
    floatValue = 0.0
    unit = 1024
    try:
        if not strValue:
            return False, floatValue

        if isLabelCap:
            unit = 1000

        if re.search("PB?", strValue):
            floatValue = float(strValue.split('P')[0].strip()) * unit * unit
        elif re.search("TB?", strValue):
            floatValue = float(strValue.split('T')[0].strip()) * unit
        elif re.search("GB?", strValue):
            floatValue = float(strValue.split('G')[0].strip())
        elif re.search("MB?", strValue):
            floatValue = float(strValue.split('M')[0].strip()) / unit
        elif re.search("KB?", strValue):
            floatValue = float(strValue.split('K')[0].strip()) / unit / unit
        elif re.search("B" , strValue):
            floatValue = float(strValue.split('B')[0].strip()) / unit / unit / unit
        else:
            return False, floatValue

        return True, floatValue
    
    except Exception:
        return False, floatValue

def changUnit2GBLabelCap(strValue):
    """ 根据传入的标签容量值转换单位为GB
    :param strValue:
    :return:
    """
    floatValue = 0.0
    ratio = 1000
    try:
        if not strValue:
            return False, floatValue
        if re.search("PB?", strValue):
            floatValue = float(strValue.split('P')[0].strip()) * ratio * ratio
        elif re.search("TB?", strValue):
            floatValue = float(strValue.split('T')[0].strip()) * ratio
        elif re.search("GB?", strValue):
            floatValue = float(strValue.split('G')[0].strip())
        elif re.search("MB?", strValue):
            floatValue = float(strValue.split('M')[0].strip()) / ratio
        elif re.search("KB?", strValue):
            floatValue = float(strValue.split('K')[0].strip()) / ratio / ratio
        elif re.search("B" , strValue):
            floatValue = float(strValue.split('B')[0].strip()) / ratio / ratio / ratio 
        else:
            return False, floatValue

        return True, floatValue
    
    except Exception:
        return False, floatValue


def changUnit2GBLabelCapForThreeDecimalDigits(strValue):
    """ 根据传入的标签容量值转换单位为GB，保留三位小数
    :param strValue:
    :return:
    """
    floatValue = decimal.Decimal('0.000')
    ratio = 1024
    try:
        if not strValue:
            return False, floatValue
        if re.search("PB?", strValue):
            floatValue = (decimal.Decimal(strValue.split('P')[0].strip()) * ratio * ratio).quantize(decimal.Decimal('0.000'))
        elif re.search("TB?", strValue):
            floatValue = (decimal.Decimal(strValue.split('T')[0].strip()) * ratio).quantize(decimal.Decimal('0.000'))
        elif re.search("GB?", strValue):
            floatValue = (decimal.Decimal(strValue.split('G')[0].strip())).quantize(decimal.Decimal('0.000'))
        elif re.search("MB?", strValue):
            floatValue = (decimal.Decimal(strValue.split('M')[0].strip()) / ratio).quantize(decimal.Decimal('0.000'))
        elif re.search("KB?", strValue):
            floatValue = (decimal.Decimal(strValue.split('K')[0].strip()) / ratio / ratio).quantize(decimal.Decimal('0.000'))
        elif re.search("B", strValue):
            floatValue = (decimal.Decimal(strValue.split('B')[0].strip()) / ratio / ratio / ratio).quantize(
                decimal.Decimal('0.000'))
        else:
            return False, floatValue

        return True, floatValue

    except Exception:
        return False, floatValue
def changUnit2GBLabel2DevCap(strValue):
    """ 根据传入的标签容量值转换为等价的设备容量，单位为GB
    :param strValue:
    :return:
    """
    floatValue = 0.0
    ratio = 1000.0/1024.0
    try:
        if not strValue:
            return False, floatValue
        if re.search("PB?", strValue):
            floatValue = float(strValue.split('P')[0].strip()) * pow(ratio, 3) * 1000 * 1000
        elif re.search("TB?", strValue):
            floatValue = float(strValue.split('T')[0].strip()) * pow(ratio, 3) * 1000
        elif re.search("GB?", strValue):
            floatValue = float(strValue.split('G')[0].strip()) * pow(ratio, 3)
        elif re.search("MB?", strValue):
            floatValue = float(strValue.split('M')[0].strip()) * pow(ratio, 2) / 1000
        elif re.search("KB?", strValue):
            floatValue = float(strValue.split('K')[0].strip()) * ratio / 1000 / 1000
        elif re.search("B" , strValue):
            floatValue = float(strValue.split('B')[0].strip()) / 1000 / 1000 / 1000 
        else:
            return False, floatValue

        formatValue = decimal.Decimal(str(floatValue)).quantize(decimal.Decimal('0.000'))
        return True, float(formatValue)
    
    except Exception:
        return False, floatValue


def changUnit2GBDecimal(strValue):
    '''
    @summary: 根据传入的值转换单位为GB
    @return: True/False, floatValue
    '''
    floatValue = decimal.Decimal("0.0")
    unitValue = decimal.Decimal("1024")
    
    try:
        if not strValue:
            return(False, floatValue)

        if re.search("PB", strValue):
            floatValue = decimal.Decimal(strValue.split('P')[0].strip()) * unitValue * unitValue
        elif re.search("TB", strValue):
            floatValue = decimal.Decimal(strValue.split('T')[0].strip()) * unitValue
        elif re.search("GB" , strValue):
            floatValue = decimal.Decimal(strValue.split('G')[0].strip())
        elif re.search("MB" , strValue):
            floatValue = decimal.Decimal(strValue.split('M')[0].strip()) / unitValue
        elif re.search("KB" , strValue):
            floatValue = decimal.Decimal(strValue.split('K')[0].strip()) / unitValue / unitValue
        elif re.search("B" , strValue):
            floatValue = decimal.Decimal(strValue.split('B')[0].strip()) / unitValue / unitValue / unitValue
        elif decimal.Decimal(strValue.strip()) == decimal.Decimal("0.0"):
            return(True, floatValue)
        else:
            return(False, floatValue)

        return(True, floatValue)
    
    except Exception:
        return (False, floatValue)

 
def getDiskCapListBaseOn50GBDiff(diskCapItr):
    """给定磁盘容量容器（列表或者集合），差值50GB以内则认为是同种类型的容量硬盘。
    :param diskCapItr:
    :return:
    """
    diskCapList = list(diskCapItr)
    if not diskCapList:
        return []
    sortedDiskCapList = sorted(diskCapList, reverse=True)
    base = sortedDiskCapList[0]
    newDiskCapList = [base]
    for cap in sortedDiskCapList[1:]:
        if base - cap <= 50:
            newDiskCapList.append(base)
        else:
            base = cap
            newDiskCapList.append(base)
    return sorted(newDiskCapList)


def hasSSDDisks(enclosureId, diskGeneralList):
    '''
    @summary: 判断框中是否下挂SSD盘
    @param enclosureId: 框id
    @param diskGeneralList: 所有硬盘信息集合
    @return: 
        True: 框中下挂SSD盘
        False: 框中没有下挂SSD盘
    '''
    for line in diskGeneralList:
        diskID = line.get("ID")
        diskType = line.get("Type")
        if enclosureId in diskID and diskType == "SSD":
            return True
    return False

def getEngineSet(cli, lang):
    '''
    @summary: 获取引擎集合
    @param cli: cli对象
    @param lang: 语言lang
    @return:
        flag:
            True: 获取成功
            False: 获取失败
        ret: 
            flag为True时，引擎集合
            flag为False时，cli回显
        errMsg: 错误消息
    '''
    cmd = "show storage_engine |filterColumn include columnList=ID"
    checkRet = cliUtil.excuteCmdInCliMode(cli, cmd, True, lang)
    if checkRet[0] != True: 
        if not cliUtil.hasCliExecPrivilege(checkRet[1]):
            return (cliUtil.RESULT_NOSUPPORT,checkRet[1],'')
        return checkRet
    
    cliRet = checkRet[1]
    cliRetLinesList = cliUtil.getHorizontalCliRet(cliRet)
    if len(cliRetLinesList) == 0:
        errMsg = getMsg(lang, "cannot.get.engine.info")
        return (cliUtil.RESULT_NOCHECK, cliRet, errMsg)
    
    engineSet = set()
    for retDict in cliRetLinesList:
        ctrlId = retDict.get("ID")
        engineSet.add(ctrlId)
    
    return (True, engineSet, cliRet)

def getPCIeSwitchNum(cli, lang):
    '''
    @summary: 获取PCIe交换机个数
    @param cli: cli对象
    @param lang: 语言lang
    @return: (falg, ret, errMsg)
        flag:
            True: 获取成功
            False: 获取失败
        ret: 
            flag为True时，PCIe交换机个数
            flag为False时，cli回显
        errMsg: 错误消息
    '''
    cliRet = ""
    errMsg = ""

    try:
        cmd = "show enclosure"
        checkRet = cliUtil.excuteCmdInCliMode(cli, cmd, True, lang)
        if checkRet[0] != True: 
            return checkRet
        
        cliRet = checkRet[1]
        dataSwitchList = []
        cliRetLinesList = cliUtil.getHorizontalCliRet(cliRet)
        
        if len(cliRetLinesList) == 0:
            errMsg = getMsg(lang, "cannot.get.enclosure.info")
            return (False, cliRet, errMsg)
        
        for line in cliRetLinesList:
            logicType = line.get("Logic Type")
            frameId = line.get("ID")
            if not "Data Switch" in logicType:
                continue
            else:
                dataSwitchList.append(frameId)
                
        return (True, len(dataSwitchList), "")
    except:
        errMsg = getMsg(lang, "cannot.get.pcie.switch.info")
        return (False, cliRet, errMsg)
            
def checkPCIePortExists(cli, lang):
    '''
    @summary: 判断是否需要检查PCIe端口，此方法用于V3R3及之后版本使用
    @param cli: cli对象
    @param lang: 语言lang
    @return: (falg, ret, errMsg)
        flag:
            True: 获取成功
            False: 获取失败
        ret: 
            flag为True时，需要检查PCIe端口
            flag为False时，不需要检查PCIe端口
        errMsg: 错误消息
    '''
    getControllerIdListRet = cliUtil.getControllerIdList(cli, lang)
    if getControllerIdListRet[0] != True:
        return getControllerIdListRet
    
    engSet = set([ctrlId[0] for ctrlId in getControllerIdListRet[1]])
    if len(engSet) <= 1:
        return (True, False, "")
    return (True, True, "")

def checkEarlierThanPCIePortExists(cli, lang):
    '''
    @summary: 判断是否需要检查PCIe端口，此方法用于V3R3之前版本使用
    @param cli: cli对象
    @param lang: 语言lang
    @return: (falg, ret, errMsg)
        flag:
            True: 获取成功
            False: 获取失败
        ret: 
            flag为True时，需要检查PCIe端口
            flag为False时，不需要检查PCIe端口
        errMsg: 错误消息
    '''
    storageTypeRet = cliUtil.getStorageType(cli, lang)
    if storageTypeRet[0] != True:
        return storageTypeRet
    
    product_series = storageTypeRet[1]
    
    getControllerIdListRet = cliUtil.getControllerIdList(cli, lang)
    if getControllerIdListRet[0] != True:
        return getControllerIdListRet
    
    ctrlNum = len(getControllerIdListRet[1])
    
    if ctrlNum <= 2 or product_series == cliUtil.SERIES_V3:
        return (True, False, "")
    
    return (True, True, "")
        
def getBBUConfig(cli, lang):
    '''
    @summary: 获取单个引擎的BBU规格配置
    @param cli: cli对象
    @param lang: 语言lang
    @return: (falg, ret, errMsg)
        flag:
            True: 获取成功
            False: 获取失败
        ret: 
            flag为True时，BBU规格
            flag为False时，cli回显
        errMsg: 错误消息
    '''
    getProductModelRet = cliUtil.getProductModel(cli, lang)
    if getProductModelRet[0] != True:
        return getProductModelRet
    
    pdtModel = getProductModelRet[1]
    
    if config.BBU_OF_ENGINE_CONFIG_DICT.has_key(pdtModel):
        return (True, config.BBU_OF_ENGINE_CONFIG_DICT.get(pdtModel), "")
    else:
        errMsg = getMsg(lang, "cannot.get.bbu.config")
        return (False, "", errMsg)

def getEngCtrlNum(enclosureID, controllerIdList):
    '''
    @summary: 获取引擎下控制器数量
    @param cli: cli对象
    @param controllerIdList: 控制器ID列表
    @return: 特定引擎下控制器数量
    '''
    
    eng = enclosureID[-1]
    engCtrlNum = len([ctrlId for ctrlId in controllerIdList if eng in ctrlId])
    if engCtrlNum % 2 != 0:
        engCtrlNum += 1
    return engCtrlNum
    
def getEnclosureFanConfig(cli, enclosureInfo, controllerIdList, highDensityDiskEnclosureIdList, lang):
    '''
    @summary: 获取风扇的规格配置
    @param cli: cli对象
    @param enclosureInfo: 机框信息
    @param highDensityDiskEnclosureIdList: 高密框集合
    @param lang: 语言lang
    @return: (falg, ret, errMsg)
        flag:
            True: 获取成功
            False: 获取失败
        ret: 
            flag为True时，风扇的规格
            flag为False时，cli回显
        errMsg: 错误消息
    '''
    storageTypeRet = cliUtil.getStorageType(cli, lang)
    if storageTypeRet[0] != True:
        return storageTypeRet
    product_series = storageTypeRet[1]
    
    enclosureID = enclosureInfo.get("ID")
    enclosureHeight = enclosureInfo.get("Height(U)")
    
    for enclosureType in ["DSW", "DAE", "ENG", "CTE"]:
        if enclosureType in enclosureID:
            if enclosureHeight == "6" and enclosureType in ["ENG", "CTE"]:
                #6U高端2C和4C场景，都需要2个辅助散热模块，风扇个数一样
                if product_series == cliUtil.SERIES_18000:
                    return (True, 12, "")
                #6U中低端2C和4C场景，风扇个数不一样
                else:
                    engCtrlNum = getEngCtrlNum(enclosureID, controllerIdList)
                    return (True, engCtrlNum * 3, "")
            else:
                daeType = "--"
                if enclosureID in highDensityDiskEnclosureIdList:
                    daeType = "high-density"
                key = (enclosureType, enclosureHeight, daeType)
                if config.FAN_CONFIG_DICT.has_key(key):
                    return (True, config.FAN_CONFIG_DICT.get(key), "")
                    
    return (False, "", getMsg(lang, "cannot.get.fan.config"))

def checkSystemStatus(cliRet, lang):
    '''
    @summary: 根据回显判断设备是否开工正常，Health Status及Running Status都要为Normal，版本号要正常
    @param cliRet: cli回显
    @param lang: 语言lang
    @return: (flag, errMsg)
        flag:
            True: 系统状态正常
            False： 系统状态异常
        errMsg: 错误消息
    '''
    healthStatus = ""
    runningStatus = ""
    productModel = ""
    productVersion = ""
    
    lineList = cliRet.splitlines()
    for line in lineList:
        fields = line.split(":")
        if len(fields) < 2:
            continue
        
        fieldName = fields[0].strip()
        fieldValue = fields[1].strip()
        
        if fieldName == "Health Status":
            healthStatus = fieldValue
        elif fieldName == "Running Status":
            runningStatus = fieldValue
        elif fieldName == "Product Model":
            productModel = fieldValue
        elif fieldName == "Product Version":
            productVersion = fieldValue
    
    if len(healthStatus) == 0 or len(runningStatus) == 0:
        return (False, getMsg(lang, "cannot.get.system.info"))
    
    if len(productModel) == 0 or len(productVersion) == 0 or productModel == "--" or productVersion == "--":
        return (False, getMsg(lang, "cannot.get.product.version.info"))
    
    if healthStatus != STATUS_NORMAL:
        return (False, getMsg(lang, "system.health.status.abnormal", healthStatus))
    
    if runningStatus != STATUS_NORMAL:
        return (False, getMsg(lang, "system.running.status.abnormal", runningStatus))
    
    return (True, "")

def getRealCapacity(capacity):
    '''
    @summary: 获取数值
    '''
    matchCapacity = re.search("\d+\.?\d*", capacity)
    if matchCapacity:
        return matchCapacity.group()
    else:
        return ""

def getBaseName(file_path):
    '''
    @summary: 返回文件路径的文件名，不包含后缀
    @param file_path:文件路径
    @return: 返回不包含后缀的文件名字符串
    '''
    file_name = os.path.basename(file_path)
    if FILE_SUFFIX in file_name:
        dot_index = file_name.rindex(FILE_SUFFIX)
        return file_name[0:dot_index]
    else:
        return file_name
    
def getLogger(loggerInstance, pyFilePath):
    '''
    @summary: 获取日志类
    @param loggerInstance: logger实例
    @param pyFilePath: py文件路径
    '''
    pyFileName = getBaseName(pyFilePath)
    return logger.Logger(loggerInstance, pyFileName)

def checkPortsBitError(cli, cmd, ports, lang, py_java_env, LOGGER):
    '''
    @summary: 检查所有端口在特定时间段内是否有持续增加的误码
    @param cli: cli对象
    @param cmd: cli命令
    @param ports: 端口列表
    @param lang: 语言对象
    @return:
        flag:
            True: 检查通过
            False: 检查不通过
        cliRetAll: cli回显
        errMsg: 错误时的消息
    '''
    flag = True
    errMsg = ""
    cliRetAll = ""
    
    #刷新进度
    refreshProcess(py_java_env, 1, LOGGER)    
    firstResultDictRet = getPortsBitErrorResultDict(cli, cmd, ports, lang)
    firstCliRet = firstResultDictRet[1]
    if firstResultDictRet[0] != True:
        return (firstResultDictRet[0], firstCliRet, firstResultDictRet[2])
    firstResultDict = firstResultDictRet[3]
    
    #刷新进度
    refreshProcess(py_java_env, 2, LOGGER)
    retriedTimes = int(PORTS_BIT_ERROR_SPEC / PORTS_BIT_ERROR_INTERVAL)
    
    currentProcess = 2
    singleProcess = 98.0/(retriedTimes*PORTS_BIT_ERROR_INTERVAL)
    for i in range(0, retriedTimes):
        #刷新进度
        currentProcess = refreshProcessWithSleep(currentProcess, PORTS_BIT_ERROR_INTERVAL, singleProcess, py_java_env, LOGGER)
        
        nextResultDictRet = getPortsBitErrorResultDict(cli, cmd, ports, lang)
        nextCliRet = nextResultDictRet[1]
        cliRetAll = firstCliRet + nextCliRet
        if nextResultDictRet[0] != True:
            return (nextResultDictRet[0], cliRetAll, nextResultDictRet[2])
        nextResultDict = nextResultDictRet[3]
        
        for portName in ports:
            firstBitErrorList = firstResultDict.get(portName)
            nextbitErrorList = nextResultDict.get(portName)
            
            if len(firstBitErrorList) != len(nextbitErrorList):
                continue
            
            cmpResult = cmpDictList(firstBitErrorList, nextbitErrorList)
            if cmpResult == -1:
                flag = False
                errMsg += getMsg(lang, "port.exists.error.bits", portName)
        
        if not flag:
            return (False, cliRetAll, errMsg)
            
    return (True, cliRetAll, "")
        
def getPortsBitErrorResultDict(cli, cmd, ports, lang):
    '''
    @summary: 获取指定端口列表对应的误码列表
    @param cli: cli对象
    @param cmd: cli命令
    @param ports: 端口列表
    @param lang: 语言对象
    @return: 
        flag: 
            True: 获取成功
            False: 获取失败
        cliRet: cli回显
        errMsg: 错误时的消息
        resultDict: 以字典的形式返回对应端口的误码列表。键对应端口，值对应该端口的误码列表
    '''
    resultDict = {}
    
    checkRet = cliUtil.excuteCmdInDeveloperMode(cli, cmd, True, lang)
    cliRet = checkRet[1]
    if checkRet[0] != True:
        return (checkRet[0], cliRet, checkRet[2], None)
    
    for portName in ports:
        getBitErrorResultListRet = getPortBitErrorResultList(cliRet, portName, lang)
        if getBitErrorResultListRet[0] != True:
            return (getBitErrorResultListRet[0], cliRet, getBitErrorResultListRet[2], None)
        
        resultDict.setdefault(portName, getBitErrorResultListRet[1])
    return (True, cliRet, "", resultDict)

def getPortBitErrorResultList(cliRet, portName, lang):
    '''
    @summary: 获取每个端口的误码列表
    @param cliRet: cli回显
    @param portName: 端口名
    @param lang: 语言对象
    @return: 
        flag: 
            True: 获取成功
            False: 获取失败
        resultList: 误码列表
        errMsg: 错误时的消息
    '''
    portInfoRet = cliUtil.getSplitedCliRet(cliRet, getSplitedPortWords(portName))
    if len(portInfoRet) == 0:
        return (True, [], "")
        
    cliRetLinesList = cliUtil.getHorizontalCliRet(portInfoRet)
    if len(cliRetLinesList) == 0:
        errMsg = getMsg(lang, "cannot.get.port.info", portName)
        return (False, None, errMsg)
    
    return (True, cliRetLinesList, "")
    
def cmpDictList(firstList, secondList):
    '''
    @summary: 判断误码数是否有增加
    @param firstList: 第一个列表（列表中的内容为字典）
    @param secondList: 第二个列表（列表中的内容为字典，且字典的键与第一个列表中字典的键一致，同时第二个列表的长度与第一个列表的长度一致）
    @return: 
        -1: 第一个列表中的元素小于第二个列表中的元素
         0: 第一个列表与第二个列表相等
         1: 第一个列表中的元素大于第二个列表中的元素
    '''
    for i in range(0, len(firstList)):
        firstDict = firstList[i]
        secondDict = secondList[i]
        
        for key in firstDict.keys():
            firstValue = str(firstDict.get(key))
            secondValue = str(secondDict.get(key))
            
            if firstValue.isdigit() and secondValue.isdigit():
                ret = cmp(long(firstValue), long(secondValue))
                if ret != 0:
                    return ret
    return 0

def getSplitedPortWords(portName):
    '''
    @summary: 根据端口名获取对应的分割字
    @param portName: 端口名
    @return: 分割字
    '''
    if portName == "PCIe":
        portName = "PCIE" 
    return portName + " port:"

def downloadErrCodeFile():
    '''
    @summary: 使用SFTP功能将错误码文件下载到本地
    '''
    return

def getErrCodeInfoDict(lang, fileName="event_xve"):
    '''
    @summary: 获取对应语言的错误码信息，将错误码信息转换为以错误码ID为key，以含错误码详细信息和修复建议的字典为value的字典
    @param lang: 语言对象
    @param fileName: 错误码文件默认为error_{zh|en}.xml
    '''
    try:
        #1.下载错误码文件到本地
        downloadErrCodeFile()
        #2.获取xml中根节点对象
        root = ElementTree.parse(os.path.join(os.path.abspath(
            os.path.join(os.path.dirname(__file__), "..")), "res", "%s_%s.xml" % (fileName, lang)))
        #3.找到error子节点
        errorNodes = root.findall("eventDefinition/param")

        errCodeInfoDict = {}
        for errorNode in errorNodes:
            #4.获取错误码ID
            eventId = errorNode.attrib.get("eventID","")
            #5.获取错误码修复建议
            suggesions = errorNode.attrib.get("suggestion","")
            #6.获取误码对象名称
            objName = errorNode.attrib.get("objName","")
            errCodeInfoDict[eventId] = {"objName":objName, "suggesions":suggesions}
        
        return errCodeInfoDict
    except Exception:
        #解析失败时，使用默认的修复建议策略
        return {}

def getErrSuggestions(lang, errCodeInfoDict, errId):
    '''
    @summary: 获取单条错误码对应的修复建议
    @param lang: 语言对象
    @param errCodeInfoDict: 错误码信息字典
    @param errId: 错误码ID
    '''
    
    suggestions = ""
    
    errCodeInfo = errCodeInfoDict.get(errId, {})
    suggestions += errCodeInfo.get("suggesions", "")

    return suggestions

def getSuggestions(lang, errCodeInfoDict, alarmIds, des=None):
    '''
    @summary: 获取多条错误码对应的修复建议
    @param lang: 语言对象
    @param errCodeInfoDict: 错误码信息字典
    @param errIds: 错误码ID列表
    '''
    sugs =  "\n".join([getErrSuggestions(lang, errCodeInfoDict, alarmId) for alarmId in alarmIds])
    
    if des is None:
        return sugs
    else:
        return des + "\n" + sugs

def getObjAlarmIds(lang, cli, obj):
    '''
    @summary: 根据指定对象查询该对象下的告警ID列表
    @param lang: 语言对象
    @param cli: cli对象
    @param obj: 指定对象
    '''
    alarmIds = set()
    cmd = "show alarm object_type=%s|filterColumn include columnList=ID"  % (obj)
    checkRet = cliUtil.excuteCmdInCliMode(cli, cmd, True, lang)
    
    cliRet = checkRet[1]
    cliRetLinesList = cliUtil.getHorizontalCliRet(cliRet)
    for line in cliRetLinesList:
        alarmId = line.get("ID")
        alarmId = str(int(alarmId, 16))
        
        alarmIds.add(alarmId)

    return alarmIds

def getSuggestionResults(lang, errCodeInfoDict, cli, obj, des=None):
    '''
    @summary: 根据指定对象，返回该指定对象下的所有错误码修复建议
    @param lang: 语言对象
    @param errCodeInfoDict: 错误码信息字典
    @param cli: cli对象
    @param obj: 指定对象
    '''
    try:
        alarmIds = getObjAlarmIds(lang, cli, obj)
        result = getSuggestions(lang, errCodeInfoDict, alarmIds, des)
        
        return result
    except:
        return ""

def isSigleModelWithCliRet(cli, lang):
    '''
          控制器模式检查：
                  执行show system config_model命令，查看返回结果：Configuration Model为Multi-Controller时多多控，为Single-Controller时为单控
    '''
    
    cliRet = ""
    errMsg = ""
    
    cmd = "show system config_model"
    checkRet = cliUtil.excuteCmdInCliMode(cli, cmd, True, lang)
    cliRet = checkRet[1]
    if "single" in cliRet.lower():
        return True, cliRet
    else:
        return False, cliRet
		
		
def isSigleModel(cli, lang):
    '''
          控制器模式检查：
                  执行show system config_model命令，查看返回结果：Configuration Model为Multi-Controller时多多控，为Single-Controller时为单控
    '''
    
    cliRet = ""
    errMsg = ""
    
    cmd = "show system config_model"
    checkRet = cliUtil.excuteCmdInCliMode(cli, cmd, True, lang)
    cliRet = checkRet[1]
    if "single" in cliRet.lower():
        return True
    else:
        return False

def isSigleModelNew(cli, lang):
    '''
          控制器模式检查：
                  执行show system config_model命令，查看返回结果：Configuration Model为Multi-Controller时多多控，为Single-Controller时为单控
    '''
    
    cliRet = ""
    errMsg = ""
    
    cmd = "show system config_model"
    checkRet = cliUtil.excuteCmdInCliMode(cli, cmd, True, lang)
    cliRet = checkRet[1]
    if "single" in cliRet.lower():
        return True, cliRet
    else:
        return False, cliRet


def parse_upgradePackage(cli, lang):
    '''
    @summary: 执行show upgrade packge命令，将Software Version与HotPatch Version的
              回显存放到同一个字典列表中，并增加Version Type键来区分Version类型,并返回CLI回显
    @param cli: cli对象
    @param lang: 语言lang
    '''    
    cmd = "show upgrade package"
    softwareVersionList = []
    hotPatchVersionList = []

    (flag, cliRet, errMsg) = cliUtil.excuteCmdInCliMode(cli, cmd, True, lang)
    if flag != True:
        return ((flag, cliRet, errMsg),softwareVersionList,hotPatchVersionList)
    
    softwareVersionIndex = cliRet.find("Software Version")
    hotPatchVersionIndex = cliRet.find("HotPatch Version")
    softwareVersionList = cliUtil.getHorizontalCliRet(cliRet[(softwareVersionIndex):hotPatchVersionIndex])
    hotPatchVersionList = cliUtil.getHorizontalCliRet(cliRet[(hotPatchVersionIndex):])
    
    if len(softwareVersionList) == 0 or len(hotPatchVersionList) == 0:
        errMsg += getMsg(lang, "cannot.get.upgrade.package.info")
        return ((False, cliRet, errMsg) , softwareVersionList , hotPatchVersionList)
        
    for softwareVersion in softwareVersionList:
        if softwareVersion["Current Version"] == "--":   
            flag = False
            errMsg += getMsg(lang, "cannot.get.contrller.version.info", softwareVersion.get("Name"))
    
    if not isControllerVersionSame(softwareVersionList):
        errMsg += getMsg(lang, "controller.version.not.consistence")
        return ((False, cliRet, errMsg),softwareVersionList,hotPatchVersionList)
    
    return ((flag, cliRet, errMsg),softwareVersionList,hotPatchVersionList)

def isControllerVersionSame(softwareVersionList): 
    '''
    @summary:校验控制器版本是否一致
    @param softwareVersionList: 控制器版本列表
    @return: 
        True:控制器版本一致
        False:控制器软件版本不一致
    '''  
    VersionSet = set(softwareVersion.get("Current Version") for softwareVersion in softwareVersionList)
    if len(VersionSet) !=1:
        return False
    return True

def getCurrentVersion(softwareVersionList, lang):
    '''
    @summary: 通过software信息字典列表获取版本信息
    '''
    currentVersion = ""
    errMsg = ""
    for controller in softwareVersionList:
        currentVersion = controller.get("Current Version")
        return (True, currentVersion, "")
    
    errMsg = getMsg(lang, "cannot.get.product.version.info")
    return (False, "", errMsg)

def getEngineList(softwareVersionList, lang):
    '''
    @summary: 通过software信息字典列表获取引擎信息
    '''
    errMsg = ""
    engineList = []
    for controller in softwareVersionList:
        contrName = controller.get("Name")
        engineId = contrName[:1]
        engineList.append(engineId)
    if len(engineList) == 0:
        errMsg = getMsg(lang, "cannot.get.controller.info")
        return (False, engineList, errMsg)
    return (True, list(set(engineList)),errMsg )
def getHistoryVersion(softwareVersionList, lang):
    '''
    @summary: 通过software信息字典列表获取历史版本信息
    '''
    historyVersion = ""
    errMsg = ""
    for controller in softwareVersionList:
        historyVersion = controller.get("History Version")
        return (True, historyVersion, "")
    
    errMsg = getMsg(lang, "cannot.get.product.version.info")
    return (False, "", errMsg)

def getCurrentVersionFilterBVer(softwareVersionList, lang):
    '''
    @summary: 通过software信息字典列表获取版本信息,并过滤其中的B版本  V300R001C10B010 -> V300R001C10
    '''
    currentVersion = ""
    errMsg = ""
    for controller in softwareVersionList:
        currentVersion = controller.get("Current Version")
        whereIsBVer = currentVersion.find("B")
        if whereIsBVer != -1:
            currentVersion = currentVersion[:whereIsBVer]
        return (True, currentVersion, "")
    
    errMsg = getMsg(lang, "cannot.get.product.version.info")
    return (False, "", errMsg)

def getHotPatchVersion(hotPatchVersionList, lang):
    '''
    @summary: 通过hotPatch信息字典列表获取补丁信息
    @return: flag, hotPatch, errMsg
    flag:
        True:补丁信息一致，且获取成功
        False:补丁信息不一致，或未安装补丁
    hotPatch:补丁信息
    errMsg:错误信息
    '''
    hotPatchVersion = ""
    errMsg = ""
    flag = True
    
    if not isControllerVersionSame(hotPatchVersionList):
        errMsg += getMsg(lang, "controller.hot.patch.version.not.consistence")
        return (False, "", errMsg)  
    
    for controller in hotPatchVersionList:
        hotPatchVersion = controller.get("Current Version")
        return (True, hotPatchVersion, "")   
    
    errMsg = getMsg(lang, "cannot.get.hot.patch.version.info")
    return (False, hotPatchVersion, errMsg)   
    
def isRiskVersion(currentVersion, bugVersion, hotPatchVersion = "", repairHotPatchDict = {}):
    '''
    @summary: 检查当前版本是否存在风险
    @return: True:存在风险
            False:不存在风险
    '''
    #需要打补丁的版本
    if currentVersion in bugVersion and currentVersion in repairHotPatchDict:
        if hotPatchVersion == "--" or hotPatchVersion < repairHotPatchDict[currentVersion]:
            return True
        else:
            return False
    #不需要打补丁的风险版本
    elif currentVersion in bugVersion:
        return True
    #不是风险版本
    else:
        return False  

  
def getCurSysDate(cli):
    '''
    @summary: 获取设备当前时间（年-月-日）
    '''
    cliRet = cli.execCmd("show system general")
    if not cliRet:
        return False, '', ''
    
    for line in cliRet.splitlines():
        #eg:"  Time                : 2016-10-12/11:48:34 +08:00 "
        if line.strip().startswith('Time'):
            sysDate = line.split(':')[1].split('/')[0].strip()
            return True, sysDate, cliRet
    
    return False, '', cliRet

def getTimeDifference(oldTime, nowTime): 
    '''
    @summary: 获取时差，格式：（年 - 月 - 日），单位：天
    '''  
    try:
        oldTimeYear = int(oldTime.split("-")[0])
        oldTimeMonth = int(oldTime.split("-")[1])
        oldTimeDay = int(oldTime.split("-")[2])
        
        nowTimeYear = int(nowTime.split("-")[0])
        nowTimeMonth = int(nowTime.split("-")[1])
        nowTimeDay = int(nowTime.split("-")[2])
        
        timeDifference = (datetime.datetime(nowTimeYear,nowTimeMonth,nowTimeDay) - datetime.datetime(oldTimeYear,oldTimeMonth,oldTimeDay)).days
        
        return timeDifference
    
    except Exception:
        return ""
        

def qryEventDetail(cli, almSn):
    '''
    @summary: 获取告警详情
    '''
    cliRet = cli.execCmdNoLog("show event sequence=" + almSn)
    if not cliRet:
        return False, '', ''
    
    for line in cliRet.splitlines():
        if line.split(':')[0].strip() == 'Detail':
            detail = line.split(':')[1].strip()
            return detail, cliRet
    
    return '', cliRet


def getLogicEngineOfDisk(diskId, productModel):
    """
    @summary: 获取硬盘所属的逻辑引擎
    """
    #硬盘id的第一个数字即为该硬盘所属的逻辑引擎
    firstDigit = re.search('([A-Z]+)(\d)', diskId).group(2)
    if firstDigit is None:
        return 0
    
    firstDigit = int(firstDigit)
    
    logicEngine = firstDigit
    
    #6U4C大卡环境逻辑i引擎需特殊处理
    bigCardModelList = ["6800 V3", "6900 V3", "18500 V3", "18800 V3", "6800F V3", "18500F V3", "18800F V3"]
    if productModel in bigCardModelList:
        secondDigit = re.search('([A-Z]+)(\d)(\d|[A-F])', diskId).group(3)
        if secondDigit is None:
            return firstDigit
        
        if secondDigit <= "7":
            logicEngine = firstDigit * 2 + 0
        else:
            logicEngine = firstDigit * 2 + 1
    
    return logicEngine


def isBugProductVersion(currentVersion, bugProductVersionList):
    '''
    @summary: 判断产品版本是否是某个已知产品问题的产品版本
    @param: bugProductVersionList
    eg:("V300R003C00", "V300R003C00SPC300]", "V300R003C10.*"]/V300R003C00到V300R003C00SPC300（不包含V300R003C00，包含V300R003C00SPC300），V300R003C10所有版本
    '''
    for bugProductVersion in bugProductVersionList:
        if bugProductVersion.find(",") > -1:
            startVersion = bugProductVersion.split(",")[0][1:].strip()
            endVersion = bugProductVersion.split(",")[1][:-1].strip()
            isContainStartVersion = bugProductVersion.startswith("[")
            isContainEndVersion = bugProductVersion.endswith("]")
            
            if isContainStartVersion and isContainEndVersion:
                if currentVersion >= startVersion and currentVersion <= endVersion:
                    return True
            
            if isContainStartVersion and (not isContainEndVersion):
                if currentVersion >= startVersion and currentVersion < endVersion:
                    return True
            
            if (not isContainStartVersion) and isContainEndVersion:
                if currentVersion > startVersion and currentVersion <= endVersion:
                    return True
            
            if (not isContainStartVersion) and (not isContainEndVersion):
                if currentVersion > startVersion and currentVersion < endVersion:
                    return True
        else:
            if re.match(bugProductVersion, currentVersion):
                return True
    
    return False


def checkProductModelAndVersion(cli, modelAndVersionListDict, LANG):
    """
    @summary: 检查设备型号和版本是否为指定的型号和版本
    @param modelAndVersionListDict: 问题型号与对应的版本，型号与版本为正则表达式，若问题版本为某个区间，用数学表达式区间表示，
            eg:{"(?!2800 V3)" : ["V200R002C20.*", "[V200R002C30,V200R002C30SPC200]"}，表示问题型号为非2800 V3，
                                        问题版本为所有V200R002C20版本，V200R002C30到V200R002C30SPC200版本，包含问题版本为所有V200R002C20版本与V200R002C30SPC200。
    @return: 
        isSucc：True/False，方法是否正常结束
        allCliRet：所有CLID回显
        errMsg：方法异常结束时的原因
        isPass：True/False，检查是否通过（设备型号与版本不是问题版本时检查通过）
        productModel：设备型号
        productVersion：设备版本
    """
    isSucc = True
    allCliRet = ""
    errMsg = ""
    
    isPass = True
    productModel = ""
    productVersion = ""
    
    #获取产品型号
    checkRet = cliUtil.getProductModelWithCliRet(cli, LANG)
    allCliRet += checkRet[2]
    if checkRet[0] != True:
        isSucc = False
        isPass = False
        errMsg = checkRet[4]
        return (isSucc, allCliRet, errMsg, isPass, productModel, productVersion)
    
    #设备型号
    productModel = checkRet[1]
    
    #获取产品软件版本
    checkRet, versionDictList, hotPatchVersionList = parse_upgradePackage(cli, LANG)
    allCliRet += checkRet[1]
    if checkRet[0] != True:
        isSucc = False
        isPass = False
        errMsg = checkRet[2]
        return (isSucc, allCliRet, errMsg, isPass, productModel, productVersion)
    
    #产品版本（版本全称）
    productVersion = versionDictList[0].get("Current Version")
    
    for model in modelAndVersionListDict:
        if not re.match(model, productModel):
            #设备型号不是问题型号
            continue
        
        versionList = modelAndVersionListDict.get(model)
        
        if isBugProductVersion(productVersion, versionList):
            #问题型号与版本均匹配
            isSucc = True
            isPass = False
            return (isSucc, allCliRet, errMsg, isPass, productModel, productVersion)
        else:
            return (isSucc, allCliRet, errMsg, isPass, productModel, productVersion)
    
    return (isSucc, allCliRet, errMsg, isPass, productModel, productVersion)


def getExpansionEnclosureByDiskID(diskID):
    """
    @summary:根据硬盘ID的计算该硬盘所在硬盘框号
    """
    if re.match("DAE([0-9]|[a-f]|[A-F]){3}.", diskID) == None:
        return None
    
    return diskID.split(".")[0]

 
def getSasLoopByDiskID(diskID, productModel):
    """
    @summary:根据硬盘ID的计算该硬盘所在硬盘框所在的环路
    """    
    if re.match("DAE([0-9]|[a-f]|[A-F]){3}", diskID) == None:
        return None
    
    engineNumber =  int(diskID[3], 16)
    secondNumber = int(diskID[4], 16)
    thirdNumber = int(diskID[5], 16)
    sasLoopNumber = secondNumber
    
    if productModel in ["18500 V3", "18800 V3", "18500F V3", "18800F V3"]:
        sasLoopNumber = (thirdNumber / 4) * 12 + secondNumber
    
    if productModel in ["6800 V3", "6900 V3", "6800F V3"]:
        if thirdNumber >= 8:
            sasLoopNumber = secondNumber + 16
     
    return (engineNumber,sasLoopNumber)


def getExpansionDepthByDiskID(diskID, productModel):
    """
    @summary:根据硬盘ID的计算该硬盘所在硬盘框的级联深度
    """    
    if re.match("DAE([0-9]|[a-f]|[A-F]){3}", diskID) == None:
        return None
        
    thirdNumber = int(diskID[5], 16)
    
    if productModel in ["18500 V3", "18800 V3", "18500F V3", "18800F V3"]:
        return thirdNumber % 4 + 1
    
    if productModel in ["6800 V3", "6900 V3", "6800F V3"]:
        if thirdNumber < 8:
            return thirdNumber + 1
        else:
            return thirdNumber - 7
        
    return thirdNumber + 1
        

def getJavaDev(ip, py_java_env):
    """
    @summary: 将连接设备的信息封装为java的DevNode对象
    """
    dev = py_java_env.get("devInfo")
    javaDev = DevNode()
    javaDev.setPort(dev.getPort())
    javaDev.setSshForwardList(dev.getSshForwardList())
    javaDev.setSocks5Proxy(dev.getSocks5Proxy())
    javaDev.setLoginUser(dev.getLoginUser())
    deviceSN = dev.getDeviceSerialNumber()
    #每个设备只有一个SN，而java DevNode初始化时需要为每个控制器传一个不同的SN，此SN只是用来作为框架识别不同的SSH连接，不比是真实的设备SN
    deviceSN = deviceSN + str(time.time())
    javaDev.setDeviceSerialNumber(deviceSN)
    javaDev.setIp(ip)
    return javaDev

def getCilConnectionByIp(ip, py_java_env, LOGGER):
    """
    @summary: 获取指定ip的控制器ssh连接
    """
    cliConnection = None
    try:
        devInfo = getCurDeviceInfo(py_java_env)
        productModel = str(devInfo.getDeviceType())
        productVersion = str(devInfo.getProductVersion())
        LOGGER.logInfo("Get product model [%s] and product version [%s]"%(productModel, productVersion))
        #判断是否是高端设备,版本大于V300R003C00，且初始链接IP不是内部IP，则不允许新建链接。
        if cliUtil.STOR_DEV_INFO_DICT.get(productModel) == cliUtil.SERIES_18000 and \
                productVersion >= HYPERMETRO_BEGIN_VERSION and not devInfo.isIpListAreInnerIp() and \
                not devInfo.canEnterDiagnose():
            LOGGER.logInfo("The initial link IP is not an internal IP, are not allowed to build new links.")
            return cliConnection
        javaDev = getJavaDev(ip, py_java_env)
        cliConnection = py_java_env.get("sshManager").getSshConnection(javaDev)
        return cliConnection
    except:
        LOGGER.logError(str(traceback.format_exc()))
        if cliConnection is not None:
            py_java_env.get("sshManager").releaseConnection(cliConnection)
        return cliConnection
    
def getProductVersionByUpgradePackage(cli, lang):
    """
    @summary: 通过show upgrade package命令获取设备版本，
          适用于OEM场景与需要获取spc版本的需求
    """
    productVersion = ""
    checkRet, softwareVersionList, hotPatchVersionList= parse_upgradePackage(cli, lang)
    if checkRet[0] != True:
        return (checkRet[0], checkRet[1], checkRet[2], productVersion)
    
    flag, productVersion, errMsg = getCurrentVersion(softwareVersionList, lang)
    return (flag, checkRet[1], errMsg, productVersion)

def checkPoolFreeCapacity(cli, lang, standard, LOGGER):
    """
    @summary: 执行命令show storage_pool general,
                                    检查是否所有pool的Free Capacity与Total Capacity的比值均高于标准
    @param standard : 标准比值
    @return: flag : 方法是否正常执行
             cliRet : cli回显
             errMsg : 错误消息
             freeCapDict : 比值低于标准的ID为key、Free Capacity为值的字典
    """
    
    flag = True
    cliRet = ""
    errMsg = ""
    freeCapDict = {}
    
    try:
        cmd = "show storage_pool general"
        checkRet = cliUtil.excuteCmdInCliMode(cli, cmd, True, lang)
        cliRet = checkRet[1]
        if not checkRet[0]:
            errMsg += getMsg(lang, "can.not.get.pool.detail")
            return (False, cliRet, errMsg, freeCapDict)
        
        if checkRet[0] != True:
            return (checkRet[0], cliRet, checkRet[2], freeCapDict)
        
        if cliUtil.queryResultWithNoRecord(cliRet):
            return (True, cliRet, errMsg, freeCapDict)
        
        linesList = cliUtil.getHorizontalCliRet(cliRet)
        
        for line in linesList:
            if "Usage Type" in line:
                usageTpye = line.get("Usage Type").lower()
                if usageTpye != "lun":
                    continue
            idNum = line.get("ID").strip()
            freeCap = line.get("Free Capacity")
            totalCap = line.get("Total Capacity")
            freeTransRet = changUnit2GBDecimal(freeCap)
            totalTransRet = changUnit2GBDecimal(totalCap)
            if not freeTransRet[0] or not totalTransRet[0]:
                errMsg += getMsg(lang, "get.pool.capacity.failed", idNum)
                flag = False
                continue
            freeCap = freeTransRet[1]
            totalCap = totalTransRet[1]

            if totalCap == decimal.Decimal('0.00'):
                errMsg += getMsg(lang, "get.pool.capacity.totalCap.empty",
                                 idNum)
                flag = False
                continue

            if freeCap/totalCap <= decimal.Decimal(standard):
                freeCapDict[idNum] = freeCap
        
        return (flag, cliRet, errMsg, freeCapDict)
        
    except:
        LOGGER.logError(str(traceback.format_exc()))
        return (False, cliRet, getMsg(lang, "query.result.abnormal"), freeCapDict)


def getLunIdListOfPool(cli, poolid, lang):
    """
    @summary: 获取设备上所有LUN的ID
    """
    lunIdList = []
    allCliRet = ''
    cmd = "show lun general pool_id=%s|filterColumn include columnList=ID" % poolid
    flag, cliRet, errMsg = cliUtil.excuteCmdInCliMode(cli, cmd, True, lang)
    allCliRet += cliRet
    if flag != True:
        return (flag, allCliRet, errMsg, lunIdList)

    if cliUtil.queryResultWithNoRecord(cliRet):
        return (True, allCliRet, errMsg, lunIdList)

    lunInfoDictList = cliUtil.getHorizontalNostandardCliRet(cliRet)

    for lunInfoDict in lunInfoDictList:
        lunIdList.append(int(lunInfoDict.get("ID")))

    return (True, allCliRet, errMsg, lunIdList)

def compareFreeCapacity(cli, poolCapacityDict, addValusServiceType, lang, py_java_env, LOGGER):
    '''
    @summary: 比较pool空闲容量和增值特性LUN总容量
    @param cli: cil对象
    @param poolCapacityDict: poolid为key，pool剩余容量为值的字典
    @param addValusServiceType：待比较的增值特性的字段名称（选项有：'Snapshot ID(s)','Remote Replication ID(s)','Split Clone ID(s)','LUN Migration','Mirror Type','HyperMetro ID(s)'）
    @param lang：语言环境参数
    @param logger：打印日志对象
    @return: bureauScore
    '''
    reachStandrd = True
    allCliRet = ''
    errMsg = ''
    errMsgRes = ''
    lunIDListDict = {}
    #LUN未叠加多个增值特性时用0.005来计算
    standard1 = decimal.Decimal("0.005")
    #LUN叠加多个增值特性时用0.01来计算
    standard2 = decimal.Decimal("0.01")
    poolIdList = poolCapacityDict.keys()
    synRemoteReplicationsList =[]
    stepProcess = 0
    lunDesc = {'Snapshot ID(s)': {"zh" : u"快照", "en" : "snapshot"},
               'Remote Replication ID(s)' : {"zh" : u"远程复制", "en" : "synchronous remote replication"},
               'Split Clone ID(s)': {"zh" : u"克隆", "en":"clone "},
               'LUN Migration': {"zh" : u"迁移", "en":"migration "},
               'Mirror Type': {"zh" : u"卷镜像", "en" : "volume mirroring"},
               'HyperMetro ID(s)' : {"zh" : u"双活", "en" : "active-active"},
               }    
    try:        
        if addValusServiceType == 'Remote Replication ID(s)':
            
            #获取同步远程复制的ID列表
            flag, cliRet, errMsg, synRemoteReplicationsList = getSynRemoteReplicationId(cli, lang, LOGGER)
            allCliRet += cliRet        
            if flag != True:
                return flag, allCliRet, reachStandrd, errMsg
            
            #没有同步远程复制直接返回True
            if synRemoteReplicationsList is None:
                return True, allCliRet, reachStandrd, errMsg
        LOGGER.logInfo("synRemoteReplicationsList:%s" % synRemoteReplicationsList)
         
        flag, cliRet, lunIDListDict, errMsg = getLunIdListOfPools(cli, poolIdList, lang)
        allCliRet += cliRet
        if flag != True:
                return  flag, allCliRet, reachStandrd, errMsg
        if len(lunIDListDict) == 0:
            return True, allCliRet, reachStandrd, errMsg
        
        totalLunNum = 0        
        for  poolId in lunIDListDict:
            lunIDList = lunIDListDict.get(poolId, '') 
            totalLunNum += len(lunIDList)    
        if totalLunNum >=1:
            currentProcess = 5
            stepProcess = (1.0 / totalLunNum) * (100 - currentProcess)
             
        for  poolId in lunIDListDict:
            lunIDList = sorted(lunIDListDict.get(poolId, ''))           
            flag, cliRet, lunsCapacity, otherFeaturesDict, errMsg = getLunListTotalCapacity(cli, lunIDList, addValusServiceType, synRemoteReplicationsList, stepProcess, lang, py_java_env, LOGGER)
            allCliRet += cliRet
            if flag != True:
                errMsgRes += errMsg
                return  flag, allCliRet, reachStandrd, errMsgRes
            if lunsCapacity == 0:
                LOGGER.logInfo("poolId:%s,lunsCapacity is 0" % poolId)
                continue 
            
            #有指定特性的增值LUN时，比较pool的剩余容量和增值特性LUN的总容量
            poolFreeCap = poolCapacityDict.get(poolId, '')
            value =  decimal.Decimal(poolFreeCap/lunsCapacity)
            LOGGER.logInfo("poolFreeCap:%sGB,lunsCapacity:%sGB,value:%s" % (poolFreeCap, lunsCapacity, value))
            if len(otherFeaturesDict) == 0 and value <= standard1:
                reachStandrd = False 
                VarLunsCapacity1 = "%.3f" % decimal.Decimal(lunsCapacity*standard1)
                errMsgRes += getMsg(lang, "pool.free.capacity.lower.standard.one", (poolId, lunDesc.get(addValusServiceType, '').get(lang), standard1*100, VarLunsCapacity1))
            if len(otherFeaturesDict) != 0 and value <= standard2:
                reachStandrd = False
                VarLunsCapacity2 = "%.3f" % decimal.Decimal(lunsCapacity*standard2)
                errMsgRes += getMsg(lang, "pool.free.capacity.lower.standard.two", (poolId, lunDesc.get(addValusServiceType, '').get(lang), standard2*100, VarLunsCapacity2))
                for lunId in otherFeaturesDict:
                    errMsgRes += getMsg(lang, "lun.include.other.features", (lunId, ','.join(otherFeaturesDict.get(lunId, ''))))                         
        return True, allCliRet, reachStandrd, errMsgRes   
    except:
        LOGGER.logError(str(traceback.format_exc()))
        return (False, allCliRet, reachStandrd, errMsgRes)   

def getLunIdListOfPools(cli, poolIdList, lang):
    '''
    @summary: 获取poolIdList列表中每个pool的LunID列表
    @param cli: cil对象
    @param poolIdList: pool列表   
    @param lang：语言环境参数
    @return: bureauScore
    '''
    lunIDListDict = {}
    allCliRet = ''
    errMsg = ''
    for poolId in poolIdList:
        flag, cliRet, errMsg, lunIDList = getLunIdListOfPool(cli, poolId, lang)  
        allCliRet += cliRet
        if flag != True:
            return flag, allCliRet, lunIDListDict, errMsg
        
        if len(lunIDList) != 0:
            lunIDListDict[poolId] =sorted(lunIDList)
    return True, allCliRet, lunIDListDict, errMsg    


def getLunListTotalCapacity(cli, lunIDList, reuestFeature, synRemoteReplicationsList, stepProcess, lang, py_java_env, LOGGER):
    '''
    @summary: 检查Lun是否包含指定特性及是否包含其他特性，如果是指定特性就累计容量
    @param cil: cli对象
    @param lunIDList:lunID列表
    @param reuestFeature:待查询的增值特性的字段名
    @param lang：语言环境
    @return: isSucc:命令是否执行成功
             hasOtherFeature：是否有其他增值特性
             hasReuestFeature：是否为指定特性的LUN
             totalCapacity：当前Lun的容量
    '''
    otherFeatureDict = {}
    totalCapacity = 0  
    all_cli_ret_list = []
    err_msg_list = []

    try:
        currentProcess = 5
        for lunId in lunIDList:
            if stepProcess != 0:
                currentProcess = refreshProcessByStep(currentProcess, stepProcess, py_java_env, LOGGER)

            cmd = 'show lun general lun_id=%s' % lunId

            flag, cli_ret, err_msg = execute_cmd_in_cli_mode_with_cache(
                py_java_env, cli, cmd, LOGGER)

            all_cli_ret_list.append(cli_ret)

            if flag is not True:
                err_msg_list.append(err_msg)
                return (flag, "\n".join(all_cli_ret_list),
                        totalCapacity, otherFeatureDict,
                        "".join(err_msg_list))
            
            if cliUtil.queryResultWithNoRecord(cli_ret):
                continue

            lunInfoDictList = cliUtil.getVerticalCliRet(cli_ret)
            #获取增值LUN总容量及其他特性的列表
            lunCapacity, otherFeatures = checkFeatureLun(lunInfoDictList[0], reuestFeature, synRemoteReplicationsList, lang, LOGGER)            
            if lunCapacity == 'False':
                return (False, "\n".join(all_cli_ret_list),
                        totalCapacity, otherFeatureDict,
                        "".join(err_msg_list))

            totalCapacity += lunCapacity
            if len(otherFeatures) != 0:
                otherFeatureDict[lunId] = otherFeatures

        return (True, "\n".join(all_cli_ret_list),
                totalCapacity, otherFeatureDict,
                '')
   
    except:
        LOGGER.logError(str(traceback.format_exc()))
        return (False, "\n".join(all_cli_ret_list),
                totalCapacity, otherFeatureDict,
                "".join(err_msg_list))
    
def checkFeatureLun(lunInfoDict, reuestFeature, synRemoteReplicationsList, lang, LOGGER):
    '''
    @summary: 获取增值LUN总容量及其他特性的列表
    @param lunInfoDictList:LUN属性信息的字典
    @param reuestFeature:待查询的增值特性的字段名
    @param synRemoteReplicationsList：同步远程复制ID列表
    @return: isSucc:命令是否执行成功
             otherFeatures：其他特性列表
             totalCapacity：当前Lun的容量
    '''
    otherFeatures = []
    lunCapacity = 0
    addValusServiceDict = {'Snapshot ID(s)': {"zh" : u"快照", "en" : "Snapshot"},
               'Remote Replication ID(s)' : {"zh" : u"远程复制", "en" : "synchronous remote replication"},
               'Split Clone ID(s)': {"zh" : u"克隆", "en":"clone "},
               'LUN Migration': {"zh" : u"迁移", "en":"migration "},
               'Mirror Type': {"zh" : u"卷镜像", "en" : "volume mirroring"},
               'HyperMetro ID(s)' : {"zh" : u"双活", "en" : "active-active"},
               }
    #确定是否为要求的增值特性LUN
    featureValue = lunInfoDict.get(reuestFeature, '')                   
    if  featureValue == '' or featureValue == '--':
        LOGGER.logInfo("featureValue is %s" % featureValue)
        return lunCapacity, otherFeatures
    #检查LUN是否为同步远程复制LUN
    if reuestFeature == 'Remote Replication ID(s)':
        #如果Remote Replication ID(s)字段的值只有一个ID 且这个值不在同步远程复制ID列表中，就不是同步远程复制LUN
        if not re.search(',', featureValue, re.I) and featureValue not in synRemoteReplicationsList: 
            LOGGER.logInfo("featureValue is not in synRemoteReplicationsList:%s" % synRemoteReplicationsList)                           
            return lunCapacity, otherFeatures 
        #如果Remote Replication ID(s)字段有多个ID，就按照0.01的标准计算
        if re.search(',', featureValue, re.I):
            LOGGER.logInfo("Remote Replication featureValue is :%s" % featureValue)               
            otherFeatures.append(addValusServiceDict.get(reuestFeature, '').get(lang))
            
    #如果检查的是检查迁移LUN，那么LUN Migration字段必须为'Source'
    if reuestFeature == 'LUN Migration' and featureValue != 'Source':
        return lunCapacity, otherFeatures
    #如果检查的是检查卷镜像LUN，那么Mirror Type字段必须为'Mirror Type'
    if reuestFeature == 'Mirror Type' and featureValue != 'Mirror LUN':
        return lunCapacity, otherFeatures 
            
    #是满足要求的增值LUN就累计LUN的使用容量，容量以GB为单位     
    subCap = lunInfoDict.get('Subscribed Capacity', '')
    if subCap == '' or subCap == '--':
        return 'False', otherFeatures
    lunCapacityDecimal = changUnit2GBDecimal(subCap)     
    lunCapacity = lunCapacityDecimal[1]
    LOGGER.logInfo("Capacity of lun[ID:%s] is %sGB" % (lunInfoDict.get("ID", ''), lunCapacity))
    #确定LUN是否包含其他增值特性                                        
    for addValusService in addValusServiceDict: 
        if addValusService == reuestFeature:
            continue 
        featureValue = lunInfoDict.get(addValusService, '')     
        if featureValue != '--' and featureValue != '': 
            otherFeatures.append(addValusServiceDict.get(addValusService, '').get(lang))      
    return  lunCapacity, otherFeatures 

def getSynRemoteReplicationId(cli, lang, logger):
    '''
    @summary: 获取同步远程复制的ID列表
    @param cil: cli对象
    @param lang：语言环境
    @return: cliRet:命令是否执行结果
             synRemoteReplicationsList：同步远程复制的ID的List
    '''
    
    synRemoteReplicationsIDList = []
    allCliRet = ''
    cmd =  'show remote_replication general |filterRow column=Replication\sMode predict=match value=Synchronous |filterColumn include columnList=ID'   
    flag, cliRet, errMsg = cliUtil.excuteCmdInCliMode(cli, cmd, False, lang)
    allCliRet += cliRet
    
    if flag != True:        
        return flag, allCliRet, errMsg, synRemoteReplicationsIDList

    if cliUtil.queryResultWithNoRecord(cliRet):        
        return True, allCliRet, errMsg, synRemoteReplicationsIDList  

    synIDDictList = cliUtil.getHorizontalNostandardCliRet(cliRet)
    logger.logInfo("synIDDictList:%s" % str(synIDDictList))
    
    for synIDDict in synIDDictList:                
        synRemoteReplicationsIDList.append(synIDDict.get('ID'))
            
    return True, allCliRet, errMsg, synRemoteReplicationsIDList

def checkKeywords(cli, cmd, lang, keywordsDict, IGNORECASE=True):
    '''
    @summary: 执行命令（记录日志），获取命令中的关键字，判断关键字是否符合预期值。
    @param cli:         cli链接
           cmd:         需要执行的命令
           lang:        语言环境
           keywordsDict:待判断的关键字及其值的字典，不允许为空
                                              格式:{keyword1:value_pattern1 [, keyword2:value_pattern2]}
                        keyword1：关键字
                        value_pattern1：匹配模式，需要匹配的值的正则表达式
                eg：{"model":r"^double$", "type":r"^(Mandatory|Advisory)$", "ID":r".*"} 对于只想拿到对应字段值的，可以用'.*'做匹配模式
           IGNORECASE:  匹配值时是否忽略大小写，默认为True
           
    @return: resultFlag:检查结果，可选值：True：     所有关键字匹配上
                                    False：未全部匹配
                                    cliUtil.RESULT_NOCHECK：关键字无法获取、命令执行失败等场景
                                    
            cliRet：cli回显
            errMsg：错误提示信息
            resultDictList：以未能成功匹配的记录的关键字及其真实值的字典列表，返回值可能存在字段不匹配和字段缺失的混合场景，后续需要处理。
    '''
    
    finalFlag = True
    resultDictList = []
    cliRet = ''
    try:
        #执行命令
        checkFlag, cliRet, errInfo = cliUtil.excuteCmdInCliMode(cli, cmd, True, lang)
        if checkFlag != True: 
            return (checkFlag, cliRet, errInfo, resultDictList) 
        
        #命令执行成功，但是没有信息
        if cliUtil.queryResultWithNoRecord(cliRet):
            return (True, cliRet, errInfo, resultDictList)
        
        #先尝试纵向解析，解析为空再横向解析；先纵向解析原因是：横向解析纵向类回显时可能有符合的值的场景
        cliInfoDictList = cliUtil.getVerticalCliRet(cliRet)
        #横向解析
        if not cliInfoDictList:
            cliInfoDictList = cliUtil.getHorizontalCliRet(cliRet)
       
        #解析结果为空，则直接返回未检查
        if not cliInfoDictList:
            return (cliUtil.RESULT_NOCHECK, cliRet, errInfo, resultDictList)
        
        #遍历回显字典列表
        for cliInfoDict in cliInfoDictList:
            #每次循环，重置以下两个变量
            resultDict = {}
            flag = True
            nocheckFlag = True
            
            #遍历匹配所有欲查询的关键字
            for keywords in keywordsDict:
                hopeValueRe = keywordsDict.get(keywords)
                actualValue = cliInfoDict.get(keywords)
                
                #实际信息无该字段, 报未检查
                if actualValue == None:
                    resultDict[keywords] = None
                    nocheckFlag = cliUtil.RESULT_NOCHECK
                    continue
                
                #匹配字段
                if IGNORECASE:
                    matchResult = re.match(hopeValueRe, actualValue, re.IGNORECASE)
                else:
                    matchResult = re.match(hopeValueRe, actualValue)
                    
                #未匹配，结果置为失败
                if matchResult == None:
                    flag = False
                
                #记录字段的实际值
                resultDict[keywords] = actualValue
            
            #利用and操作的特性，如果flag为False，则直接返回False，如果flag为True，则取值取决于nocheckFlag
            #原则 只要有False，结果一定为False，否则为nocheck
            #eg： False and True and nocheck = False
            #   nocheck and False and nocheck = False
            #   True and True and nocheck = nocheck 
            if flag == False or nocheckFlag == cliUtil.RESULT_NOCHECK:         
                finalFlag = finalFlag and flag and nocheckFlag   
                resultDictList.append(resultDict) 
           
        return (finalFlag, cliRet, errInfo, resultDictList)

    except Exception:
        return (cliUtil.RESULT_NOCHECK, cliRet, getMsg(lang, "query.result.abnormal"), [])    
    

def isNasFeatureSupported(cli, LANG, LOGGER):
    '''
    @summary: checking whether this  is a NAS feature supported device:
    @check logic: 2800 All series 2600 for video all series V3R2C10 and lower donot support Nas
    @note: 2200 16G V3R6C00SPC100 and upper version do support NAS feature, others do not 
    @param cli: cli context  
    @return: isQrySuccess, boolean
    @return: isNasFeatureSupported, boolean
    @return: errorMsg, str 
    '''
    
    LOGGER.logInfo("checking whether the device have NAS feature...")
    isSuccess, product_model, product_version, errMsg = cliUtil.getProductModelAndVersion(cli, LANG)
    if not isSuccess :
        return False, False, errMsg
    LOGGER.logInfo("current product_model is %s" % str(product_model))
    LOGGER.logInfo("current product_version is %s" % str(product_version))
    if product_model == "2200 V3":
        isFetchOk, cacheCapacity, errorMsg = getCrntDeviceCacheCapacity(cli, LANG, LOGGER)
        if not isFetchOk:
            LOGGER.logInfo("failed in fetching cache capacity")
            return False, False, errorMsg
        
        if float(cacheCapacity.rstrip("GB")) < 15.0:
            LOGGER.logInfo("current 2200 device cache is lower than 16GB, NAS feature's no supported! ")
            return True, False, ""
        else:
            if product_version > "V300R006C00":
                LOGGER.logInfo("2200 16G V3R6C00+ devices support NAS feature")
                return True, True, ""
            elif product_version == "V300R006C00":
                isFetchOk, hotPatchVersion, errorMsg = getSoftwarePatchVersion(cli, LANG, LOGGER)
                if not isFetchOk:
                    return False, False, errorMsg
                if hotPatchVersion >= "V300R006C00SPC100":
                    return True, True, ""
                else:
                    return True, False, ""
            else :
                return True, False, ""
                
    if product_model in cliUtil.NAS_FEATURE_UNSUPPORT_DEVICE or product_version < "V300R002C10":
        return True, False, ""
    LOGGER.logInfo("this device is not in the black list ,returns True as it supports NAS feature.")
    return True, True, "" 

def getCrntDeviceCacheCapacity(cli, LANG, LOGGER):
    '''
    @summary: get current device cache capacity :8G  16G etc.
    '''
    cmd  = "show controller general |filterColumn include columnList=Cache\sCapacity"
    echoStatus, cliRet, errMsg = cliUtil.excuteCmdInCliMode(cli, cmd, True, LANG)
    if not echoStatus or echoStatus == cliUtil.RESULT_NOSUPPORT or echoStatus == cliUtil.RESULT_NOCHECK :
        LOGGER.logInfo("show controller general command executed with exception:")
        return False, "", getMsg(LANG, "cannot.get.device.cache.capacity")
    for cliRetLine in cliRet.splitlines():
        if "cache capacity" in cliRetLine.lower():
            fields = cliRetLine.split(":")
            if len(fields) < 2:
                continue
            fieldValue = fields[1].strip()
            LOGGER.logInfo("current device's cache capacity is :%s" % str(fieldValue))
            return True, fieldValue, ""
    
    return False, "", getMsg(LANG, "cannot.get.device.cache.capacity")


def get_device_cache_capacity_with_ret(cli, lang, logger):
    """
    获取设备内存容量
    """
    cmd = "show controller general |filterColumn include columnList=Cache\sCapacity"
    flag, cli_ret, err_msg = cliUtil.excuteCmdInCliMode(cli, cmd, True, lang)
    if not flag or flag == cliUtil.RESULT_NOSUPPORT or flag == cliUtil.RESULT_NOCHECK:
        logger.logInfo(
            "show controller general command executed with exception:")
        return False, "", cli_ret, getMsg(lang, "cannot.get.device.cache.capacity")
    for cli_ret_line in cli_ret.splitlines():
        capacity = re.search(r"([0-9]+\.?[0-9]+[KMGTP]?B)", cli_ret_line)
        if not capacity:
            continue
        cache_capacity = capacity.group(1)
        logger.logInfo("current device's cache capacity is :{}".format(
            str(cache_capacity)))
        return True, cache_capacity, cli_ret, ""

    return False, "", cli_ret, getMsg(lang, "cannot.get.device.cache.capacity")


def getSoftwarePatchVersion(cli, LANG, LOGGER):
    '''
    @summary: get current device patch version
    '''
    ((echoStatus, cliRet, errMsg),softwareVersionList,hotPatchVersionList) = parse_upgradePackage(cli, LANG)
    if not echoStatus :
        return False, "", errMsg

    for upgradeInfoMap in softwareVersionList:
        currentVersion = upgradeInfoMap.get("Current Version", "")
        if currentVersion :
            LOGGER.logInfo("current software version is: %s" % str(currentVersion))
            return True, currentVersion, ""
    
    return False, "", getMsg(LANG, "cannot.get.upgrade.package.info")

def isHyperMetroLunFeatureSupported(cli, LANG, LOGGER):
    '''
    @summary: checking whether this is a Active-Active Lun Feature supported device
    @note: V3R3C20、V3R3C20SPC100、V3R3C20SPC200、V3R6C00SCP100、V3R6C10、Dorado C01、Dorado C20
    @return:  isCheckOk, isAALunSupported, cliEchos, errMsg
    '''
    ((echoStatus, cliRet, errMsg), softwareVersionList, hotPatchVersionList) = parse_upgradePackage(cli, LANG)
    
    if not echoStatus :
        return False, False, cliRet, errMsg

    for upgradeInfoMap in softwareVersionList:
        currentVersion = upgradeInfoMap.get("Current Version", "")
        if not currentVersion :
            return True, False, cliRet, ""
        
        # 以前那种判断方式不能继承在研版本，每次如果有在研版本都需要做修改。
        # V300R003种C20开始支持双活
        if currentVersion.startswith("V300R003"):
            if currentVersion[0:11] >= "V300R003C20":
                return True, True, cliRet, ""
            else:
                return True, False, cliRet, ""
        
        # V300R001从 c01开始支持双活
        elif currentVersion.startswith("V300R001"):
            if currentVersion[0:11] >= "V300R001C01":
                return True, True, cliRet, ""
            else:
                return True, False, cliRet, ""
        
        # 其他版本以配置的版本为准都支持双活，如V300R006，dorado V300R002
        else:
            return True, True, cliRet, ""
            
    
    
def getProductModeFromContext(py_java_env):
    """
    @summary: 从工具箱的缓存中获取当前设备的产品类型
    """
    return str(py_java_env.get("devInfo").getDeviceType())


def getEngsFromContext(py_java_env):
    """
    @summary: 从工具箱的缓存中获取引擎列表
    """
    return py_java_env.get("expInfo").getEngs()

def getpoolAndDiskDomainMap(py_java_env):
    """
    @summary: 从工具箱的缓存中获取存储池与硬盘域对应关系
    """
    return py_java_env.get("expInfo").getDevPoolAndDiskDomainMapping()


def is18000(py_java_env, cli):
    """
    @summary:检查设备是否为18000系列
    """
    dev_node = py_java_env.get("devInfo")

    # 新工具箱，优先使用CBB的接口,判断是否是18000设备
    return DeviceTypeUtil.hasSVPModule(dev_node) and not dev_node.canEnterDiagnose()

def isDorado(productModel):
    """
    @summary:检查设备是否为Dorado系列
    """
    if productModel in config.DORADO_DEVS:
        return True
    return False

def isDorado5000(productModel):
    """
    @summary:检查设备是否为Dorado系列
    """
    if "DORADO5000" in productModel.upper():
        return True
    return False

def reConnectionCli(cli, LOGGER):
    """
    @summary: 重新获取SSH通道
    """
    if cli is None:
        return False
    try:
        cli.reConnect()
        LOGGER.logInfo("it is afresh to connect to device by ssh gallery.")
        return True
    except:
        LOGGER.logError(str(traceback.format_exc()))
        return False
    
    
def refreshProcess(py_java_env, percentNumber, LOGGER):
    """
    @summary: 设置巡检当前进度
    """
    observer = py_java_env.get("progressObserver")
    try:
        if observer != None:
            observer.updateProgress(int(percentNumber))
    except:
        LOGGER.logInfo(str(traceback.format_exc()))
        
        
def refreshProcessByStep(currentProcess, stepProcess, py_java_env, logger):
    """
    @summary: 用于循环中刷新进度
    """
    if int(currentProcess + stepProcess) - int(currentProcess) >= 1:
        refreshProcess(py_java_env, currentProcess + stepProcess, logger)
           
    currentProcess += stepProcess
    
    return currentProcess


def refreshProcessWithSleep(currentProcess, sleepTime, singleProcess, py_java_env, LOGGER):
    """
    @summary: 刷新循环进度（存在休眠情况）
    @param currentProcess: 当前进度
    @param sleepTime: 每次循环休眠时间
    @param singleProcess: 每次休眠进度
    """
    for i in range(0, sleepTime):
        time.sleep(1)
        currentProcess += singleProcess
        refreshProcess(py_java_env, int(currentProcess), LOGGER)
    
    return currentProcess
   
def joinLines(originLines, postLines):
    """
    @summary: 将postLines追加originLines后
    """
    if not (originLines or postLines):
        return ""
    
    if not originLines:
        return postLines
    
    if not postLines:
        return originLines
    
    return "\n".join([originLines, postLines])

class UnCheckException(Exception):
    """
    @summary: 未检查异常自定义类
    """
    def __init__(self, errorMsg, cliRet, flag=cliUtil.RESULT_NOCHECK):
        self.errorMsg = errorMsg
        self.cliRet = cliRet
        self.flag = flag

def getVersion(cli, LANG):
    """
    @summary: 获取阵列软件版本与热补丁版本
    """
    (flag, cliRet, errMsg), softwareVersionList, hotPatchVersionList = parse_upgradePackage(cli, LANG)
    if flag != True:
        return (cliUtil.RESULT_NOCHECK, cliRet, errMsg, "", "")
    
    softwareVersion = softwareVersionList[0].get("Current Version")
    hotPatchVersion = hotPatchVersionList[0].get("Current Version")
    return (True, cliRet, "", softwareVersion, hotPatchVersion)


def sortListByInt(sortedList, LOGGER):
    """
    @summary: 对sortedList按int方式排序
    """
    try:
        sortedList.sort(cmp=None, key=int, reverse=False)
    except:
        LOGGER.logInfo("List sort by int failed, Maybe the list item is not int type.")
        LOGGER.logInfo(str(traceback.format_exc())) 
def getBureauScore(py_java_env):
    '''
    @summary: 从上下文中获取bureauScore分数
    @param py_java_env: 上下文对象
    @return: bureauScore
    '''
    return py_java_env.get("bureauScore")

def isProductModelSupport(cli, notSupportProductModels, lang): 
    """
    @summary: 检查型号是否支持                                    
    @return: 
        isSucc：True/False，方法是否正常结束
        allCliRet：CLI回显
        issupport: True(支持)
                   False(不支持)
        errMsg：方法异常结束时的错误消息
    """
    allCliRet = '' 
    isSucc, product, cliRet, errMsg = cliUtil.getProductModelWithCliRet(cli, lang)  
    allCliRet = joinLines(allCliRet, cliRet)

    if isSucc != True:        
        return (isSucc, allCliRet, False, errMsg)
    
    for notSupportProduct in notSupportProductModels:
        if re.search(notSupportProduct, product, re.I):
            return (isSucc, allCliRet, False, errMsg)
        
    return (isSucc, allCliRet, True, errMsg)

def getProductModelAndCurSysDate(cli, lang):
    '''
    @summary: 获取产品类型和系统当前时间并返回CLI回显
    @param cli: cli对象
    @param lang: 语言lang
    @return: (falg, productModel, ret, errMsg)
        flag:
            True: 获取成功
            False: 获取失败
        productModel:产品型号
        sysDate:系统当前时间
        ret: cli回显
        errMsg: 错误消息
    '''  
    flag, cliRet, errMsg, product_model, sysDate = cliUtil.getOEMproductModelAndCurSysDate(cli, lang)
    if flag == True:
        return (flag ,product_model, sysDate, cliRet, errMsg)
    
    cmd = "show system general"
    flag, cliRet, errMsg = cliUtil.excuteCmdInCliMode(cli, cmd, True, lang)
    if flag != True: 
        return (flag ,product_model, sysDate, cliRet, errMsg)
    
    cliRetList = cliRet.splitlines()
    for line in cliRetList:
        fields = line.split(":")
        if len(fields) < 2:
            continue
        
        fieldName = fields[0].strip()
        fieldValue = fields[1].strip()
        
        if fieldName == "Product Model":
            product_model = fieldValue
            
        if fieldName == "Time":
            sysDate = fieldValue
        
        if len(product_model) != 0 and product_model != "--" and sysDate:
            return (True, product_model, sysDate, cliRet, "")
        
    return (False, "", cliRet, sysDate, getMsg(lang, "cannot.get.product.model.info"))


def getRunningTimeOfControllers(cli, lang, sysDate, LOGGER):     
    '''
    @summary: 获取每个控制器的运行时间（天）
    @param cli: cli对象
    @param lang: 语言lang
    @return flag: 是否查询成功
            controlRunningTimeDict: 控制器ID，控制器运行时间字典
            allCliRet: CLI回显
            errMsg: 错误消息
    '''
    allCliRet = ""
    controlRunTimeDict = {}
    
    sysDate = sysDate.split("/")[0].strip()
    flag, controlIdList, errMsg, cliRet = cliUtil.getControllerIdListWithRet(cli, lang)
    allCliRet = joinLines(allCliRet, cliRet)
    if flag != True: 
        return (flag, controlRunTimeDict, allCliRet, errMsg)
    
    for controlId in controlIdList:
        cmd = "show controller general controller=%s" % controlId
        flag, cliRet, errMsg = cliUtil.excuteCmdInCliMode(cli, cmd, True, lang)
        allCliRet = joinLines(allCliRet, cliRet)
        
        if flag != True: 
            return (flag, controlRunTimeDict, allCliRet, errMsg)
        
        infoDictList = cliUtil.getVerticalCliRetFilterElabel(cliRet)
        for infoDict in infoDictList:
            manufactured = infoDict.get("Manufactured", "")
            #获取控制器信息失败
            LOGGER.logInfo("controlId = %s, manufactured= %s, sysDate = %s" % (str(controlId),str(manufactured),str(sysDate)))
            timeDifference = getTimeDifference(manufactured, sysDate)
            if timeDifference:
                LOGGER.logInfo("Controller[%s],running time = %s" % (controlId, timeDifference))
                controlRunTimeDict.setdefault(controlId, timeDifference)
            
    return (True, controlRunTimeDict, allCliRet, errMsg)


def getDiskLife(cli, LANG, diskIdList, LOGGER):
    '''
    @summary: 获取硬盘集合的最大运行（天）
    @return runTimeMax: 当前硬盘集合的最大运行时间
    '''
    runTimeMax = ""
    runTimeList = []
    for diskId in diskIdList:
        cmd = "show disk general disk_id=%s" % diskId
        flag, cliRet, errMsg = cliUtil.excuteCmdInCliMode(cli, cmd, True, LANG)
        if flag != True:
            continue
        
        dictList = cliUtil.getVerticalCliRet(cliRet)
        if len(dictList) == 0:
            continue
        
        for diskInfo in dictList:
            runTime = diskInfo.get("Run Time(Day)","")
            if runTime and int(runTime) < 5000:
                runTimeList.append(int(runTime))
    
    LOGGER.logInfo("runTimeList = %s" % runTimeList)
    if runTimeList:
        runTimeMax = max(runTimeList)
        
    return runTimeMax

def nodeId2controlId(nodeId): 
    '''
    @summary: 将节点ID转换为控制器ID（引擎下面只有两个控制器场景，不包含6800 V3、18000 V3等）
    @param cli: cli对象
    @param lang: 语言lang
    @return controlId: 控制器ID
    ''' 
    nodeContrDict = {"0":"A", "1":"B"}
    engeId = str(nodeId/2)
    temId = str(nodeId%2)
    contrId = str(engeId) + nodeContrDict[temId]
 
    return contrId

def getEngNodeInfo(cli,lang):
    '''
    @summary: 获取当前控制器节点ID和引擎下的节点ID列表
    @param cli: cli对象
    @param lang: 语言lang
    @param contrIdList: 控制器列表
    @return flag: 是否查询成功
            cliRet: CLI回显
            engNodeInfoList: 引擎下节点和当前节点字典列表
    eg: engNodeInfoList = [{"0":[0,1],"1":[2,3]},{"currentNodeId" : 1}]
    '''
    engNodeInfoList = []
    isExeSucc, cliRet, errMsg = cliUtil.excuteCmdInDebugModel(cli, cliUtil.DIAGNOSE_SYS_SHOW_CLS_CMD, lang)
    if not isExeSucc:
        return (False, cliRet, getMsg(lang, "failed.to.get.present.nodeid"))
    
    if "not found" in cliRet and "error" in cliRet.lower():
        return (False, cliRet, getMsg(lang, "failed.to.get.present.nodeid"))
    
    ctrlInfoDictList = cliUtil.getVerticalCliRet(cliRet)
    engineInfoDictList = cliUtil.getHorizontalNostandardCliRet(cliRet)
    
    currentCtrlNodeIdDict = {}
    for ctrlInfo in ctrlInfoDictList:
        if ctrlInfo.get("local node id", "") != "":
            currentCtrlNodeId = ctrlInfo.get("local node id","")
            if currentCtrlNodeId:
                currentCtrlNodeIdDict.setdefault("currentNodeId",currentCtrlNodeId)
                engNodeInfoList.append(currentCtrlNodeIdDict)
            break
        
    engineNodeDict = {}    
    for engineInfo in engineInfoDictList:
        engineId = engineInfo.get("engine","")
        nodeId = engineInfo.get("id","")
        status = engineInfo.get("status","")
        if engineId == "" or nodeId == "" or status != "normal":
            continue
        
        tmpList = engineNodeDict.get(engineId, [])
        tmpList.append(int(nodeId))
        engineNodeDict[engineId] = tmpList
       
    engNodeInfoList.append(engineNodeDict)
    
    return (True, cliRet, engNodeInfoList)

def getCurrentNodeId(cli,lang): 
    '''
    @summary: 获取当前节点ID信息
    '''
    isExeSucc, cliRet, errMsg = cliUtil.excuteCmdInDebugModel(cli, cliUtil.DIAGNOSE_SYS_SHOW_CLS_CMD, lang)
    if not isExeSucc:
        return (False, cliRet, errMsg)
    
    infoDict = cliUtil.getVerticalCliRet(cliRet)
    currentCtrlNodeId = ""
    for info in infoDict:
        currentCtrlNodeId = info.get("local node id","")
    
    if currentCtrlNodeId:
        return (True, cliRet, currentCtrlNodeId)
    
    return (False, cliRet, getMsg(lang, "failed.to.get.present.nodeid"))

def heartBeatToOtherCtrl(cli, nodeId, PY_JAVA_ENV, LOGGER, LANG):
    '''
    @summary: 心跳至指定节点
    @param cli: cli连接
    @param nodeId: 控制器节点ID
    @return: (flag, errMsg)
        flag:
            True: 命令执行成功
            False: 命令执行失败
        errMsg: 错误消息
    '''
    cmd = "sshtoremoteExt %s" % str(nodeId)
    priKey = PY_JAVA_ENV.get("devInfo").getPriKey()
    if priKey:
        #不支持PublicKey鉴权方式进行心跳控制器
        errMsg = getMsg(LANG, "no.support.publickey.forensics")
        return (False, "", errMsg)
    
    passWord = PY_JAVA_ENV.get("devInfo").getLoginUser().getPassword()
    
    flag, cliRet, errMsg = cliUtil.sshToRemoteContr(cli, cmd, passWord, LANG)
    if flag != True:
        # 适配V5R7C60SPC100版本不支持sshtoremoteExt命令，直接使用sshtoremote
        if "not support" in cliRet:
            cmd = "sshtoremote"
            flag, cliRet, errMsg = cliUtil.sshToRemoteContr(cli, cmd, passWord,
                                                            LANG)
            return flag, cliRet, errMsg

        #不支持跨引擎心跳场景，转换节点ID后从新查询一次
        if not checkHeartSupportCrossEngine(cli, LANG):
            LOGGER.logInfo("current version no support cross engine heart" )
            #将节点ID转换为内部节点ID
            newNodeId = getNodeIdAsNew(cli, LANG, nodeId)
            LOGGER.logInfo("newNodeId is: %s" % str(newNodeId))
            if newNodeId != "":
                cmd = "sshtoremoteExt %s" % str(newNodeId) 
                flag, cliRet, errMsg = cliUtil.sshToRemoteContr(cli, cmd, passWord, LANG)
                
                #兼容老版本不支持sshtoremoteExt命令场景，使用sshtoremote代替
                if flag != True:
                    cmd = "sshtoremote" 
                    flag, cliRet, errMsg = cliUtil.sshToRemoteContr(cli, cmd, passWord, LANG)
                
                del passWord
                if flag == True:
                    return (flag, cliRet, errMsg)
                
        LOGGER.logInfo("heart beat to other node Failed. errMsg: %s" % errMsg)
        errMsg = getMsg(LANG, "heart.beat.to.node.failed", nodeId)
        return (flag, cliRet, errMsg)
    #删除本地密码
    del passWord
    
    return (flag, cliRet, errMsg)

def getContrIpListOfEngine(cli, LANG):
    """
    @summary: 获取引擎对应下的控制器IP
    """
    ipListDict = {}
    
    cmd = "show upgrade package"
    flag, cliRet, errMsg = cliUtil.excuteCmdInCliMode(cli, cmd, True, LANG)
    if flag != True:
        return (flag, cliRet, errMsg, ipListDict)
    
    beginIndex = cliRet.find("Software Version")
    endIndex = cliRet.find("HotPatch Version")
    
    infoDictList = []
    if beginIndex != -1 and endIndex != -1:
        infoDictList = cliUtil.getHorizontalCliRet(cliRet[beginIndex : endIndex])
    
    for infoDict in infoDictList:
        ip = infoDict.get("IP", "")
        contrName = infoDict.get("Name", "")
        if ip != "" and contrName != "":
            engine = contrName[:1]
            ipList = ipListDict.get(engine, [])
            ipList.append(ip)
            ipListDict.update({engine:ipList})
    
    #控制器未配置管理IP，无法连接控制器。请参考预警公告手动检查。
    if len(ipListDict) == 0:
        errMsg = getMsg(LANG, "contr.not.config.ip")
        return (False, cliRet, errMsg, ipListDict)
    
    return (True, cliRet, errMsg, ipListDict)


def closeSSH(ssh):
    """
    @summary: 释放ssh连接。
    @param devNode: 设备DevNode.java对象。
    """
    if ssh != None:
        SshConnectionManager.releaseConnection(ssh)


def getSSHbyDevNode(devNode):
    """
    @summary: 通过DevNode对象获取工具与阵列的连接。
    @param devNode: 设备DevNode.java对象。
    @return : (ssh, errorId) --> (ssh连接, 获取连接失败的错误码，错误消息定义在resource.py中)
    """
    ssh = None
    errorId = ""
    
    for times in range(3):
        try:
            return (SshConnectionManager.getSshConnection(devNode), errorId)
        except ToolException as toolException:
            errorId = toolException.getErrorId()
        except:
            errorId = "ssh.connect.fail"
        
    return (ssh, errorId)


def getSnFromDevNode(devNode):
    """
    @summary: 通过DevNode.java对象获取设备SN。
    """
    return devNode.getDeviceSerialNumber()


def getIpFromDevNode(devNode):
    """
    @summary: 通过DevNode.java对象获取设备IP。
    """
    return devNode.getIp()


def getNameFromDevNode(devNode):
    """
    @summary: 通过DevNode.java对象获取设备名称。
    """
    return devNode.getDeviceName()


def getRemoteSNsFromDevNode(devNode):
    """
    @summary: 通过DevNode.java对象获取设备关联的远程设备SN。
    """
    return devNode.getRemoteSNs()


def hasFeatureRecord(ssh, cmd, lang): 
    """
    @summary: 检查是否存在特性数据。
    """
    _, cliRet, errMsg = cliUtil.excuteCmdInCliMode(ssh, cmd, True, lang)
    
    if not cliRet:
        return (FLAG_FAIL, cliRet, errMsg)
    
    if cliUtil.getHorizontalNostandardCliRet4Martiu(cliRet):
        return (FLAG_YES, cliRet, errMsg)
    
    if cliUtil.isNotSupport(cliRet):
        return (FLAG_NO, cliRet, errMsg)
    
    if not cliUtil.hasCliExecPrivilege(cliRet):
        return (FLAG_NO, cliRet, errMsg)
    
    if cliUtil.isNoneLicense(cliRet):
        return (FLAG_NO, cliRet, errMsg)
    
    if cliUtil.queryResultWithNoRecord(cliRet):
        return (FLAG_NO, cliRet, errMsg)
    
    return (FLAG_FAIL, cliRet, errMsg)
    
        
def getHyperMetroRemoteDeviceSn(ssh, lang):
    """
    @summary: 获取双活远端设备的SN。
    """
    allCliRet = ""
    # 获取双活对应的远程设备ID
    cmd = "show hyper_metro_domain general|filterColumn include columnList=ID,Remote\sDevice\sID"
    flag, cliRet, errMsg = hasFeatureRecord(ssh, cmd, lang)
    allCliRet = joinLines(allCliRet, cliRet)
    
    if flag == FLAG_NO:
        return (flag, allCliRet, errMsg, [])
    
    if flag == FLAG_FAIL:
        return (flag, allCliRet, errMsg, None)
    
    infoDictList = cliUtil.getHorizontalNostandardCliRet4Martiu(cliRet)
    if not infoDictList:
        return (FLAG_FAIL, allCliRet, errMsg, None)
    
    remoteDeviceIdList = []
    for infoDict in infoDictList:
        remoteDeviceId = infoDict.get("Remote Device ID")
        if remoteDeviceId and remoteDeviceId != "--" and remoteDeviceId not in remoteDeviceIdList:
            remoteDeviceIdList.append(remoteDeviceId)
    
    if not remoteDeviceIdList:
        return (FLAG_NO, allCliRet, errMsg, [])
    
    # 获取双活对应的远程设备SN
    cmd = "show remote_device general|filterColumn include columnList=ID,SN"
    flag, cliRet, errMsg = hasFeatureRecord(ssh, cmd, lang)
    allCliRet = joinLines(allCliRet, cliRet)
    
    if flag == FLAG_NO:
        return (flag, allCliRet, errMsg, [])
    
    if flag == FLAG_FAIL:
        return (flag, allCliRet, errMsg, None)
    
    infoDictList = cliUtil.getHorizontalNostandardCliRet4Martiu(cliRet)
    if not infoDictList:
        return (FLAG_FAIL, allCliRet, errMsg, None)
    
    remoteDeviceSnList = []
    for infoDict in infoDictList:
        remoteDeviceId = infoDict.get("ID")
        if remoteDeviceId in remoteDeviceIdList:
            remoteDeviceSn = infoDict.get("SN")
            if remoteDeviceSn and remoteDeviceSn != "--" and remoteDeviceSn not in remoteDeviceSnList:
                remoteDeviceSnList.append(remoteDeviceSn)
    
    if not remoteDeviceSnList:
        return (FLAG_NO, allCliRet, errMsg, [])
    
    return (FLAG_YES, allCliRet, errMsg, remoteDeviceSnList)
    
def getObjFromFile(py_java_env, LOGGER, devSn, cmd, LANG='en'):
    """
    @summary: 根据设备SN获取命令执行CLI回显。
    """
    # 首先从数据库中取值
    sqlite_manager = SqliteManager()
    objectForPy = py_java_env.get("objectForPy")
    sqlite_conn = sqlite_context.get_sqlite_conn_from_context(objectForPy,
                                                              devSn,
                                                              LOGGER)
    flag, cli_ret, err_msg = query_one_cmd(sqlite_manager, sqlite_conn, cmd,
                                           devSn)
    # 如果flag是None则表示数据库中无数据
    if flag is not None:
        return flag, cli_ret, err_msg

    pid = str(py_java_env.get('pid'))
    basePath = os.path.abspath(DIR_RELATIVE_CMD)
    filePath = os.path.join(basePath + HYPERMETRO_DATA, pid)
    filePath = os.path.join(filePath, devSn)
    # 等待文件创建，一般都有一个空文件
    obj_status = objectForPy.get(HYPER_DEV_STATUS.format(devSn))
    LOGGER.logInfo("testRes devSn: %s, command is :%s, "
                   "obj_status:%s" % (devSn, cmd, obj_status))
    retryTimes = 60 * 5
    while not os.path.exists(filePath):
        retryTimes -= 1
        time.sleep(1)
        if retryTimes <= 0:
            errMsg = {"zh" : u"命令[%s]执行失败，设备(SN：%s)。", "en" : "Failed to run the[%s] command on device[SN:%s]."}.get(LANG)
            return False, '', errMsg % (cmd, devSn)

        # 如果未获取到信息，且状态是中断状态或状态不是运行状态
        # 则直接返回失败（规避登录失败场景）。
        if obj_status == HYPER_DEV_STATUS_INTERRUPTED or \
                obj_status == HYPER_DEV_STATUS_COLLECT_END or not obj_status:
            LOGGER.logInfo(
                "sn:{0} get interrupted status.".format(devSn)
            )
            errMsg = getMsg(LANG, "get.hyper.data.failed", (
                devSn, cmd))
            return False, '', errMsg

    # 等待收集命令成功-防呆，超大规格两端相差2W+主机的场景，还是会出现等待超时的现象。
    retryTimes = 60 * 60
    while flag is None:
        flag, cli_ret, err_msg = query_one_cmd(sqlite_manager,
                                               sqlite_conn, cmd,
                                               devSn)
        retryTimes -= 1
        time.sleep(1)
        LOGGER.logInfo(
            "sleep 1 sec cmd:{}, retryTimes:{}".format(cmd, retryTimes)
        )
        if retryTimes <= 0:
            err_msg = getMsg(LANG, "get.hyper.data.failed", (
                devSn, cmd))
            return cliUtil.RESULT_NOCHECK, '', err_msg

        LOGGER.logInfo(
            "hyper dev[sn:{0}] status:{1}".format(
                devSn, objectForPy.get(
                    HYPER_DEV_STATUS.format(devSn)))
        )
        # 如果未获取到信息，且状态是中断状态或状态不是运行状态
        # 则直接返回失败（规避登录失败场景）。
        if obj_status == HYPER_DEV_STATUS_INTERRUPTED or \
                obj_status == HYPER_DEV_STATUS_COLLECT_END or not obj_status:
            LOGGER.logInfo(
                "sn:{0} get interrupted status.".format(devSn)
            )
            err_msg = getMsg(LANG, "get.hyper.data.failed", (
                devSn, cmd))
            return cliUtil.RESULT_NOCHECK, '', err_msg

    if flag is None:
        err_msg = getMsg(LANG, "get.hyper.data.failed", (
            devSn, cmd))
        return cliUtil.RESULT_NOCHECK, '', err_msg

    return flag, cli_ret, err_msg


def isSuperAdmin(cli, lang):
    """
    @summary: 检查用户是否为超级管理员
    """
    flag, cliRet, userPrivilege, errMsg = cliUtil.getUserPrivilegeWithCliRet(cli, lang)
    if flag != True:
        raise UnCheckException(errMsg, cliRet)
    
    if userPrivilege.lower() == "Super_admin".lower():
        return (True, cliRet)
    
    return (False, cliRet)


def getEngineIps(cli, lang):
    """
    @summary: 获取引擎配置的管理IP
    """
    cmd = "show upgrade package"
    flag, cliRet, errMsg = cliUtil.excuteCmdInCliMode(cli, cmd, True, lang)
    if flag != True:
        errMsg = getMsg(lang, "query.result.abnormal")
        raise UnCheckException(errMsg, cliRet)
    
    beginIndex = cliRet.find("Software Version")
    endIndex = cliRet.find("HotPatch Version")
    infoDictList = cliUtil.getHorizontalCliRet(cliRet[beginIndex : endIndex])
    
    if len(infoDictList) == 0:
        errMsg = getMsg(lang, "query.result.abnormal")
        raise UnCheckException(errMsg, cliRet)
    
    engineIpsDict = {}
    
    for infoDict in infoDictList:
        ip = infoDict.get("IP")
        contrName = infoDict.get("Name")
        if (ip and contrName) and "." in ip:
            # 取0号元素
            engine = contrName[:1]
            ipList = engineIpsDict.get(engine, [])
            ipList.append(ip)
            engineIpsDict[engine] = ipList
    
    return (engineIpsDict, cliRet)
	
def getAllIps(cli, lang):
    """
    @summary: 获取引擎配置的管理IP
    """
    ipList = []
    cmd = "show upgrade package"
    flag, cliRet, errMsg = cliUtil.excuteCmdInCliMode(cli, cmd, True, lang)
    if flag != True:
        return ipList
    
    beginIndex = cliRet.find("Software Version")
    endIndex = cliRet.find("HotPatch Version")
    infoDictList = cliUtil.getHorizontalCliRet(cliRet[beginIndex : endIndex])
    
    if len(infoDictList) == 0:
        return ipList
    
    for infoDict in infoDictList:
        ip = infoDict.get("IP")
        ipList.append(ip)
    
    return ipList
	
def getRemoteDevSn(py_java_env, locaDevSn, LOGGER, LANG='en'):
    """
    @summary: 获取双活对端的设备SN
    """
    
    allCliRet = ""
    hyperRemoteSnList = []
    #获取双活两端LUN的归属设备厂商信息            
    cmd = "show remote_device general"
    flag, cliRet, errMsg = getObjFromFile(py_java_env, LOGGER, locaDevSn, cmd, LANG)
    allCliRet = joinLines(allCliRet, cliRet)
    if flag != True: 
        return (cliUtil.RESULT_NOCHECK, allCliRet, errMsg, hyperRemoteSnList)            
    
    #获取双活远端设备ID列表
    hyperDevIdSnDict = {} 
    remoteDevInfoDictList = cliUtil.getHorizontalCliRet(cliRet)
    LOGGER.logInfo("remoteDevInfoDictList = %s" % str(remoteDevInfoDictList))
    for remoteDevInfo in remoteDevInfoDictList:
        devId = remoteDevInfo.get("ID")
        snNumber = remoteDevInfo.get("SN")
        if devId:
            hyperDevIdSnDict[devId] = snNumber
    
    LOGGER.logInfo("hyperDevIdSnDict = %s" % str(hyperDevIdSnDict))        
    cmd = "show hyper_metro_domain general"
    flag, cliRet, errMsg = getObjFromFile(py_java_env, LOGGER, locaDevSn, cmd,
                                          LANG)
    allCliRet = joinLines(allCliRet, cliRet)
    if flag != True: 
        return (cliUtil.RESULT_NOCHECK, allCliRet, errMsg, hyperRemoteSnList)            
    
    #获取双活远端设备ID列表
    hyperDomainIdList = [] 
    hyperDomainDictList = cliUtil.getHorizontalCliRet(cliRet)
    for hyperDomain in hyperDomainDictList:
        domainId = hyperDomain.get("ID")
        if domainId:
            hyperDomainIdList.append(domainId)
    
    LOGGER.logInfo("hyperDomainIdList = %s" % str(hyperDomainIdList))
    #根据双活域查询双活远端设备的ID列表
    if hyperDomainIdList:
        for domainId in hyperDomainIdList:
            cmd = "show hyper_metro_domain general domain_id=%s" % domainId
            flag, cliRet, errMsg = getObjFromFile(py_java_env, LOGGER, locaDevSn, cmd, LANG)
            allCliRet = joinLines(allCliRet, cliRet)
            if flag != True: 
                return (cliUtil.RESULT_NOCHECK, allCliRet, errMsg, hyperRemoteSnList)   
            
            remoteDevInfoDictList = cliUtil.getVerticalCliRet(cliRet)
            for remoteDevInfo in remoteDevInfoDictList:
                remoteDevId = remoteDevInfo.get("Remote Device ID")
                if remoteDevId:
                    hyperSn = hyperDevIdSnDict.get(remoteDevId, "")
                    if hyperSn:
                        hyperRemoteSnList.append(hyperSn)
                    
    return (flag, allCliRet, errMsg, hyperRemoteSnList)


def checkAddedRemoteDevSn(PY_JAVA_ENV, LANG):
    """
    @summary: 检查是否添加双活设备
    """
    errMsg = ""
    snList = PY_JAVA_ENV.get("devInfo").getRemoteSNs()
    selectDevs = PY_JAVA_ENV.get("selectDevs")
    cli = PY_JAVA_ENV.get("ssh")

    # 如果未None表示添加设备时检查远端设备未成功。
    if snList is None:
        #兼容老工具箱用新子工具场景，从新获取远端设备SN
        flag, _, errMsg, snList = getHyperMetroRemoteDeviceSn(cli, LANG)
        if snList is None:
            errorMsgDict = {"zh": u"双活远端设备", "en": "hyper metro remote device"}
            return cliUtil.RESULT_NOCHECK, [], getMsg(LANG, "cannot.get.info", errorMsgDict.get(LANG))

    # 如果为空列表，表示非远端双活设备
    if not snList:
        return True, [], ''
    
    selectSn = [devNode.getDeviceSerialNumber() for devNode in selectDevs]
    addedSn = [devSn for devSn in snList if devSn in selectSn]
    
    #如果存在远端设备，但一台都没有添加则报未检查。否则尽量去检查。
    if not addedSn:
        errMsg = getMsg(LANG, "not.add.remote.device.again", ",".join(snList))
        return cliUtil.RESULT_NOCHECK, [], errMsg

    return True, addedSn, ''        
    
def getConnectionByContrIp(PY_JAVA_ENV, cli, ipListDict, engine, LOGGER, LANG):
    """
    @summary: 建立到阵列控制器的SSH连接，只有登录控制器的连接才能进入debug，minisystem模式
    """
    currentContrIp = PY_JAVA_ENV.get("devInfo").getIp()
    ipList = ipListDict.get(engine, [])
    if currentContrIp in ipList:
        # 当前连接就是与控制器的连接（18000设备跳过SVP，PC直接连接控制器）
        LOGGER.logInfo('the current ip(%s) is controller management ip.' % str(currentContrIp))
        return (True, "", cli)

    for ip in ipList:
        cilConnection = getCilConnectionByIp(ip, PY_JAVA_ENV, LOGGER)
        if cilConnection:
            LOGGER.logInfo('Success to connect to controller(IP:%s)' % ip)
            return (True, "", cilConnection)
        else:
            LOGGER.logInfo('Failed to connect to controller(IP:%s)' % ip)

    #连接控制器失败。请参考预警公告手动检查。
    errMsg = getMsg(LANG, "chunk.check.connect.to.controller.failed")
    return (False, errMsg, cli)

def getConnectionByContrIpWithConnIp(PY_JAVA_ENV, cli, ipListDict, engine, LOGGER, LANG):
    """
    @summary: 建立到阵列控制器的SSH连接，只有登录控制器的连接才能进入debug，minisystem模式
    """
    currentContrIp = PY_JAVA_ENV.get("devInfo").getIp()
    ipList = ipListDict.get(engine, [])
    connIp = currentContrIp
    if currentContrIp in ipList:
        # 当前连接就是与控制器的连接（18000设备跳过SVP，PC直接连接控制器）
        LOGGER.logInfo('the current ip(%s) is controller management ip.' % str(currentContrIp))
        return (True, "", cli, connIp)

    for ip in ipList:
        cilConnection = getCilConnectionByIp(ip, PY_JAVA_ENV, LOGGER)
        if cilConnection:
            connIp = ip
            LOGGER.logInfo('Success to connect to controller(IP:%s)' % ip)
            return (True, "", cilConnection, connIp)
        else:
            LOGGER.logInfo('Failed to connect to controller(IP:%s)' % ip)

    #连接控制器失败。请参考预警公告手动检查。
    errMsg = getMsg(LANG, "chunk.check.connect.to.controller.failed")
    return (False, errMsg, cli, connIp)

def getDomainInfo(py_java_env, devSn, LOGGER, LANG):
    domainDict = {}
    cmd = "show hyper_metro_domain general"
    flag, cliRet, errMsg = getObjFromFile(py_java_env, LOGGER, devSn, cmd,
                                          LANG)
    if flag != True:
        LOGGER.logInfo("Failed to get information about HyperMetro domain. errMsg:%s" % errMsg)
        return cliUtil.RESULT_NOCHECK, {}, getMsg(LANG, "cannot.get.info", {"zh": u"双活域", "en": "HyperMetro domain"}.get(LANG))
    hyperMetroDomainList = cliUtil.getHorizontalCliRet(cliRet)
    for domainInfo in hyperMetroDomainList:
        domainId = domainInfo.get("ID", '')
        remoteDeviceId = domainInfo.get("Remote Device ID", '')
        if domainId and remoteDeviceId:
            domainDict[domainId] = remoteDeviceId
    return True, domainDict, ''

def getRemoteDeviceInfo(py_java_env, devSn, domainDict, LOGGER, LANG):
    remoteDeviceDict = {}
    cmd = "show remote_device general"
    flag, cliRet, errMsg = getObjFromFile(py_java_env, LOGGER, devSn, cmd, LANG)
    if flag is not True:
        LOGGER.logInfo("Failed to get information about remote device. errMsg:%s" % errMsg)
        return cliUtil.RESULT_NOCHECK, {}, getMsg(LANG, "cannot.get.info", {"zh": u"远端设备", "en": "remote device"}.get(LANG))
    remoteDeviceList = cliUtil.getHorizontalCliRet(cliRet)
    for remoteDev in remoteDeviceList:
        remoteDeviceId = remoteDev.get("ID", '')
        remoteDeviceSn = remoteDev.get("SN", '')
        for domainId in domainDict:
            if remoteDeviceId == domainDict[domainId]:
                remoteDeviceDict[domainId] = remoteDeviceSn
    return True, remoteDeviceDict, '', cliRet


def isExpansionCapacityScenePreInspect(py_java_env):
    """
    @summary: 检查是否是扩容场景（扩链路除外，扩链路容量不会增加）中的扩容前巡检。
    sceneData={field=Storage, subScene=Expansion Links, toolScene=perInspector, mainScene=Expansion}, 
    """
    sceneData = py_java_env.get("sceneData")
    if not sceneData:
        return False
    
    mainScene = sceneData.get("mainScene")
    if not mainScene:
        return False
    
    # 是否是扩容场景巡检
    if mainScene != "Expansion":
        return False
    
    subScene = sceneData.get("subScene")
    if not subScene:
        return False
    
    # 是否是非扩链路场景
    if subScene == "Expansion Links":
        return False
    
    toolScene = sceneData.get("toolScene")
    if not toolScene:
        return False
    
    # 是否是扩容前巡检
    if toolScene == "perInspector":
        return True
    
    return False


def is_opening_delivery_inspect(py_java_env):
    """
    @summary: 检查是否是开局场景
    sceneData={field=Storage, subScene=Expansion Links,
    toolScene=perInspector, mainScene=Expansion},
    """

    if py_java_env.get("isBureau") or py_java_env.get("bureauCheckSelected"):
        return True

    scene_data = py_java_env.get("sceneData")
    if not scene_data:
        return False

    main_scene = scene_data.get("mainScene")
    if not main_scene:
        return False

    # 开局巡检
    if main_scene == "Opening Delivery":
        return True

    sub_scene = scene_data.get("subScene")
    if not sub_scene:
        return False

    # 是否是开局巡检场景
    if sub_scene == "Quality Checks":
        return True

    return False

def getEngineIdByDiskId(disk_id, productModel=""):
    """
    根据disk_id获取逻辑引擎ID（特别是6U SAS小卡），默认3U设备
    """
    if "CTE" in disk_id:
        return disk_id[3]
    
    if len(disk_id) < 5:
        return ""
    
    if productModel in config.SMALL_SAS_6U_PRODUCTS:
        pEng = int(disk_id[3]) * 2
        if disk_id[4] >= "8":
            return str(pEng + 1)
        else:
            return str(pEng)
        
    else:
        return disk_id[3]


def getDiskDomainInfo(cli, lang):
    """获取设备硬盘域信息

    :param cli: cli连接
    :param lang: 语言
    :return:
    """
    diskDomainList = []
    cmd = "show disk_domain general"
    flag, cliRet, errMsg = cliUtil.excuteCmdInCliMode(cli, cmd, True, lang)
    if not flag:
        errMsg = getMsg(lang, "cannot.get.diskdomain.info")
        return False, cliRet, errMsg, diskDomainList

    if cliUtil.queryResultWithNoRecord(cliRet):
        return True, cliRet, errMsg, diskDomainList

    diskDomainList = cliUtil.getHorizontalCliRet(cliRet)
    if len(diskDomainList) == 0:
        errMsg = getMsg(lang, "cannot.get.diskdomain.info")
        return False, cliRet, errMsg, diskDomainList

    return True, cliRet, errMsg, diskDomainList

def getDiskDomainInfoById(cli, disk_domain_id, lang):
    diskInDomainList = []
    cmd = "show disk in_domain disk_domain_id=%s" % disk_domain_id
    flag, cliRet, errMsg = cliUtil.excuteCmdInCliMode(cli, cmd, True, lang)
    if not flag:
        errMsg = getMsg(lang, "cannot.get.diskindomain.info")
        return False, cliRet, errMsg, diskInDomainList

    diskInDomainList = cliUtil.getHorizontalCliRet(cliRet)
    if len(diskInDomainList) == 0:
        errMsg = getMsg(lang, "cannot.get.diskindomain.info")
        return False, cliRet, errMsg, diskInDomainList

    return True, cliRet, errMsg, diskInDomainList

def getDomainInfoById(cli, disk_domain_id, lang):
    diskInDomainInfo = {}
    cmd = "show disk_domain general disk_domain_id=%s" % disk_domain_id
    flag, cliRet, errMsg = cliUtil.excuteCmdInCliMode(cli, cmd, True, lang)
    if not flag:
        errMsg = getMsg(lang, "cannot.get.diskindomain.info.param",disk_domain_id)
        return False, cliRet, errMsg, diskInDomainInfo

    diskInDomainList = cliUtil.getVerticalCliRet(cliRet)
    if len(diskInDomainList) == 0:
        errMsg = getMsg(lang, "cannot.get.diskindomain.info.param", disk_domain_id)
        return False, cliRet, errMsg, diskInDomainInfo

    return True, cliRet, errMsg, diskInDomainList[0]

def getDiskTypeByDiskDomainId(cli, disk_domain_id, lang):
    diskTypeList = []
    flag, cliRet, errMsg, diskInDomainList = getDiskDomainInfoById(cli, disk_domain_id, lang)
    if flag:
        diskTypeList = [disk["Type"]for disk in diskInDomainList]
    
    return flag, cliRet, errMsg, diskTypeList

def getDiskTypeByEngineOnDD(cli, diskDomainId, engineId, lang,productModel=""):
    """
    获取指定硬盘域中指定引擎硬盘类型集合
    """
    cliRet = "" 
    errMsg = ""
    
    diskTypeSet = set()
    checkRet = getDiskDomainInfoById(cli, diskDomainId, lang)
    cliRet = checkRet[1]
    if not checkRet[0]:
        return False, cliRet, checkRet[2], diskTypeSet
    
    diskInDomainList = checkRet[3]
    for diskDic in diskInDomainList:
        if getEngineIdByDiskId(diskDic.get("ID"),productModel) == engineId:
            diskTypeSet.add(diskDic.get("Type"))
            
    return True, cliRet, errMsg, diskTypeSet

def getDiskTypeNumByEngineOnDD(cli, diskDomainId, engineId, lang, productModel=""):
    """
    获取指定硬盘域中指定引擎硬盘类型-数量集合字典 ,返回值例如{"SSD":25,"SAS":12}
    """
    cliRet = "" 
    errMsg = ""
    
    diskTypeDict = {}
    checkRet = getDiskDomainInfoById(cli, diskDomainId, lang)
    cliRet = checkRet[1]
    if not checkRet[0]:
        return False, cliRet, checkRet[2], diskTypeDict
    
    diskInDomainList = checkRet[3]
    for diskDic in diskInDomainList:
        if getEngineIdByDiskId(diskDic.get("ID"),productModel) == engineId:
            diskType = diskDic.get("Type")
            diskTypeDict[diskType] = diskTypeDict.get(diskType, 0) + 1
            
    return True, cliRet, errMsg, diskTypeDict

def getEngDiskNumByDD(cli, diskList, lang, productModel=""):
    """
    获取系统上指定硬盘域所在引擎的硬盘类型-数量字典信息,例如:{0:{"SSD":11, "SAS":6}, 1:{"SSD":17,"SAS":15,"SATA":8}}
    """
    engDiskTypeDic = {}
    for diskDict in diskList:
        engId = getEngineIdByDiskId(diskDict.get("ID"),productModel)
        diskType = diskDict.get("Type")
        if not engDiskTypeDic.has_key(engId):
            engDiskTypeDic[engId] = {}
        if not engDiskTypeDic.get(engId).has_key(diskType):
            engDiskTypeDic[engId][diskType] = 1
        else:
            engDiskTypeDic[engId][diskType] += 1
    
    return engDiskTypeDic
        

def getDiskTypeCapacityByEngineOnDD(cli, diskDomainId, engineId, lang,  productModel=""):
    """
    获取指定硬盘域中指定引擎硬盘类型-容量集合字典 ,返回值例如{"SSD":set([500,700]),"SAS":set([700])}
    """
    cliRet = ""
    errMsg = ""
    
    diskTypeCapacityDict = {}
    checkRet = getDiskDomainInfoById(cli, diskDomainId, lang)
    cliRet = checkRet[1]
    if not checkRet[0]:
        return False, cliRet, checkRet[2], diskTypeCapacityDict
    
    diskInDomainList = checkRet[3]
    for diskDic in diskInDomainList:
        if getEngineIdByDiskId(diskDic.get("ID"),productModel) == engineId:
            diskType = diskDic.get("Type")
            diskId = diskDic.get("ID")
            diskCapacitySets = set()
            checkRet = getDiskCapacityByDiskId(cli, diskId, lang)
            if not checkRet[0]:
                return False, checkRet[1], checkRet[2], diskTypeCapacityDict
            diskCapacitySets.add(checkRet[1])
            
            diskTypeCapacityDict[diskType] = diskTypeCapacityDict.get(diskType, set()) | diskCapacitySets
    
    return True, cliRet, errMsg, diskTypeCapacityDict

def getEngDiskCapByDD(cli, diskList, lang, productModel=""):
    """
    获取系统指定硬盘域中指定引擎硬盘类型-容量集合字典 ,返回值例如{"SSD":set([500,700]),"SAS":set([700])}
    """
    flag = True
    cliRetAll = ""
    errMsg = ""
    engDiskTypeCapDict = {}
    for diskDict in diskList:
        diskId = diskDict.get("ID")
        engId = getEngineIdByDiskId(diskId, productModel)
        diskType = diskDict.get("Type")
        isQrySucc, diskCapacity, errInfo = getDiskCapacityByDiskId(cli, diskId, lang, isHasLog=False)
        if not isQrySucc:
            flag = False
            cliRetAll += diskCapacity
            errMsg += errInfo
            continue
        
        if not engDiskTypeCapDict.has_key(engId):
            engDiskTypeCapDict[engId] = {}
        if not engDiskTypeCapDict.get(engId).has_key(diskType):
            diskCapacitySets = set()
            diskCapacitySets.add(diskCapacity)
            engDiskTypeCapDict[engId][diskType] = diskCapacitySets
        else:
            engDiskTypeCapDict[engId][diskType].add(diskCapacity)
        
    return flag, cliRetAll, errMsg, engDiskTypeCapDict
        

def getEnclosureType(cli, lang):
    '''
    @summary: 获取Dorado 5000V3 框类型
    @param cli: cli对象
    @param lang: 语言lang
    @return:
        flag:
            True: 获取成功
            False: 获取失败
        ret:
            flag为True时，框类型
            flag为False时，cli回显
        errMsg: 错误消息
    '''
    enclosureType = "SAS"
    cmd = "show enclosure"
    flag, cliRet, errMsg = cliUtil.excuteCmdInCliMode(cli, cmd, True, lang)
    if not flag:
        return False, cliRet, errMsg, ""

    enclosureList = cliUtil.getHorizontalCliRet(cliRet)
    if len(enclosureList) == 0:
        errMsg = getMsg(lang, "cannot.get.enclosure.info")
        return False, cliRet, errMsg, ""

    for line in enclosureList:
        if line.get("Logic Type") == "Engine":
            if "NVMe" in line.get("Type"):
                enclosureType = "NVMe"
        break

    return True, cliRet, errMsg, enclosureType


def getDiskCapacity(cli, diskId, lang):
    """通过CLI获取指定硬盘容量
    :param cli:
    :param diskId:
    :param lang:
    :return:
    """
    cmd = "show disk general disk_id=%s" % diskId
    flag, cliRet, errMsg = cliUtil.excuteCmdInCliMode(cli, cmd, True, lang)
    if not flag:
        errMsg = getMsg(lang, "failed.to.get.disk.info", diskId)
        return False, cliRet, errMsg, 0
    for line in cliRet.splitlines():
        if line.strip() and line.split(':')[0].strip() == 'Capacity':
            cap = line.split(':')[1].strip()
            transGbOk, capacityGb = changUnit2GB(cap)
            if not transGbOk:
                break
            return True, cliRet, '', capacityGb
    errMsg = getMsg(lang, "failed.to.get.disk.info", diskId)
    return False, cliRet, errMsg, 0

def getDiskCapacityByDiskId(cli, disk_id, lang, isOrigin=False, isHasLog=True):
    '''
    @summary: 获取硬盘容量
    :param cli:
    :param lang:
    @return:
        flag:
            True: 获取成功
            False: 获取失败
        ret:
            flag为True时，硬盘容量
            flag为False时，cli回显
        errMsg: 错误消息
    '''
    cliRet = ""
    errMsg = ""
    checkRet = getDiskElectronicLabelById(cli, disk_id, lang, isHasLog)
    if not checkRet[0]:
        return False, checkRet[1], checkRet[2]
    cliRet = checkRet[1]
    # 匹配电子标签中的硬盘容量大小
    diskCapacity = None
    cliRetList = checkRet[3].split("  ")
    ElectronicList = filter(lambda x : x != "", cliRetList)
    flag = False
    for line in ElectronicList:
        if not re.search("Description", line, re.IGNORECASE):
            continue
        descValueList = line.split("=")
        if len(descValueList) < 2:
            errMsg = getMsg(lang, "failed.to.get.disk.electronic.label.info", disk_id)
            return False, cliRet, errMsg
        resultList = descValueList[1].split(",")
        for result in resultList:
            diskValueList = result.strip().split(' ')
            for diskValue in diskValueList:
                if not re.search("^[0-9]+(\.\d+)?((G$)|(GB$)|(T$)|(TB$))", diskValue):
                    continue
                if diskValue.startswith("6G"):#SAS速率跳过
                    continue
                if diskValue.endswith("GB") or diskValue.endswith("TB"):
                    flag = True
                    diskCapacity = diskValue
                    break
                if diskValue.endswith("T"):
                    diskCapacity = diskValue.replace("T", "TB")
                    flag = True
                    break
                if diskValue.endswith("G"):
                    diskCapacity = diskValue.replace("G", "GB")
                    flag = True
                    break
            if flag:
                if isOrigin:
                    return True, diskCapacity, errMsg
                else:
                    checkRet = changUnit2GBLabelCap(diskCapacity)
                return True, checkRet[1], errMsg
            
    errMsg = getMsg(lang, "failed.to.get.disk.electronic.label.info", disk_id)
    return False, cliRet, errMsg

def getDiskElectronicLabelById(cli, disk_id, lang, isHasLog=True):
    """
    根据硬盘ID获取硬盘电子标签
    """
    elecLabelStr = ""
    cmd = "show disk general disk_id=%s" % disk_id
    flag, cliRet, errMsg = cliUtil.excuteCmdInCliMode(cli, cmd, isHasLog, lang)
    if not flag:
        errMsg = getMsg(lang, "failed.to.get.disk.info", disk_id)
        return False, cliRet, errMsg, elecLabelStr

    retList = cliUtil.getVerticalCliRetFilterElabel(cliRet, isParseElcLabel=False)
    
    if not retList:
        errMsg = getMsg(lang, "failed.to.get.disk.info", disk_id)
        return False, cliRet, errMsg, elecLabelStr
    
    for line in retList:
        if line.has_key("Electronic Label"):
            elecLabelStr = line.get("Electronic Label")
            return True, cliRet, errMsg, elecLabelStr
    errMsg = getMsg(lang, "failed.to.get.disk.info", disk_id)
    return False, cliRet, errMsg, elecLabelStr


def getEnclosureElectronicLabelById(cli, lang, isHasLog=True):
    """
        获取控制框电子标签
    """
    elecLabelStr = ""
    cmd = "show enclosure enclosure_id=CTE0"
    flag, cliRet, errMsg = cliUtil.excuteCmdInCliMode(cli, cmd, isHasLog, lang)
    if not flag:
        errMsg = getMsg(lang, "failed.to.get.encloure.cte0.info")
        return False, cliRet, errMsg, elecLabelStr

    retList = cliUtil.getVerticalCliRetFilterElabel(cliRet, isParseElcLabel=False)
    
    if not retList:
        errMsg = getMsg(lang, "failed.to.get.encloure.cte0.electronic.label.info")
        return False, cliRet, errMsg, elecLabelStr
    
    for line in retList:
        if line.has_key("Electronic Label"):
            elecLabelStr = line.get("Electronic Label")
            return True, cliRet, errMsg, elecLabelStr
    
    return False, cliRet, errMsg, elecLabelStr

def isEnhancedVersion(cli, lang, isOrigin=False, isHasLog=True):
    '''
    @summary: 判断是否为Purley增强版
    :param cli:
    :param lang:
    @return:
        flag:
            True: 获取成功
            False: 获取失败
        ret:
            flag为True时，硬盘容量
            flag为False时，cli回显
        errMsg: 错误消息
    '''
    errMsg = ""
    checkRet = getEnclosureElectronicLabelById(cli, lang, isHasLog)
    if not checkRet[0]:
        return False, checkRet[1], checkRet[2]
    cliRet = checkRet[1]
    cliRetList = checkRet[3].split("  ")
    ElectronicList = filter(lambda x : x != "", cliRetList)
    for line in ElectronicList:
        if not re.search("Description", line, re.IGNORECASE):
            continue
        descValueList = line.split("=")
        if len(descValueList) < 2:
            errMsg = getMsg(lang, "failed.to.get.encloure.cte0.electronic.label.info")
            return False, cliRet, errMsg
        if "Enhanced" in descValueList[1]:
            return True, True, errMsg
        else:
            return True, False, errMsg
            
    errMsg = getMsg(lang, "failed.to.get.encloure.cte0.electronic.label.info")
    return False, cliRet, errMsg

def getExpDiskListFromContext(py_java_env):
    """
    @summary: 从工具箱的缓存中获取新扩硬盘列表
    """
    return py_java_env.get("expDiskList")

def getExpDiskListFromContextFilter(py_java_env):
    """
    获取并过滤dorado v3版本中的非新建硬盘域列表
    """
    expDiskList = getExpDiskListFromContext(py_java_env)
    return filter(lambda x : x.get("diskDomain") != "none", expDiskList)

def getNewExpDiskDomainListFromContext(py_java_env):
    """
    获取并过滤dorado v3版本中的新建硬盘域列表
    """
    expDiskList = getExpDiskListFromContext(py_java_env)
    return filter(lambda x : x.get("diskDomain") == "none", expDiskList)

def getExpCtrlNumber(py_java_env):
    """
     获取扩容后的控制器数量
    """
    return int(py_java_env.get("expCtrl"))

def getEngMemberDiskCapacity(diskDictList):
    """
    获取引擎成员盘容量信息
    """
    engDiskCapacityDict = {}
    for diskDict in diskDictList:
        diskCapacityList = []
        engId = getEngineIdByDiskId(diskDict.get("ID"))
        flag, diskCapacity = changUnit2GB(diskDict.get("Capacity"))
        if flag:
            diskCapacityList.append(diskCapacity)
        engDiskCapacityDict[engId] = engDiskCapacityDict.get(engId, []) + diskCapacityList
    
    return engDiskCapacityDict


def getEngMemberDiskType(diskDictList):
    """
    获取引擎成员盘类型信息
    """
    engDiskTypeDict = {}
    for diskDict in diskDictList:
        diskTypeSet = set()
        engineID = getEngineIdByDiskId(diskDict.get("ID"))
        diskTypeSet.add(diskDict.get("Type"))
        engDiskTypeDict[engineID] = engDiskTypeDict.get(engineID, set()) | diskTypeSet
    
    return engDiskTypeDict
    
def calcDiskRAIDThreshold(raid_disk_num):
    if raid_disk_num in range(1, 13):
        return raid_disk_num + 1 if raid_disk_num >= 10 else 11
    
    if raid_disk_num in range(13, 25):
        return raid_disk_num + 2
    
    if raid_disk_num in range(25, 29):
        return raid_disk_num + 3
    

def getDiskTruncationThreshold(cli, disk_domain_id, disk_type, lang):
    """
    获取硬盘截断阈值
    """
    cliRet = ""
    errMsg = ""
    thresholdValue = 11
    thresholdValueList = []
    
    cmd = "show storage_pool general |filterRow column=Disk\sDomain\sID predict=equal_to value=%s" % disk_domain_id
    checkRet = cliUtil.excuteCmdInCliMode(cli, cmd, True, lang)
    cliRet = checkRet[1]
    if not checkRet[0]:
        return False, checkRet[1], checkRet[2], thresholdValue
    
    if cliUtil.queryResultWithNoRecord(cliRet):
        return True, cliRet, errMsg, thresholdValue
    
    poolDictList = cliUtil.getHorizontalCliRet(cliRet)
    if len(poolDictList) == 0:
        return False, cliRet, errMsg, thresholdValue
    
    for poolDict in poolDictList:
        pool_id = poolDict.get("ID")
        checkRet = getRaidNumberByDiskType(cli, pool_id, disk_type, lang)
        cliRet += checkRet[1]
        if not checkRet[0]:
            errMsg = checkRet[2]
            return False, cliRet, errMsg, thresholdValue
        thresholdValueList.append(checkRet[3])
    
    if not thresholdValueList:
        return True, cliRet, errMsg, thresholdValue
    
    thresholdValue = calcDiskRAIDThreshold(max(thresholdValueList))
    
    return True, cliRet, errMsg, thresholdValue


def getRaidNumberByDiskType(cli, pool_id, disk_type, lang):
    """
    获取指定硬盘类型的RAID成员盘数
    """
    flag = False
    cliRet = ""
    errMsg = ""
    raidDiskNumber = 0
    
    cmd = "show storage_pool tier pool_id=%s|filterRow column=Name predict=equal_to value=%s" % (pool_id, config.DISK_TYPE_LEVEL.get(disk_type))
    checkRet = cliUtil.excuteCmdInCliMode(cli, cmd, True, lang)
    cliRet = checkRet[1]
    if not checkRet[0]:
        return False, cliRet, checkRet[2], raidDiskNumber
    
    if cliUtil.queryResultWithNoRecord(cliRet):
        return True, cliRet, errMsg, raidDiskNumber
    
    dictList = cliUtil.getVerticalCliRet(cliRet)
    for tierDict in dictList:
        if tierDict.has_key("RAID Disk Number"):
            raidDiskNumber = int(tierDict.get("RAID Disk Number"))
            flag = True
            break
    
    return flag, cliRet, errMsg, raidDiskNumber

def getSysVersion(cli, lang):
    """
    获取系统版本
    """
    cliRet = ""
    errMsg = ""
    curSysVersion = ""
    ret, sysVersionList, hotpatchVersionList = parse_upgradePackage(cli, lang)
    if not ret[0]:
        return False, ret[1], ret[2], curSysVersion
    
    ret, curSysVersion, errMsg = getCurrentVersion(sysVersionList,lang)
    if not ret:
        return False, cliRet, errMsg, curSysVersion
    
    return True, cliRet, errMsg, curSysVersion
    

#刷新进度公共方法
def threadUpProcess(py_java_env, totalTime, intervalTime, logger):
    try:
        inProcess(py_java_env)
        t = threading.Thread(target=updateProcess, args=(py_java_env, totalTime, intervalTime, logger))
        t.start()
        py_java_env.put("thread", t)
    except:
        return

# 扩容评估检查项8s优化提取添加的更新进度的公共方法    
def updateProcess(py_java_env, totalTime, interval, logger):
    #剩余时间总数
    totalReaminTime = totalTime
    refreshProcess(py_java_env, 1, logger)
    
    #进度平滑处理
    #0~50 interval/50~75 2*interval/75~90 4*interval
    #/90~100 8*interval /99停留直到100
    tmpInterval = interval
    
    #isSet[0] range(50,75)  isSet[1] range(75,90)  isSet[2] range(90,100)
    isSet = [False, False, False]
    
    while py_java_env.get("checkState") == config.PROCESS_STATE_CHECKING:
        #更新进度条
        totalReaminTime -= tmpInterval
        if  totalReaminTime <= 0:
            #最后的剩余时间保持为上一次显示的剩余时间
            totalReaminTime += tmpInterval
            refreshProcess(py_java_env, 99, logger)
            safeSleep(interval)
            continue
        
        currentPro = int(100*(totalTime - totalReaminTime)/totalTime)
        if tmpInterval != 1:
            if not isSet[0] and currentPro in range(50,75):
                tmpInterval = 1 if tmpInterval/2 == 0 else tmpInterval/2
                isSet[0] = True
            elif not isSet[1] and currentPro in range(75,90):
                tmpInterval = 1 if tmpInterval/2 == 0 else tmpInterval/2
                isSet[1] = True
            elif not isSet[2] and currentPro in range(90,100):
                tmpInterval = 1 if tmpInterval/2 == 0 else tmpInterval/2
                isSet[2] = True
        
        logger.logInfo("[UI_thread]totalReaminTime:%s currentPro : %s" % (str(totalReaminTime),str(currentPro)))
        refreshProcess(py_java_env, currentPro, logger)
        
        safeSleep(interval)
    
    if py_java_env.get("checkState") == config.PROCESS_UPGRADE_FINISHED:
        refreshProcess(py_java_env, 100, logger)
    return

# 扩容评估检查项8s优化提取添加的正在刷进度的公共方法    
def inProcess(py_java_env):
    py_java_env.put("checkState", config.PROCESS_STATE_CHECKING)
    return

# 扩容评估检查项8s优化提取添加的完成进度的公共方法    
def finishProcess(py_java_env):
    py_java_env.put("checkState", config.PROCESS_UPGRADE_FINISHED)
    #主线程等待刷进度的线程将剩余时间置于0
    threadJoin(py_java_env)
    return

def threadJoin(py_java_env):
    try:
        if py_java_env.get("thread") != None:
            py_java_env.get("thread").join()
    except:
        return

def safeSleep(seconds):
    '''
    @summary: 安全睡眠时间
    @param param: seconds为睡眠时间，单位：秒；数据类型：整数或小数
    '''    
    try:
        if type(seconds) not in [int,long,float] or seconds <= 0:
            return
        
        startTime = time.clock()
        except_counter = 0
        while True:
            if (time.clock() - startTime) >= seconds:
                return
            
            #睡眠一下，避免长时间占用cpu，该时间设置过长会影响睡眠时间精度
            try:
                time.sleep(0.1)
            except:
                except_counter += 1
    except:
        return
    
    

def getDiskInfoList(cli, lang):
    '''
    @summary: 获取所有硬盘信息
    @param cli: cli对象
    @param lang: 语言lang
    '''
    cmd = "show disk general"
    checkRet = cliUtil.excuteCmdInCliMode(cli, cmd, False, lang)
    if checkRet[0] != True: 
        return checkRet
    cliRet = checkRet[1]
    
    if cliUtil.queryResultWithNoRecord(cliRet):
        return (True, [], "")
    
    cliRetLinesList = cliUtil.getHorizontalCliRet(cliRet)
    if not cliRetLinesList:
        errMsg = getMsg(lang, "cannot.get.disk.info")
        return (False, cliRet, errMsg)
    
    return (True, cliRetLinesList, "")

def getEnclosureList(cli, lang):
    '''
    @summary: 获取所有框信息
    @param cli: cli对象
    @param lang: 语言lang
    '''
    cmd = "show enclosure"
    checkRet = cliUtil.excuteCmdInCliMode(cli, cmd, True, lang)
    if checkRet[0] != True: 
        return checkRet
    cliRet = checkRet[1]
    
    if cliUtil.queryResultWithNoRecord(cliRet):
        return (True, [], "")
    
    cliRetLinesList = cliUtil.getHorizontalCliRet(cliRet)
    if not cliRetLinesList:
        errMsg = getMsg(lang, "cannot.get.enclosure.info")
        return (False, cliRet, errMsg)
    
    return (True, cliRetLinesList, "")

def getDiskInfo(cli, lang, disk_id):
    '''
    @summary: 获取所有框信息
    @param cli: cli对象
    @param lang: 语言lang
    '''
    diskCap = "--"
    flag, result, __ = getDiskCapacityByDiskId(cli, disk_id, lang, isOrigin=True)
    if not flag:
        return diskCap
    return result
    

def getEncTypeInfo(cli, lang):
    '''
    @summary: 获取所有框类型
    @param cli: cli对象
    @param lang: 语言lang
    '''
    encInfo = {}
    flag, encInfoList, __ = getEnclosureList(cli, lang)
    if not flag:
        return encInfo
    
    for info in encInfoList:
        encId = info.get("ID")
        encType = info.get("Type")
        encInfo[encId] = encType
    
    return encInfo
	
def getProductVersionAndHotPatchVersion(cli, LOGGER, LANG):
    """
    获取当前SPC版本信息,补丁版本信息
    :param cli:
    :return:productVersion 产品版本信息, hotPatchVersion补丁版本信息
    """
    ALL_CLI_RET = ""
    (succFlag, cliRet, errMsg), softwareVersionList, hotPatchVersionList = parse_upgradePackage(cli, LANG)
    ALL_CLI_RET = joinLines(ALL_CLI_RET, cliRet)
    if succFlag != True:
        LOGGER.logInfo("get package info fail! softwareVersionList:%s, hotPatchVersionList%s" %
                       (softwareVersionList, hotPatchVersionList))
        return succFlag, "", "", ALL_CLI_RET, errMsg

    flag, productVersion, errMsg = getCurrentVersion(softwareVersionList, LANG)
    if flag != True:
        LOGGER.logInfo("get current product version error. errMsg: %s" % errMsg)
        return flag, "", "", ALL_CLI_RET, errMsg

    flag, hotPatchVersion, errMsg = getHotPatchVersion(hotPatchVersionList, LANG)
    if flag != True:
        LOGGER.logInfo("get hotPatchVersion error. errMsg: %s" % errMsg)
        return flag, "", "", ALL_CLI_RET, errMsg

    return True, productVersion, hotPatchVersion, ALL_CLI_RET, ""


class AsynProgress(threading.Thread):
    """
    异步刷新线程
    当某个命令执行需要很久时，考虑使用。刷新时间定为0.1秒能更好、更快的反应关掉线程。
    可选参数说明：
    currentProgress 当前起始进度。
    endProgress：预计结束进度。
    """
    def __init__(self, PY_JAVA_ENV, LOGGER, currentProgress = 1.0, endProgress = 99, sleepTime = 0.1):
        threading.Thread.__init__(self)
        self.stopFlg = False
        self.endProgress = endProgress
        self.currentProgress = currentProgress
        self.PY_JAVA_ENV = PY_JAVA_ENV
        self.LOGGER = LOGGER
        self.sleepTime = sleepTime

    def run(self):
        self.LOGGER.logInfo(
            "start threading progress:%s" % threading.current_thread().name)
        tmp = 1
        while self.currentProgress <= self.endProgress and not self.stopFlg:
            if tmp >= 1:
                refreshProcess(self.PY_JAVA_ENV, self.currentProgress, self.LOGGER)
                tmp = 0
            self.currentProgress += 0.1
            tmp += 0.1
            time.sleep(self.sleepTime)

        self.LOGGER.logInfo("thread exit! %s" %
                            threading.current_thread().name)

    def setStopFlag(self, stopFlag):
        self.stopFlg = stopFlag

    def start_thread(self):
        try:
            self.start()
        except ToolException, e:
            self.LOGGER.logInfo("thread start except! %s:%s" % (
                threading.current_thread().name, str(e)))


def getDayOfDay(UTC=False, days=0, hours=0, miutes=0, seconds=0): 
    '''
    @summary: 获取当前时间的时间差
        if days>=0,date is larger than today 
        if days<0,date is less than today 
    @return: 返回新时间
        date format = "YYYY-MM-DD"
    ''' 
    now = time.time() 
    timeNew = now + days*24*60*60 + hours*60*60 + miutes*60 + seconds 
    if UTC: 
        #协调世界时 
        timeNew = timeNew + time.timezone 
    t = time.localtime(timeNew)
    return time.strftime('%Y-%m-%d/%H:%M:%S', t)

def checkHeartSupportCrossEngine(cli, lang):
    '''
    @summary: 检查当前版本是否支持跨引擎心跳
    @return: 
            True:支持跨引擎心跳
            False:不支持跨引擎心跳
    '''
    #从其他模式切换到CLI模式
    cliUtil.enterCliModeFromSomeModel(cli, lang)
    checkResult = getProductVersionByUpgradePackage(cli, lang)
    productVersion = checkResult[3]
    
    checkResult = cliUtil.getProductModelWithCliRet(cli, lang)  
    productModel = checkResult[1]
    
    #通过版本和型号判断是否支持跨引擎心跳
    if (productModel in config.NO_SUPPORT_CROSS_ENGINE_VERSION_DICT) and \
    (productVersion < config.NO_SUPPORT_CROSS_ENGINE_VERSION_DICT[productModel]):
        return False
    
    if (productModel not in config.NO_SUPPORT_CROSS_ENGINE_VERSION_DICT) and \
    (productVersion < config.NO_SUPPORT_CROSS_ENGINE_VERSION_DICT.get("otherModel")):
        return False
    
    return True

def getNodeIdAsNew(cli, lang, nodeId):
    '''
    @summary: 将节点ID转换为实际的内部节点ID（不支持跨引擎心跳场景）
    '''
    try:
        newNodeId = ""
        checkResult = getEngNodeInfo(cli, lang)
        engNodeInfoList = checkResult[2]
        for engNodeInfo in engNodeInfoList:
            if "currentNodeId" in engNodeInfo:
                continue
            
            for engId in engNodeInfo:
                nodeIdList = engNodeInfo[engId]
                if int(nodeId) in nodeIdList:
                    contrNum = len(nodeIdList)
                    newNodeId = int(nodeId) % contrNum
                    break
        
        return newNodeId
    except:
        return ""
    
def getEngHeight(devObj):
    '''
    @summary: 获取控制框高度
    @return: 
            param1:命令是否执行成功：True-成功，False-失败
            param2:高度
            param3:cli回显
            param4:命令执行失败的错误信息
    '''
    lang = str(devObj.get("lang"))
    cli = devObj.get("ssh")
    height = ""
    cmd = "show enclosure enclosure_id=CTE0"
    __, cliRet, __ = cliUtil.excuteCmdInCliMode(cli, cmd, True, lang)
    for line in cliRet.splitlines():
        line = line.strip()
        if "Height(U)" in line:
            height = line.split(":")[-1].strip()
            return (True, height,cliRet, "")
    
    cmd = "show enclosure enclosure_id=ENG0"
    __, cliRet, __ = cliUtil.excuteCmdInCliMode(cli, cmd, True, lang)
    for line in cliRet.splitlines():
        line = line.strip()
        if "Height(U)" in line:
            height = line.split(":")[-1].strip()
            return (True, height,cliRet, "")
        
    errMsg = cliUtil.getMsg(lang, "failed.to.get.eng")
    return (False, height,cliRet, errMsg)

#只用于V3系列
def getDisplayEngId(engId, productModel):
    if engId.startswith("CTE"):
        return engId
    
    if engId.isdigit():
        if productModel in config.LOGIC_ENG_PRODUCTS:
            eng = int(engId)/2
            node = int(engId)%2
            if not node:
                return "%sA/%sB" %(eng,eng)
            else:
                return "%sC/%sD" %(eng,eng)
        else:
            return "CTE%s"%engId
    return engId

def getExpDiskList(expDiskInfoDict):
    '''
    @summary: 同一硬盘域，同一引擎的扩容配置
    '''
    diskInfo = {}
    for domainId in expDiskInfoDict.keys():
        diskList = expDiskInfoDict.get(domainId)
        for disk in diskList:
            domainId = disk.getDiskDomainId()
            logicEng = disk.getDiskLogicEngId()
            key = "%s_%s"%(domainId, logicEng)
            expList = diskInfo.get(key, [])
            expList.append(disk)
            diskInfo[key] = expList
    return diskInfo.values()


def getCtrlsByLogicEng(engId, productModel):
    ctrlMap_6u_mid = {
        "0":["0A","0B"],
        "1": ["0C", "0D"],
        "2": ["1A", "1B"],
        "3": ["1C", "1D"],
        "4": ["2A", "2B"],
        "5": ["3C", "3D"],
        "6": ["4A", "4B"],
        "7": ["4C", "4D"],
    }
    ctrlMap_6u_high = {
        "0":["0A","0B", "0C", "0D"],
        "1": ["1A","1B", "1C", "1D"],
        "2": ["2A","2B", "2C", "2D"],
        "3": ["3A","3B", "3C", "3D"],
    }

    ctrlMap_2u_3u_mid = {
        "0":["0A","0B"],
        "1": ["1A","1B"],
        "2": ["2A","2B"],
        "3": ["3A","3B"],
    }
    if engId.isdigit():
        if productModel in config.SMALL_SAS_6U_PRODUCTS:
            return  ctrlMap_6u_mid.get(str(engId), [])

        elif cliUtil.STOR_DEV_INFO_DICT.get(productModel, None) == cliUtil.SERIES_18000:
            return ctrlMap_6u_high.get(str(engId), [])
        else:
            return ctrlMap_2u_3u_mid.get(str(engId),[])

    return None

def getCli4Ctrl(cli, lang,logger, py_java_env):
    flag, errMsg, ipListDict = cliUtil.getContrIpList(cli, lang)
    if not flag:
        return flag, errMsg, cli

    for ip in ipListDict.values():
        cliConn = getCilConnectionByIp(ip, py_java_env, logger)
        if cliConn:
            return True, "", cliConn
    return False, getMsg(lang, "connect.to.controller.failed"), cli

def isConnectSVP(controllerIps, py_java_env):
    """
    @summary: 工具连接的是否是SVP。
    """
    devInfo = getCurDeviceInfo(py_java_env)
    currentConnectIp = getIpFromDevNode(devInfo)
    if currentConnectIp in controllerIps:
        return False
    return True


def closeConnection(cilConnection, py_java_env, logger):     
    """
    @summary: 关闭cli连接。
    """
    try:
        py_java_env.get("sshManager").releaseConnection(cilConnection) 
    except:
        logger.logError(str(traceback.format_exc()))


def getConnection2Controller(ips, py_java_env, logger):
    """
    @summary: 获取与阵列控制器的管理链路。
    """
    cilConnection = None
    
    for ip in ips:
        cilConnection = getCilConnectionByIp(ip, py_java_env, logger)
        if cilConnection == None:
            logger.logInfo('Failed to connect to controller(IP:%s)' % ip)
            continue
        else:
            logger.logInfo('Success to connect to controller(IP:%s)' % ip)
            break
        
    return cilConnection


def executeOneDebugCommand(cli, cmd, lang):
    """
    @summary: 执行一条debug命令。命令执行完后恢复到CLI模式。
    """
    switch = True
    try:
        # V3R6及其之后版本版本，需要打开developer模式开关才能进入developer模式
        (flag, cliRet, errMsg), switch = cliUtil.openDeveloperSwitch(cli, lang)
        if flag == False: 
            return (False, cliRet, errMsg)  
        flag, cliRet, errMsg = cliUtil.excuteCmdInDebugModel(cli, cmd, lang) 
        return (flag, cliRet, errMsg)   
    finally:
        if switch == False:
            cliUtil.closeDeveloperSwitch(cli, lang)
        #退出到cli模式
        cliUtil.enterCliModeFromSomeModel(cli, lang)
        

def executeDebugCommand(cli, cmd, py_java_env, logger):
    """
    @summary: 执行debug命令。命令执行完后恢复到CLI模式。若工具连接的是SVP则需要建立到控制器的管理链路，因为SVP无法进入debug模式。
    """
    lang = getLang(py_java_env)
    
    if not is18000(py_java_env, cli):
        return executeOneDebugCommand(cli, cmd, lang)
    
    # 所有控制器上的管理IP。
    controllerIps = getAllIps(cli, lang)
    
    # 工具直连18000系列控制器，直接执行命令。
    if not isConnectSVP(controllerIps, py_java_env):
        return executeOneDebugCommand(cli, cmd, lang)
    
    # 获取工具到控制器的连接。
    cilConnection = getConnection2Controller(controllerIps, py_java_env, logger)
    
    # 工具无法连接控制器，尝试在现有的连接上执行debug命令。
    if cilConnection == None:
        flag, cliRet, errMsg = executeOneDebugCommand(cli, cmd, lang)
        if flag is not True:
            # 连接控制器失败。请参考预警公告手动检查。
            errMsg = getMsg(lang, "chunk.check.connect.to.controller.failed")
            return flag, cliRet, errMsg
        return flag, cliRet, errMsg
    try:
        return executeOneDebugCommand(cilConnection, cmd, lang)
    finally:
        closeConnection(cilConnection, py_java_env, logger)

def getDiskEnclosure(cli, lang):

    enclosureInfo = {"SAS":[],"NVMe":[]}
    cmd = "show enclosure"
    checkRet = cliUtil.excuteCmdInCliMode(cli, cmd, True, lang)
    if not checkRet[0]:
        return False, {}, checkRet[1]
    cliRet = checkRet[1]
    cliRetLinesExpModuleList = cliUtil.getHorizontalCliRet(cliRet)
    for rec in cliRetLinesExpModuleList:
        logicType = rec.get("Logic Type","")
        if logicType != "Expansion Enclosure":
            continue
        typeEnc = rec.get("Type","")
        encid = rec.get("ID","")
        if "NVMe" in typeEnc:
            enclosureInfo["NVMe"].append(encid)
        else:
            enclosureInfo["SAS"].append(encid)
    return True, enclosureInfo,checkRet[1]

def getResult(perFlag, curFlag):
    if perFlag == curFlag:
        return perFlag

    if perFlag == False or curFlag == False:
        return False

    if perFlag == cliUtil.RESULT_NOCHECK or curFlag == cliUtil.RESULT_NOCHECK:
        return cliUtil.RESULT_NOCHECK

    if perFlag == True or curFlag == True:
        return True

    return curFlag


def isSupportStrictConnEngineToEngineHeartBeat(productVersion):
    """
    可直接用于判断支持直连组网的
    :param productVersion:
    :return:
    """
    if (productVersion.startswith("V300R006") and productVersion >= config.SUPPORT_DERICT_CONN_ENGINE_HEART_BEAT_V3R6)\
        or (productVersion.startswith("V500R007") and productVersion >= config.SUPPORT_DERICT_CONN_ENGINE_HEART_BEAT_V5R7):
        return True
    if product.is_dorado_series_version(productVersion):
        return True
    return False


def isSupportEngineToEngineHeartBeat(productVersion, productModel):
    """
    开始支持引擎间心跳，且直连组网限制 0->2 1->3场景，判断需要先判断isSupportStrictConnEngineToEngineHeartBeat这个方法。
    :param productVersion:
    :return:
    """
    if (productVersion.startswith("V300R006") and productVersion >= config.SUPPORT_ENGINE_HEART_BEAT_V3R6)\
        or (productVersion.startswith("V500R007") and productVersion>= config.SUPPORT_ENGINE_HEART_BEAT_V5R7) \
            or (productModel in config.DORADO_DEVS and
                productVersion >= config.SUPPORT_ENGINE_HEART_BEAT_V3R1):
        return True
    if product.isDigitalVer(productVersion):
        return True
    return False


def getNewNVMeDiskDomainFromContext(py_java_env):
    """
    获取并过滤新建硬盘域NVME硬盘类型列表
    """
    expDiskList = getExpDiskListFromContext(py_java_env)
    return filter(lambda x: "nvme" in x.get("diskModel").lower(), expDiskList)

def getInterModule(cli, lang):
    '''
    @summary: 查询1号槽位
    @return:
        flag：True，是否查询成功
        cliRet：CLI回显
        errMsg：方法异常结束时的原因
    '''
    inerfIdModel = {}
    cmd = "show interface_module"
    flag, cliRet, errMsg = cliUtil.excuteCmdInCliMode(cli, cmd, True, lang)
    #命令执行失败
    if flag != True:
        return (flag, cliRet, errMsg, inerfIdModel)

    if cliUtil.queryResultWithNoRecord(cliRet):
        return (True, cliRet, errMsg, inerfIdModel)
    else:
        interModuleDictList = cliUtil.getHorizontalCliRet(cliRet)
        for interModuleDict in interModuleDictList:
            moduleId = interModuleDict.get("ID","")
            model = interModuleDict.get("Model","")
            inerfIdModel[moduleId] = model
    return (flag, cliRet, errMsg, inerfIdModel)

def getDiskList(cli, lang):
    '''
    @summary: 获取所有硬盘信息集合
    @param cli: cli对象
    @param lang: 语言lang
    '''
    cliRetLinesList = []
    cmd = "show disk general"
    checkRet = cliUtil.excuteCmdInCliMode(cli, cmd, True, lang)
    cliRet = checkRet[1]
    if checkRet[0] != True:
       return (True,cliRet, cliRetLinesList, "")

    if cliUtil.queryResultWithNoRecord(cliRet):
        return (True,cliRet, cliRetLinesList, "")

    cliRetLinesList = cliUtil.getHorizontalCliRet(cliRet)
    if not cliRetLinesList:
        errMsg = getMsg(lang, "cannot.get.disk.info")
        return (False,cliRet ,cliRetLinesList, errMsg)

    return (True, cliRet,cliRetLinesList, "")

def getControllerNum(cli, lang):

    allCliRet = ""
    flag, controlIdList, errMsg, cliRet = cliUtil.getControllerIdListWithRet(cli, lang)
    allCliRet = joinLines(allCliRet, cliRet)
    if not flag:
        return (flag ,0, allCliRet, errMsg)
    return True,len(controlIdList),allCliRet,errMsg


class AsynProgressExecuteCmd(threading.Thread):
    """
    异步执行命令的线程
    目的用于异步执行命令，保持长连接
    """
    def __init__(self, cli, LOGGER, lang, cmd="show system general"):
        threading.Thread.__init__(self)
        self.stopFlg = False
        self.LOGGER = LOGGER
        self.cmd = cmd
        self.cli = cli
        self.lang = lang

    def run(self):
        try:
            thread_name = threading.current_thread().name
            self.LOGGER.logInfo(
                "start threading progress:%s" % thread_name)
            self.LOGGER.logInfo("[%s]." % self.cmd)
            while not self.stopFlg:
                _, ret, _ = cliUtil.excuteCmdInCliMode(self.cli, self.cmd, True, self.lang)
                self.LOGGER.logInfo("execute cmd[%s], ret:[%s]." % (self.cmd, str(ret)))
                time.sleep(30)

            self.LOGGER.logInfo("thread exit!:%s" % thread_name)
        except:
            self.LOGGER.logInfo(
                "thread start except! %s" % (
                    threading.current_thread().name,
                    str(traceback.format_exc())))

    def start_thread(self):
        try:
            self.start()
        except ToolException, e:
            self.LOGGER.logInfo(
                "thread start except! %s:%s" % (
                    threading.current_thread().name, str(e)))

    def setStopFlag(self, stopFlag):
        self.stopFlg = stopFlag
        self.LOGGER.logInfo("setStopFlag execute cmd[%s], stopFlag:%s" % (self.cmd, stopFlag))


def getHotPatchVersionAndCurrentVersion(cli, lang):
    '''
    @summary: 执行show upgrade packge命令，将Software Version与HotPatch Version的
              回显存放到同一个字典列表中，并增加Version Type键来区分Version类型,并返回CLI回显
    @param cli: cli对象
    @param lang: 语言lang
    '''
    cmd = "show upgrade package"
    softwareVersion = ''
    hotPatchVersion = ''

    flag, cliRet, errMsg = cliUtil.excuteCmdInCliMode(cli, cmd, True, lang)
    if flag != True:
        return cliRet, softwareVersion, hotPatchVersion

    softwareVersionIndex = cliRet.find("Software Version")
    hotPatchVersionIndex = cliRet.find("HotPatch Version")
    softwareVersionList = cliUtil.getHorizontalCliRet(cliRet[(softwareVersionIndex):hotPatchVersionIndex])
    hotPatchVersionList = cliUtil.getHorizontalCliRet(cliRet[(hotPatchVersionIndex):])

    for ctrlInfoDict in softwareVersionList:
        softwareVersion = ctrlInfoDict.get("Current Version", '')
        break

    for ctrlInfoDict in hotPatchVersionList:
        hotPatchVersion = ctrlInfoDict.get("Current Version", '')
        break

    return cliRet, softwareVersion, hotPatchVersion


def getEngineCtrlNodeInfo(cli, LOGGER, LANG):
    """
    @summary: 获取除当前节点外的引擎其他健康节点信息，当前节点信息。
    @param cli: cli连接
    @return: (currentCtrlNodeId, currentEngineCtrlIdList)
        currentNodeId: 当前节点ID
        engineCtrlNodeMappingDict: 除当前节点外的引擎其他健康节点信息
        nodeNum
    """
    nodeNum = 2
    cmd = 'sys showcls'
    # 当前节点
    currentCtrlNodeId = None
    currentEngine = None
    engineCtrlNodeMappingDict = {}

    flag, cliRet, errMsg = executeOneDebugCommand(cli, cmd, LANG)
    if flag != True:
        LOGGER.logInfo("get node info Failed. errMsg: %s" % errMsg)
        return flag, errMsg,\
             cliRet, currentCtrlNodeId, engineCtrlNodeMappingDict, currentEngine, nodeNum

    ctrlInfoDictList = cliUtil.getVerticalCliRet(cliRet)
    engineInfoDictList = cliUtil.getHorizontalNostandardCliRet(cliRet)

    for ctrlInfo in ctrlInfoDictList:
        if ctrlInfo.get("local node id", "") != "":
            currentCtrlNodeId = ctrlInfo.get("local node id", "")
            break

    for engineInfo in engineInfoDictList:
        engine = engineInfo.get("engine", "")
        if engine == "":
            continue

        status = engineInfo.get("status", "")
        if status == "" or status != "normal":
            continue

        ctrlNodeId = engineInfo.get("id", "")
        if ctrlNodeId == "":
            continue

        tmpList = engineCtrlNodeMappingDict.get(engine, [])
        tmpList.append(ctrlNodeId)
        engineCtrlNodeMappingDict[engine] = tmpList

        if ctrlNodeId == currentCtrlNodeId:
            currentEngine = engine

    for engineId in engineCtrlNodeMappingDict:
        nodeNum = max(len(engineCtrlNodeMappingDict.get(engineId, [])), nodeNum)

    # 当前引擎包含的控制器节点
    return (True, "", cliRet, currentCtrlNodeId, engineCtrlNodeMappingDict, currentEngine, nodeNum)

def enginesJumpByheartBeat(connCli, targetEngineID, currentCtrlNodeId, nodeNum, PY_JAVA_ENV, LOGGER, LANG, engineCtrlNodeMappingDict, curEngineID):
    '''
          通过心跳实现cli链接从当前引擎跳转到制定引擎
    '''
    errMsg = ""
    allCliRet = ""
    closeHeartBeatTimes = 0
    # 计算需要心跳的节点值
    targetNodeId = int(currentCtrlNodeId) % nodeNum + int(targetEngineID) * nodeNum
    targetNodeList = engineCtrlNodeMappingDict.get(targetEngineID, [])
    LOGGER.logInfo("nodeNum:%s, currentCtrlNodeId is: %s, targetNodeId:%s, targetNodeList:%s" % \
                   (nodeNum, currentCtrlNodeId, targetNodeId, str(targetNodeList)))

    if str(targetNodeId) not in targetNodeList:
        # 4+2的6控，且连接的是2号节点。节点为0-5但会出现心跳6号节点的问题。
        # 计算出当前引擎的最小节点
        nodeIdList = engineCtrlNodeMappingDict.get(curEngineID, [])
        nodeIdList.sort()
        LOGGER.logInfo("targetNodeId is not exist, need change current ndoe, nodeIdList:%s" % nodeIdList)
        jumpNodeId = None
        for tmpJumpNodeId in nodeIdList:
            # 从最小节点计算对端节点平面
            targetNodeId = int(tmpJumpNodeId) % nodeNum + int(targetEngineID) * nodeNum
            LOGGER.logInfo("tmpJumpNodeId:%s, targetNodeId:%s, targetNodeList:%s" % (tmpJumpNodeId, targetNodeId, targetNodeList))
            if str(targetNodeId) not in targetNodeList:
                continue

            jumpNodeId = tmpJumpNodeId
            break
            
        if not jumpNodeId:
            errMsg = getMsg(LANG, "heart.beat.to.engine.failed", targetEngineID)
            return False, allCliRet, errMsg, connCli, closeHeartBeatTimes

        LOGGER.logInfo("jumpNodeId is: %s, targetNodeId is: %s" % (jumpNodeId, targetNodeId))

        # 心跳到存在对端平面的本端节点
        flag, cliRet, errMsg = heartBeatToOtherCtrl(connCli, jumpNodeId, PY_JAVA_ENV, LOGGER, LANG)
        allCliRet = joinLines(allCliRet, cliRet)
        if flag != True:
            return flag, allCliRet, errMsg, connCli, closeHeartBeatTimes
        closeHeartBeatTimes += 1

    flag, cliRet, errMsg = heartBeatToOtherCtrl(connCli, targetNodeId, PY_JAVA_ENV, LOGGER,LANG)
    allCliRet = joinLines(allCliRet, cliRet)
    if flag != True:
        return flag, allCliRet, errMsg, connCli, closeHeartBeatTimes

    closeHeartBeatTimes += 1
    return True, allCliRet, "", connCli, closeHeartBeatTimes

def getCurrentEngine(ipListDict,PY_JAVA_ENV):
    """
          获取当前引擎id
    :param ipListDict:
    :return:
    """
    currentContrIp = PY_JAVA_ENV.get("devInfo").getIp()
    for engine in ipListDict:
        if currentContrIp in ipListDict[engine]:
            return engine

    return '0'

def enginesJump(connCli, engineID, curEngineID, currentNodeId, nodeNum, PY_JAVA_ENV, LOGGER, LANG, engineCtrlNodeMappingDict):
    '''
         与enginesBack配套使用
          实现引擎间CLI链接跳转功能
         如果是支持引擎间心跳的版本，通过心跳跳转到目标引擎
         如果是不支持引擎间心跳的版本，通过IP建链接。
         输入： connCli链接，engineID引擎号
        输出：flag是否成功，errMsg错误信息，jumpConnCli跳转后链接
    '''
    allCliRet = ""
    errMsg = ""
    jumpConnCli = None
    productModel = str(PY_JAVA_ENV.get("devInfo").getDeviceType())
    productVersion = str(PY_JAVA_ENV.get("devInfo").getProductVersion())
    LOGGER.logInfo("productModel is: %s, productVersion:%s" % (productModel, productVersion))
    closeHeartBeatTimes = 0
    if not isSupportEngineToEngineHeartBeat(productVersion, productModel):
        LOGGER.logInfo("Jump to engine %s via IP"%(engineID))
        flag, cliRet, errMsg, engineIpListDict = getContrIpListOfEngine(connCli, LANG)
        LOGGER.logInfo("engineIpListDict is: %s" % (engineIpListDict))

        # 获取控制器IP
        flag, errMsg, jumpConnCli = getConnectionByContrIp(PY_JAVA_ENV, connCli, engineIpListDict, engineID, LOGGER, LANG)
        if flag:
            return flag, allCliRet, errMsg, jumpConnCli, closeHeartBeatTimes

        if productModel in SPECIAL_ENGINE_JUMP_PRODUCT_MODEL_LIST:
            new_engine_ip_list_dict = get_engine_ip(
                connCli, LANG, LOGGER, engineIpListDict, engineCtrlNodeMappingDict)
            flag, errMsg, jumpConnCli = getConnectionByContrIp(
                PY_JAVA_ENV, connCli, new_engine_ip_list_dict,
                engineID, LOGGER, LANG
            )
            LOGGER.logInfo(
                "new_engine_ip_list_dict is:{}, flag is:{}".format(new_engine_ip_list_dict, str(flag)))
            if flag is not True:
                errMsg = getMsg(
                    LANG, "can.not.check.6800.conn.fail", (engineID, engineID)
                )
    else:
        LOGGER.logInfo("Jump to engine %s through heartbeat" % (engineID))
        flag, cliRet, errMsg, jumpConnCli, closeHeartBeatTimes = enginesJumpByheartBeat(connCli, engineID, currentNodeId, nodeNum, PY_JAVA_ENV,
                                                                   LOGGER, LANG, engineCtrlNodeMappingDict, curEngineID)
        allCliRet = joinLines(allCliRet, cliRet)

    LOGGER.logInfo("curEngineID is: %s, engineID is: %s" % (curEngineID, engineID))


    return flag, allCliRet, errMsg, jumpConnCli, closeHeartBeatTimes


def get_engine_ip(cli, lang, py_logger, engine_ip_list_dict, engine_node_dict):
    """
    sys showcls 查出来的节点和引擎关系，
    show upgrade package 节点和IP的关系
    综合获取 引擎下IP关系
    :param cli:
    :param lang:
    :param py_logger:
    :param engine_ip_list_dict:
    :param engine_node_dict:
    :return:
    """
    new_engine_ip_list_dict = engine_ip_list_dict
    if is_6800_v3_multi_logical_engine(engine_ip_list_dict, engine_node_dict):
        new_engine_ip_list_dict = {}
        ctrl_engine_dict, node_list = get_node_engine_info(cli, py_logger, lang)
        all_ip_list = get_all_node_ip(cli, lang)
        py_logger.logInfo("ctrl_engine_dict:{}, node_list:{}, all_ip_list:{}".format(
            ctrl_engine_dict, node_list, all_ip_list))
        index = 0
        if len(all_ip_list) != len(node_list):
            return engine_ip_list_dict
        for node_id in node_list:
            engine_id = ctrl_engine_dict.get(node_id)
            eng_ip_list = new_engine_ip_list_dict.get(engine_id, [])
            eng_ip_list.append(all_ip_list[index])
            new_engine_ip_list_dict[engine_id] = eng_ip_list
            index += 1
    return new_engine_ip_list_dict


def is_6800_v3_multi_logical_engine(engine_ip_list_dict, engine_node_dict):
    """
    处理 6800 v3， sys showcls 查出来两个逻辑引擎， show upgrade package 只有1个引擎的场景
    :param engine_ip_list_dict:
    :param engine_node_dict:
    :return:
    """
    for engine, node_list in engine_node_dict.items():
        ip_list = engine_ip_list_dict.get(engine, [])
        if len(ip_list) != len(node_list):
            return True
    return False


def get_node_engine_info(cli, logger, lang):
    """
    获取节点和引擎ID
    :param cli:
    :param logger:
    :param lang:
    :return:
    """
    cmd = 'sys showcls'
    ctrl_engine_dict = {}
    node_list = []
    flag, ret, __ = executeOneDebugCommand(cli, cmd, lang)
    if flag is not True:
        logger.logInfo("get node info Failed.")
        return ctrl_engine_dict

    engine_info_dict_list = cliUtil.getHorizontalNostandardCliRet(ret)
    for engine_info in engine_info_dict_list:
        engine_id = engine_info.get("engine", "")
        if engine_id == "":
            continue

        node_id = engine_info.get("id", "")
        node_list.append(node_id)
        ctrl_engine_dict[node_id] = engine_id
    return ctrl_engine_dict, node_list


def get_all_node_ip(cli, lang):
    """
    @summary: 获取全部节点的IP
    """
    all_ip_list = []
    cmd = "show upgrade package"
    flag, ret, __ = cliUtil.excuteCmdInCliMode(cli, cmd, True, lang)
    if flag is not True:
        return all_ip_list

    begin_index = ret.find("Software Version")
    end_index = ret.find("HotPatch Version")
    info_list = cliUtil.getHorizontalCliRet(ret[begin_index: end_index])
    for info_dict in info_list:
        all_ip_list.append(info_dict.get("IP", ""))

    return all_ip_list


def enginesBack(connCli,PY_JAVA_ENV, LOGGER, LANG, closeHeartBeatTimes):
    '''
         与enginesJump配套使用
    CLI链接退回到原引擎
         如果是不支持心跳的设备需要直接关闭链接
        如果是支持心跳的设备，退出心跳链接
    '''
    if not connCli:
        return True
    productModel = str(PY_JAVA_ENV.get("devInfo").getDeviceType())
    productVersion = str(PY_JAVA_ENV.get("devInfo").getProductVersion())
    LOGGER.logInfo("productModel is: %s, productVersion:%s" % (productModel, productVersion))
    if not isSupportEngineToEngineHeartBeat(productVersion, productModel):
        LOGGER.logInfo("Back to the original engine through close connection :%s."%str(connCli))
        closeConnection(connCli, PY_JAVA_ENV, LOGGER)
    else:
        
        for i in range(closeHeartBeatTimes):
            cliUtil.exitHeartbeatCli(connCli, LANG)
            LOGGER.logInfo("Back to the original engine through exit heart beat :%s. exit range:%d" % (str(connCli), i))
    return True
def getNodeIdInEngine(connCli, PY_JAVA_ENV, LOGGER, LANG):
    '''
         获取当前引擎下所有节点
    '''
    nodeIdList = []
    errMsg = ""
    # 获取当前连接的节点、节点配置
    flag, errMsg, currentCtrlNodeId, engineCtrlIdList,_  = getEngineCtrlNodeInfo(connCli, LOGGER, LANG)
    if flag !=True:
        return flag, errMsg, nodeIdList
    # 计算需要心跳的节点值
    LOGGER.logInfo("currentCtrlNodeId is: %s, engineCtrlIdList:%s" % (currentCtrlNodeId, str(engineCtrlIdList))) 
    for engine in engineCtrlIdList:
        if currentCtrlNodeId in engineCtrlIdList.get(engine,[]):
            nodeIdList = engineCtrlIdList.get(engine,[])
            return True, errMsg, nodeIdList
    errMsg = getMsg(LANG, "chunk.check.get.controller.node.failed")
    return False, errMsg, nodeIdList
            
def createDeviceCliContFor18000(connCli, PY_JAVA_ENV, LOGGER, LANG):
    '''
          与closeDeviceCliContFor18000成对使用，如果是18000设备建立阵列链接
         如果不是18000设备，直接返回原有链接
    '''
    if is18000(PY_JAVA_ENV, connCli):
        flag, _, errMsg, engineIpListDict = getContrIpListOfEngine(connCli, LANG)
        LOGGER.logInfo("Currently 18000 devices, the controller link needs to be established first")
        # 18000 需要直接建立连接
        flag, errMsg, connCli = getConnectionByContrIp(PY_JAVA_ENV, connCli, engineIpListDict, u"0", LOGGER, LANG)
        if flag != True:
            return (False, connCli, errMsg)
    return True, connCli, ""

def closeDeviceCliContFor18000(connCli, PY_JAVA_ENV, LOGGER, LANG):
    '''
           与createDeviceCliContFor18000成对使用，如果是18000设备直接关闭链接
    '''
    if is18000(PY_JAVA_ENV, connCli):
        closeConnection(connCli, PY_JAVA_ENV, LOGGER)

def checkAllNodesInEngineWrap(func):
    '''
          遍历当前引擎中所有节点执行对应检查
         当检查函数返回CHECK_FLAG_NOT_CONTINUE时直接返回，否则继续遍历其他节点进行检查
         装饰函数出错时，抛出UnCheckException异常
        结果数据需要定义全局变量进行存储
    '''
    def wrap(Cli, PY_JAVA_ENV, LOGGER, LANG, heartBeatCliRet, *args, **kargs):
        heartBeatCliRet = ""
        funcRet = []
        flag, errMsg, cliRet, currentCtrlNodeId, engineCtrlNodeMappingDict, currentEngine, _ = getEngineCtrlNodeInfo(Cli, LOGGER, LANG)
        heartBeatCliRet = joinLines(heartBeatCliRet, cliRet)
        if flag != True:
            raise UnCheckException(errMsg, heartBeatCliRet)
        curEngineNodeList = engineCtrlNodeMappingDict.get(currentEngine)
        LOGGER.logInfo("contrNodeIdList:%s" % (curEngineNodeList))
        #先执行当前节点检查
        funcRet = func(Cli, PY_JAVA_ENV, LOGGER, LANG, heartBeatCliRet, *args, **kargs)
        heartBeatCliRet = ""
        if funcRet == CHECK_FLAG_NOT_CONTINUE:
            return funcRet
        curEngineNodeList.remove(currentCtrlNodeId)
        for contrNodeId in curEngineNodeList:
            flag, cliRet, errMsg=heartBeatToOtherCtrl(Cli, contrNodeId, PY_JAVA_ENV, LOGGER, LANG)
            heartBeatCliRet = joinLines(heartBeatCliRet, cliRet)
            if flag != True:
                raise UnCheckException(errMsg, heartBeatCliRet)
            try:
                funcRet = func(Cli, PY_JAVA_ENV, LOGGER, LANG, heartBeatCliRet, *args, **kargs)
                if funcRet == CHECK_FLAG_NOT_CONTINUE:
                    return funcRet
            except UnCheckException as unCheckException:
                LOGGER.logInfo(u"UnCheckException, errMsg: %s" % unCheckException.errorMsg)
                raise UnCheckException(errMsg, heartBeatCliRet)
            except:
                LOGGER.logInfo(str(traceback.format_exc()))
                raise UnCheckException(getMsg(LANG, "query.result.abnormal"), heartBeatCliRet)
            finally:
                cliUtil.exitHeartbeatCli(Cli, LANG)
                LOGGER.logInfo("exit heart beat success.")
                # 退出到cli模式
                ret = cliUtil.enterCliModeFromSomeModel(Cli, LANG)
                LOGGER.logInfo("enter cli mode from some model ret is %s" % str(ret))
                # 退出失败后为不影响后续检查项重新连接cli
                if not ret[0]:
                    reConnectionCli(Cli, LOGGER)
        return funcRet
    return wrap       


def checkAllNodesInCurEngine(func, Cli, PY_JAVA_ENV, LOGGER, LANG, heartBeatCliRet, *args, **kargs):
    funcRet = []
    flag, errMsg, cliRet, currentCtrlNodeId, engineCtrlNodeMappingDict, currentEngine, _ = getEngineCtrlNodeInfo(Cli, LOGGER, LANG)
    if flag != True:
        raise UnCheckException(errMsg, heartBeatCliRet)
    curEngineNodeList = engineCtrlNodeMappingDict.get(currentEngine)
    LOGGER.logInfo("contrNodeIdList:%s" % (curEngineNodeList))
    #先执行当前节点检查
    LOGGER.logInfo("checkAllNodesInCurEngine heartBeatCliRet:%s"%heartBeatCliRet)
    funcRet = func(Cli, PY_JAVA_ENV, LOGGER, LANG, heartBeatCliRet, *args, **kargs)
    heartBeatCliRet = ""
    if funcRet == CHECK_FLAG_NOT_CONTINUE or funcRet == CHECK_FLAG_ONLY_ONE_CTRL:
        return funcRet
    curEngineNodeList.remove(currentCtrlNodeId)
    if not curEngineNodeList:
        # 退出到cli模式
        LOGGER.logInfo(
            "The current engine has no remaining nodes, exit to cli mode")
        ret = cliUtil.enterCliModeFromSomeModel(Cli, LANG)
        # 退出失败后为不影响后续检查项重新连接cli
        if not ret[0]:
            reConnectionCli(Cli, LOGGER)
        return funcRet
    for contrNodeId in curEngineNodeList:
        flag, cliRet, errMsg=heartBeatToOtherCtrl(Cli, contrNodeId, PY_JAVA_ENV, LOGGER, LANG)
        heartBeatCliRet = joinLines(heartBeatCliRet, cliRet)
        if flag != True:
            raise UnCheckException(errMsg, heartBeatCliRet)
        try:
            LOGGER.logInfo("checkAllNodesInCurEngine heartBeatCliRet:%s"%heartBeatCliRet)
            funcRet = func(Cli, PY_JAVA_ENV, LOGGER, LANG, heartBeatCliRet, *args, **kargs)
            heartBeatCliRet = ""
            if funcRet == CHECK_FLAG_NOT_CONTINUE:
                return funcRet
        except UnCheckException as unCheckException:
            LOGGER.logInfo(u"UnCheckException, errMsg: %s" % unCheckException.errorMsg)
            raise UnCheckException(errMsg, heartBeatCliRet)
        except:
            LOGGER.logInfo(str(traceback.format_exc()))
            raise UnCheckException(getMsg(LANG, "query.result.abnormal"), heartBeatCliRet)
        finally:
            cliUtil.exitHeartbeatCli(Cli, LANG)
            LOGGER.logInfo("exit heart beat success.")
            # 退出到cli模式
            ret = cliUtil.enterCliModeFromSomeModel(Cli, LANG)
            LOGGER.logInfo("enter cli mode from some model ret is %s" % str(ret))
            # 退出失败后为不影响后续检查项重新连接cli
            if not ret[0]:
                reConnectionCli(Cli, LOGGER)
    return funcRet

def checkAllEngineInClusterWarp(func):
    '''
          遍历集群中所有节点执行对应检查
         当检查函数返回CHECK_FLAG_NOT_CONTINUE时直接返回，否则继续遍历其他节点进行检查
         装饰函数出错时，抛出UnCheckException异常
        结果数据需要定义全局变量进行存储
    '''
    def wrap(Cli, PY_JAVA_ENV, LOGGER, LANG, heartBeatCliRet, *args, **kargs):
        heartBeatCliRet = ""
        jumpConnCli = ""
        # 获取引擎列表
        falg, errMsg, cliRet, currentNodeId, engineCtrlNodeMappingDict, currentEngine, nodeNum = getEngineCtrlNodeInfo(Cli, LOGGER, LANG)
        heartBeatCliRet = joinLines(heartBeatCliRet, cliRet)
        if falg != True:
            LOGGER.logSysAbnormal()
            raise UnCheckException(errMsg, heartBeatCliRet)
        engineList = engineCtrlNodeMappingDict.keys()
        LOGGER.logInfo("engineList:%s" % (engineList))
        #先检查当前连接引擎
        funcRet = checkAllNodesInCurEngine(func, Cli, PY_JAVA_ENV, LOGGER, LANG, heartBeatCliRet, *args, **kargs)
        heartBeatCliRet = ""
        if funcRet == CHECK_FLAG_NOT_CONTINUE:
            return funcRet
        engineList.remove(currentEngine)
        closeHeartBeatTimes = 0
        for targetEngineID in engineList:
            flag, cliRet, errMsg, jumpConnCli, closeHeartBeatTimes= enginesJump(Cli, targetEngineID, currentEngine, currentNodeId, nodeNum, PY_JAVA_ENV, LOGGER, LANG, engineCtrlNodeMappingDict)
            heartBeatCliRet = joinLines(heartBeatCliRet, cliRet)
            if flag != True:
                raise UnCheckException(errMsg, heartBeatCliRet)
            try:
                LOGGER.logInfo("Jump to Engine %s success" % (targetEngineID))
                funcRet = checkAllNodesInCurEngine(func, jumpConnCli, PY_JAVA_ENV, LOGGER, LANG, heartBeatCliRet, *args, **kargs)
                if funcRet == CHECK_FLAG_NOT_CONTINUE:
                    return funcRet
            except UnCheckException as unCheckException:
                LOGGER.logInfo(u"UnCheckException, errMsg: %s" % unCheckException.errorMsg)
                raise UnCheckException(unCheckException.errorMsg, heartBeatCliRet)
            except:
                LOGGER.logInfo(str(traceback.format_exc()))
                raise UnCheckException(getMsg(LANG, "query.result.abnormal"), heartBeatCliRet)
            finally:
                LOGGER.logInfo("Engines back success.closeHeartBeatTimes:%d" % closeHeartBeatTimes)
                enginesBack(jumpConnCli, PY_JAVA_ENV, LOGGER, LANG, closeHeartBeatTimes)
                LOGGER.logInfo("Engines back success.")
                # 退出到cli模式
                ret = cliUtil.enterCliModeFromSomeModel(Cli, LANG)
                LOGGER.logInfo("enter cli mode from some model ret is %s" % str(ret))
                # 退出失败后为不影响后续检查项重新连接cli
                if not ret[0]:
                    reConnectionCli(Cli, LOGGER)
        return funcRet
    return wrap


def enterVstoreMode(cli, vstoreId, vstoreName, lang, LOGGER, ):
    '''
    进入vstoreId的租户模式
    :param cli:
    :param vstoreId:
    :param lang:
    :param vstoreName:用来判断是否进入了对应的租户模式
    :return:
    '''
    cliRet = ""
    try:
        cmd = "change vstore view id=%s" % vstoreId
        flag, cliRet, errMsg = cliUtil.excuteCmdCommon(cli, cmd, lang)
        if flag != True:
            return (False, cliRet, errMsg)
        if isInVstoreMode(cliRet, vstoreName):
            return (True, cliRet, "")
        else:
            return (False, cliRet, getMsg(lang, "enter.vstore.mode.fail", vstoreId))
    except:
        LOGGER.logInfo(str(traceback.format_exc()))
        return (False, cliRet, getMsg(lang, "enter.vstore.mode.fail", vstoreId))


def isInVstoreMode(cliRet, vstoreName):
    '''
    根据回显判断是否在vstoreName租户模式下
    :param cli:
    :param vstoreId:
    :param vstoreName:
    :return:
    '''
    if re.search("@%s" % vstoreName, cliRet, re.IGNORECASE):
        return True
    return False


def exitVstoreMode(cli, lang, LOGGER, vstoreName):
    '''
    退出vstoreId租户模式到CLI模式
    :param cli:
    :param vstoreId:
    :param vstoreName:
    :return:
    '''
    allCliRet = ""
    try:
        flag, cliRet, errMsg = cliUtil.excuteCmdCommon(cli, "show system general", lang)
        if flag == False:
            return (False, allCliRet, errMsg)
        if isInVstoreMode(cliRet, vstoreName):
            flag, cliRet, errMsg = cliUtil.excuteCmdCommon(cli, "exit", lang)
            allCliRet = joinLines(allCliRet, cliRet)
            if flag == False:
                return (False, allCliRet, errMsg)
        if isInVstoreMode(cliRet, vstoreName):
            return (False, allCliRet, errMsg)
        return (True, allCliRet, "")
    except:
        LOGGER.logInfo(str(traceback.format_exc()))
        return (False, allCliRet, getMsg(lang, "exit.vstore.mode.fail", vstoreName))


def getVstoreNameById(cli, vstoreId, LANG):
    '''
    获取租户名称
    :param cli:
    :param vstoreId:
    :return:
    '''
    vstoreName = ""
    cmd = "show vstore id=%s" % vstoreId
    flag, cliRet, errMsg = cliUtil.excuteCmdInCliMode(cli, cmd, True, LANG)
    if flag != True:
        return (flag, vstoreName, cliRet, errMsg)
    vstoreInfoDictList = cliUtil.getVerticalCliRet(cliRet)
    if len(vstoreInfoDictList) == 0:
        return (False, vstoreName, cliRet, getMsg(LANG, "get.vstore.name.fail", vstoreId))
    vstoreInfoDict = vstoreInfoDictList[0]
    vstoreName = vstoreInfoDict.get("Name", "")
    if len(vstoreName) == 0:
        return (False, vstoreName, cliRet, getMsg(LANG, "get.vstore.name.fail", vstoreId))
    return (True, vstoreName, cliRet, "")


def checkInVstoreModeWrap(func):
    '''
          进入vstoreId租户执行检查
    '''

    def wrap(cli, LOGGER, LANG, enterVstoreModeCliRet, vstoreId, *args, **kargs):
        enterVstoreModeCliRet = ""
        exitVstoreModeCliRet= ""
        #获取Vstore Name
        flag, vstoreName, cliRet, errMsg = getVstoreNameById(cli, vstoreId, LANG)
        if flag != True:
            raise UnCheckException(errMsg, enterVstoreModeCliRet)
        try:
            flag, cliRet, errMsg = enterVstoreMode(cli, vstoreId, vstoreName, LANG, LOGGER, )
            enterVstoreModeCliRet = joinLines(enterVstoreModeCliRet, cliRet)
            if flag != True:
                raise UnCheckException(errMsg, enterVstoreModeCliRet)
            funcRet = func(cli, LOGGER, LANG, enterVstoreModeCliRet,vstoreId)
            _, cliRet, _ = exitVstoreMode(cli, LANG, LOGGER, vstoreName)
            exitVstoreModeCliRet = joinLines(exitVstoreModeCliRet, cliRet)
            return funcRet, exitVstoreModeCliRet
        except UnCheckException as unCheckException:
            LOGGER.logInfo(u"UnCheckException, errMsg: %s" % unCheckException.errorMsg)
            raise UnCheckException(unCheckException.errorMsg, enterVstoreModeCliRet)
        except:
            LOGGER.logInfo(str(traceback.format_exc()))
            raise UnCheckException(getMsg(LANG, "query.result.abnormal"), enterVstoreModeCliRet)
        finally:
            flag, cliRet, errMsg = exitVstoreMode(cli, LANG, LOGGER, vstoreName)
            LOGGER.logInfo("exit vstore mode success.")
            # 退出到cli模式
            ret = cliUtil.enterCliModeFromSomeModel(cli, LANG)
            LOGGER.logInfo("enter cli mode from some model ret is %s" % str(ret))
            # 退出失败后为不影响后续检查项重新连接cli
            if not ret[0]:
                reConnectionCli(cli, LOGGER)

    return wrap


def getConnectionByControllerIp(javaEnv, cli, logger):
    """
    @summary: 建立到阵列控制器的SSH连接，只有登录控制器的连接才能进入debug，minisystem模式
    """
    currentContrIp = javaEnv.get("devInfo").getIp()
    lang = javaEnv.get("lang")
    connIp = currentContrIp

    flag, cliRet, errMsg, ipListDict = getContrIpListOfEngine(cli, lang)
    logger.logInfo(
        'controller management ip list in the engine is %s' % str(ipListDict))
    if not flag:
        return False, cliRet, errMsg, cli, connIp

    ipListList = ipListDict.values()
    for ipList in ipListList:
        if currentContrIp in ipList:
            # 当前连接就是与控制器的连接（18000设备跳过SVP，PC直接连接控制器）
            logger.logInfo(
                'the current ip(%s) is controller management ip.' % str(
                    currentContrIp))
            return True, cliRet, "", cli, connIp

    for engine in ipListDict:
        ipList = ipListDict.get(engine)
        for ip in ipList:
            cilConnection = getCilConnectionByIp(ip, javaEnv, logger)
            if cilConnection:
                connIp = ip
                logger.logInfo('Success to connect to controller(IP:%s)' % ip)
                return True, cliRet, "", cilConnection, connIp
            else:
                logger.logInfo('Failed to connect to controller(IP:%s)' % ip)
    # 连接控制器失败。
    errMsg = getMsg(lang, "connect.to.controller.failed")
    return False, cliRet, errMsg, cli, connIp


def get_sn_from_env(py_java_env):
    """
    获取SN
    :param py_java_env:
    :return:
    """
    return py_java_env.get("devInfo").getDeviceSerialNumber()


def get_all_lun_detail_info_with_cache(cli, lun_id_list, py_java_env,
                                       py_logger, step_process=None,
                                       cur_process=None):
    """
    从缓存中获取信息
    :param cli:
    :param lun_id_list:
    :param py_java_env:
    :param py_logger:
    :param step_process:
    :param cur_process:
    :return:
    """
    all_lun_info_dict_list = []
    all_cli_ret_list = []
    current_process = cur_process
    tmp_process = 0
    for lun_id in lun_id_list:
        cmd = 'show lun general lun_id=%s' % lun_id

        flag, cli_ret, err_msg = execute_cmd_in_cli_mode_with_cache(
            py_java_env, cli, cmd, py_logger)

        all_cli_ret_list.append(cli_ret)

        if flag is not True:
            raise UnCheckException(err_msg, "\n".join(all_cli_ret_list))

        lun_info_dict_list = cliUtil.getVerticalCliRet(cli_ret)
        for lun_info_dict in lun_info_dict_list:
            all_lun_info_dict_list.append(lun_info_dict)

        if step_process is not None and cur_process is not None:
            tmp_process += step_process
            current_process += step_process

            if tmp_process < 1:
                continue

            tmp_process -= 1
            refreshProcess(py_java_env, current_process, py_logger)

    return all_lun_info_dict_list, all_cli_ret_list


def get_all_lun_info_with_cache(py_java_env, cli, py_logger):
    """
    获取show lun general的lun信息
    :param py_java_env:
    :param cli:
    :param py_logger:
    :return:
    """
    cmd = "show lun general"

    flag, cli_ret, err_msg = execute_cmd_in_cli_mode_with_cache(
        py_java_env, cli, cmd, py_logger)

    if flag is not True:
        raise UnCheckException(err_msg, cli_ret)

    if cliUtil.queryResultWithNoRecord(cli_ret):
        return [], cli_ret

    lun_info_dict_list = cliUtil.getHorizontalNostandardCliRet(cli_ret)

    return lun_info_dict_list, cli_ret


def exp_evaluate_by_rest(py_java_env, evaluate_param, logger, shield_err_code_list=list()):
    """调用TLV接口 执行硬盘域扩容评估

    :param py_java_env: 变量上下文
    :param evaluate_param: 扩容评估入参
    :param logger: 日志句柄
    :param shield_err_code_list: 屏蔽错误码列表
    :return:
    """
    ret = ""
    try:
        flag = True
        err_msg = []
        context = py_java_env.get("context")
        lang = getLang(py_java_env)
        ret += restData.RestCfg.OBJ.EXPANSION_EVAL
        uri_param_dict = restUtil.CommonRest.getUriParamDict(
            restData.RestCfg.OBJ.EXPANSION_EVAL)
        rest = contextUtil.getRest(context)
        param, pool_id = get_exp_dd_param(evaluate_param)
        logger.logInfo("params:" + str(param))
        ret_obj = restUtil.CommonRest.execCmd(
            rest, uri_param_dict, param,
            restData.RestCfg.RestMethod.POST, 120, True)
        ret += ":\nRequest Param:{}\nResponseInfo: {}".format(
            str(param), str(ret_obj))
        ret_data = ret_obj.get("data")
        if ret_data:
            ret_code_str = ret_data[0].get("expandEvaluationRet")
            # 某些场景需屏蔽部分错误码
            if ret_code_str in shield_err_code_list:
                return True, "", ret
            ret_data_str = ret_data[0].get("expandExpansionDataList")
            if ret_code_str != "0":
                flag = False
                err_msg = get_error_info(
                    lang, ret_code_str, ret_data_str, pool_id)

        return flag, err_msg, ret
    except Exception as ex:
        logger.logInfo("exp_evaluate_by_rest Exception:{}".format(traceback.format_exc()))
        if ex.args[0] == "1077949002":
            # 命令不支持 兼容TR5版本（6.0.RC1） 返回成功
            return True, [], ret
        else:
            raise ex


def get_exp_dd_param(evaluate_param):
    pool_id = str(evaluate_param.get("poolId"))
    param = {}
    default_list = ['0']
    param["ID"] = evaluate_param.get("diskDomainId")
    param["diskNumList"] = evaluate_param.get(
        "diskNumList") if evaluate_param.get("diskNumList") else default_list
    param["diskCapacityList"] = evaluate_param.get(
        "diskCapacityList") if evaluate_param.get(
        "diskCapacityList") else default_list
    # SSD类型的硬盘
    if evaluate_param.get("diskNumList") and evaluate_param.get(
            "tier0DiskType"):
        param["diskNumList"] = evaluate_param.get("diskNumList", default_list)
        param["diskCapacityList"] = evaluate_param.get(
            "diskCapacityList", default_list)
        param["TIER0DISKTYPE"] = evaluate_param.get("tier0DiskType")[0]
    # HDD类型的硬盘
    if evaluate_param.get("nlsasDiskNumList") and evaluate_param.get(
            "tier2DiskType"):
        param["nlsasDiskNumList"] = evaluate_param.get("nlsasDiskNumList",
                                                       default_list)
        param["nlsasdiskCapacityList"] = evaluate_param.get(
            "nlsasdiskCapacityList", default_list)
        param["TIER2DISKTYPE"] = evaluate_param.get("tier2DiskType")[0]
    param["ENGINEIDLIST"] = evaluate_param.get("engineIdList", ["CTE0"])
    param["frameLevelCheck"] = "0"
    if len(evaluate_param.get("diskEnclosureId", [])) > 0:
        param["frameLevelCheck"] = "1"
        param["frameIdList"] = evaluate_param.get("diskEnclosureId", [])
    if EMPTY_POOL_FLAG in param.get("diskNumList", []) or \
            EMPTY_POOL_FLAG in param.get("nlsasDiskNumList", []):
        param = {}
        param["SSDDISKNUM"] = EMPTY_POOL_FLAG
        param["ID"] = evaluate_param.get("diskDomainId")
        param["ENGINEIDLIST"] = evaluate_param.get("engineIdList", ["CTE0"])
    # 框级冗余，同时扩存储池和性能层，需要下发性能层盘数据
    if evaluate_param.get("performanceLayerId"):
        param["performanceLayerDiskType"] = evaluate_param.get("performanceLayerDiskType")
        param["performanceLayerDiskCapList"] = evaluate_param.get("performanceLayerDiskCapList")
        param["performanceLayerDiskNumList"] = evaluate_param.get("performanceLayerDiskNumList")
        param["performanceLayerId"] = evaluate_param.get("performanceLayerId")
        param["performanceLayerFrameId"] = evaluate_param.get("performanceLayerFrameId")
        param["performanceLayerEngineIdList"] = evaluate_param.get("performanceLayerEngineIdList")


    return param, pool_id


def exp_performance_layer_evaluate_by_rest(py_java_env, evaluate_param, logger):
    """
    性能层评估
    :param py_java_env: 变量上下文
    :param evaluate_param: 扩容评估入参
    :param logger: 日志句柄
    :return:
    """
    ret = ""
    try:
        flag = True
        err_msg = []
        context = py_java_env.get("context")
        lang = getLang(py_java_env)
        uri_param_dict = restUtil.CommonRest.getUriParamDict(
            restData.RestCfg.OBJ.PERFORMANCE_LAYER_EXPANSION_EVAL)
        ret += restData.RestCfg.OBJ.PERFORMANCE_LAYER_EXPANSION_EVAL
        rest = contextUtil.getRest(context)
        logger.logInfo("params:" + str(evaluate_param))
        ret_obj = restUtil.CommonRest.execCmd(
            rest, uri_param_dict, evaluate_param,
            restData.RestCfg.RestMethod.POST, 120, True)
        ret += ":\nRequest Param:{}\nResponseInfo: {}".format(
            str(evaluate_param), str(ret_obj))
        ret_data = ret_obj.get("data")
        if ret_data:
            ret_code_str = ret_data[0].get("expandEvaluationRet")
            ret_data_str = ret_data[0].get("expandExpansionDataList")
            if ret_code_str != "0":
                flag = False
                err_msg = get_error_info(
                    lang, ret_code_str, ret_data_str, evaluate_param.get("id"))

        return flag, err_msg, ret
    except Exception as ex:
        logger.logInfo("exp_evaluate_by_rest Exception:{}".format(traceback.format_exc()))
        if ex.args[0] == "1077949002":
            # 命令不支持 兼容TR5版本（6.0.RC1） 返回成功
            return True, [], ret
        else:
            raise ex


def get_error_info(lang, error_code_str, error_data_str, pool_id):
    """获取错误消息

    :param lang: 语言
    :param error_code_str: 错误编码字符串 以逗号分隔 例如：1073809960,1073809963
    :param error_data_str: 错误信息中需要替换的数据 以逗号分隔
    :param pool_id: 存储池ID
    :return: 错误消息列表
    """

    err_msg_list = []
    # 参数校验
    if not error_code_str:
        return ["--"]

    error_codes = error_code_str.split(",")
    error_data_list = error_data_str.split(",")
    for error_code in error_codes:
        error_code = error_code.strip()
        code_err_msg = get_error_info_by_code(
            lang, error_code, error_data_list, pool_id)
        err_msg_list.append(code_err_msg)
        err_msg_list.append(os.linesep)

    return err_msg_list


def get_error_info_by_code(lang, error_code, error_data_list, pool_id):
    """根据错误编码获取错误消息

    :param lang: 语言
    :param error_code: 错误编码
    :param error_data_list: 错误数据列表
    :param pool_id: 存储池ID
    :return:
    """

    ERROR_CODE_AND_PARA_NUM_MAP = {
        # 当前硬盘配置已经达到系统最大规格
        "1073809960": 1,
        # 总容量超过系统容量规格
        "1073810027": 2,
        # 存储池个数已达到最大规格
        "1073809993": 1,
        # 存储池最多支持x种不同硬盘容量类型
        "1073809959": 1,
        # 存储池可用容量之和超过可得容量规格
        "1073810066": 1,
        # 框级冗余检查下，硬盘框容量点盘数小于系统规格
        "1073810079": 0,
        # 框级冗余检查下，选择的硬盘框不是第一级硬盘框
        "1073810085": 0,
        # 框级冗余检查下，选择的硬盘框不满足正反接组网
        "1073810083": 0,
        # 框级冗余检查下，硬盘框之间硬盘类型、个数、容量大小不一致
        "1073810081": 0,
        # 框级冗余检查下，硬盘框存在组网错误
        "1073810084": 0,
        # 硬盘可用物理容量小于对应硬盘可用物理容量
        "1073810117": 3,
        # 创建存储池时，或者存储池扩盘时，由于指定的性能层配额不满足存储池需要的最小配额，操作失败。
        "1073810148": 2,
        # 指定ID创建对象的时候，ID超过系统最大规格。
        "1077949099": 0,
        # 指定的硬盘类型不支持创建硬盘域或扩容。
        "1077953174": 0,
        # 单个控制框上选择的硬盘数不能小于最低规格
        "1073810133": 1,
        # 当前控制框上的性能层个数已达到最大规格
        "1073810138": 1,
        # 选取的硬盘(类型：##00)不支持在硬盘域内使用。
        "1073810124": 1,
        # 该类型(##00)的硬盘数量达到单控制框所支持的最大个数(##01)。
        "1073810094": 2,
        # 硬盘域内每种类型的硬盘数不能小于系统规格(##00)。
        "1073810095": 1,
        # 硬盘域内某种类型的硬盘数小于系统规格下限(类型：##00，数量：##01)。
        "1073810114": 2,
        # 系统内成员盘总物理容量（##00）大于系统许可容量（##01）。
        "1073810118": 2,
        # 该控制框(名称：##00)上指定硬盘类型(##01)的硬盘数不足，无法创建指定热备硬盘数(##02)的性能层，还需要更多硬盘(数量：##03)才能创建成功。
        "1073810143": 4,
        # 控制框数量超过单个硬盘域支持的最大规格（%s个）。
        "1073810090": 1,
        # 控制框数量超过单个性能层支持的最大规格（%s个）。
        "1073810165": 1,
        # 硬盘域内某种类型硬盘的容量类型个数大于系统最高要求（类型：%s，数量：%s）。
        "1073810126": 2,
        # 硬盘域成员盘个数大于最大成员盘数（%s）
        "1073810163": 1,
        # 性能层分布硬盘框和容量层分布硬盘框重叠时，其中一层分布的硬盘框必须是另一层分布硬盘框的子集。
        "1073797227": 0
    }

    err_msg = ""
    no_pool_id_code_list = ["1073810148", "1073809960", "1073810163"]
    # 1073809960 这个错误码不需要替换存储池ID，其他错误码都需要替换
    if error_code in no_pool_id_code_list:
        err_msg_args = []
    else:
        err_msg_args = [pool_id]
    # 其他需要替换的数量
    error_args_number = ERROR_CODE_AND_PARA_NUM_MAP.get(error_code, None)
    if error_args_number and error_args_number <= len(error_data_list):
        for i in range(error_args_number):
            param = error_data_list.pop(0).strip()
            err_msg_args.append(param)
    elif error_args_number and error_args_number > len(error_data_list):
        err_msg = "not enough args for error code: %s" % error_code
        return err_msg

    return get_err_msg(err_msg_args, error_code, lang)


def get_err_msg(err_msg_args, error_code, lang):
    # 获取错误消息
    error_msg_key = "exp.storage.pool.error.code." + error_code
    err_msg = getMsg(lang, error_msg_key, tuple(err_msg_args))
    # 存储池参数影响，可能导致多加一个pool的参数，需去除。
    if "--" in err_msg:
        err_msg_args.pop(0)
        err_msg = getMsg(lang, error_msg_key, tuple(err_msg_args))
    # 未获取到错误信息
    if "--" in err_msg:
        error_msg_key = "exp.storage.pool.error.code.unknown"
        err_msg = getMsg(lang, error_msg_key, error_code)
    return err_msg


def version_no_support_msg_str(product_model, current_version, risky_model,
                               risky_version, lang):
    """
    使用在由于版本不在风险版本范围内是，生成原始信息
    根据设备的型号和版本，风险型号和版本，生成对应的原始信息
    使用与风险版本为文字描述的场景
    :param product_model: 设备型号
    :param current_version: 设备版本
    :param risky_model: 风险型号
    :param risky_version: 风险版本
    :return:
    """
    all_msg = getMsg(lang, "msg.not.risky.msg")
    period = getMsg(lang, "msg.period")
    if product_model:
        all_msg = all_msg + getMsg(lang, "msg.dev.product.model") \
                  + product_model + period
    if current_version:
        all_msg = all_msg + getMsg(lang, "msg.current.version") \
                  + current_version + period
    if risky_model:
        all_msg = all_msg + getMsg(lang, "msg.risk.model") \
                  + risky_model + period
    if risky_version:
        all_msg = all_msg + getMsg(lang, "msg.risky.version") \
                  + risky_version + period

    return all_msg


def version_no_support_msg(product_model, current_version, risky_model,
                           risky_version, lang):
    """
    使用在由于版本不在风险版本范围内是，生成原始信息
    根据设备的型号和版本，风险型号和版本，生成对应的原始信息
    适用于风险版本为具体列表的场景
    :param product_model: 设备型号
    :param current_version: 设备版本
    :param risky_model: 风险型号
    :param risky_version: 风险版本
    :return:
    """
    comma = getMsg(lang, "msg.comma")
    risky_model_str = comma.join(risky_model)
    risky_version_str = comma.join(risky_version)
    return version_no_support_msg_str(product_model, current_version,
                                      risky_model_str,
                                      risky_version_str, lang)


def get_product_key(product_model, current_version):
    """
    判断设备是Dorado，还是V3，V5
    :param product_model: 设备版本
    :param current_version: 设备型号
    :return:
    """
    if product_model in config.DORADO_DEVS:
        return "dorado"
    if current_version.startswith("V3"):
        return "V3"
    if current_version.startswith("V5"):
        return "V5"
    return ""


def get_product_key_by_version(current_version):
    """
    判断设备是V3，还是V5
    :param current_version: 设备型号
    :return:
    """
    if current_version.startswith("V3"):
        return "V3"
    if current_version.startswith("V5"):
        return "V5"
    return ""


def get_soft_and_patch_version(cli, LOGGER, LANG):
    """
    获取阵列版本和热补丁版本
    :return: flag 阵列版本，热补丁版本，回显，错误提示
    """
    (ver_flag, cliRet, err_msg), software_version_list, \
        hot_patch_version_list = parse_upgradePackage(cli, LANG)

    if ver_flag is not True:
        LOGGER.logSysAbnormal()
        LOGGER.logInfo(
            "get package info fail! software_version_list:%s,"
            " hot_patch_version_list%s" %
            (software_version_list, hot_patch_version_list))
        return cliUtil.RESULT_NOCHECK, '', '', cliRet, err_msg

    flag, soft_version, err_msg = getCurrentVersion(
        software_version_list,
        LANG)
    if flag is not True:
        LOGGER.logInfo(
            "get current product version error. "
            "err_msg: %s" % err_msg)
        return cliUtil.RESULT_NOCHECK, '', '', cliRet, err_msg

    flag, patch_version, err_msg = getHotPatchVersion(
        hot_patch_version_list,
        LANG)
    if flag is not True:
        LOGGER.logInfo("get hotPatchVersion error. "
                       "err_msg: %s" % err_msg)
        return cliUtil.RESULT_NOCHECK, '', '', cliRet, err_msg

    return True, soft_version, patch_version, cliRet, err_msg


def get_engine_node_id_list(cli, PY_JAVA_ENV, LOGGER):
    '''
    @summary: 获取当前引擎的全部健康节点信息，当前节点信息。
    @param cli: cli连接
    @param PY_JAVA_ENV 上下文
    @param LOGGER 日志
    @return: current_engine_ctrl_id_list)
        current_engine_ctrl_id_list: 当前引擎的全部健康节点信息
    '''
    # 获取当前节点信息，当前引擎的全部节点信息。
    cmd = 'sys showcls'
    # 当前节点
    current_engine_ctrl_id_list = []
    flag, cliRet, errMsg = executeDebugCommand(cli, cmd, PY_JAVA_ENV, LOGGER)
    if flag is not True:
        LOGGER.logInfo("get node info Failed. errMsg: %s" % errMsg)
        return False, current_engine_ctrl_id_list

    engineInfoDictList = cliUtil.getHorizontalNostandardCliRet(cliRet)

    for engineInfo in engineInfoDictList:
        ctrlNodeId = engineInfo.get("id", "")
        if ctrlNodeId == "":
            continue
        current_engine_ctrl_id_list.append(ctrlNodeId)
    return True, current_engine_ctrl_id_list


def is_expansion_disk_or_ctrl_scene(py_java_env):
    """
    :param py_java_env: 上下文
    :return: 是否是扩容控制器和硬盘，硬盘域，硬盘框场景
    """
    scene_data = py_java_env.get("sceneData")
    if not scene_data:
        return False

    return all(
        [
            scene_data.get("mainScene") == "Expansion",
            scene_data.get("toolScene") == "perInspector",
            any(
                [
                    scene_data.get("subScene") == "Expansion Controller",
                    py_java_env.get("expMode") == "EXTEND_CTRL",
                    scene_data.get("subScene") == "Expansion Disk",
                    py_java_env.get("expMode") == "EXTEND_DISK",
                ]
            ),
        ]
    )


def is_support_data_protect_check(py_java_env, cli):
    """
    判断设备是否支持数据保护检查（含备份引擎告警检查）
    支持设备：
        1、含CloudBackup特性（A8000原生自带）
        2、Dorado 6.1.5防勒索设备
        3、X8000 支持容器服务特性设备

    :param py_java_env: 上下文
    :param cli: 设备连接
    :return: 是否支持数据保护检查
    """
    dev_node = py_java_env.get('devInfo')
    if "OceanProtect A8000" == str(dev_node.getDeviceType()):
        return True, ""

    from com.huawei.ism.tool.devicemanager.utils import LicenseFeatureQueryUtil
    if LicenseFeatureQueryUtil.hasHyperDetectFeature(dev_node)\
            or LicenseFeatureQueryUtil.hasDataBackupFeature(dev_node):
        return LicenseFeatureQueryUtil.isContainerAppDeployed(cli), ""

    state = LicenseFeatureQueryUtil.queryCloudBackupState(dev_node)
    if not state:
        return False, ""
    if state == QUERY_CLOUDBACKUP_ERROR_STATE:
        return False, getMsg(getLang(py_java_env), "query.cloudbackup.fail")
    return LicenseFeatureQueryUtil.isContainerAppDeployed(cli), ""

def has_data_backup_and_support_data_protect(py_java_env, cli):
    """
    判断设备是否开启备份特性，支持数据保护检查
    :param py_java_env: 上下文
    :param cli: 设备连接
    :return: 是否为开启备份特性的X8000设备且支持数据保护检查
    """
    from com.huawei.ism.tool.devicemanager.utils import LicenseFeatureQueryUtil
    return LicenseFeatureQueryUtil.hasDataBackupFeature(py_java_env.get('devInfo')) \
           and LicenseFeatureQueryUtil.isContainerAppDeployed(cli)


def is_need_change_devnode_ip(cli, LOGGER, LANG):
    """
    判断设备登录IP是否在0,1号引擎

    :param cli: 设备连接
    :param LOGGER: 脚本日志
    :param LANG: 语言
    :return:
    """
    # 命令和数据格式：sys showcls {id: engine id}, [id]
    ctrl_engine_dict, node_list = get_node_engine_info(cli, LOGGER, LANG)
    # 当前登录nodeID
    flag, ret, current_id = getCurrentNodeId(cli, LANG)
    #返回cli模式
    cliUtil.enterCliModeFromSomeModel(cli, LANG)
    # 命令和数据格式：show upgrade package {0: [ips], 1: [ips]}
    engine_ips_dict = getEngineIps(cli, LANG)[0]
    if len(engine_ips_dict) > 2 and ctrl_engine_dict.get(current_id) not in (0, 1):
        return True, engine_ips_dict
    return False, {}


def check_holding_fcv_connection(inspect_context):
    dev = inspect_context.get('devInfo')
    return dev and dev.getComputeStorageDevNode()
