#!/usr/bin/python
# -*- coding: UTF-8 -*-

from memory_inspect.address_decodes import forwardRankAddrTranslator, connect
from memory_inspect.utils.six_about import to_hex_str, to_int


# 输入的 channelAddr 为整形变量
# page_mode 的值会对结果造成影响
# NUME: Disable - - socket交织, Enable - - socket不交织


def RIR_2_16G_1P(socket_id, imc_id, channel_id, channelAddr, page_mode, nume_mode):
    shift = 0
    rirWays = 0
    rirOffset = 0
    Chip_select = 0
    rir_rnk_tgt0 = {}
    base_temp = ''

    if nume_mode == 'Disable':
        # 配置信息 1.
        rir_rnk_tgt0 = {0: 0, 1: 1}

        rirWays_temp = connect.select(
            "select _RIR_WAYS from PURPLE_RIR_1P where _CONFIG = '2_16G' and "
            "_INFO = '%s_%s' and _CHANNEL_NO = '%s'" % (socket_id, imc_id, channel_id)
        )
        rirOffset_temp = connect.select(
            "select _RIR_OFFSET from PURPLE_RIR_1P where _CONFIG = '2_16G' "
            "and _INFO = '%s_%s' and _CHANNEL_NO = '%s'" % (socket_id, imc_id, channel_id)
        )
        rirWays = ''.join(rirWays_temp)
        rirOffset = ''.join(rirOffset_temp)

        base_temp = connect.select(
            "select _BASE, _LIMIT from PURPLE_RIR_1P where _CONFIG = '2_16G' "
            "and _INFO = '%s_%s' and _CHANNEL_NO = '%s'" % (socket_id, imc_id, channel_id)
        )

        shift = 6 if (page_mode == 'Closed') else 13

    if to_int(base_temp[0]) <= channelAddr <= to_int(base_temp[1]):

        rankAddr = channelAddr >> shift
        rankAddr = rankAddr // int(rirWays)
        rankAddr = rankAddr << shift  # rankAddr = ((channelAddr >> shift) // int(rirWays)) << shift
        rankAddr = (rankAddr | channelAddr & (2 ** shift - 1)) - to_int(rirOffset)
        rank_address_result = '0x{:012x}'.format(rankAddr)

        rankInterleaveIndex = (channelAddr >> shift) % int(rirWays)

        for key in rir_rnk_tgt0.keys():
            if key == rankInterleaveIndex:
                Chip_select = rir_rnk_tgt0[key]

        dimm = Chip_select >> 2
        rank = Chip_select % 4

        #   求出的rank_address_result  为字符串类型，如果要传入 bank_translator 求取 bank等信息需要先转化为 整形变量
        rank_address_input = to_int(rank_address_result)
        result_bank_translator = forwardRankAddrTranslator.Translator1_ddr4(rank_address_input, page_mode)

        result = str(dimm) + "," + str(rank) + "," + result_bank_translator + "," + str(
            Chip_select) + "," + rank_address_result

        return result


def RIR_2_32G_1P(socket_id, imc_id, channel_id, channelAddr, page_mode, nume_mode):
    shift = 0
    rirWays = 0
    rirOffset = 0
    Chip_select = 0
    rir_rnk_tgt0 = {}
    base_temp = ''

    if nume_mode == 'Disable':  # 4*32G  socket交织

        # 配置信息 1.
        rir_rnk_tgt0 = {0: 0, 1: 1}

        rirWays_temp = connect.select(
            "select _RIR_WAYS from PURPLE_RIR_1P where _CONFIG = '2_32G' "
            "and _INFO = '%s_%s' and _CHANNEL_NO = '%s'" % (socket_id, imc_id, channel_id))
        rirOffset_temp = connect.select(
            "select _RIR_OFFSET from PURPLE_RIR_1P where _CONFIG = '2_32G' "
            "and _INFO = '%s_%s' and _CHANNEL_NO = '%s'" % (socket_id, imc_id, channel_id)
        )
        rirWays = ''.join(rirWays_temp)
        rirOffset = ''.join(rirOffset_temp)

        base_temp = connect.select(
            "select _BASE, _LIMIT from PURPLE_RIR_1P where _CONFIG = '2_32G' "
            "and _INFO = '%s_%s' and _CHANNEL_NO = '%s'" % (socket_id, imc_id, channel_id)
        )

        shift = 6 if (page_mode == 'Closed') else 13

    if nume_mode == 'Enable':  # 4*32G socket不交织
        pass

    if to_int(base_temp[0]) <= channelAddr <= to_int(base_temp[1]):

        rankAddr = channelAddr >> shift
        rankAddr = rankAddr // int(rirWays)
        rankAddr = rankAddr << shift  # rankAddr = ((channelAddr >> shift) // int(rirWays)) << shift
        rankAddr = (rankAddr | channelAddr & (2 ** shift - 1)) - to_int(rirOffset)
        rank_address_result = '0x{:012x}'.format(rankAddr)

        rankInterleaveIndex = (channelAddr >> shift) % int(rirWays)

        for key in rir_rnk_tgt0.keys():
            if key == rankInterleaveIndex:
                Chip_select = rir_rnk_tgt0[key]

        dimm = Chip_select >> 2
        rank = Chip_select % 4

        #   求出的rank_address_result  为字符串类型，如果要传入 bank_translator 求取 bank等信息需要先转化为 整形变量
        rank_address_input = to_int(rank_address_result)
        result_bank_translator = forwardRankAddrTranslator.Translator2_ddr4(rank_address_input, page_mode)

        result = str(dimm) + "," + str(rank) + "," + result_bank_translator + "," + str(
            Chip_select) + "," + rank_address_result

        return result


def RIR_3_16G_1P(socket_id, imc_id, channel_id, channelAddr, page_mode, nume_mode):
    shift = 0
    rirWays = 0
    rirOffset = 0
    Chip_select = 0
    rir_rnk_tgt0 = {}
    base_temp = ''

    if nume_mode == 'Disable':  # 4*32G  socket交织

        # 配置信息 1.
        rir_rnk_tgt0 = {0: 0, 1: 1}

        rirWays_temp = connect.select(
            "select _RIR_WAYS from PURPLE_RIR_1P where _CONFIG = '3_16G' "
            "and _INFO = '%s_%s' and _CHANNEL_NO = '%s'" % (socket_id, imc_id, channel_id)
        )
        rirOffset_temp = connect.select(
            "select _RIR_OFFSET from PURPLE_RIR_1P where _CONFIG = '3_16G' "
            "and _INFO = '%s_%s' and _CHANNEL_NO = '%s'" % (socket_id, imc_id, channel_id)
        )
        rirWays = ''.join(rirWays_temp)
        rirOffset = ''.join(rirOffset_temp)

        base_temp = connect.select(
            "select _BASE, _LIMIT from PURPLE_RIR_1P where _CONFIG = '3_16G' "
            "and _INFO = '%s_%s' and _CHANNEL_NO = '%s'" % (socket_id, imc_id, channel_id)
        )

        shift = 6 if (page_mode == 'Closed') else 13

    if nume_mode == 'Enable':  # 4*32G socket不交织
        pass

    if to_int(base_temp[0]) <= channelAddr <= to_int(base_temp[1]):

        rankAddr = channelAddr >> shift
        rankAddr = rankAddr // int(rirWays)
        rankAddr = rankAddr << shift  # rankAddr = ((channelAddr >> shift) // int(rirWays)) << shift
        rankAddr = (rankAddr | channelAddr & (2 ** shift - 1)) - to_int(rirOffset)
        rank_address_result = '0x{:012x}'.format(rankAddr)

        rankInterleaveIndex = (channelAddr >> shift) % int(rirWays)

        for key in rir_rnk_tgt0.keys():
            if key == rankInterleaveIndex:
                Chip_select = rir_rnk_tgt0[key]

        dimm = Chip_select >> 2
        rank = Chip_select % 4

        #   求出的rank_address_result  为字符串类型，如果要传入 bank_translator 求取 bank等信息需要先转化为 整形变量
        rank_address_input = to_int(rank_address_result)
        result_bank_translator = forwardRankAddrTranslator.Translator1_ddr4(rank_address_input, page_mode)

        result = str(dimm) + "," + str(rank) + "," + result_bank_translator + "," + str(
            Chip_select) + "," + rank_address_result

        return result


def RIR_4_16G_1P(socket_id, imc_id, channel_id, channelAddr, page_mode, nume_mode):
    shift = 0
    rirWays = 0
    rirOffset = 0
    Chip_select = 0
    rir_rnk_tgt0 = {}
    base_temp = ''

    if nume_mode == 'Disable':  # 4*16G  socket交织

        # 配置信息 1.
        rir_rnk_tgt0 = {0: 0, 1: 1}

        rirWays_temp = connect.select(
            "select _RIR_WAYS from PURPLE_RIR_1P where _CONFIG = '4_16G' "
            "and _INFO = '%s_%s' and _CHANNEL_NO = '%s'" % (socket_id, imc_id, channel_id)
        )
        rirOffset_temp = connect.select(
            "select _RIR_OFFSET from PURPLE_RIR_1P where _CONFIG = '4_16G' "
            "and _INFO = '%s_%s' and _CHANNEL_NO = '%s'" % (socket_id, imc_id, channel_id)
        )
        rirWays = ''.join(rirWays_temp)
        rirOffset = ''.join(rirOffset_temp)

        base_temp = connect.select(
            "select _BASE, _LIMIT from PURPLE_RIR_1P where _CONFIG = '4_16G' "
            "and _INFO = '%s_%s' and _CHANNEL_NO = '%s'" % (socket_id, imc_id, channel_id)
        )

        shift = 6 if (page_mode == 'Closed') else 13

    if nume_mode == 'Enable':  # 4*32G socket不交织
        pass

    if to_int(base_temp[0]) <= channelAddr <= to_int(base_temp[1]):

        rankAddr = channelAddr >> shift
        rankAddr = rankAddr // int(rirWays)
        rankAddr = rankAddr << shift  # rankAddr = ((channelAddr >> shift) // int(rirWays)) << shift
        rankAddr = (rankAddr | channelAddr & (2 ** shift - 1)) - to_int(rirOffset)
        rank_address_result = '0x{:012x}'.format(rankAddr)

        rankInterleaveIndex = (channelAddr >> shift) % int(rirWays)

        for key in rir_rnk_tgt0.keys():
            if key == rankInterleaveIndex:
                Chip_select = rir_rnk_tgt0[key]

        dimm = Chip_select >> 2
        rank = Chip_select % 4

        #   求出的rank_address_result  为字符串类型，如果要传入 bank_translator 求取 bank等信息需要先转化为 整形变量
        rank_address_input = to_int(rank_address_result)
        result_bank_translator = forwardRankAddrTranslator.Translator1_ddr4(rank_address_input, page_mode)

        result = str(dimm) + "," + str(rank) + "," + result_bank_translator + "," + str(
            Chip_select) + "," + rank_address_result

        return result


def RIR_4_32G_1P(socket_id, imc_id, channel_id, channelAddr, page_mode, nume_mode):
    shift = 0
    rirWays = 0
    rirOffset = 0
    Chip_select = 0
    rir_rnk_tgt0 = {}
    base_temp = ''

    if nume_mode == 'Disable':  # 4*32G  socket交织

        # 配置信息 1.
        rir_rnk_tgt0 = {0: 0, 1: 1}

        rirWays_temp = connect.select(
            "select _RIR_WAYS from PURPLE_RIR_1P where _CONFIG = '4_32G' "
            "and _INFO = '%s_%s' and _CHANNEL_NO = '%s'" % (socket_id, imc_id, channel_id)
        )
        rirOffset_temp = connect.select(
            "select _RIR_OFFSET from PURPLE_RIR_1P where _CONFIG = '4_32G' "
            "and _INFO = '%s_%s' and _CHANNEL_NO = '%s'" % (socket_id, imc_id, channel_id)
        )
        rirWays = ''.join(rirWays_temp)
        rirOffset = ''.join(rirOffset_temp)

        base_temp = connect.select(
            "select _BASE, _LIMIT from PURPLE_RIR_1P where _CONFIG = '4_32G' "
            "and _INFO = '%s_%s' and _CHANNEL_NO = '%s'" % (socket_id, imc_id, channel_id)
        )

        shift = 6 if (page_mode == 'Closed') else 13

    if nume_mode == 'Enable':  # 4*32G socket不交织
        pass

    if to_int(base_temp[0]) <= channelAddr <= to_int(base_temp[1]):

        rankAddr = channelAddr >> shift
        rankAddr = rankAddr // int(rirWays)
        rankAddr = rankAddr << shift  # rankAddr = ((channelAddr >> shift) // int(rirWays)) << shift
        rankAddr = (rankAddr | channelAddr & (2 ** shift - 1)) - to_int(rirOffset)
        rank_address_result = '0x{:012x}'.format(rankAddr)

        rankInterleaveIndex = (channelAddr >> shift) % int(rirWays)

        for key in rir_rnk_tgt0.keys():
            if key == rankInterleaveIndex:
                Chip_select = rir_rnk_tgt0[key]

        dimm = Chip_select >> 2
        rank = Chip_select % 4

        #   求出的rank_address_result  为字符串类型，如果要传入 bank_translator 求取 bank等信息需要先转化为 整形变量
        rank_address_input = to_int(rank_address_result)
        result_bank_translator = forwardRankAddrTranslator.Translator2_ddr4(rank_address_input, page_mode)

        result = str(dimm) + "," + str(rank) + "," + result_bank_translator + "," + str(
            Chip_select) + "," + rank_address_result

        return result


def RIR_8_32G_1P(socket_id, imc_id, channel_id, channelAddr, page_mode, nume_mode):
    shift = 0
    rirWays = 0
    rirOffset = 0
    Chip_select = 0
    rir_rnk_tgt0 = {}
    base_temp = ''

    if nume_mode == 'Disable':

        # 配置信息 1.
        rir_rnk_tgt0 = {0: 0, 1: 4, 2: 1, 3: 5}

        rirWays_temp = connect.select(
            "select _RIR_WAYS from PURPLE_RIR_1P where _CONFIG = '8_32G' "
            "and _INFO = '%s_%s' and _CHANNEL_NO = '%s'" % (socket_id, imc_id, channel_id)
        )
        rirOffset_temp = connect.select(
            "select _RIR_OFFSET from PURPLE_RIR_1P where _CONFIG = '8_32G' "
            "and _INFO = '%s_%s' and _CHANNEL_NO = '%s'" % (socket_id, imc_id, channel_id)
        )
        rirWays = ''.join(rirWays_temp)
        rirOffset = ''.join(rirOffset_temp)

        base_temp = connect.select(
            "select _BASE, _LIMIT from PURPLE_RIR_1P where _CONFIG = '8_32G' "
            "and _INFO = '%s_%s' and _CHANNEL_NO = '%s'" % (socket_id, imc_id, channel_id)
        )

        shift = 6 if (page_mode == 'Closed') else 13

    if nume_mode == 'Enable':  # 4*32G socket不交织
        pass

    if to_int(base_temp[0]) <= channelAddr <= to_int(base_temp[1]):

        rankAddr = channelAddr >> shift
        rankAddr = rankAddr // int(rirWays)
        rankAddr = rankAddr << shift  # rankAddr = ((channelAddr >> shift) // int(rirWays)) << shift
        rankAddr = (rankAddr | channelAddr & (2 ** shift - 1)) - to_int(rirOffset)
        rank_address_result = '0x{:012x}'.format(rankAddr)

        rankInterleaveIndex = (channelAddr >> shift) % int(rirWays)

        for key in rir_rnk_tgt0.keys():
            if key == rankInterleaveIndex:
                Chip_select = rir_rnk_tgt0[key]

        dimm = Chip_select >> 2
        rank = Chip_select % 4

        #   求出的rank_address_result  为字符串类型，如果要传入 bank_translator 求取 bank等信息需要先转化为 整形变量
        rank_address_input = to_int(rank_address_result)
        result_bank_translator = forwardRankAddrTranslator.Translator2_ddr4(rank_address_input, page_mode)

        result = str(dimm) + "," + str(rank) + "," + result_bank_translator + "," + str(
            Chip_select) + "," + rank_address_result

        return result


def RIR_4_32G_2P(socket_id, imc_id, channel_id, channelAddr, page_mode, nume_mode):
    shift = 0
    rirWays = 0
    rirOffset = 0
    Chip_select = 0
    rir_rnk_tgt0 = {}
    base_temp = ''

    if nume_mode == 'Disable':  # 4*32G  socket交织

        # 配置信息 1.
        rir_rnk_tgt0 = {0: 0, 1: 1}

        rirWays_temp = connect.select(
            "select _RIR_WAYS from PURPLE_RIR_2P where _CONFIG = '4_32G' "
            "and _INFO = '%s_%s' and _CHANNEL_NO = '%s'" % (socket_id, imc_id, channel_id)
        )
        rirOffset_temp = connect.select(
            "select _RIR_OFFSET from PURPLE_RIR_2P where _CONFIG = '4_32G' "
            "and _INFO = '%s_%s' and _CHANNEL_NO = '%s'" % (socket_id, imc_id, channel_id)
        )
        rirWays = ''.join(rirWays_temp)
        rirOffset = ''.join(rirOffset_temp)

        base_temp = connect.select(
            "select _BASE, _LIMIT from PURPLE_RIR_2P where _CONFIG = '4_32G' "
            "and _INFO = '%s_%s' and _CHANNEL_NO = '%s'" % (socket_id, imc_id, channel_id)
        )

        shift = 6 if (page_mode == 'Closed') else 13

    if nume_mode == 'Enable':  # 4*32G socket不交织

        # 配置信息 1.
        rir_rnk_tgt0 = {0: 0, 1: 1}

        rirWays_temp = connect.select(
            "select _RIR_WAYS from PURPLE_RIR_2P where _CONFIG = 'NUMA_4_32G' "
            "and _INFO = '%s_%s' and _CHANNEL_NO = '%s'" % (socket_id, imc_id, channel_id)
        )
        rirOffset_temp = connect.select(
            "select _RIR_OFFSET from PURPLE_RIR_2P where _CONFIG = 'NUMA_4_32G' "
            "and _INFO = '%s_%s' and _CHANNEL_NO = '%s'" % (socket_id, imc_id, channel_id)
        )
        rirWays = ''.join(rirWays_temp)
        rirOffset = ''.join(rirOffset_temp)
        base_temp = connect.select(
            "select _BASE, _LIMIT from PURPLE_RIR_2P where _CONFIG = 'NUMA_4_32G' "
            "and _INFO = '%s_%s' and _CHANNEL_NO = '%s'" % (socket_id, imc_id, channel_id)
        )
        shift = 6 if (page_mode == 'Closed') else 13

    if to_int(base_temp[0]) <= channelAddr <= to_int(base_temp[1]):

        rankAddr = channelAddr >> shift
        rankAddr = rankAddr // int(rirWays)
        rankAddr = rankAddr << shift  # rankAddr = ((channelAddr >> shift) // int(rirWays)) << shift
        rankAddr = (rankAddr | channelAddr & (2 ** shift - 1)) - to_int(rirOffset)
        rank_address_result = '0x{:012x}'.format(rankAddr)

        rankInterleaveIndex = (channelAddr >> shift) % int(rirWays)

        for key in rir_rnk_tgt0.keys():
            if key == rankInterleaveIndex:
                Chip_select = rir_rnk_tgt0[key]

        dimm = Chip_select >> 2
        rank = Chip_select % 4

        #   求出的rank_address_result  为字符串类型，如果要传入 bank_translator 求取 bank等信息需要先转化为 整形变量
        rank_address_input = to_int(rank_address_result)
        result_bank_translator = forwardRankAddrTranslator.Translator2_ddr4(rank_address_input, page_mode)

        result = str(dimm) + "," + str(rank) + "," + result_bank_translator + "," + str(
            Chip_select) + "," + rank_address_result

        return result


def RIR_8_32G_2P(socket_id, imc_id, channel_id, channelAddr, page_mode, nume_mode):
    shift = 0
    rirWays = 0
    rirOffset = 0
    Chip_select = 0
    rir_rnk_tgt0 = {}
    base_temp = ''

    if nume_mode == 'Disable':  # 8*32G  socket交织

        # 配置信息 1.
        rir_rnk_tgt0 = {0: 0, 1: 1}

        rirWays_temp = connect.select(
            "select _RIR_WAYS from PURPLE_RIR_2P where _CONFIG = '8_32G' "
            "and _INFO = '%s_%s' and _CHANNEL_NO = '%s'" % (socket_id, imc_id, channel_id)
        )
        rirOffset_temp = connect.select(
            "select _RIR_OFFSET from PURPLE_RIR_2P where _CONFIG = '8_32G' "
            "and _INFO = '%s_%s' and _CHANNEL_NO = '%s'" % (socket_id, imc_id, channel_id)
        )
        rirWays = ''.join(rirWays_temp)
        rirOffset = ''.join(rirOffset_temp)

        base_temp = connect.select(
            "select _BASE, _LIMIT from PURPLE_RIR_2P where _CONFIG = '8_32G' "
            "and _INFO = '%s_%s' and _CHANNEL_NO = '%s'" % (socket_id, imc_id, channel_id)
        )

        shift = 6 if (page_mode == 'Closed') else 13

    if nume_mode == 'Enable':  # 8*32G socket 不交织
        # 配置信息 1.
        rir_rnk_tgt0 = {0: 0, 1: 1}

        rirWays_temp = connect.select(
            "select _RIR_WAYS from PURPLE_RIR_2P where _CONFIG = 'NUMA_8_32G' "
            "and _INFO = '%s_%s' and _CHANNEL_NO = '%s'" % (socket_id, imc_id, channel_id)
        )
        rirOffset_temp = connect.select(
            "select _RIR_OFFSET from PURPLE_RIR_2P where _CONFIG = 'NUMA_8_32G' "
            "and _INFO = '%s_%s' and _CHANNEL_NO = '%s'" % (socket_id, imc_id, channel_id)
        )
        rirWays = ''.join(rirWays_temp)
        rirOffset = ''.join(rirOffset_temp)

        base_temp = connect.select(
            "select _BASE, _LIMIT from PURPLE_RIR_2P where _CONFIG = 'NUMA_8_32G' "
            "and _INFO = '%s_%s' and _CHANNEL_NO = '%s'" % (
                socket_id, imc_id, channel_id))

        shift = 6 if (page_mode == 'Closed') else 13

    if to_int(base_temp[0]) <= channelAddr <= to_int(base_temp[1]):

        rankAddr = channelAddr >> shift
        rankAddr = rankAddr // int(rirWays)
        rankAddr = rankAddr << shift  # rankAddr = ((channelAddr >> shift) // int(rirWays)) << shift
        rankAddr = (rankAddr | channelAddr & (2 ** shift - 1)) - to_int(rirOffset)
        rank_address_result = '0x{:012x}'.format(rankAddr)

        rankInterleaveIndex = (channelAddr >> shift) % int(rirWays)

        for key in rir_rnk_tgt0.keys():
            if key == rankInterleaveIndex:
                Chip_select = rir_rnk_tgt0[key]

        dimm = Chip_select >> 2
        rank = Chip_select % 4

        #   求出的rank_address_result  为字符串类型，如果要传入 bank_translator 求取 bank等信息需要先转化为 整形变量
        rank_address_input = to_int(rank_address_result)
        result_bank_translator = forwardRankAddrTranslator.Translator2_ddr4(rank_address_input, page_mode)

        result = str(dimm) + "," + str(rank) + "," + result_bank_translator + "," + str(
            Chip_select) + "," + rank_address_result

        return result


def RIR_16_32G_2P(socket_id, imc_id, channel_id, channelAddr, page_mode, nume_mode):
    shift = 0
    rirWays = 0
    rirOffset = 0
    Chip_select = 0
    rir_rnk_tgt0 = {}
    base_temp = ''

    if nume_mode == 'Disable':  # 16*32G socket交织

        # 配置信息 1.
        rir_rnk_tgt0 = {0: 0, 1: 4, 2: 1, 3: 5}

        rirWays_temp = connect.select(
            "select _RIR_WAYS from PURPLE_RIR_2P where _CONFIG = '16_32G' "
            "and _INFO = '%s_%s' and _CHANNEL_NO = '%s'" % (
                socket_id, imc_id, channel_id))
        rirOffset_temp = connect.select(
            "select _RIR_OFFSET from PURPLE_RIR_2P where _CONFIG = '16_32G' "
            "and _INFO = '%s_%s' and _CHANNEL_NO = '%s'" % (
                socket_id, imc_id, channel_id))
        rirWays = ''.join(rirWays_temp)
        rirOffset = ''.join(rirOffset_temp)

        base_temp = connect.select(
            "select _BASE, _LIMIT from PURPLE_RIR_2P where _CONFIG = '16_32G' "
            "and _INFO = '%s_%s' and _CHANNEL_NO = '%s'" % (
                socket_id, imc_id, channel_id))

        shift = 6 if (page_mode == 'Closed') else 13

    if nume_mode == 'Enable':  # 16*32G  socket不交织

        # 配置信息 1.
        rir_rnk_tgt0 = {0: 0, 1: 4, 2: 1, 3: 5}

        rirWays_temp = connect.select(
            "select _RIR_WAYS from PURPLE_RIR_2P where _CONFIG = 'NUMA_16_32G' "
            "and _INFO = '%s_%s' and _CHANNEL_NO = '%s'" % (
                socket_id, imc_id, channel_id))
        rirOffset_temp = connect.select(
            "select _RIR_OFFSET from PURPLE_RIR_2P where _CONFIG = 'NUMA_16_32G' "
            "and _INFO = '%s_%s' and _CHANNEL_NO = '%s'" % (
                socket_id, imc_id, channel_id))
        rirWays = ''.join(rirWays_temp)
        rirOffset = ''.join(rirOffset_temp)

        base_temp = connect.select(
            "select _BASE, _LIMIT from PURPLE_RIR_2P where _CONFIG = 'NUMA_16_32G' "
            "and _INFO = '%s_%s' and _CHANNEL_NO = '%s'" % (
                socket_id, imc_id, channel_id))

        shift = 6 if (page_mode == 'Closed') else 13

    if to_int(base_temp[0]) <= channelAddr <= to_int(base_temp[1]):

        rankAddr = channelAddr >> shift
        rankAddr = rankAddr // int(rirWays)
        rankAddr = rankAddr << shift  # rankAddr = ((channelAddr >> shift) // int(rirWays)) << shift
        rankAddr = (rankAddr | channelAddr & (2 ** shift - 1)) - to_int(rirOffset)
        rank_address_result = '0x{:012x}'.format(rankAddr)

        rankInterleaveIndex = (channelAddr >> shift) % int(rirWays)

        for key in rir_rnk_tgt0.keys():
            if key == rankInterleaveIndex:
                Chip_select = rir_rnk_tgt0[key]

        dimm = Chip_select >> 2
        rank = Chip_select % 4

        #   求出的rank_address_result  为字符串类型，如果要传入 bank_translator 求取 bank等信息需要先转化为 整形变量
        rank_address_input = to_int(rank_address_result)
        result_bank_translator = forwardRankAddrTranslator.Translator2_ddr4(rank_address_input, page_mode)

        result = str(dimm) + "," + str(rank) + "," + result_bank_translator + "," + str(
            Chip_select) + "," + rank_address_result

        return result


def RIR_24_32G_2P(socket_id, imc_id, channel_id, channelAddr, page_mode, nume_mode):
    shift = 0
    rirWays = 0
    rirOffset = 0
    Chip_select = 0
    rir_rnk_tgt0 = {}
    base_temp = ''

    if nume_mode == 'Disable':  # 16*32G socket交织

        # 配置信息 1.
        rir_rnk_tgt0 = {0: 0, 1: 4, 2: 1, 3: 5}

        rirWays_temp = connect.select(
            "select _RIR_WAYS from PURPLE_RIR_2P where _CONFIG = '24_32G' "
            "and _INFO = '%s_%s' and _CHANNEL_NO = '%s'" % (
                socket_id, imc_id, channel_id))
        rirOffset_temp = connect.select(
            "select _RIR_OFFSET from PURPLE_RIR_2P where _CONFIG = '24_32G' "
            "and _INFO = '%s_%s' and _CHANNEL_NO = '%s'" % (
                socket_id, imc_id, channel_id))
        rirWays = ''.join(rirWays_temp)
        rirOffset = ''.join(rirOffset_temp)

        base_temp = connect.select(
            "select _BASE, _LIMIT from PURPLE_RIR_2P where _CONFIG = '24_32G' "
            "and _INFO = '%s_%s' and _CHANNEL_NO = '%s'" % (
                socket_id, imc_id, channel_id))

        shift = 6 if (page_mode == 'Closed') else 13

    if nume_mode == 'Enable':  # 16*32G  socket不交织

        # 配置信息 1.
        rir_rnk_tgt0 = {0: 0, 1: 4, 2: 1, 3: 5}

        rirWays_temp = connect.select(
            "select _RIR_WAYS from PURPLE_RIR_2P where _CONFIG = 'NUMA_24_32G' "
            "and _INFO = '%s_%s' and _CHANNEL_NO = '%s'" % (
                socket_id, imc_id, channel_id))
        rirOffset_temp = connect.select(
            "select _RIR_OFFSET from PURPLE_RIR_2P where _CONFIG = 'NUMA_24_32G' "
            "and _INFO = '%s_%s' and _CHANNEL_NO = '%s'" % (
                socket_id, imc_id, channel_id))
        rirWays = ''.join(rirWays_temp)
        rirOffset = ''.join(rirOffset_temp)

        base_temp = connect.select(
            "select _BASE, _LIMIT from PURPLE_RIR_2P where _CONFIG = 'NUMA_24_32G' "
            "and _INFO = '%s_%s' and _CHANNEL_NO = '%s'" % (
                socket_id, imc_id, channel_id))

        shift = 6 if (page_mode == 'Closed') else 13

    if to_int(base_temp[0]) <= channelAddr <= to_int(base_temp[1]):

        rankAddr = channelAddr >> shift
        rankAddr = rankAddr // int(rirWays)
        rankAddr = rankAddr << shift  # rankAddr = ((channelAddr >> shift) // int(rirWays)) << shift
        rankAddr = (rankAddr | channelAddr & (2 ** shift - 1)) - to_int(rirOffset)
        rank_address_result = '0x{:012x}'.format(rankAddr)

        rankInterleaveIndex = (channelAddr >> shift) % int(rirWays)

        for key in rir_rnk_tgt0.keys():
            if key == rankInterleaveIndex:
                Chip_select = rir_rnk_tgt0[key]

        dimm = Chip_select >> 2
        rank = Chip_select % 4

        #   求出的rank_address_result  为字符串类型，如果要传入 bank_translator 求取 bank等信息需要先转化为 整形变量
        rank_address_input = to_int(rank_address_result)
        result_bank_translator = forwardRankAddrTranslator.Translator2_ddr4(rank_address_input, page_mode)

        result = str(dimm) + "," + str(rank) + "," + result_bank_translator + "," + str(
            Chip_select) + "," + rank_address_result

        return result


def RIR_12_32G_2P(socket_id, imc_id, channel_id, channelAddr, page_mode, nume_mode):
    shift = 0
    rirWays = 0
    rirOffset = 0
    Chip_select = 0
    rir_rnk_tgt0 = {}
    base_temp = ''

    if nume_mode == 'Disable':  # 16*32G socket交织

        # 配置信息 1.
        rir_rnk_tgt0 = {0: 0, 1: 1}

        rirWays_temp = connect.select(
            "select _RIR_WAYS from PURPLE_RIR_2P where _CONFIG = '12_32G' "
            "and _INFO = '%s_%s' and _CHANNEL_NO = '%s'" % (
                socket_id, imc_id, channel_id))
        rirOffset_temp = connect.select(
            "select _RIR_OFFSET from PURPLE_RIR_2P where _CONFIG = '12_32G' "
            "and _INFO = '%s_%s' and _CHANNEL_NO = '%s'" % (
                socket_id, imc_id, channel_id))
        rirWays = ''.join(rirWays_temp)
        rirOffset = ''.join(rirOffset_temp)

        base_temp = connect.select(
            "select _BASE, _LIMIT from PURPLE_RIR_2P where _CONFIG = '12_32G' "
            "and _INFO = '%s_%s' and _CHANNEL_NO = '%s'" % (
                socket_id, imc_id, channel_id))

        shift = 6 if (page_mode == 'Closed') else 13

    if nume_mode == 'Enable':  # 16*32G  socket不交织

        # 配置信息 1.
        rir_rnk_tgt0 = {0: 0, 1: 1}

        rirWays_temp = connect.select(
            "select _RIR_WAYS from PURPLE_RIR_2P where _CONFIG = 'NUMA_12_32G' "
            "and _INFO = '%s_%s' and _CHANNEL_NO = '%s'" % (
                socket_id, imc_id, channel_id))
        rirOffset_temp = connect.select(
            "select _RIR_OFFSET from PURPLE_RIR_2P where _CONFIG = 'NUMA_12_32G' "
            "and _INFO = '%s_%s' and _CHANNEL_NO = '%s'  " % (
                socket_id, imc_id, channel_id))
        rirWays = ''.join(rirWays_temp)
        rirOffset = ''.join(rirOffset_temp)

        base_temp = connect.select(
            "select _BASE, _LIMIT from PURPLE_RIR_2P where _CONFIG = 'NUMA_12_32G'"
            " and _INFO = '%s_%s' and _CHANNEL_NO = '%s'" % (
                socket_id, imc_id, channel_id))

        shift = 6 if (page_mode == 'Closed') else 13

    if to_int(base_temp[0]) <= channelAddr <= to_int(base_temp[1]):

        rankAddr = channelAddr >> shift
        rankAddr = rankAddr // int(rirWays)
        rankAddr = rankAddr << shift  # rankAddr = ((channelAddr >> shift) // int(rirWays)) << shift
        rankAddr = (rankAddr | channelAddr & (2 ** shift - 1)) - to_int(rirOffset)
        rank_address_result = '0x{:012x}'.format(rankAddr)

        rankInterleaveIndex = (channelAddr >> shift) % int(rirWays)

        for key in rir_rnk_tgt0.keys():
            if key == rankInterleaveIndex:
                Chip_select = rir_rnk_tgt0[key]

        dimm = Chip_select >> 2
        rank = Chip_select % 4

        #   求出的rank_address_result  为字符串类型，如果要传入 bank_translator 求取 bank等信息需要先转化为 整形变量
        rank_address_input = to_int(rank_address_result)
        result_bank_translator = forwardRankAddrTranslator.Translator2_ddr4(rank_address_input, page_mode)

        result = str(dimm) + "," + str(rank) + "," + result_bank_translator + "," + str(
            Chip_select) + "," + rank_address_result

        return result


def RIR_16_64G_2P(socket_id, imc_id, channel_id, channelAddr, page_mode, nume_mode):
    rir = ''
    rirWays = 0
    rirOffset = 0
    Chip_select = 0
    rir_rnk_tgt = {}
    base_temp = ''
    rir_rnk_tgt1 = {0: 0, 1: 4, 2: 1, 3: 5}
    rir_rnk_tgt2 = {0: 2, 1: 6, 2: 3, 3: 7}

    if nume_mode == 'Disable':  # 16*64G socket交织

        base = ''

        for rrr in range(0, 2):
            base_temp = connect.select(
                "select _BASE, _LIMIT from PURPLE_RIR_2P where _CONFIG = '16_64G' "
                "and _INFO = '%s_%s' and _CHANNEL_NO = '%s' and _RIR='RIR%s'"
                % (socket_id, imc_id, channel_id, rrr))
            if to_int(base_temp[0]) <= channelAddr <= to_int(base_temp[1]):
                base = to_int(base_temp[0])  # 求出了属于具体 SAD 区间的 base值
                break

        rir_temp = connect.select(
            "select _RIR from PURPLE_RIR_2P where _CONFIG = '16_64G' "
            "and _INFO = '%s_%s' and _CHANNEL_NO = '%s' and _BASE = '%s'"
            % (socket_id, imc_id, channel_id, to_hex_str(base)))
        rir = ''.join(rir_temp)

        rirWays_temp = connect.select(
            "select _RIR_WAYS from PURPLE_RIR_2P where _CONFIG = '16_64G' "
            "and _INFO = '%s_%s' and _CHANNEL_NO = '%s' and _RIR = '%s'"
            % (socket_id, imc_id, channel_id, rir))
        rirOffset_temp = connect.select(
            "select _RIR_OFFSET from PURPLE_RIR_2P where _CONFIG = '16_64G' "
            "and _INFO = '%s_%s' and _CHANNEL_NO = '%s' and _RIR = '%s'"
            % (socket_id, imc_id, channel_id, rir))
        rirWays = ''.join(rirWays_temp)
        rirOffset = ''.join(rirOffset_temp)

    if nume_mode == 'Enable':  # 16*64G socket不交织

        base = ''

        for rrr in range(0, 2):
            base_temp = connect.select(
                "select _BASE, _LIMIT from PURPLE_RIR_2P where _CONFIG = 'NUMA_16_64G' "
                "and _INFO = '%s_%s' and _CHANNEL_NO = '%s' and _RIR='RIR%s'"
                % (socket_id, imc_id, channel_id, rrr))
            if to_int(base_temp[0]) <= channelAddr <= to_int(base_temp[1]):
                base = to_int(base_temp[0])  # 求出了属于具体 SAD 区间的 base值
                break

        rir_temp = connect.select(
            "select _RIR from PURPLE_RIR_2P where _CONFIG = 'NUMA_16_64G' "
            "and _INFO = '%s_%s' and _CHANNEL_NO = '%s' and _BASE = '%s'"
            % (socket_id, imc_id, channel_id, to_hex_str(base)))
        rir = ''.join(rir_temp)

        rirWays_temp, rirOffset_temp = connect.select(
            "select _RIR_WAYS, _RIR_OFFSET from PURPLE_RIR_2P where _CONFIG = 'NUMA_16_64G' "
            "and _INFO = '%s_%s' and _CHANNEL_NO = '%s' and _RIR = '%s'"
            % (socket_id, imc_id, channel_id, rir))
        rirWays = ''.join(rirWays_temp)
        rirOffset = ''.join(rirOffset_temp)

    shift = 6 if (page_mode == 'Closed') else 13

    rir_rnk_tgt = rir_rnk_tgt1 if (rir == "RIR0") else rir_rnk_tgt2

    rankAddr = channelAddr >> shift
    rankAddr = rankAddr // int(rirWays)
    rankAddr = rankAddr << shift  # rankAddr = ((channelAddr >> shift) // int(rirWays)) << shift
    rankAddr = (rankAddr | channelAddr & (2 ** shift - 1)) - to_int(rirOffset)
    rank_address_result = '0x{:012x}'.format(rankAddr)

    rankInterleaveIndex = (channelAddr >> shift) % int(rirWays)

    for key in rir_rnk_tgt.keys():
        if key == rankInterleaveIndex:
            Chip_select = rir_rnk_tgt[key]

    dimm = Chip_select >> 2
    rank = Chip_select % 4

    #   求出的rank_address_result  为字符串类型，如果要传入 bank_translator 求取 bank等信息需要先转化为 整形变量
    rank_address_input = to_int(rank_address_result)
    result_bank_translator = forwardRankAddrTranslator.Translator2_ddr4(rank_address_input, page_mode)

    result = str(dimm) + "," + str(rank) + "," + result_bank_translator + "," + str(
        Chip_select) + "," + rank_address_result

    return result
