# -*- coding: UTF-8 -*-
# Copyright (c) Huawei Technologies Co., Ltd. 2019-2021. All rights reserved.
import re
import time
import datetime


def get_ctrl_id(file_path):
    ctrl_log_name_pattern = re.compile('(\d+[A-Z])_messages')
    match_object = ctrl_log_name_pattern.search(file_path)
    if match_object:
        return match_object.group(1)
    return ''


def format_time(time_str):
    try:
        return time.strftime(
            "%Y-%m-%d %H:%M:%S",
            time.strptime(time_str, "%a %b %d %H:%M:%S %Y"),
        )
    except Exception:
        return time_str


def get_timestamp_second(time_str, str_format='%Y-%m-%d %H:%M:%S'):
    """
    将符合格式的时间字符串转为时间戳（秒数）
    """
    return time.mktime(datetime.datetime.strptime(
        time_str, str_format).timetuple())
