# -*- coding: UTF-8 -*-

import common
from common_utils import get_dpa_rest_record

PY_JAVA_ENV = py_java_env
LANG = common.getLang(PY_JAVA_ENV)
LOGGER = common.getLogger(PY_LOGGER, __file__)


def execute(dpa_rest):
    err_msg = ""
    node_query_uri = "/clusters/nodes"
    record = get_dpa_rest_record(dpa_rest, node_query_uri)
    for node_info in record.get("responseData", {}).get("data", [{}]):
        if str(node_info.get("status")) != "1":
            node_name = node_info.get("nodeName")
            node_status = node_info.get("status")
            err_msg += common.getMsg(LANG, "dpa.node.status.abnormal", (node_name, node_status))
            LOGGER.logNoPass("The status of node [{}] is abnormal (Node Status:{})".format(node_name, node_status))

    if not err_msg:
        return True, record, err_msg
    return False, record, err_msg
