from __future__ import with_statement

import copy
import os

import cliUtil
import common
from frameone.util import common as frameCommon

lang = common.getLang(py_java_env)
logger = common.getLogger(PY_LOGGER, __file__)


class MagicNum:
    # 槽位号索引
    SLOT_INDEX = 6
    # 引擎号索引
    ENG_INDEX = 3
    # 硬盘框号开始位置
    ENCLOS_START_INDEX = 4
    # 硬盘框号结束位置
    ENCLOS_END_INDEX = 6
    # Dorado6000槽位split后的长度
    DORADO6000_SLOT_LENGHT = 2
    # Dorado18000槽位split后的长度
    DORADO18000_SLOT_LENGHT = 3
    # 新建硬盘最小盘数（单引擎）
    NEW_DD_MINNUM_SINGLE_ENG = 8
    # 新建硬盘最小盘数（跨引擎）
    NEW_DD_MINNUM_CROSS_ENG = 16
    # 新建硬盘最大盘数（单引擎）（扩容硬盘域每引擎）
    NEW_DD_MAXNUM_SINGLE_ENG = 50
    # 新建硬盘最大盘数（跨引擎）
    NEW_DD_MAXNUM_CROSS_ENG = 100


# 筛选产品列表
DORADO_NVME_DEVS = ["DORADO18000_V3", "DORADO6000E_V3"]
DORADO_NVME_VERSION = "V300R002C10"
# PCIe Scale-up接口模块
PCIE_SCALE_UP_MODULE = u'2-port 8 Gbit/s PCIe scale-up interface module'

# 12Gb SAS级联模块
SAS_INTERF = u'4x12G SAS QSFP Interface Module'
# 配置数据持久化目录
CFG_DATA_PERSIST_DIR = "{0}temp{0}expanEval".format(os.sep)
# 目录分割
FILE_DEPSIGN = os.sep
# 文件名称 设备SN号+_needMoveSasCard
CFG_DATA_PERSIST_FILENAME = "%s_needMoveSasCard"
# 向上两级目录
DIR_RELATIVE_CMD = "..\.."

# Dorado18000硬盘框域逻辑引擎对应关系
diskIDEngDictForDorado18000 = {'0': ['00', '20', '40', '60', '08', '28', '48', '68'],
                               '1': ['80', 'A0', 'C0', 'E0', '88', 'A8', 'C8', 'E8'],
                               }

DORADO18000_SLOT_PRIORITY = ["2", "4"]
DORADO6000_SLOT_PRIORITY = ["2", "4", "5", "6", "3"]

# Dorado18000域Dorado6000接口卡槽位信息
dorado_slot_info = {
    'DORADO6000 V3': {
        '1': ['A1', 'B1'],
        '2': ['A2', 'B2'],
        '4': ['A4', 'B4'],
        '5': ['A5', 'B5'],
        '6': ['A6', 'B6'],
        '3': ['A3', 'B3'],
    },
    'DORADO18000 V3': {
        '1': {
            "0": ['L1.IOM0', 'R1.IOM0'],
            "1": ['L1.IOM1', 'R1.IOM1']
        },
        '2': {
            "0": ['L2.IOM0', 'R2.IOM0'],
            "1": ['L2.IOM1', 'R2.IOM1']
        },
        "4": {
            "0": ['L4.IOM0', 'R4.IOM0'],
            "1": ['L4.IOM1', 'R4.IOM1']
        }
    }
}


@frameCommon.fakeProgress(py_java_env, totalSeconds=30, logger=logger, interval=1)
def execute(cli):
    '''
    扩容NVME盘检查是否需要挪12Gb SAS级联模块
    1.检查扩容硬盘类型是否为NVMe
    2.硬件类型是否为Dorado 6000 V3增强版和Dorado 18000 V3。此处不做版本验证，选择硬盘类型中已有防呆处理
    3.检查空闲槽位，Dorado 6000 2、4、5、6、3，Dorado 18000 ： 2、4
    4.检查NVMe硬盘数量: 扩容硬盘域（单最大50块） 新建硬盘域（单引擎：最小8，最大50；跨引擎：最小16，最大100）
    :param cli:
    :return:
    '''
    errMsg = ""
    sussgestion = ""
    mess = ""
    notice = ""
    cliRetAll = ""

    try:
        # 删除扩容评估移卡文件
        filePath = getFilePath()
        logger.logInfo("filePath : %s" % filePath)
        if os.path.exists(filePath):
            os.remove(filePath)
            logger.logInfo("delete file: %s" % filePath)
        deviceType = str(common.getProductModeFromContext(py_java_env))
        interal = py_java_env.get("expInfo").getInternalModel()
        version = py_java_env.get("expInfo").getProductVersion()
        version = version if len(version) <= 11 else version[0:11]
        logger.logInfo("interal is = " + str(interal) + ", version is = " + version)
        ## Dorado V3R1C21之前的型号无内部型号字段  先判断版本大于V3R2C10再比较内部版本
        if (version and version.upper() < DORADO_NVME_VERSION) or (interal and interal.upper() not in DORADO_NVME_DEVS):
            return cliUtil.RESULT_NOSUPPORT, cliRetAll, errMsg
        # 获取控制器个数
        flag, controllerNum, cliRet, errMsg = common.getControllerNum(cli, lang)
        cliRetAll += cliRet
        if not flag:
            return cliUtil.RESULT_NOCHECK, cliRetAll, errMsg
        logger.logInfo("controllerNum is = " + str(controllerNum))

        # 新增NVMe盘列表
        newExpDiskList = common.getNewNVMeDiskDomainFromContext(py_java_env)
        logger.logInfo("newExpDiskList is = " + str(newExpDiskList))
        # 无NVMe硬盘或者产品型号不是dorado6000和doardo18000，不涉及
        if not newExpDiskList:
            return cliUtil.RESULT_NOSUPPORT, cliRetAll, errMsg

        # 每引擎上的原有NVMe硬盘
        flag, diskNumOfEngs, cliRet, errMsg = getNVMeDiskNumForEng(cli, lang, deviceType)
        cliRetAll += cliRet
        if not flag:
            return cliUtil.RESULT_NOCHECK, cliRetAll, errMsg

        # 扩容或新建硬盘域硬盘信息
        expNVMeNums = getExpNVMeNum(newExpDiskList)
        logger.logInfo("expNVMeNums is = " + str(expNVMeNums))

        # 查询接口卡信息
        flag, cliRet, errMsg, interfIdModel = common.getInterModule(cli, lang)
        logger.logInfo("interfIdModel = " + (str(interfIdModel)))
        cliRetAll += cliRet
        if not flag:
            return flag, cliRetAll, errMsg

        # 遍历槽位占用信息
        pcieSlot, sasSlot, freeSlot, othersBusy = getSlotInfo(interfIdModel, deviceType)

        # NVME硬盘数量检查
        diskCheck, suss, errMsg = checkNVMeNum(diskNumOfEngs, newExpDiskList, expNVMeNums)
        logger.logInfo("diskCheck is = " + str(diskCheck))
        if not diskCheck:
            mess += common.getMsg(lang, "expand.disk.move.sas.module.NVME.numCheck")
            mess += errMsg
            sussgestion += suss
            return False, cliRetAll, mess, sussgestion

        # 挪卡检查
        needMoveSasCard, canExp, moveCard, notice, suss = checkMoveCard(newExpDiskList, sasSlot, pcieSlot, freeSlot,
                                                                        othersBusy,
                                                                        deviceType)
        logger.logInfo("moveCard is = " + str(moveCard) + ", canExp is ="+ str(canExp)+ ", needMoveSasCard is ="+ str(needMoveSasCard))
        mess += notice
        sussgestion += suss

        # 无空闲槽位需要挪卡
        if needMoveSasCard:
            need = True if moveCard else False
            createMoveSasCardFile(freeSlot, moveCard, need)

        if needMoveSasCard or (not diskCheck):
            return False, cliRetAll, mess, sussgestion
        return True, cliRetAll, "", ""
    except Exception, exception:
        logger.logException(exception)
        return cliUtil.RESULT_NOCHECK, cliRetAll, common.getMsg(lang,"query.result.abnormal")
    finally:
        logger.logInfo("finish process!")

def checkMoveCard(newExpDiskList, sasSlot, pcieSlot, freeSlot, othersBusy, deviceType):
    '''
    检查移卡条件
    :param newExpDiskList:
    :param sasSlot:
    :param pcieSlot:
    :param freeSlot:
    :param othersBusy:
    :param deviceType:
    :return: needMoveSasCard 是否需要挪卡
             canExp 是否满足挪卡条件
             moveCard 挪卡槽位
             mess 检查结果信息
             sussgestion 修复建议
    '''
    mess, sussgestion, notice = "", "", ""
    title = common.getMsg(lang, "expand.disk.move.sas.module.needMove.check")
    mess += title
    needMoveSasCard, canExp = False, True
    moveCard = {}
    for scenceNums in newExpDiskList:
        engLogics = scenceNums.get("crossEng")
        engLogics = engLogics.split(",")
        for engLogic in engLogics:
            # engLogic CTE0:0/1
            arr = engLogic.split(":")
            eng = arr[0]
            logics = arr[1].split("/")
            for logic in logics:
                need, can, notice, suss = moveCheck(eng, logic, sasSlot, pcieSlot, freeSlot,
                                                    othersBusy,
                                                    deviceType, moveCard)
                if need:
                    needMoveSasCard = True
                if not can:
                    canExp = False
                mess = mess if notice in mess else mess + notice
                sussgestion = sussgestion if suss in sussgestion else sussgestion + suss
    return needMoveSasCard, canExp, moveCard, mess, sussgestion


def moveCheck(eng, logic, sasSlot, pcieSlot, freeSlot, othersBusy, deviceType, moveCard):
    notice, suss = "", ""
    needMove, can, hasFree, move = needMoveSasCardCheck(eng,
                                                        logic, sasSlot, pcieSlot, freeSlot, othersBusy, deviceType,
                                                        moveCard)
    if needMove:
        suss, notice = generateMess(eng, needMove, can, hasFree, move)
    return needMove, can, notice, suss


def getExpNVMeNum(newExpDiskList):
    '''
    扩容硬盘域场景的NVMe硬盘统计
    :param newExpDiskList:
    :return:
    '''
    NVMeNum = {}
    for expInfo in newExpDiskList:
        diskNum = expInfo.get("diskNum")
        diskNum = int(diskNum)
        if expInfo.get("eng") != "new":
            engNums = NVMeNum.get(expInfo.get("eng"), {})
            nums = engNums.get(expInfo.get("logicEng"), 0)
            nums += diskNum
            engNums[expInfo.get("logicEng")] = nums
            NVMeNum[expInfo.get("eng")] = engNums
    return NVMeNum


def generateMess(engId, needMoveSasCard, canExp, hasFree, moveCard):
    '''
    生成修复建议
    :param engId:
    :param needMoveSasCard:
    :param canExp:
    :param hasFree:
    :param moveCard:
    :return:
    '''
    sugesstion = ""
    notice = ""
    if needMoveSasCard:
        if canExp and hasFree:
            enginfo = " "
            for eng, slot in moveCard.items():
                if isinstance(slot, dict):
                    for logic, slots in slot.items():
                        enginfo += eng + "." + slots[0] + " " + eng + "." + slots[1] + " "
                else:
                    enginfo = eng + "." + slot[0] + " " + eng + "." + slot[1] + " "
            sugesstion += common.getMsg(lang, "expand.disk.move.sas.module.needmove", (enginfo))
            notice += common.getMsg(lang, "expand.disk.move.sas.module.needmove.result", (enginfo))
        elif not canExp:
            sugesstion += common.getMsg(lang, "expand.disk.move.sas.module.not.sas", (engId))
            notice += common.getMsg(lang, "expand.disk.move.sas.module.not.sas.result", (engId))
        elif not hasFree:
            sugesstion += common.getMsg(lang, "expand.disk.move.sas.module.not.free", (engId))
            notice += common.getMsg(lang, "expand.disk.move.sas.module.not.free.result", (engId))

    return sugesstion, notice


def needMoveSasCardCheck(eng, logicEng, sasSlot, pcieSlot, freeSlot, othersBusy, deviceType, moveCard):
    '''
    判断是否需要挪卡
    :param eng:
    :param logicEng:
    :param sasSlot:
    :param pcieSlot:
    :param freeSlot:
    :param deviceType:
    :return: needMoveSasCard  是否需要挪卡
             canExp  是否能扩容。如果1号槽位被其他模块占用，则无法挪卡，不能扩容
             moveCard 需要挪卡的槽位
    '''
    needMoveSasCard, hasFree, canExp = False, False, False
    move = {}
    freeSlotCheck = checkSlotForExpDD(eng, logicEng, pcieSlot, freeSlot, othersBusy, deviceType)
    logger.logInfo("freeSlotCheck is = " + str(freeSlotCheck))
    if not freeSlotCheck:
        needMoveSasCard = True
        if deviceType.upper() == "DORADO6000 V3":
            if sasSlot.get(eng, {}).get("1"):
                value = sasSlot.get(eng, {}).get("1")
                canExp = True
                if hasFreeSlotByLogic(eng, freeSlot):
                    hasFree = True
                    setMoveCar(moveCard, eng, value)
                    setMoveCar(move, eng, value)
        else:
            if sasSlot.get(eng, {}).get("1", {}).get(logicEng):
                value = sasSlot.get(eng, {}).get("1", {}).get(logicEng)
                canExp = True
                if hasFreeSlotByLogic(eng, freeSlot, logicEng):
                    hasFree = True
                    setMoveCar(moveCard, eng, value, logicEng, True)
                    setMoveCar(move, eng, value, logicEng, True)
    return needMoveSasCard, canExp, hasFree, move


def hasFreeSlotByLogic(eng, infoDict, logic=""):
    '''
    涉及到逻辑引擎的空闲槽位检查
    :param eng: 引擎号
    :param logic: 逻辑引擎号
    :param infoDict: 空闲槽位dict
    :return:
    '''

    if logic:
        if infoDict.get(eng):
            if not hasFreeSlot(infoDict.get(eng), DORADO18000_SLOT_PRIORITY):
                return False
            for k, v in infoDict.get(eng).items():
                if k != "1" and v.get(logic):
                    return True
    else:
        if infoDict.get(eng) and hasFreeSlot(infoDict.get(eng), DORADO6000_SLOT_PRIORITY):
            return True
    return False


def hasFreeSlot(infoDict, slots):
    for k, v in infoDict.items():
        if k in slots:
            return True
    return False


def checkSlotForExpDD(eng, logicEng, pcieSlot, freeSlot, othersBusy, deviceType):
    '''
    检测1号槽位是否空闲或者被PCIe scale-up接口模块占用或者一个呗PCIE占用一个空闲
    :param eng:
    :param logicEng:
    :param pcieSlot:
    :param freeSlot:
    :param deviceType:
    :return:
    '''
    logger.logInfo("eng is = " + str(eng) + ", logicEng is = " + str(logicEng))
    if deviceType.upper() == "DORADO6000 V3":
        if freeSlot and freeSlot.get(eng, {}).get("1"):
            return True
        if pcieSlot and pcieSlot.get(eng, {}).get("1"):
            return True
        if othersBusy and othersBusy.get(eng, {}).get("1"):
            return True
    else:
        if freeSlot and freeSlot.get(eng, {}).get("1", {}).get(logicEng):
            return True
        if pcieSlot and pcieSlot.get(eng, {}).get("1", {}).get(logicEng):
            return True
        if othersBusy and othersBusy.get(eng, {}).get("1", {}).get(logicEng):
            return True
    return False


def getSlotInfo(interfIdModel, deviceType):
    '''
    获取槽位信息
    :param interfIdModel:
    :param deviceType:
    :return:
    '''
    # 空闲1号槽位
    freeSlot = {}
    # PCIe Scale-up接口模块对称占用
    pcieSlot = {}
    # 12Gb SAS级联模块对称占用
    sasSlot = {}
    # 一个槽位空闲，一个槽位被PCIe scale-up接口卡占用
    othersBusy = {}
    deviceType = deviceType.upper()
    engSlotMap = parseIDModel(interfIdModel)
    soltInfo = dorado_slot_info.get(deviceType)
    for slotIndex, slots in soltInfo.items():
        for eng, slotCurrent in engSlotMap.items():
            if deviceType == "DORADO6000 V3":
                # {'0': {'A1': u'2-port 8 Gbit/s PCIe scale-up interface module', 'B1': u'2-port 8 Gbit/s PCIe scale-up interface module'}
                getDorado6000SlotInfo(slotIndex, slots, slotCurrent, eng, freeSlot, pcieSlot, sasSlot, othersBusy)
            if deviceType == "DORADO18000 V3":
                # {{u'0': {'0': {'R0.IOM0': u'2-port 8 Gbit/s PCIe scale-up interface module', 'L0.IOM0': u'2-port 8 Gbit/s PCIe scale-up interface module'}
                getDorado18000SlotInfo(slotIndex, slots, slotCurrent, eng, freeSlot, pcieSlot, sasSlot, othersBusy)
    logger.logInfo("pcieSlot is = " + str(pcieSlot))
    logger.logInfo("sasSlot is = " + str(sasSlot))
    logger.logInfo("othersBusy is = " + str(othersBusy))
    logger.logInfo("freeSlot is = " + str(freeSlot))
    return pcieSlot, sasSlot, freeSlot, othersBusy


def getDorado6000SlotInfo(slotIndex, slots, slotCurrent, eng, freeSlot, pcieSlot, sasSlot, othersBusy):
    '''
    获取Dorado6000槽位信息
    :param slotIndex:
    :param slots:
    :param slotCurrent:
    :param eng:
    :param freeSlot:
    :param pcieSlot:
    :param sasSlot:
    :param othersBusy:
    :return:
    '''
    if not slotCurrent.get(slotIndex):
        setItem(freeSlot, eng, slotIndex, slots)
    else:
        # 其他情况占用
        logicCurrent = slotCurrent.get(slotIndex)
        if len(logicCurrent) == 1:
            name, model = logicCurrent.items()[0]
            if model.lower() == PCIE_SCALE_UP_MODULE.lower():
                setItem(othersBusy, eng, slotIndex, [name])
        elif len(logicCurrent) == 2:
            name, model = logicCurrent.items()[0]
            name1, mode11 = logicCurrent.items()[1]
            # 12Gb SAS级联模块
            if SAS_INTERF.lower() == model.lower() and SAS_INTERF.lower() == mode11.lower():
                if slotIndex == "1":
                    setItem(sasSlot, eng, slotIndex, [name, name1])
            # PCIe Scale-up接口模块
            elif PCIE_SCALE_UP_MODULE.lower() == model.lower() and PCIE_SCALE_UP_MODULE.lower() == mode11.lower():
                setItem(pcieSlot, eng, slotIndex, [name, name1])


def getDorado18000SlotInfo(slotIndex, slots, slotCurrent, eng, freeSlot, pcieSlot, sasSlot, othersBusy):
    '''
    获取Dorado18000槽位信息
    :param slotIndex:
    :param slots:
    :param slotCurrent:
    :param eng:
    :param freeSlot:
    :param pcieSlot:
    :param sasSlot:
    :param othersBusy:
    :return:
    '''
    if not slotCurrent.get(slotIndex):
        setItem(freeSlot, eng, slotIndex, slots)
    elif len(slotCurrent.get(slotIndex)) == 1:
        logicEng, slotModel = slotCurrent.get(slotIndex).items()[0]
        name, model = slotModel.items()[0]
        if len(slotModel) == 1:
            if model.lower() == PCIE_SCALE_UP_MODULE.lower():
                setItem(othersBusy, eng, slotIndex, [name], logicEng, True)
        else:
            name1, mode11 = slotModel.items()[1]
            if SAS_INTERF.lower() == model.lower() and SAS_INTERF.lower() == mode11.lower():
                setItem(sasSlot, eng, slotIndex, [name, name1], logicEng, True)
            elif PCIE_SCALE_UP_MODULE.lower() == model.lower() and PCIE_SCALE_UP_MODULE.lower() == mode11.lower():
                setItem(pcieSlot, eng, slotIndex, [name, name1], logicEng, True)
        engSlot = freeSlot.get(eng, {})
        slotCopy = copy.deepcopy(slots)
        slotCopy.pop(logicEng)
        engSlot[slotIndex] = slotCopy
        freeSlot[eng] = engSlot
    else:
        logicSlot = slotCurrent.get(slotIndex)
        for logicEng, value in logicSlot.items():
            if len(value) == 1:
                name, model = value.items()[0]
                if model.lower() == PCIE_SCALE_UP_MODULE.lower():
                    setItem(othersBusy, eng, slotIndex, [name], logicEng, True)
            elif len(value) == 2:
                name, model = value.items()[0]
                name1, mode11 = value.items()[1]
                if SAS_INTERF.lower() == model.lower() and SAS_INTERF.lower() == mode11.lower():
                    setItem(sasSlot, eng, slotIndex, [name, name1], logicEng, True)
                elif PCIE_SCALE_UP_MODULE.lower() == model.lower() and PCIE_SCALE_UP_MODULE.lower() == mode11.lower():
                    setItem(pcieSlot, eng, slotIndex, [name, name1], logicEng, True)


def setMoveCar(infoDict, eng, value, logic="", hasLogic=False):
    if hasLogic and logic:
        engSlot = infoDict.get(eng, {})
        engSlot[logic] = value
        infoDict[eng] = engSlot
    else:
        infoDict[eng] = value


def setItem(infoDict, eng, slotIndex, value, logicEng="", hasLogic=False):
    '''
    设置数据值，Dorado18000与Dorado6000区分逻辑引擎
    :param infoDict:
    :param eng:
    :param slotIndex:
    :param value:
    :param logicEng:
    :param hasLogic:
    :return:
    '''
    engSlot = infoDict.get(eng, {})
    if not hasLogic:
        engSlot[slotIndex] = value
    else:
        slotMap = engSlot.get(slotIndex, {})
        slotMap[logicEng] = value
        engSlot[slotIndex] = slotMap
    infoDict[eng] = engSlot


def parseIDModel(interfIdModel):
    '''
    解析接口卡信息。格式：
    {u'CTE0': {u'0': {u'B0': u'4x12G SAS QSFP Interface Module', u'A0': u'4x12G SAS QSFP Interface Module'}}}
    :param interfIdModel:
    :return:
    '''
    symInterfMap = {}
    for key, value in interfIdModel.items():
        if not key:
            continue
        slotIndex = key[MagicNum.SLOT_INDEX]
        keyWords = key.split(".")
        lastLocat = "default"
        # Dorado6000 CTE0.A1
        if keyWords and len(keyWords) == MagicNum.DORADO6000_SLOT_LENGHT:
            eng = keyWords[0]
            slot = keyWords[1]
            name = slot
        # Dorado180000 CTE0.L1.IOM0
        if keyWords and len(keyWords) == MagicNum.DORADO18000_SLOT_LENGHT:
            eng = keyWords[0]
            location = keyWords[1]
            slot = keyWords[2]
            name = location + "." + slot
            lastLocat = slot[len(slot) - 1]
        if slotIndex.isdigit():
            slotMap = symInterfMap.get(eng, {})
            slotLogic = slotMap.get(slotIndex, {})
            if lastLocat != "default":
                slotModel = slotLogic.get(lastLocat, {})
                slotModel[name] = value
                slotLogic[lastLocat] = slotModel
            else:
                slotLogic[name] = value
            slotMap[slotIndex] = slotLogic
            symInterfMap[eng] = slotMap
    logger.logInfo("symInterfMap is = " + str(symInterfMap))
    return symInterfMap


def checkNVMeNum(diskNumOfEngs, newExpDiskList, expNVMeNums):
    '''
    检查扩容硬盘数+原有硬盘数是否超过引擎最大规格
    :param logicEng:
    :param diskNumOfEngs:
    :return:
    '''
    sussgestion = ""
    errMsg = ""
    checkResult = True
    overMax = False
    allNum = 0
    for scenceNums in newExpDiskList:
        diskNum = scenceNums.get("diskNum")
        ctrls = scenceNums.get("ctrls")
        diskNum = int(diskNum)
        # 新建硬盘域盘数校验
        if scenceNums.get("eng") == "new":
            oldNum = 0
            logger.logInfo("ctrls is = " + str(ctrls))
            engLogicStr = scenceNums.get("crossEng")
            engLogics = engLogicStr.split(",")
            logicStrs = engLogics[0].split(":")[1]
            logics = logicStrs.split("/")
            cross = True if len(engLogics) == 2 or len(logics) == 2 else False
            if (cross and diskNum < MagicNum.NEW_DD_MINNUM_CROSS_ENG) or (
                    not cross and diskNum < MagicNum.NEW_DD_MINNUM_SINGLE_ENG):
                checkResult = False
                checkNum = MagicNum.NEW_DD_MINNUM_CROSS_ENG if cross else MagicNum.NEW_DD_MINNUM_SINGLE_ENG
                sussgestion += common.getMsg(lang, "expand.disk.move.sas.module.NVMe.lessthanmin")
                errMsg += common.getMsg(lang, "expand.disk.move.sas.module.NVMe.lessthanmin.result", (checkNum))
            for engLogic in engLogics:
                arr = engLogic.split(":")
                eng = arr[0]
                logics = arr[1].split("/")
                # 不跨引擎
                for logic in logics:
                    oldNum += diskNumOfEngs.get(eng, {}).get(logic, 0)
                    allNum += diskNumOfEngs.get(eng, {}).get(logic, 0) + expNVMeNums.get(eng, {}).get(logic, 0)
            allNum += diskNum
            checkNum = MagicNum.NEW_DD_MAXNUM_CROSS_ENG if cross else MagicNum.NEW_DD_MAXNUM_SINGLE_ENG
            if allNum > checkNum:
                errMsg += common.getMsg(lang, "expand.disk.move.sas.module.NVMe.morethanmax.result",
                                        (ctrls, oldNum, checkNum))
                checkResult = False
                overMax = True
    # 扩容硬盘域硬盘数校验
    for eng, logicNum in expNVMeNums.items():
        for logic, num in logicNum.items():
            oldNum = diskNumOfEngs.get(eng, {}).get(logic, 0)
            if num + oldNum > MagicNum.NEW_DD_MAXNUM_SINGLE_ENG:
                data = filter(lambda x: x.get("logicEng") == logic and x.get("eng") == eng, newExpDiskList)
                ctrls = data[0].get("ctrls") if data else ""
                logger.logInfo("ctrls is = " + str(ctrls))
                checkResult = False
                overMax = True
                errMsg += common.getMsg(lang, "expand.disk.move.sas.module.NVMe.morethanmax.result",
                                        (ctrls, oldNum, MagicNum.NEW_DD_MAXNUM_SINGLE_ENG))
    if overMax:
        sussgestion += common.getMsg(lang, "expand.disk.move.sas.module.NVMe.morethanmax")
    return checkResult, sussgestion, errMsg


def getNVMeDiskNumForEng(cli, lang, deviceType):
    '''
    获取系统NVMe硬盘信息
    :param cli:
    :param lang:
    :return: {u'CTE0': {'0': 25, '1': 25}}]
    '''
    diskIdListForEngDict = {}
    flag, cliRet, cliRetLinesList, errMsg = common.getDiskList(cli, lang)
    if flag != True:
        return (False, diskIdListForEngDict, cliRet, errMsg)

    for diskInfoDict in cliRetLinesList:
        diskId = diskInfoDict.get("ID", "")
        diskType = diskInfoDict.get("Type", "")
        if diskId and "nvme" in diskType.lower():
            engId = "CTE" + diskId.split(".")[0][MagicNum.ENG_INDEX]
            logicEngId = "0"
            if deviceType.upper() == "DORADO18000 V3":
                logicEngId = getLogicEng(diskId)
            oldNmveNum = diskIdListForEngDict.setdefault(engId, {}).setdefault(logicEngId, 0)
            diskIdListForEngDict[engId][logicEngId] = oldNmveNum + 1
    logger.logInfo("diskIdListForEngDict = " + (str(diskIdListForEngDict)))
    return True, diskIdListForEngDict, cliRet, errMsg


def createMoveSasCardFile(freeSlot, moveCard, need):
    '''
    创建临时文件SN_needMoveSasCard,写入扩容信息与槽位信息，用于挪卡
    :param newExpDiskList: 扩容信息
    :param freeSlot:  空闲槽位信息
    :param sasSlot:  被12G SAS级联模块占用的槽位
    :return:
    '''
    persistFile = getFilePath()
    try:
        logger.logInfo("persistFile is =" + str(persistFile))
        data = generateData(freeSlot, moveCard, need)
        logger.logInfo("data is =" + str(data))
        with open(persistFile, 'w') as f:
            f.write(str(data))
        logger.logInfo("create file : %s" % persistFile)
    except Exception, ex:
        if os.path.exists(persistFile):
            os.remove(persistFile)
            logger.logInfo("delete file: %s" % persistFile)
        import traceback
        logger.logNoPass("exception:" + traceback.format_exc())
        logger.logInfo("create file exception: %s" % ex)


def getFilePath():
    sn = py_java_env.get("devInfo").getDeviceSerialNumber()
    fileName = CFG_DATA_PERSIST_FILENAME % (sn)
    baseDir = os.path.abspath(DIR_RELATIVE_CMD)
    persistDir = baseDir + CFG_DATA_PERSIST_DIR
    # 工具箱基本目录
    isExistsDataDir = os.path.exists(persistDir)
    if not isExistsDataDir:
        logger.logInfo("The persist directory does not exist: %s" % persistDir)
        os.makedirs(persistDir)
    persistFile = persistDir + FILE_DEPSIGN + fileName
    return persistFile


def generateData(freeSlot, needMoveSasCard, need):
    '''
    :param freeSlot:
    :param sasSlot:
    :return:
    '''
    moveCards = []
    for eng, engInfo in needMoveSasCard.items():
        if isinstance(engInfo, dict):
            for logic, slot in engInfo.items():
                setMoveCardValues(DORADO18000_SLOT_PRIORITY, moveCards, eng, slot, freeSlot, logic, True)
        else:
            setMoveCardValues(DORADO6000_SLOT_PRIORITY, moveCards, eng, engInfo, freeSlot)
    return {"moveCardInfo": moveCards, "couldMove": need}


def setMoveCardValues(proprity, moveCards, eng, slot, freeSlot, logic="", hasLogic=False):
    moveCardL, moveCardR = {}, {}
    moveCardL["srcLoc"] = eng + "." + slot[0]
    moveCardR["srcLoc"] = eng + "." + slot[1]
    index = 0
    length = len(proprity)
    destsL, destsR = [], []
    while (index < length):
        propritySlot = proprity[index]
        value = freeSlot.get(eng, {}).get(propritySlot, {}).get(logic) if hasLogic else freeSlot.get(eng, {}).get(
            propritySlot)
        if freeSlot.get(eng, {}).get(propritySlot, {}) and value:
            dest = value
            ctrlLIndex = moveCardL["srcLoc"][5]
            value1, value2 = eng + "." + dest[0], eng + "." + dest[1]
            value1CtrlIndex = value1[5]
            valueL = value1 if ctrlLIndex == value1CtrlIndex else value2
            valueR = value2 if ctrlLIndex == value1CtrlIndex else value1
            destsL.append(valueL)
            destsR.append(valueR)
        index += 1
    moveCardL["dstLocList"] = destsL
    moveCardR["dstLocList"] = destsR
    moveCards.extend([moveCardL, moveCardR])
    logger.logInfo("moveCards is =" + str(moveCards))


def getLogicEng(diskId):
    '''
    根据硬盘框号判断所属逻辑引擎
    :param diskId:
    :return:
    '''
    if not diskId[MagicNum.ENCLOS_START_INDEX:MagicNum.ENCLOS_END_INDEX]:
        return ""
    encId = diskId[MagicNum.ENCLOS_START_INDEX:MagicNum.ENCLOS_END_INDEX]
    for k, v in diskIDEngDictForDorado18000.items():
        if encId in v:
            return k
    return ""
