# -*- coding: UTF-8 -*-
import cliUtil
import common
from common import UnCheckException

LANG = common.getLang(py_java_env)
LOGGER = common.getLogger(PY_LOGGER, __file__)
PY_JAVA_ENV = py_java_env
allCliRet = ""

def execute(cli):
    """
    @summary: 2600 V3 V300R005C00SPC300控制器BIOS版本为10.01.01T58且内存为DDR4的设备，因该批次的BIOS版本问题，存在系统下电风险。
    """
    try:
        # 检查系统版本
        isBugVersion = checkProductVersion(cli)
        if not isBugVersion:
            return (True, allCliRet, "")
        
        # 检查设备型号      
        isBugModel = checkProductModel(cli)
        if not isBugModel:
            return (True, allCliRet, "")

        # 检查控制器BIOS版本和BarCode
        isBugContrller = checkContrller(cli)
        if not isBugContrller:
             return (True, allCliRet, "")
         
        errMsg = common.getMsg(LANG, "ddr4.arm.board.bios.version")
        return (False, allCliRet, errMsg)

    except UnCheckException, unCheckException:
        LOGGER.logException(unCheckException)
        return (cliUtil.RESULT_NOCHECK, unCheckException.cliRet, unCheckException.errorMsg)

    except Exception, exception:
        LOGGER.logException(exception)
        return (cliUtil.RESULT_NOCHECK, allCliRet, common.getMsg(LANG, "query.result.abnormal"))


def checkProductVersion(cli):
    """
    @summary: 检查系统版本是否为问题版本
    @return: True 问题版本；False 非问题版本
    """
    # 获取系统版本
    flag, cliRet, errMsg, softwareVersion, _ = common.getVersion(cli, LANG)
    global allCliRet
    allCliRet = common.joinLines(allCliRet, cliRet)
    if flag != True:
        raise UnCheckException(errMsg, allCliRet)
    
    if softwareVersion == "V300R005C00SPC300":
        return True
    
    return False


def checkProductModel(cli):
    """
    @summary: 检查设备型号是否为问题型号
    @return: True 问题型号；False 非问题型号
    """
    # 获取产品型号
    flag, productModel ,cliRet, errMsg = cliUtil.getProductModelWithCliRet(cli, LANG)
    global allCliRet
    allCliRet = common.joinLines(allCliRet, cliRet)
    if flag != True:
        raise UnCheckException(errMsg, allCliRet)
    
    if productModel == "2600 V3":
        return True
    
    return False


BUG_BAR_CODES = [
                 "210305720310J2000001",
                "210305720310J2000002",
                "210305720310J1000563",
                "210305720310J1000564",
                "210305720310J1000561",
                "210305720310J1000562",
                "210305720310J1000559",
                "210305720310J1000560",
                "210305720310J1000491",
                "210305720310J1000492",
                "210305720310J1000477",
                "210305720310J1000478",
                "210305720310J1000584",
                "210305720310J1000585",
                "210305720310J1000582",
                "210305720310J1000583",
                "210305720310J1000540",
                "210305720310J1000539",
                "210305720310J1000537",
                "210305720310J1000538",
                "210305720310J1000535",
                "210305720310J1000536",
                "210305720310J1000472",
                "210305720310J1000471",
                "210305720310J1000469",
                "210305720310J1000470",
                "210305720310J1000467",
                "210305720310J1000468",
                "210305720310J1000449",
                "210305720310J1000450",
                "210305720310J1000444",
                "210305720310J1000443",
                "210305720310J1000437",
                "210305720310J1000438",
                "210305720310J1000433",
                "210305720310J1000434",
                "210305720310J1000578",
                "210305720310J1000579",
                "210305720310J1000580",
                "210305720310J1000581",
                "210305720310J1000576",
                "210305720310J1000577",
                "210305720310J1000553",
                "210305720310J1000554",
                "210305720310J1000551",
                "210305720310J1000552",
                "210305720310J1000549",
                "210305720310J1000550",
                "210305720310J1000543",
                "210305720310J1000544",
                "210305720310J1000520",
                "210305720310J1000519",
                "210305720310J1000517",
                "210305720310J1000518",
                "210305720310J1000489",
                "210305720310J1000490",
                "210305720310J1000451",
                "210305720310J1000452",
                "210305720310J2000041",
                "210305720310J2000042",
                "210305720310J1000567",
                "210305720310J1000568",
                "210305720310J1000515",
                "210305720310J1000516",
                "210305720310J1000513",
                "210305720310J1000514",
                "210305720310J1000511",
                "210305720310J1000512",
                "210305720310J1000509",
                "210305720310J1000510",
                "210305720310J1000507",
                "210305720310J1000508",
                "210305720310J1000505",
                "210305720310J1000506",
                "210305720310J1000503",
                "210305720310J1000504",
                "210305720310J1000501",
                "210305720310J1000502",
                "210305720310J1000425",
                "210305720310J1000426",
                "210305720310J1000061",
                "210305720310J1000391",
                "210305720310J2000056",
                "210305720310J2000055",
                "210305720310J2000058",
                "210305720310J2000057",
                "210305720310J2000017",
                "210305720310J2000016",
                "210305720310J2000014",
                "210305720310J2000015",
                "210305720310J2000009",
                "210305720310J2000010",
                "210305720310J1000596",
                "210305720310J1000597",
                "210305720310J1000574",
                "210305720310J1000575",
                "210305720310J1000573",
                "210305720310J1000572",
                "210305720310J1000566",
                "210305720310J1000565",
                "210305720310J1000527",
                "210305720310J1000528",
                "210305720310J1000456",
                "210305720310J1000455",
                "210305720310J1000465",
                "210305720310J1000466",
                "210305720310J1000499",
                "210305720310J1000500",
                "210305720310J1000497",
                "210305720310J1000498",
                "210305720310J1000495",
                "210305720310J1000496",
                "210305720310J1000493",
                "210305720310J1000494",
                "210305720110J1000395",
                "210305720110J1000396",
                "210305720110J2000036",
                "210305720110J2000037",
                "210305720110J2000006",
                "210305720110J2000005",
                "210305720110J2000004",
                "210305720110J2000003",
                "210305720110J1000603",
                "210305720110J1000602",
                "210305720110J1000579",
                "210305720110J1000580",
                "210305720110J1000545",
                "210305720110J1000544",
                "210305720110J1000543",
                "210305720110J1000542",
                "210305720110J1000529",
                "210305720110J1000530",
                "210305720110J1000596",
                "210305720110J1000601",
                "210305720110J2000047",
                "210305720110J2000046",
                "210305720110J2000027",
                "210305720110J2000028",
                "210305720110J2000018",
                "210305720110J2000017",
                "210305720110J2000015",
                "210305720110J2000016",
                "210305720110J1000619",
                "210305720110J1000618",
                "210305720110J1000584",
                "210305720110J1000585",
                "210305720110J1000566",
                "210305720110J1000565",
                "210305720110J1000540",
                "210305720110J1000541",
                "210305720110J1000524",
                "210305720110J1000523",
                "210305720110J1000455",
                "210305720110J1000456",
                "210305720110J1000453",
                "210305720110J1000454",
                "210305720110J1000451",
                "210305720110J1000452",
                "210305720110J1000445",
                "210305720110J1000446",
                "210305720110J1000448",
                "210305720110J1000447",
                "210305720110J1000449",
                "210305720110J1000450",
                "210305720110J1000444",
                "210305720110J1000443",
                "210305720110J1000441",
                "210305720110J1000442",
                "210305720110J1000439",
                "210305720110J1000440",
                "210305720110J1000437",
                "210305720110J1000438",
                "210305720110J1000436",
                "210305720110J1000435",
                "210305720110J1000433",
                "210305720110J1000434",
                "210305720110J1000432",
                "210305720110J1000431",
                "210305720110J1000430",
                "210305720110J1000429",
                "210305720110J1000428",
                "210305720110J1000427",
                "210305720110J1000426",
                "210305720110J1000425",
                "210305720110J1000423",
                "210305720110J1000424",
                "210305720110J1000422",
                "210305720110J1000421",
                "210305720110J1000420",
                "210305720110J1000419",
                "210305720110J1000417",
                "210305720110J1000418",
                "210305720110J1000416",
                "210305720110J1000415",
                "210305720110J1000413",
                "210305720110J1000414",
                "210305720110J1000411",
                "210305720110J1000412",
                "210305720110J1000410",
                "210305720110J1000409",
                "210305720110J1000407",
                "210305720110J1000408",
                "210305720110J1000405",
                "210305720110J1000406",
                "210305720110J1000404",
                "210305720110J1000403",
                "210305720110J1000401",
                "210305720110J1000402",
                "210305720110J1000399",
                "210305720110J1000400",
                "210305720110J1000398",
                "210305720110J1000397",
                "210305720110J1000393",
                "210305720110J1000394",
                "210305720110J1000391",
                "210305720110J1000392",
                "210305720110J1000389",
                "210305720110J1000390",
                "210305720110J1000387",
                "210305720110J1000388",
                "210305720110J1000381",
                "210305720110J1000382",
                "210305720110J1000380",
                "210305720110J1000379",
                "210305720110J1000374",
                "210305720110J1000373",
                "210305720110J1000371",
                "210305720110J1000372",
                "210305720110J1000369",
                "210305720110J1000370",
                "210305720110J1000368",
                "210305720110J1000367",
                "210305720110J1000366",
                "210305720110J1000365",
                "210305720110J1000363",
                "210305720110J1000364",
                "210305720110J1000362",
                "210305720110J1000361",
                "210305720110J1000359",
                "210305720110J1000360",
                "210305720110J1000358",
                "210305720110J1000357",
                "210305720110J1000355",
                "210305720110J1000356",
                "210305720110J1000353",
                "210305720110J1000354",
                "210305720110J1000352",
                "210305720110J1000351",
                "210305720110J1000349",
                "210305720110J1000350",
                "210305720110J1000347",
                "210305720110J1000348",
                "210305720110J1000346",
                "210305720110J1000345",
                "210305720110J1000344",
                "210305720110J1000343",
                "210305720110J1000342",
                "210305720110J1000341",
                "210305720110J1000340",
                "210305720110J1000339",
                "210305720110J1000338",
                "210305720110J1000337",
                "210305720110J1000336",
                "210305720110J1000335",
                "210305720110J1000333",
                "210305720110J1000334",
                "210305720110J1000331",
                "210305720110J1000332",
                "210305720110J1000329",
                "210305720110J1000330",
                "210305720110J1000327",
                "210305720110J1000328",
                "210305720110J1000326",
                "210305720110J1000325",
                "210305720110J1000324",
                "210305720110J1000323",
                "210305720110J1000321",
                "210305720110J1000322",
                "210305720110J1000319",
                "210305720110J1000320",
                "210305720110J1000318",
                "210305720110J1000317",
                "210305720110J1000316",
                "210305720110J1000315",
                "210305720110J1000311",
                "210305720110J1000312",
                "210305720110J1000310",
                "210305720110J1000309",
                "210305720110J1000308",
                "210305720110J1000307",
                "210305720110J1000306",
                "210305720110J1000305",
                "210305720110J1000304",
                "210305720110J1000303",
                "210305720110J1000300",
                "210305720110J1000299",
                "210305720110J1000298",
                "210305720110J1000297",
                "210305720110J1000295",
                "210305720110J1000296",
                "210305720110J1000293",
                "210305720110J1000294",
                "210305720110J1000291",
                "210305720110J1000292",
                "210305720110J1000289",
                "210305720110J1000290",
                "210305720110J1000287",
                "210305720110J1000288",
                "210305720110J1000286",
                "210305720110J1000285",
                "210305720110J1000283",
                "210305720110J1000284",
                "210305720110J1000282",
                "210305720110J1000281",
                "210305720110J1000280",
                "210305720110J1000279",
                "210305720110J1000277",
                "210305720110J1000278",
                "210305720110J1000276",
                "210305720110J1000275",
                "210305720110J1000273",
                "210305720110J1000274",
                "210305720110J1000272",
                "210305720110J1000271",
                "210305720110J1000270",
                "210305720110J1000269",
                "210305720110J1000268",
                "210305720110J1000267",
                "210305720110J1000265",
                "210305720110J1000266",
                "210305720110J1000264",
                "210305720110J1000263",
                "210305720110J1000261",
                "210305720110J1000262",
                "210305720110J1000260",
                "210305720110J1000259",
                "210305720110J1000258",
                "210305720110J1000257",
                "210305720110J1000256",
                "210305720110J1000255",
                "210305720110J1000253",
                "210305720110J1000254",
                "210305720110J1000246",
                "210305720110J1000245",
                "210305720110J1000225",
                "210305720110J1000226",
                "210305720110J1000223",
                "210305720110J1000224",
                "210305720110J1000222",
                "210305720110J1000221",
                "210305720110J1000220",
                "210305720110J1000219",
                "210305720110J1000218",
                "210305720110J1000217",
                "210305720110J1000210",
                "210305720110J1000209",
                "210305720110J1000208",
                "210305720110J1000207",
                "210305720310J1000475",
                "210305720310J1000476",
                "210305720310J1000013",
                "210305720310J1000014",
                "210305720310J1000474",
                "210305720310J1000473",
                "210305720310J1000586",
                "210305720310J1000587",
                 ]

def checkContrller(cli):
    """
    @summary: 检查控制器BIOS是否为问题版本，barCode是否为问题批次
    @return: True 问题版本； False 非问题版本
    """
    cmd = "show controller general"
    flag ,cliRet, errMsg = cliUtil.excuteCmdInCliMode(cli, cmd, True, LANG)
    global allCliRet
    allCliRet = common.joinLines(allCliRet, cliRet)
    if flag != True:
        raise UnCheckException(errMsg, allCliRet)
    
    controller = ""
    biosVersion = ""
    barCode = ""
    
    for line in cliRet.splitlines():
        if ":" in line and "controller" in line.lower():
            controller = line.split(":")[1].strip()
        if ":" in line and "bios version" in line.lower():
            biosVersion = line.split(":")[1].strip()
        if "=" in line and "barcode" in line.lower():
            barCode = line.split("=")[1].strip()
            
        if controller and biosVersion and barCode:
            if biosVersion == "10.01.01T58" and barCode in BUG_BAR_CODES:
                return True
            controller = ""
            biosVersion = ""
            barCode = ""
    
    return False