# -*- coding: UTF-8 -*-
import cliUtil
import common
import datetime, time

LANG = common.getLang(py_java_env)
LOGGER = common.getLogger(PY_LOGGER, __file__)

def execute(cli):
    """
         步骤1 以admin用户登录设备。
         步骤2 执行show bbu general命令，记录系统中所有BBU的ID。
         步骤3 执行show event命令，获取系统所有触发的事件信息。

    1 如果设备上存在BBU在4个月（30天/月）内没有在线测试，则检查结果为建议优化；
    """
    allCliRet = ""
    errMsg = ""
    flag = True
    #记录检查开始时间
    startTime = time.time()
    chkProductModel = ["2800 V3","5300 V3","5500 V3"]
    chkProductVersion = ["V300R001C00","V300R001C10","V300R001C10SPC100","V300R001C10SPC200","V300R001C20","V300R001C20SPC100","V300R001C20SPC200","V300R002C10","V300R002C10SPC100","V300R002C10SPC200","V300R003C00","V300R003C00SPC100"]
    try:
        #检查用户是否为只读用户（只读用户限制检查）
        loginUserName = py_java_env.get("devInfoMap").get("userName")
        LOGGER.logInfo("loginUserName is %s" % str(loginUserName))
        isSucc, cliRet, errMsg = checkLoginGuest(cli, loginUserName, LANG)
        allCliRet = cliRet
        if isSucc != True:
            return (isSucc, cliRet, errMsg)
        
        #查询产品型号
        result, productModel, cliRet, errMsg = cliUtil.getProductModelWithCliRet(cli, LANG)
        if result != True:
            if not result:
                return cliUtil.RESULT_NOCHECK, allCliRet, errMsg
            return result, allCliRet, errMsg  # 修改备注：查询产品型号失败
        
        #查看当前设备型号是否在指定的型号范围内
        if productModel not in chkProductModel: 
            return (True, allCliRet, "")
    
        #获取版本号
        resultList, currentVersionDictList, hotPatchVersionDictList = common.parse_upgradePackage(cli, LANG)
        cliRet += resultList[1]
        allCliRet += '\n' + cliRet
        if resultList[0] != True:
            errMsg = resultList[2]
            if not resultList[0]:
                return cliUtil.RESULT_NOCHECK, allCliRet, errMsg  # 修改备注：获取版本号失败
            return (resultList[0], allCliRet, errMsg)
        
        result, currentVersion, errInfo = common.getCurrentVersion(currentVersionDictList, LANG)
        if not result:
            errMsg = errInfo
            return (cliUtil.RESULT_NOCHECK, allCliRet, errMsg)  # 修改备注：获取版本信息失败

        #查看当前版本是否在指定的版本范围内
        if currentVersion not in chkProductVersion: 
            return (True, allCliRet, "")
        
        #获取当前系统时间
        isSucc, sysDate, cliRet = common.getCurSysDate(cli)
        if not isSucc:
            errMsg = common.getMsg(LANG, "query.system.date.abnormal")
            LOGGER.logNoPass("get system date abnormal.")
            return (cliUtil.RESULT_NOCHECK, allCliRet, errMsg)  # 修改备注：获取当前系统时间失败
        
        #获取当前设备上所有的BBU ID
        cmd = "show bbu general"
        LOGGER.logExecCmd(cmd)
        checkRet = cliUtil.excuteCmdInCliMode(cli, cmd, True, LANG)
        cliRet = checkRet[1]
        allCliRet += '\n' + cliRet
        if checkRet[0] != True:
            LOGGER.logSysAbnormal()
            errMsg = checkRet[2]
            if not checkRet[0]:
                return cliUtil.RESULT_NOCHECK, allCliRet, errMsg  # 修改备注：获取当前设备上所有的BBU ID失败
            return (checkRet[0], allCliRet, errMsg)
      
        cliRetLinesList = cliUtil.getHorizontalCliRet(cliRet)
        if len(cliRetLinesList) == 0:
            errMsg = common.getMsg(LANG, "cannot.get.bbu.info")
            LOGGER.logNoPass("Cannot get information about BBU")
            return (False, allCliRet, errMsg)
        
        bbuIdList = []
        for line in cliRetLinesList:
            bbuId = line.get("ID",'')
            if bbuId:
                bbuIdList.append(bbuId)
        LOGGER.logInfo("bbuIdList:" + str(bbuIdList))
        year, month, day =  map(int, sysDate.split('-'))
        startMonth = datetime.date(year, month, day) - datetime.timedelta(270) 
        objectType = '210'
        # 获取最近270天内的BBU是否在线测试事件
        cmd = "show event object_type=%s level=informational from_time=%s/00:00:00" % (objectType,startMonth.strftime('%Y-%m-%d'))
        cmd += "|filterRow column=Name predict=match value=.*Periodic\\sDischarge\\sTest.*"
        if currentVersion not in ["V300R003C00","V300R003C00SPC100"]:
            cmd = "show event level=informational from_time=%s/00:00:00" % startMonth.strftime('%Y-%m-%d')
            cmd += "|filterColumn include columnList=Sequence,Name|filterRow column=Name predict=match value=.*Periodic\\sDischarge\\sTest.*"

        isSucc, bbuEventCliRet, errMsg = cliUtil.excuteCmdTimeOutInCliMode(cli, cmd, True, LANG, 5*60)
        allCliRet += '\n' + bbuEventCliRet
        
        # 因数据量大，5min（用户可接受的时间）内未完成查询时不再做检查
        if "TOOLKIT_SEND_CMD_TIME_OUT" in bbuEventCliRet or isTimeOut(startTime):
            errMsg = common.getMsg(LANG, "get.event.timeout")
            return (cliUtil.RESULT_NOCHECK, allCliRet, errMsg)
        
        if isSucc != True:
            LOGGER.logSysAbnormal()
            if not isSucc:
                return cliUtil.RESULT_NOCHECK, allCliRet, errMsg  # 修改备注：获取最近270天内的BBU是否在线测试事件失败
            return (isSucc, allCliRet, errMsg)
        
        #获取所有与备电模块相关的事件信息
        eventSequenceList = getEventSequenceList(bbuEventCliRet)
        if len(eventSequenceList) > 0:
            
            #找出详细event中与"Periodic Discharge Test"相关的时间信息
            chkRet = getOnlineTestBBU(cli,eventSequenceList,LANG)
            allCliRet += chkRet[1]
            if chkRet[0]:
                testBBUIdList = chkRet[2]
                LOGGER.logInfo("testBBUIdList:" + str(testBBUIdList))
                #找出270天内没有进行在线测试的BBUID值
                noTestBbuIdList = list(set(bbuIdList).difference(set(testBBUIdList))) 
                if len(noTestBbuIdList) > 0 :
                    flag = cliUtil.RESULT_WARNING
                    errMsg = common.getMsg(LANG, "no.online.test.bbuinfo",",".join(noTestBbuIdList))
            else:
                errMsg = chkRet[3]
                # 修改备注：找出详细event中与"Periodic Discharge Test"相关的时间信息命令执行失败
                return cliUtil.RESULT_NOCHECK, allCliRet, errMsg
        else:
            flag = cliUtil.RESULT_WARNING
            errMsg = common.getMsg(LANG, "no.online.test.bbuinfo",",".join(bbuIdList))
            
        return (flag, allCliRet, errMsg)
        
    except Exception, exception:
        LOGGER.logException(exception)
        return (cliUtil.RESULT_NOCHECK, allCliRet, common.getMsg(LANG, "query.result.abnormal"))

def isTimeOut(startTime):
    '''
    @summary: 检查项是否执行超过5min
    '''
    if (time.time() - startTime) > 5 * 60:
        return True
    
    return False

def getOnlineTestBBU(cli,eventSequenceList,lang):
    
    bbuIdList = []
    allCliRet = ""
    for sequence in eventSequenceList:
        cmd = "show event sequence=" + sequence
        checkRet = cliUtil.excuteCmdInCliMode(cli, cmd, True, lang)
        cliRet = checkRet[1]
        allCliRet += '\n' + cliRet
        if checkRet[0] != True: 
            return False, allCliRet, bbuIdList, checkRet[2]

        bbuId = getBBUTestId(cliRet)
        if bbuId:
            bbuIdList.append(bbuId)
        else:
            LOGGER.logInfo("No have detailInfo in" + cmd)
    return True,allCliRet,list(set(bbuIdList)),''
      
def getEventSequenceList(cliRet):
    '''
    @summary: show event object_type=210 level=informational from_time=2016-11-30/00:00:00命令，获取event的Sequence值
    '''

    eventSequenceList = []

    eventDictList = cliUtil.getHorizontalCliRet(cliRet)
    if len(eventDictList) > 0:
        for eventDict in eventDictList:
            name = eventDict.get("Name","")
            sequence = eventDict.get("Sequence","")
            if "periodic discharge test" in name.lower():
                eventSequenceList.append(sequence)
    LOGGER.logInfo("eventSequenceList:" + str(eventSequenceList))
    return eventSequenceList

def getBBUTestId(cliRet):
    '''
    @summary: 返回show event sequence=XX,BBU在线测试事件中对应具体BBU的ID值
    @param cliRet
    @return: 将表格形式cli回显处理为以表头为key，以项值为键的字典集合,处理不正常时，返回空集合
    '''
    bbuId = ''
    cliRetLinesList = cliUtil.getVerticalCliRet(cliRet)
    if len(cliRetLinesList) == 0:
        return bbuId
    for retDict in cliRetLinesList:
        detailInfo = retDict.get("Detail","")
        if "periodic discharge test" in detailInfo:
            bbuList = detailInfo.split("(")[1].split(")")[0].split(",")
            encloureId = bbuList[0].split()[-1]
            bbuModuleId = "".join(bbuList[1].split()[2:])
            bbuId = encloureId + "." + bbuModuleId
            break
    return bbuId
    
def checkLoginGuest(cli, loginUserName, LANG):
    '''
    @summary: 检查用户是否为只读用户
    '''
    guestUserLevel = "Guest"
    cmd = "show user user_name=%s" % (loginUserName)
    isSuccess, cliRet, errMsg = cliUtil.excuteCmdInCliMode(cli, cmd, True, LANG)
    if isSuccess != True:
        LOGGER.logSysAbnormal()
        return isSuccess, cliRet, errMsg
    
    dictList = cliUtil.getHorizontalCliRet(cliRet)
    if len(dictList) == 0:
        errMsg = common.getMsg(LANG, "query.result.abnormal")
        LOGGER.logNoPass("Cannot get information about user")
        return (False, cliRet, errMsg)
         
    level = dictList[0].get("Level","")
        
    if level.upper() == guestUserLevel.upper():
        LOGGER.logNoPass("loginUser.name.level.guest.warning")
        return cliUtil.RESULT_NOCHECK, cliRet, common.getMsg(LANG, "loginUser.name.level.guest.warning")
    
    return True, cliRet, ""
