# coding:utf-8
from cbb.business.operate.fru.common.checkItem import compute_storage_common
from cbb.frame.checkitem.context_adapter import InspectContext
import common
import cliUtil
import common_utils

PY_JAVA_ENV = py_java_env
LANG = common.getLang(PY_JAVA_ENV)
LOGGER = common.getLogger(PY_LOGGER, __file__)
CTRL_A_PORT = ".A."
CTRL_B_PORT = ".B."
SWITCH_PORT = ["P0", "P1"]


def execute(cli):
    all_cli_ret = []
    err_msg_switch_port = check_switch_bond_port(cli, all_cli_ret)
    return not bool(err_msg_switch_port), "\n".join(all_cli_ret), "\n".join(err_msg_switch_port)


def check_switch_bond_port(cli, all_cli_ret):
    """
    检查switch 端口
    :param cli: ssh 连接
    :param all_cli_ret: 回文
    :return: 错误消息
    """
    err_msg = common_utils.get_err_msg(LANG, "compute.storage.switch.port.check.not.pass")
    # Switch 端口检查不通过
    cmd = "show port general physical_type=ETH"
    flag, ret, msg = cliUtil.excuteCmdInCliMode(cli, cmd, True, LANG)
    all_cli_ret.append(ret)
    if flag is not True:
        return err_msg
    res_list = cliUtil.getHorizontalCliRet(ret[str(ret).find("Switch Port:") :])
    all_link_up_list = filter_check_switch_port(res_list)
    if not all_link_up_list:
        return ""
    port_id_in_ctrl_a = filter_ctrl_check_switch_port(all_link_up_list, CTRL_A_PORT)
    port_id_in_ctrl_b = filter_ctrl_check_switch_port(all_link_up_list, CTRL_B_PORT)
    # 如果存在连接端口，但是A,B控任意控又没有连接，则存在不对称
    if not (port_id_in_ctrl_a and port_id_in_ctrl_b):
        return err_msg
    # 检查对称
    if not check_port_is_symmetry(
        port_id_in_ctrl_a, port_id_in_ctrl_b, CTRL_A_PORT, CTRL_B_PORT
    ) or not check_port_is_symmetry(port_id_in_ctrl_b, port_id_in_ctrl_a, CTRL_B_PORT, CTRL_A_PORT):
        return err_msg
    return ""


def check_port_is_symmetry(port_list_a, port_list_b, ctrl_a, ctrl_b):
    for port_id in port_list_a:
        if str(port_id).replace(ctrl_a, ctrl_b) not in port_list_b:
            return False
    return True


def filter_check_switch_port(port_list):
    return [
        port.get("ID")
        for port in port_list
        if port.get("ID").split(".")[-1] in SWITCH_PORT and port.get("Running Status") == "Link Up"
    ]


def filter_ctrl_check_switch_port(port_list, ctrl):
    return [port_id for port_id in port_list if ctrl in port_id]
