# -*- coding: UTF-8 -*-
import common
import cliUtil

LANG = common.getLang(py_java_env)
LOGGER = common.getLogger(PY_LOGGER, __file__)

def execute(cli):
    '''
    @summary: 检查当前设备型号和版本号，且是否包含4K盘
    '''
    
    cliRet = ""
    errMsg = ""
    flag = True
    
    #定义风险型号和版本号
    bugProduct_TV2 = ("S2600T", "S5500T", "S5600T", "S5800T", "S6800T")
    bugVersion_TV2 = ("V200R002C20", "V200R002C20SPC200", "V200R002C30")
    repairHotPatchDict_TV2 = {"V200R002C30":"V200R002C30SPH001"}
    bugProduct_V3 = ("5300 V3", "5500 V3", "5600 V3", "5800 V3", "6800 V3", "6900 V3")
    bugVersion_V3 = ("V300R001C10", "V300R001C10SPC100", "V300R001C10SPC200", "V300R001C20")
    repairHotPatchDict_V3 = {"V300R001C20":"V300R001C20SPH001"}
    bugProduct_18000 = ("HVS85T", "HVS88T", "18500", "18800", "18800F")
    bugVersion_18000 = ("V100R001C20", "V100R001C20SPC100", "V100R001C20SPC200", "V100R001C20LNLT01", "V100R001C20SPC300", "V100R001C30")
    repairHotPatchDict_18000 = {"V100R001C30":"V100R001C30SPH001"}
    
    #查询产品型号
    result, productModel, cliRet, errMsg = cliUtil.getProductModelWithCliRet(cli, LANG)
    if result != True:
        if not result:
            return cliUtil.RESULT_NOCHECK, cliRet, errMsg  # 修改备注：获取产品类型（getProductModelWithCliRet）失败
        return (result, cliRet, errMsg)
    if (productModel not in bugProduct_TV2) and\
        (productModel not in bugProduct_V3) and\
        (productModel not in bugProduct_18000) and\
        (productModel != "2800 V3"):
        return (cliUtil.RESULT_NOSUPPORT, cliRet, "")
    
    #获取版本号和补丁版本号，并判断是否为风险版本
    resultList, currentVersionDictList, hotPatchVersionDictList = common.parse_upgradePackage(cli, LANG)
    cliRet += resultList[1]
    if resultList[0] != True:
        return (cliUtil.RESULT_NOCHECK, cliRet, resultList[2])
    
    result, currentVersion, errInfo = common.getCurrentVersion(currentVersionDictList, LANG)
    if not result:
        errMsg += errInfo
        return (cliUtil.RESULT_NOCHECK, cliRet, errMsg)  # 修改备注：通过software信息字典列表获取版本信息（getCurrentVersion）失败，返回了False

    result, hotPatchVersion, errInfo = common.getHotPatchVersion(hotPatchVersionDictList, LANG)
    if not result:
        errMsg += errInfo
        # 修改备注：通过hotPatch信息字典列表获取补丁信息（getHotPatchVersion）失败，返回False，但是获取失败和补丁信息不一致未做区分
        return (cliUtil.RESULT_NOCHECK, cliRet, errMsg)
      
    #根据不同型号检查版本和热补丁是否符合要求
    if productModel in bugProduct_TV2:
        continueCheck = common.isRiskVersion(currentVersion, bugVersion_TV2, hotPatchVersion, repairHotPatchDict_TV2)
    elif productModel in bugProduct_V3:
        continueCheck = common.isRiskVersion(currentVersion, bugVersion_V3, hotPatchVersion, repairHotPatchDict_V3)
    elif productModel in bugProduct_18000:
        continueCheck = common.isRiskVersion(currentVersion, bugVersion_18000, hotPatchVersion, repairHotPatchDict_18000)
    #新增2800检查
    elif productModel == "2800 V3":
        continueCheck = isRiskVersion2800(currentVersion, hotPatchVersion)
                   
    if not continueCheck:
        return (True, cliRet, errMsg)
    
    #查询是否存在4K盘
    result, cmdRet, errInfo, diskSectorSizeDictList = common.getDiskSectorSize(cli, LANG)
    cliRet += cmdRet
    errMsg += errInfo
    if result != True:  # 修改备注：获取扇区大小（getDiskSectorSize）返回的不是True，不能用if not result判断
        return (result, cliRet, errMsg)
    
    result, is4KDiskIdList, errInfo = common.is4KDiskWithSectorSize(diskSectorSizeDictList,LANG)
    errMsg += errInfo
    if result:
        return (False, cliRet, errMsg)
    
    return (True, cliRet, errMsg)


def isRiskVersion2800(currentVersion, hotPatchVersion):
    '''
    @summary: 检查版本是否存在风险（2800的特殊检查方法）
    '''
    continueCheck = False
    if currentVersion.startswith("V300R001"):
        continueCheck = True
    elif currentVersion.startswith("V300R003") and currentVersion < "V300R003C00SPC100":
         continueCheck = True
    elif currentVersion == "V300R003C00SPC100" and hotPatchVersion < "V300R003C00SPH102":
        continueCheck = True
    else:
        continueCheck = False
        
    return continueCheck

                
                
                
        
        
        
        
    
    
    