# -*- coding: UTF-8 -*-
import cliUtil
import common
import config
from effective_capacity_check import ExpDiskCapacityCheck
from frameone.util import contextUtil
from frameone.rest import restData
from frameone.rest import restUtil
from cbb.business.operate.expansion import common as exp_common

lang = common.getLang(py_java_env)
logger = common.getLogger(PY_LOGGER, __file__)

hasVarErrCodeList = ["1073809960", "1073809963", "1073809959"]

# 进度总剩余时间
LIMIT_TIME = 120
# 进度刷新间隔
INTERVAL = 2


def execute(cli):
    '''
        扩容硬盘容量规格检查
    '''
    cli_ret_all = ""
    version_limit = "V300R002C00"
    exp_disk_list = common.getExpDiskListFromContextFilter(py_java_env)
    logger.logInfo("expDiskList is %s" % exp_disk_list)

    try:
        if not exp_disk_list:
            return cliUtil.RESULT_NOSUPPORT, "", ""

        # 进度条刷新
        common.threadUpProcess(py_java_env, LIMIT_TIME, INTERVAL, logger)
        # 进度开始
        common.inProcess(py_java_env)
        logger.logInfo("process Thread started!")

        ret, sys_version_list, __ = common.parse_upgradePackage(cli, lang)
        cli_ret = ret[1]
        if not ret[0]:
            return cliUtil.RESULT_NOCHECK, cli_ret, ret[2]

        ret, sys_version, err_info = \
            common.getCurrentVersion(sys_version_list, lang)
        logger.logInfo("current system version:%s" % (sys_version))
        if not ret:
            err_msg = err_info
            return cliUtil.RESULT_NOCHECK, cli_ret, err_msg
        if sys_version < version_limit:
            logger.logInfo("the current system version is not mentioned")
            return cliUtil.RESULT_NOSUPPORT, cli_ret, ""

        cli_ret_all += cli_ret
        # 获取硬盘域信息
        flag, cli_ret, err_msg, disk_domain_list = \
            common.getDiskDomainInfo(cli, lang)
        cli_ret_all += cli_ret
        if not flag:
            logger.logSysAbnormal()
            return cliUtil.RESULT_NOCHECK, cli_ret_all, err_msg

        # 硬盘域不存在返回不涉及
        if flag and not disk_domain_list:
            logger.logInfo("the disk domain is not exist")
            return cliUtil.RESULT_NOSUPPORT, cli_ret_all, ""
        logger.logInfo("diskDomainList is %s" % disk_domain_list)

        # 如果是双引擎系统，但只选择了一个引擎进行扩容评估，检查不通过
        exp_domain_eng_map = {}
        exp_info = py_java_env.get("expInfo")
        exp_mode_list = exp_info.getExpModeInfoList()
        logger.logInfo("The expInfo expModeList is %s" % str(exp_mode_list))
        if len(exp_mode_list) != 1:
            domain_eng_map = {}
            for an_exp_mode in exp_mode_list:
                an_exp_mode_array = an_exp_mode.split(":")
                domain_eng_map[an_exp_mode_array[1]] = domain_eng_map.get(
                    an_exp_mode_array[1], 0) + 1
            logger.logInfo(
                "The domainEngMap of expModeList is %s" % str(domain_eng_map))

            for line in exp_disk_list:
                exp_disk_dom_id = line.get("diskDomain")
                engine_id = line.get("logicEng")

                str_logic_eng_id = str(engine_id)

                if not exp_domain_eng_map.get(exp_disk_dom_id):
                    exp_domain_eng_map[exp_disk_dom_id] = [str_logic_eng_id]
                    continue

                if str_logic_eng_id not in exp_domain_eng_map[exp_disk_dom_id]:
                    tmp_exp_domain_eng_map_ary = exp_domain_eng_map.get(
                        exp_disk_dom_id)
                    tmp_exp_domain_eng_map_ary.append(str_logic_eng_id)
                    exp_domain_eng_map[
                        exp_disk_dom_id] = tmp_exp_domain_eng_map_ary
            logger.logInfo("The expDomainEngMap of expModeList is %s" % str(
                exp_domain_eng_map))
            check_flag = True
            for exp_disk_dom_id in exp_domain_eng_map.keys():
                if domain_eng_map.get(exp_disk_dom_id) != len(
                        exp_domain_eng_map.get(exp_disk_dom_id)):
                    logger.logNoPass(
                        "double engines system need to config on each engine")
                    err_msg += common.getMsg(lang,
                                             "expand.disk.dualengine.not.pass",
                                             exp_disk_dom_id)
                    check_flag = False
                    continue
            if not check_flag:
                return False, cli_ret_all, err_msg
        else:
            exp_disk_dom_id = exp_disk_list[0].get("diskDomain")
            engine_id = exp_disk_list[0].get("logicEng")
            exp_domain_eng_map[exp_disk_dom_id] = [engine_id]

        # 如果为双引擎系统，两个引擎新扩容硬盘数量不一致或者两个引擎新扩容硬盘容量不一致，检查不通过
        engine_disk_num_dict = {}
        engine_disk_capacity_dict = {}
        exp_disk_dom_id_ary = []
        for line in exp_disk_list:
            exp_disk_dom_id = line.get("diskDomain")
            engine_id = line.get("eng")
            disk_num = int(line.get("diskNum"))
            disk_capacity = str(line.get("diskCapacity"))
            capacity_unit = str(line.get("unit"))
            disk_capacity_2_gb = common.changUnit2GBLabelCap(
                disk_capacity + capacity_unit)
            engine_disk_num_dict[
                (exp_disk_dom_id, engine_id)] = engine_disk_num_dict.get(
                (exp_disk_dom_id, engine_id), 0) + disk_num
            engine_disk_capacity_dict[
                (exp_disk_dom_id, engine_id)] = engine_disk_capacity_dict.get(
                (exp_disk_dom_id, engine_id), 0) + disk_capacity_2_gb[
                                                    1] * disk_num
            exp_disk_dom_id_ary.append(exp_disk_dom_id)

        logger.logInfo("engineDiskNumDict is %s" % engine_disk_num_dict)
        logger.logInfo(
            "engineDiskCapacityDict is %s" % engine_disk_capacity_dict)

        for dom_id in set(exp_disk_dom_id_ary):
            engine_disk_num_in_domain = {}
            engine_disk_capacity_in_domain = {}
            for an_engine_disk in engine_disk_num_dict:
                if an_engine_disk[0] == dom_id:
                    tmp_dict = {an_engine_disk: engine_disk_num_dict.get(
                            an_engine_disk)}
                    engine_disk_num_in_domain.update(tmp_dict)
            logger.logInfo(
                "engineDiskNumInDomain is %s" % str(engine_disk_num_in_domain))
            if len(set(engine_disk_num_in_domain.values())) != 1:
                logger.logNoPass("the disk number of engines is inconsistent")
                err_msg = common.getMsg(lang, "expand.disk.number.not.pass")
                return False, cli_ret_all, err_msg
            for an_engine_disk in engine_disk_capacity_dict:
                if an_engine_disk[0] == dom_id:
                    tmp_dict = {an_engine_disk: engine_disk_capacity_dict.get(
                        an_engine_disk)}
                    engine_disk_capacity_in_domain.update(tmp_dict)
            logger.logInfo("engineDiskCapacityInDomain is %s" % str(
                engine_disk_capacity_in_domain))

            engine_disk_capacity_list_base_50gb_diff = \
                common.getDiskCapListBaseOn50GBDiff(
                    engine_disk_capacity_in_domain.values())
            logger.logInfo(
                "engineDiskCapacityListBase50GbDiff is %s"
                % engine_disk_capacity_list_base_50gb_diff)
            if len(set(engine_disk_capacity_list_base_50gb_diff)) != 1:
                logger.logNoPass(
                    "the disk capacity of engines is not consistent")
                err_msg = common.getMsg(lang, "expand.disk.capacity.not.pass")
                return False, cli_ret_all, err_msg

        # 下发接口的参数 & 数据持久化的参数 begin
        config_data_disk_num_dict = {}
        config_data_disk_cap_dict = {}
        config_data_disk_model_dict = {}
        config_data_disk_work_model_dict = {}
        for line in exp_disk_list:
            exp_disk_dom_id = line.get("diskDomain")
            engine_id = line.get("eng")
            disk_num = int(line.get("diskNum"))
            disk_capacity = str(line.get("diskCapacity"))
            capacity_unit = str(line.get("unit"))
            disk_model = str(line.get("diskModel"))
            disk_work_mode = line.get("diskWorkMode")
            disk_capacity_2_gb = common.changUnit2GBLabelCap(
                disk_capacity + capacity_unit)
            config_data_disk_num_dict[
                exp_disk_dom_id] = config_data_disk_num_dict.get(
                exp_disk_dom_id, 0) + disk_num
            if config_data_disk_cap_dict.get(exp_disk_dom_id, 0) == 0:
                config_data_disk_cap_dict[exp_disk_dom_id] = \
                    disk_capacity_2_gb[1]
            if config_data_disk_model_dict.get(exp_disk_dom_id, "") == "":
                config_data_disk_model_dict[exp_disk_dom_id] = disk_model
            if config_data_disk_work_model_dict.get(exp_disk_dom_id, "") == "":
                config_data_disk_work_model_dict[exp_disk_dom_id] = \
                    disk_work_mode
        logger.logInfo(
            "configDataDiskNumDict is %s" % config_data_disk_num_dict)
        logger.logInfo(
            "configDataDiskCapDict is %s" % config_data_disk_cap_dict)
        logger.logInfo(
            "configDataDiskModelDict is %s" % config_data_disk_model_dict)
        logger.logInfo(
            "configDataDiskWorkModelDict is %s"
            % config_data_disk_work_model_dict)

        config_persist_data = {}
        for a_dom_id in config_data_disk_num_dict.keys():
            a_persist_data = {}
            a_persist_data["domainId"] = a_dom_id
            a_persist_data["diskNum"] = config_data_disk_num_dict.get(a_dom_id)
            a_persist_data["diskCapacity"] = config_data_disk_cap_dict.get(
                a_dom_id)
            a_persist_data["engine"] = exp_domain_eng_map[a_dom_id]
            a_persist_data["diskModel"] = config_data_disk_model_dict[a_dom_id]
            a_persist_data["diskWorkMode"] = \
                config_data_disk_work_model_dict[exp_disk_dom_id]
            config_persist_data[a_dom_id] = a_persist_data
        # 下发接口的参数 & 数据持久化的参数 end

        # 获取版本号，判断16TB NVMe盘
        __, sys_ver, patch_ver, __, __ = common. \
            getProductVersionAndHotPatchVersion(cli, logger, lang)

        # 遍历硬盘域来检查
        for disk_domain_id in set(exp_disk_dom_id_ary):
            is_qry_succ, cli_ret, err_info, disk_in_domain_list = \
                common.getDiskDomainInfoById(cli, disk_domain_id, lang)
            cli_ret_all += cli_ret
            if not is_qry_succ:
                flag = False
                err_msg += err_info
                return cliUtil.RESULT_NOCHECK, cli_ret_all, err_msg

            # 获取硬盘域中的硬盘类型
            disk_type_list = [disk["Type"] for disk in disk_in_domain_list]
            logger.logInfo("diskTypeList is %s" % disk_type_list)

            # 根据硬盘域ID获取对应的新扩硬盘类型
            new_exp_disk_list = filter(
                lambda disk: disk.get("diskDomain") == disk_domain_id,
                exp_disk_list)
            logger.logInfo("newExpDiskList is %s" % new_exp_disk_list)

            new_disk_model_list = [disk.get("diskModel") for disk in
                                   new_exp_disk_list]
            logger.logInfo("diskModelList is %s" % new_disk_model_list)

            # 新扩容硬盘类型和已有硬盘域中的SSD硬盘类型(加密:SSDSED;非加密硬盘SSD等)不一致
            if len(set(disk_type_list)) == 1 and set(disk_type_list) != set(
                    new_disk_model_list):
                flag = False
                logger.logNoPass(
                    "the disk type of the system diskdomain"
                    " is not consistent with the expanding diskType")
                err_msg += common.getMsg(lang, "expand.disk.type.not.pass")
                continue

            # 获取新扩容硬盘容量
            new_disk_capacity_list = []
            for line in new_exp_disk_list:
                disk_capacity = str(line.get("diskCapacity"))
                capacity_unit = str(line.get("unit"))
                disk_capacity_gb = common.changUnit2GBLabel2DevCap(
                    disk_capacity + capacity_unit)
                new_disk_capacity_list.append(disk_capacity_gb[1])
            logger.logInfo("newCapacityList is %s" % new_disk_capacity_list)

            new_disk_capacity_list_base_50gb_diff = \
                common.getDiskCapListBaseOn50GBDiff(new_disk_capacity_list)
            logger.logInfo(
                "newDiskCapacityListBase50GbDiff is %s"
                % new_disk_capacity_list_base_50gb_diff)
            # 同一批次新扩容的硬盘容量不止一种,检查不通过
            if len(set(new_disk_capacity_list_base_50gb_diff)) != 1:
                flag = False
                logger.logNoPass(
                    "The capacity of new expand disk is not consistent")
                err_msg += common.getMsg(lang, "expand.disk.capacity.not.pass")
                continue

            # 通过调用接口方式
            context = contextUtil.getContext(py_java_env)
            disk_num = config_persist_data.get(disk_domain_id).get("diskNum")
            disk_work_mode = config_persist_data.get(disk_domain_id).get(
                "diskWorkMode")
            logger.logInfo("start to evaluate with interface")
            logger.logInfo(
                "diskDomainId:%s, diskNum:%s, diskCapacity:%s, diskWorkMode:%s"
                % (disk_domain_id, disk_num, int(disk_capacity_gb[1]),
                   disk_work_mode))
            exp_ret = expan_evalua_check_by_rest_inf(context, disk_domain_id,
                                                     disk_num,
                                                     int(disk_capacity_gb[1]),
                                                     disk_work_mode)
            logger.logInfo("expRet=%s" % exp_ret)
            ret_code = \
                restUtil.CommonRest.getRecordValue(
                    exp_ret,
                    restData.RestCfg.ExpandEvaluaCheck.RET_CODE)
            ret_value = \
                restUtil.CommonRest.getRecordValue(
                    exp_ret,
                    restData.RestCfg.ExpandEvaluaCheck.SHOW_DATA)
            if ret_code != "0":
                flag = False
                logger.logNoPass(
                    "Invoke expan_evalua_check_by_rest_inf return error")
                errorKey = "expdd.errorcode." + ret_code
                if ret_code == "100990":
                    err_msg += \
                        get_100990_err_msg(sys_ver, patch_ver, exp_disk_list)
                    continue

                if ret_code in hasVarErrCodeList:
                    err_msg += common.getMsg(lang, errorKey, (ret_value))
                else:
                    err_msg += common.getMsg(lang, errorKey)
                continue

        # 检查不通过，返回
        if not flag:
            return flag, cli_ret_all, err_msg

        # 检查通过，持久化配置数据
        # 扩容配置持久化数据
        logger.logInfo(
            "part 1 check pass, start to persist config data: %s"
            % config_persist_data)
        exp_common.save_expansion_config_data(config_persist_data, logger)
        exp_common.get_expansion_config_data(logger)

        # 扩容后有效容量超规格检查
        check = ExpDiskCapacityCheck(py_java_env, cli, lang, logger)
        check.execute()
        check_flag, check_cli_ret, err_msg = check.get_eval_result()
        cli_ret_all = common.joinLines(cli_ret_all, check_cli_ret)
        return check_flag, cli_ret_all, err_msg

    except Exception as exception:
        logger.logException(exception)
        err_msg = common.getMsg(lang, "query.result.abnormal")
        return cliUtil.RESULT_NOCHECK, cli_ret_all, err_msg
    finally:
        common.finishProcess(py_java_env)
        logger.logInfo("finish process!")


def expan_evalua_check_by_rest_inf(context, domain_id, disk_num, disk_capacity,
                                   disk_work_mode):
    # 下发扩容评估命令
    uri_param_dict = restUtil.CommonRest.getUriParamDict(
        restData.RestCfg.OBJ.EXPANSION_EVAL)
    rest = contextUtil.getRest(context)
    disk_num_list = []
    disk_num_list.append(str(disk_num))
    disk_capacity_list = []
    disk_capacity_list.append(str(disk_capacity))
    try:
        tmp_dict = {"ID": domain_id,
                    "diskNumList": disk_num_list,
                    "diskCapacityList": disk_capacity_list,
                    "diskWorkMode": disk_work_mode}
        record = restUtil.CommonRest.execCmd(rest, uri_param_dict,
                                             tmp_dict,
                                             restData.RestCfg.RestMethod.POST)
        ret_data = restUtil.CommonRest.getData(record)
        logger.logInfo(
            "The retData of expan_evalua_check_by_rest_inf is : %s" % ret_data)
        return ret_data[0]
    except Exception as e:
        err_args = e.args
        err_code = err_args[0] if err_args else "no code"
        logger.logInfo(
            "expan_evalua_check_by_rest_inf throws except, errCode is : %s"
            % err_code)
    finally:
        try:
            if rest:
                rest.close()
            logger.logInfo("conn close success!")
        except Exception as e:
            logger.logInfo("conn close except:%s" % str(e))


def get_100990_err_msg(sys_ver, patch_ver, exp_disk_list):
    """
    V300R002C10SPC100不支持16TB NVMe SSD（发货15.36TB）评估
    :param sys_ver: 系统版本
    :param patch_ver: 补丁版本
    :param exp_disk_list:
    :return:
    """

    solution_ver = {"V300R002C10SPC100": "V300R002C10SPH112"}
    patch = solution_ver.get(sys_ver)
    # 不是问题版本直接返回
    if not patch:
        msg = common.getMsg(lang, "expdd.errorcode.100990")
        return msg

    for exp in exp_disk_list:
        disk_capacity = str(exp.get("diskCapacity"))
        capacity_unit = str(exp.get("unit"))
        disk_model = str(exp.get("diskModel"))
        disk_capacity_label = disk_capacity + capacity_unit
        if disk_model in \
                [config.DiskType.NVMe_SSD, config.DiskType.NVMe_SSD_SED] \
                and disk_capacity_label in ["15.36TB", "15360GB"]:
                if patch_ver and (patch_ver == "--" or patch_ver < patch):
                    msg = common.getMsg(lang, "expdd.errorcode.100990.patch",
                                        args=patch)
                    return msg

    msg = common.getMsg(lang, "expdd.errorcode.100990")
    return msg
