# -*- coding: UTF-8 -*-
import cliUtil
import common

LANG = common.getLang(py_java_env)
LOGGER = common.getLogger(PY_LOGGER, __file__)

def execute(cli):
    '''
        硬盘链路状态检查：
                如果不存在相应的记录表示正常，否则表示存在单链路的硬盘。
    '''
    flag = True
    cliRet4SmallCard = "" #小卡时的CLI回显信息
    cliRet4BigCard = "" #大卡时的CLI回显信息
    errMsg = ""

    try:
        #单控场景不涉及硬盘链单路状态检查
        isSiglePdtModel, cliRet = common.isSigleModelNew(cli, LANG)
        if isSiglePdtModel:
            return (cliUtil.RESULT_NOSUPPORT, cliRet, "")
        
        #小卡环境
        cmd4SmallCard = "show disk general|filterColumn include columnList=Multipathing,ID|filterRow column=Multipathing predict=match value=A\\|B\\|C\\|D"
        LOGGER.logExecCmd(cmd4SmallCard)
        ret4SmallCard = cliUtil.excuteCmdInCliMode(cli, cmd4SmallCard, True, LANG)
        
        if ret4SmallCard[0] != True: 
            LOGGER.logSysAbnormal()
            return ret4SmallCard
            
        #大卡环境
        cmd4BigCard = "show disk general|filterColumn include columnList=Multipathing,ID|filterRow column=Multipathing predict=match value=(\\\\([A-D],\\\\s([A-Z0-9]+).R\\\\d.P\\\\d\\\\),{0,1}){1,}\\|(\\\\([A-D],\\\\s([A-Z0-9]+).L\\\\d.P\\\\d\\\\),{0,1}){1,}"
        LOGGER.logExecCmd(cmd4BigCard)
        ret4BigCard = cliUtil.excuteCmdInCliMode(
            cli, cmd4BigCard, True, LANG, cliUtil.endWithSignToAdmin
        )
        
        if ret4BigCard[0] != True: 
            LOGGER.logSysAbnormal()
            return ret4BigCard
        
        cliRet4SmallCard = ret4SmallCard[1]
        cliRet4BigCard = ret4BigCard[1]
        if cliUtil.queryResultWithNoRecord(cliRet4SmallCard) and cliUtil.queryResultWithNoRecord(cliRet4BigCard):
            return (True, cliRet4SmallCard+cliRet4BigCard, errMsg)
        
        linesList4SmallCard = cliUtil.getHorizontalCliRet(cliRet4SmallCard)
        linesList4BigCard = cliUtil.getHorizontalCliRet(cliRet4BigCard)
        
        if len(linesList4SmallCard) == 0 and len(linesList4BigCard) == 0:
            errMsg = common.getMsg(LANG, "cannot.get.multipathing.info")
            LOGGER.logNoPass("Cannot get information about Multipathing")
            return (cliUtil.RESULT_NOCHECK, cliRet4SmallCard+cliRet4BigCard, errMsg)  # 修改备注：解析回显失败导致列表长度为0

        #打印出小卡情况下存在的单链路硬盘信息
        for line in linesList4SmallCard:
            flag = False
            diskId = line.get("ID")
            errMsg += common.getMsg(LANG, "disk.path.single", diskId)
            LOGGER.logNoPass("The path of Disk [%s] is single" % diskId)
        
        #打印出大卡情况下存在的单链路硬盘信息		
        for line in linesList4BigCard:
            flag = False
            diskId = line.get("ID")
            errMsg += common.getMsg(LANG, "disk.path.single", diskId)
            LOGGER.logNoPass("The path of Disk [%s] is single" % diskId)
            
        if flag:
            LOGGER.logPass()
            
        return (flag, cliRet4SmallCard+cliRet4BigCard, errMsg)
        
    except Exception, exception:
        LOGGER.logException(exception)
        return (cliUtil.RESULT_NOCHECK, cliRet4SmallCard+cliRet4BigCard, common.getMsg(LANG, "query.result.abnormal"))
