# -*- coding: UTF-8 -*-
import cliUtil
import common
import expandconfig
import expTask

lang = common.getLang(py_java_env)
logger = common.getLogger(PY_LOGGER, __file__)

#进度总剩余时间
LIMIT_TIME = 120
#进度刷新间隔
INTERVAL = 2


def execute(cli):
    '''
        扩容硬盘容量规格检查
    '''
    flag = True
    cliRetAll = ""
    errMsg = ""
    
    
    expConfigObj = expandconfig.ExpandConfig(py_java_env)
    
    try:
        #进度条刷新
        common.threadUpProcess(py_java_env, LIMIT_TIME, INTERVAL, logger)
        #进度开始
        common.inProcess(py_java_env)
        logger.logInfo("process Thread started!")
        
        expDiskInfoDict = expConfigObj.getExpDiskInfo()
        logger.logInfo("The expDiskInfoDict is %s" % expDiskInfoDict)
        
        expDiskList = common.getExpDiskList(expDiskInfoDict)
        logger.logInfo("The expDiskList is %s" % expDiskList)
        
        # 遍历扩容硬盘域
        for expDisks in expDiskList:
            checkTask = expTask.ExpTask(py_java_env, cli, expDisks, logger)
            checkTask.execute()
            result, msg, cliRet = checkTask.getResult()
            cliRetAll += cliRet
            if result != True:
                errMsg += msg
                flag = result if flag and result else False

        return flag, cliRetAll, errMsg

    except Exception, exception:
        logger.logException(exception)
        return cliUtil.RESULT_NOCHECK, cliRetAll, common.getMsg(lang,"query.result.abnormal")
    finally:
        common.finishProcess(py_java_env)
        logger.logInfo("finish process!")
        


