import cliUtil
import common
import collections
""" 
@version: Toolkit V200R006C00
@time: 2019/08/30 
@file: check_item_service_hypermetro_remote_replication_link_v5r7c60.py 
@function: 
@modify: 
"""
LANG = common.getLang(py_java_env)
LOGGER = common.getLogger(PY_LOGGER, __file__)
CHECK_SHARECARD_DEVICE_TYPE_SET = {'6810 V5', '6800 V5', '6800K V5', '6810F V5', '6800F V5', '18510 V5', '18500 V5',
                                    '18500K V5', '18510F V5', '18500F V5', '18810 V5', '18800 V5', '18800K V5',
                                    '18810F V5', '18800F V5'}
CHECK_SHARECARD_DEVICE_VERSION_MIN = 'V500R007C60SPC200'
DEVICE_FC_REMOTE_LINK = 'FC'
DEVICE_ISCSI_REMOTE_LINK = 'iSCSI'
DEVICE_IP_REMOTE_LINK = 'IP'
FC_LINK_LOCAL_PORT = 'Local Port ID'


def execute(cli):
    '''
    脚本入口
    :param cli:
    :return:
    '''
    all_cli_ret = ''
    try:
        # 设备是否有双活远端设备
        flag, cli_ret, err_msg, id_list = get_remote_device_id(cli)
        all_cli_ret = common.joinLines(all_cli_ret, cli_ret)
        if flag is not True:
            return flag, all_cli_ret, err_msg
        if not id_list:
            return True, all_cli_ret, ''

        # 是否是使用共享卡设备
        execute_flag, use_share_card, system_cli_ret, error_message = check_use_share_card_by_system(cli)
        all_cli_ret = common.joinLines(all_cli_ret, system_cli_ret)
        if execute_flag is not True:
            return cliUtil.RESULT_NOCHECK, all_cli_ret, error_message

        # 校验双活复制链路
        check_flag, check_cli_ret, check_error = check_link_info(cli, id_list, use_share_card)
        all_cli_ret = common.joinLines(all_cli_ret, check_cli_ret)
        return check_flag, all_cli_ret, check_error
    except common.UnCheckException as e:
        LOGGER.logException(e)
        return cliUtil.RESULT_NOCHECK, e.cliRet, e.errorMsg
    except Exception as exception:
        LOGGER.logException(exception)
        return cliUtil.RESULT_NOCHECK, all_cli_ret, common.getMsg(LANG, "query.result.abnormal")


def check_use_share_card_by_system(cli):
    '''
    设备型号为CHECK_SHARECARD_DEVICE_TYPE_SET内，系统版本为Kunpeng V500R007C60SPC200及以上，则进行共享卡判断，否则进行控制器判断
    :param cli:
    :return: 获取信息是否成功，是否是使用共享卡的设备，系统信息cli回显，
    '''
    sys_check_cli_ret = ''
    # 获取设备型号
    sys_flag, product_model, sys_cli_ret, error_msg = cliUtil.getProductModelWithCliRet(cli, LANG)
    sys_check_cli_ret = common.joinLines(sys_check_cli_ret, sys_cli_ret)
    if sys_flag is not True:
        return cliUtil.RESULT_NOCHECK, False, sys_check_cli_ret, error_msg
    # 获取设备版本
    version_flag, version_cli_ret, error_msg, product_version = common.getProductVersionByUpgradePackage(cli, LANG)
    sys_check_cli_ret = common.joinLines(sys_check_cli_ret, version_cli_ret)
    if version_flag is not True:
        return cliUtil.RESULT_NOCHECK, False, sys_check_cli_ret, error_msg

    # 检查是否为Kunpeng
    if 'kunpeng' not in sys_check_cli_ret.lower():
        LOGGER.logInfo('not share-card-supported device:not kunpeng version')
        return True, False, sys_check_cli_ret, ''
    # 检查设备版本
    if product_version < CHECK_SHARECARD_DEVICE_VERSION_MIN:
        LOGGER.logInfo('not share-card-supported device:version lower than V5R7C60SPC200')
        return True, False, sys_check_cli_ret, ''
    # 检查设备型号
    if product_model not in CHECK_SHARECARD_DEVICE_TYPE_SET:
        LOGGER.logInfo('not share-card-supported device:not high device type')
        return True, False, sys_check_cli_ret, ''
    return True, True, sys_check_cli_ret, ''


def get_remote_device_link(cli, device_id):
    '''
        获取每个双活远端设备链路情况
    :param cli:
    :param device_id:
    :return:获取信息是否成功，cli回显，错误信息，链路集合
    '''
    remote_device_link = collections.OrderedDict()
    cmd = "show remote_device link remote_device_id=%s" % str(device_id)
    flag, cli_ret, err_rsg = cliUtil.excuteCmdInCliMode(cli, cmd, True, LANG)
    if flag is not True:
        LOGGER.logSysAbnormal()
        return False, cli_ret, err_rsg, remote_device_link
    fc_link_index = cli_ret.find("FC Link:")
    iscsi_link_index = cli_ret.find("iSCSI Link:")
    ip_link_index = cli_ret.find("IP Link:")
    if fc_link_index == -1 or iscsi_link_index == -1:
        LOGGER.logNoPass("Cannot get information about Link")
        return False, cli_ret, common.getMsg(LANG, "cannot.get.link.info", device_id), remote_device_link
    # FC Link
    fc_link_cli_ret = cli_ret[fc_link_index:iscsi_link_index]
    fc_cli_ret_dict_list = cliUtil.getHorizontalCliRet(fc_link_cli_ret)
    # ISCSI Link
    iscsi_link_cli_ret = cli_ret[iscsi_link_index:ip_link_index]
    iscsi_cli_ret_dict_list = cliUtil.getHorizontalCliRet(iscsi_link_cli_ret)
    # IP Link
    ip_link_cli_ret = cli_ret[ip_link_index:]
    ip_link_cli_ret_dict_list = cliUtil.getHorizontalCliRet(ip_link_cli_ret)
    # 封装所有链路数据
    remote_device_link[DEVICE_FC_REMOTE_LINK] = fc_cli_ret_dict_list
    remote_device_link[DEVICE_ISCSI_REMOTE_LINK] = iscsi_cli_ret_dict_list
    remote_device_link[DEVICE_IP_REMOTE_LINK] = ip_link_cli_ret_dict_list
    return True, cli_ret, '', remote_device_link


def check_link_info(cli, id_list, use_share_card):
    '''
    循环每个远端双活设备，获取链路信息，检查链路冗余情况
    若设备为CHECK_SHARECARD_DEVICE_TYPE_SET中版本为V500R007C60SPC200及以上，则为高端共享卡设备
    高端共享卡设备FC链路需按端口所在引擎检查是否每个绑定引擎下均存在至少两条位于不同接口卡的正常远程复制链路
    其他设备形态，或高端共享卡设备中非FC链路检查链路中每个控制器是否均绑定了至少一条状态正常的复制链路到同一个远端设备的相同控制器。
    :param cli:
    :param id_list:
    :param use_share_card:是否为使用共享卡设备
    :return:
    '''
    all_cli_ret = ''
    check_flag = True
    all_error_msg = ''
    controller_id_list = []
    for device_id in id_list:
        device_error = ''
        execute_flag, execute_cli_ret, execute_error, remote_device_link = get_remote_device_link(cli, device_id)
        all_cli_ret = common.joinLines(all_cli_ret, execute_cli_ret)
        if execute_flag is not True:
            uncheck_msg = common.getMsg(
                LANG, "hypermetro.remote.replication.link.v5r7c60.remotedevice.showlink.error", device_id)
            raise common.UnCheckException(uncheck_msg, all_cli_ret)
        # 循环组网类型
        for device_link_type in remote_device_link:
            current_link_type = common.getMsg(
                LANG, "hypermetro.remote.replication.link.v5r7c60.remotedevice.linktype.error", device_link_type)
            type_all_link_info = remote_device_link.get(device_link_type)
            # 获取正常远程复制链路
            type_link_info = get_normal_remote_link_check(type_all_link_info)
            # 若该组网中存在链路，但无正常远端复制链路，记录异常
            if type_all_link_info and not type_link_info:
                check_flag = cliUtil.RESULT_WARNING
                device_error = common.joinLines(device_error, current_link_type)
                device_error = common.joinLines(device_error, common.getMsg(LANG,
                          "hypermetro.remote.replication.link.v5r7c60.nolink"))
                continue
            # 若存储为支持共享卡存储，则对FC链路执行共享卡模式检查冗余
            if use_share_card and device_link_type == DEVICE_FC_REMOTE_LINK:
                ret, check_res, tmp_error = check_fc_link_high_end(
                    cli, current_link_type, device_link_type, type_link_info)
                device_error = common.joinLines(device_error, tmp_error)
                device_error += common.getMsg(LANG, "hyper.metro.remote.rep.link.not.pass.fc.sugg", device_id) if \
                    check_res is not True else ""
                check_flag = check_res if check_res is not True else check_flag
                all_cli_ret = common.joinLines(all_cli_ret, ret)
            else:
                cli_ret, check_res, tmp_error = check_mid_dev_single_link(
                    cli, controller_id_list, current_link_type, type_link_info)
                all_cli_ret = common.joinLines(all_cli_ret, cli_ret)
                device_error = common.joinLines(device_error, tmp_error)
                device_error += common.getMsg(LANG, "hyper.metro.remote.rep.link.not.pass.iscsi.sugg", device_id) if \
                    check_res is not True else ""
                check_flag = check_res if check_res is not True else check_flag

        if device_error:
            all_error_msg = common.joinLines(all_error_msg, common.getMsg(
                LANG, "hypermetro.remote.replication.link.v5r7c60.remotedevice.error", device_id))
            all_error_msg = common.joinLines(all_error_msg, device_error)
    return check_flag, all_cli_ret, all_error_msg


def check_mid_dev_single_link(cli, controller_id_list, current_link_type, type_link_info):
    all_cli_ret = ""
    err_msg = ""
    check_flag = True
    # 否则该种类链路将按控制器检查冗余
    if len(type_link_info) > 1 and not controller_id_list:
        flag, controller_id_list, err_msg, cli_ret = cliUtil.getControllerIdListWithRet(cli, LANG)
        all_cli_ret = common.joinLines(all_cli_ret, cli_ret)
        if flag is not True:
            raise common.UnCheckException(err_msg, all_cli_ret)
    # 检查链路是否在存储所有控制器下均冗余
    controller_flag, controller_error_message = check_link_by_controller(type_link_info, controller_id_list)
    if controller_flag == cliUtil.RESULT_NOCHECK:
        raise common.UnCheckException(controller_error_message, all_cli_ret)
    if not controller_flag:
        check_flag = cliUtil.RESULT_WARNING
        err_msg = common.joinLines(err_msg, current_link_type)
        err_msg = common.joinLines(err_msg, controller_error_message)
    return all_cli_ret, check_flag, err_msg


def check_fc_link_high_end(cli, current_link_type, device_link_type, type_link_info):
    all_cli_ret = ""
    err_msg = ""
    check_flag = True
    execute_flag, cli_ret, execute_error = stuff_port_id(cli, device_link_type, type_link_info)
    all_cli_ret = common.joinLines(all_cli_ret, cli_ret)
    if execute_flag is not True:
        raise common.UnCheckException(execute_error, all_cli_ret)
    share_card_link_check_flag, share_card_link_check_error = check_share_card_link(type_link_info)
    if share_card_link_check_flag == cliUtil.RESULT_NOCHECK:
        raise common.UnCheckException(share_card_link_check_error, all_cli_ret)
    if not share_card_link_check_flag:
        check_flag = cliUtil.RESULT_WARNING
        err_msg = common.joinLines(err_msg, current_link_type)
        err_msg = common.joinLines(err_msg, share_card_link_check_error)
    return all_cli_ret, check_flag, err_msg


def check_link_by_controller(cli_ret_dict_list, controller_id_list):
    """
        @summary: 配置了双活功能的设备，建议每个控制器绑定至少两个远程复制链路，
        每个控制器均绑定了至少一条状态正常的复制链路到同一双活远端设备的相同控制器，否则将影响可靠性。
        """
    all_err_msg = ''
    all_check_result = True
    try:
        contr_band_link_num_dict, contr_remote_contr_band_link_num_dict = get_contrbandlink_num(cli_ret_dict_list)
        flag_check_contr, err_msg = check_contrbandlink_num(contr_band_link_num_dict, controller_id_list)
        all_err_msg = common.joinLines(all_err_msg, err_msg)
        if flag_check_contr is not True:
            all_check_result = False
        flag_contr_remote_contr, err_msg = check_contr_remote_contrbandlink_num(contr_remote_contr_band_link_num_dict,
                                                                                controller_id_list)
        all_err_msg = common.joinLines(all_err_msg, err_msg)
        if flag_contr_remote_contr is not True:
            all_check_result = False
        return all_check_result, all_err_msg
    except Exception, exception:
        LOGGER.logException(exception)
        return cliUtil.RESULT_NOCHECK, common.getMsg(LANG, "query.result.abnormal")


def check_share_card_link(type_link_info):
    '''
    检查共享卡模式下双活复制远程设备FC链路冗余情况：
    检查标准：
    1.每个引擎下至少需要两条正常链路
    2.链路需要分布在至少两个接口卡上
    :param type_link_info:
    :return:
    '''
    # 按引擎数据分类
    share_card_link_check_flag = True
    share_card_link_check_error = ''
    share_card_engine_dict = {}
    for link_info in type_link_info:
        port_info = link_info.get(FC_LINK_LOCAL_PORT)
        port_name = port_info.get(FC_LINK_LOCAL_PORT)
        engine_name, interface_card_name = get_port_engine_and_interface_card(port_name)
        if not engine_name or not interface_card_name:
            return cliUtil.RESULT_NOCHECK, common.getMsg(LANG,
                                               "hypermetro.remote.replication.link.v5r7c60.remotedevice.linkport.error")
        if engine_name not in share_card_engine_dict.keys():
            share_card_engine_dict[engine_name] = []
        share_card_engine_dict[engine_name].append(interface_card_name)
    # 按远程复制链路分布引擎检查链路
    for link_engine_name in share_card_engine_dict.keys():
        link_interface_card_name_list = share_card_engine_dict[link_engine_name]
        # 每个引擎是否绑定链路
        if len(link_interface_card_name_list) < 1:
            share_card_link_check_flag = False
            share_card_link_check_error = common.joinLines(share_card_link_check_error, common.getMsg(LANG,
                                                    "hypermetro.remote.replication.link.v5r7c60.fclink.noredundantlink",
                                                                                                      link_engine_name))
            continue
        # 每个引擎至少需要绑定两条正常链路
        if len(link_interface_card_name_list) < 2:
            share_card_link_check_flag = False
            share_card_link_check_error = common.joinLines(share_card_link_check_error, common.getMsg(LANG,
                                              "hypermetro.remote.replication.link.v5r7c60.fclink.missingredundantlink",
                                                                                                      link_engine_name))
            continue
        # 链路至少分布在两个接口卡上
        if len(set(link_interface_card_name_list)) < 2:
            share_card_link_check_flag = False
            share_card_link_check_error = common.joinLines(share_card_link_check_error, common.getMsg(LANG,
                                               "hypermetro.remote.replication.link.v5r7c60.fclink.missinginterfacecard",
                                                                                                      link_engine_name))
    return share_card_link_check_flag, share_card_link_check_error


def get_normal_remote_link_check(type_link_info):
    '''
    获取组网链路中正常的远程复制链路
    :param type_link_info:
    :return:
    '''
    normal_link_info = []
    for link_info in type_link_info:
        if is_normal_remote_link(link_info):
            normal_link_info.append(link_info)
    return normal_link_info


def is_normal_remote_link(link_info):
    '''
    是否是正常的远程复制链路
    :param link_info:
    :return: True，False
    '''
    is_in_remote_device = link_info.get("In Remote Device")
    remote_device_id = link_info.get("Remote Device ID")
    # 控制器与远端设备绑定的状态正常的远程复制链路
    # 非远程复制链路
    if is_in_remote_device != "Yes" or remote_device_id == '--' or not remote_device_id:
        return False
    health_status = link_info.get("Health Status")
    running_status = link_info.get("Running Status")
    # 非正常状态链路
    if health_status != "Normal" or running_status != "Link Up":
        return False
    return True


def get_port_engine_and_interface_card(port_name):
    '''
    解析共享卡模式下端口信息，获取所在引擎和所在接口卡名称：
    以.分割，得到数组第一位为引擎名称，倒数第二位为接口卡名称
    若端口ID不包含.则引擎名称和接口卡名称均为空
    若分割后数组长度小于四，则接口卡名称为空
    :param port_name:
    :return:引擎名称，接口卡名称
    '''
    if '.' not in port_name:
        LOGGER.logError('port id [%s] do not have point' % port_name)
        return '', ''
    port_info = port_name.split('.')
    engine_name = port_info[0]
    if len(port_info) < 4:
        LOGGER.logError('port id [%s] style is not A.B.C.D' % port_name)
        return engine_name, ''
    return engine_name, port_info[len(port_info) - 2]


def stuff_port_id(cli, link_type, type_link_info):
    '''
    获取链路所在端口详细信息，将其重新封装入链路信息集合内，key为Local Port ID
    :param cli:
    :param link_type: 组网类型，FC,iSCSI，IP
    :param type_link_info: 链路信息
    :return: 是否执行成功，执行命令，异常信息，端口详情
    '''
    all_cli_ret = ''
    for link_info in type_link_info:
        port_id = link_info.get('ID')
        cmd = "show remote_device link link_type=%s link_id=%s" % (str(link_type), str(port_id))
        flag, cli_ret, err_msg = cliUtil.excuteCmdInCliMode(cli, cmd, True, LANG)
        all_cli_ret = common.joinLines(all_cli_ret, cli_ret)
        if flag is not True:
            LOGGER.logSysAbnormal()
            return flag, all_cli_ret, err_msg
        port_info_list = cliUtil.getVerticalCliRet(cli_ret)
        if len(port_info_list) > 0:
            link_info[FC_LINK_LOCAL_PORT] = port_info_list[0]
    return True, all_cli_ret, ''


def get_remote_device_id(cli):
    """
    @summary: 检查设备上是否存在双活特性,记录双活远端设备ID（Remote Device ID）
    @return: CLI命令执行结果，CLI回显，错误提示信息，双活远端设备ID
    """
    id_list = []
    cmd = "show hyper_metro_domain general|filterColumn include columnList=Remote\sDevice\sID"
    flag, cli_ret, err_msg = cliUtil.excuteCmdInCliMode(cli, cmd, True, LANG)
    if flag is not True:
        LOGGER.logSysAbnormal()
        return flag, cli_ret, err_msg, id_list

    if cliUtil.queryResultWithNoRecord(cli_ret):
        return True, cli_ret, '', id_list

    ret_list = cliUtil.getHorizontalNostandardCliRet(cli_ret)
    if not ret_list:
        return cliUtil.RESULT_NOCHECK, cli_ret, common.getMsg(LANG, "query.result.abnormal"), id_list
    for retDict in ret_list:
        remote_device_id = retDict.get("Remote Device ID")
        if remote_device_id == '--' or not remote_device_id:
            continue
        id_list.append(remote_device_id)

    return True, cli_ret, '', id_list


def get_contrbandlink_num(cli_ret_dict_list):
    """
    @summary: 获取控制器到远程设备状态正常的复制链路数量，控制器到远端设备相同控制器绑定的正常的链路数量
    @return: (是否获取成功，CLI回显，CLI执行失败的原因，控制器与远端设备绑定的正常的链路数量，
    控制器与远端设备相同控制器绑定的正常的链路数量)
    """
    contr_band_link_num_dict = {}
    contr_remote_contr_band_link_num_dict = {}
    LOGGER.logInfo("getContrBandLinkNum cli_ret_dict_list:%s" % cli_ret_dict_list)
    for cli_ret_dict in cli_ret_dict_list:
        LOGGER.logInfo("cli_ret_dict:%s" % cli_ret_dict)
        remote_device_id = cli_ret_dict.get("Remote Device ID")
        # 控制器与远端设备绑定的状态正常的远程复制链路
        controller = cli_ret_dict.get("Local Controller")
        remote_controller = cli_ret_dict.get("Remote Controller")

        tmp_dict = contr_band_link_num_dict.get(remote_device_id, {})
        contr_band_link_num_dict[remote_device_id] = tmp_dict
        tmp_dict_contr = contr_remote_contr_band_link_num_dict.get(remote_device_id, {})
        contr_remote_contr_band_link_num_dict[remote_device_id] = tmp_dict_contr

        link_num = tmp_dict.get(controller, 0)
        tmp_dict[controller] = link_num + 1
        contr_band_link_num_dict[remote_device_id] = tmp_dict

        link_num_contr = tmp_dict_contr.get(controller, 0)
        if controller == remote_controller:
            tmp_dict_contr[controller] = link_num_contr + 1
        else:
            tmp_dict_contr[controller] = link_num_contr
        contr_remote_contr_band_link_num_dict[remote_device_id] = tmp_dict_contr

    return contr_band_link_num_dict, contr_remote_contr_band_link_num_dict


def check_contrbandlink_num(contr_band_link_num_dict, contro_id_list):
    """
    @summary: 检查每个控制器是否均绑定了至少两条状态正常的远程复制链路到同一双活远端设备
    """
    err_msg = ''
    LOGGER.logInfo("contrBandLinkNumDict:%s" % contr_band_link_num_dict)
    for remote_device_id in contr_band_link_num_dict:
        ctrl_link_dict = contr_band_link_num_dict.get(remote_device_id, {})
        for ctrl_id in contro_id_list:
            if ctrl_link_dict.get(ctrl_id, 0) < 2:
                err_msg += common.getMsg(LANG, "contor.band.remote.replication.link.less.2", (ctrl_id, remote_device_id))
    if err_msg:
        return cliUtil.RESULT_WARNING, err_msg
    return True, ''


def check_contr_remote_contrbandlink_num(contr_remote_contr_band_link_num_dict, contro_id_list):
    """
    @summary: 检查每个控制器是否均绑定了至少一条状态正常的复制链路到同一双活远端设备的相同控制器
    """
    err_msg = ''
    for remote_device_id in contr_remote_contr_band_link_num_dict:
        ctrl_link_dict = contr_remote_contr_band_link_num_dict.get(remote_device_id, {})
        for ctrl_id in contro_id_list:
            if ctrl_link_dict.get(ctrl_id, 0) < 1:
                err_msg += common.getMsg(LANG, "contor.band.remote.replication.link.less.1",
                                         (ctrl_id, remote_device_id, ctrl_id))
    if err_msg:
        return cliUtil.RESULT_WARNING, err_msg

    return True, ''
