# -*- coding: UTF-8 -*-
"""
@desc: NetLogonEX开关检查
@date: 2021.1.26
"""


from cbb.business.checkitems.net_log_on_ex_enable_check import (
    NetLogEnableCheck,
)
from cbb.frame.checkitem.context_adapter import InspectContext

import common
from cliUtil import (RESULT_NOCHECK, enterCliModeFromSomeModel)


PY_JAVA_ENV = py_java_env
JAVA_LOGGER = PY_LOGGER
LANG = common.getLang(PY_JAVA_ENV)
LOGGER = common.getLogger(JAVA_LOGGER, __file__)


def execute(cli):
    """
    NetLogonEX开关检查
    :param cli:
    :return:
    """

    tool_context = InspectContext(PY_JAVA_ENV, cli)
    context_inspect = tool_context.get_context()
    context_inspect["logger"] = JAVA_LOGGER
    context_inspect["mem_version"] = str(PY_JAVA_ENV.get(
        "devInfo").getProductVersion())
    context_inspect["product_mode"] = str(PY_JAVA_ENV.get(
        "devInfo").getDeviceType())
    net_log_check = NetLogEnableCheck(context_inspect)

    try:
        flag, msg = net_log_check.check()
        LOGGER.logInfo("net log check error vstore:{}".format(
            net_log_check.error_list))
        res_flag, ret, msg = tool_context.get_result(
            flag, msg, net_log_check.get_origin_info())
        return res_flag, ret, msg

    except Exception as e:
        LOGGER.logError(str(e))
        return (
            RESULT_NOCHECK,
            net_log_check.get_origin_info(),
            common.getMsg(LANG, "query.result.abnormal"),
        )
    finally:
        # 退出到cli模式
        ret = enterCliModeFromSomeModel(cli, LANG)
        LOGGER.logInfo("enter cli mode from some model {}".format(ret))
        # 退出失败后为不影响后续检查项重新连接cli

        if not ret[0]:
            common.reConnectionCli(cli, LOGGER)
