# -*- coding: UTF-8 -*-
import cliUtil
import common
import traceback
from common import UnCheckException

LANG = common.getLang(py_java_env)
LOGGER = common.getLogger(PY_LOGGER, __file__)
LINK_TYPE_FC = "FC"
LINK_TYPE_ISCSI = "iSCSI"
PORT_TYPE_FC = "FC"
PORT_TYPE_ETH = "ETH"
ALL_CLI_RET = ""


def execute(cli):
    '''
    前端主机端口与复制端口是否共用
    '''
    try:
        errMsg = ''
        uncheckErrMsg = ''
        #获取复制链路信息
        fcLinkIds, iscsiLinkIds = getRemoteDeviceLink(cli)
        LOGGER.logInfo("fcLinkIds : %s" % fcLinkIds)
        LOGGER.logInfo("iscsiLinkIds : %s" % iscsiLinkIds)

        #获取复制链路的FC端口信息
        fcPortInfoDict, failedFcLinkIdList = getRepLinkPort(cli, LINK_TYPE_FC, fcLinkIds)
        LOGGER.logInfo("fcPortInfoDict : %s" % fcPortInfoDict)

        # 获取复制链路的ISCSI端口信息
        iscsiPortInfoDict, failedIscsiLinkIdList = getRepLinkPort(cli, LINK_TYPE_ISCSI, iscsiLinkIds)
        LOGGER.logInfo("iscsiPortInfoDict : %s" % iscsiPortInfoDict)

        #获取复制链路FC端口占用信息
        occupiedFcPortInfoDict, failedFcInitList = getInitiatorInfoDict(cli, PORT_TYPE_FC, fcPortInfoDict)
        LOGGER.logInfo("occupiedFcPortInfoDict : %s" % occupiedFcPortInfoDict)

        # 获取复制链路ISCSI端口占用信息
        occupiedEthPortInfoDict, failedEthInitList = getInitiatorInfoDict(cli, PORT_TYPE_ETH, iscsiPortInfoDict)
        LOGGER.logInfo("occupiedEthPortInfoDict : %s" % occupiedEthPortInfoDict)

        #获取仲裁链路信息
        quorumPortIdDict = getQuorumServerLink(cli)
        LOGGER.logInfo("quorumPortIdDict : %s" % quorumPortIdDict)

        #获取仲裁链路端口占用信息
        occupiedQuoPortInfoDict, failedQuoInitList = getInitiatorInfoDict(cli, PORT_TYPE_ETH, quorumPortIdDict)
        LOGGER.logInfo("occupiedQuoPortInfoDict : %s" % occupiedQuoPortInfoDict)

        # 复制端口和主机端口共用
        for portId in occupiedFcPortInfoDict:
            if occupiedFcPortInfoDict[portId]:
                errMsg += common.getMsg(LANG, "port.for.host.and.other.replication.link.port.occupied",
                                        (",".join(fcPortInfoDict.get(portId, [])), portId))
        for portId in occupiedEthPortInfoDict:
            if occupiedEthPortInfoDict[portId]:
                errMsg += common.getMsg(LANG, "port.for.host.and.other.replication.link.port.occupied",
                                        (",".join(iscsiPortInfoDict.get(portId, [])), portId))

        # 仲裁链路和主机端口共用
        for portId in occupiedQuoPortInfoDict:
            if occupiedQuoPortInfoDict[portId]:
                errMsg += common.getMsg(LANG, "port.for.host.and.other.quorum.link.port.occupied",
                                        (",".join(quorumPortIdDict.get(portId, [])), portId))

        # 仲裁链路和复制链路共用端口
        repPortList = []
        repFcPortList = occupiedFcPortInfoDict.keys()
        repIscsiPortList = occupiedEthPortInfoDict.keys()
        repPortList.extend(repFcPortList)
        repPortList.extend(repIscsiPortList)
        quorPortList = quorumPortIdDict.keys()

        for portId in quorPortList:
            if portId in repFcPortList:
                errMsg += common.getMsg(LANG, "port.for.host.and.other.repAndQuorum.link.port.occupied",
                                        (",".join(fcPortInfoDict.get(portId, [])),
                                         ",".join(quorumPortIdDict.get(portId, [])), portId))

            if portId in repIscsiPortList:
                errMsg += common.getMsg(LANG, "port.for.host.and.other.repAndQuorum.link.port.occupied",
                                        (",".join(iscsiPortInfoDict.get(portId, [])),
                                         ",".join(quorumPortIdDict.get(portId, [])), portId))

        uncheckErrMsg = ''
        failedFcLinkIdList.extend(failedIscsiLinkIdList)

        failedQuoInitList.extend(failedFcInitList)
        failedQuoInitList.extend(failedEthInitList)

        if failedFcLinkIdList:
            uncheckErrMsg += common.getMsg(LANG, "failed.query.replication.link.ports", ",".join(failedFcLinkIdList))

        if failedQuoInitList:
            uncheckErrMsg += common.getMsg(LANG, "failed.query.link.ports", ",".join(failedQuoInitList))

        if errMsg:
            errMsg += uncheckErrMsg
            return cliUtil.RESULT_WARNING, ALL_CLI_RET, errMsg + common.getMsg(LANG, "replication.link.sugg")

        if uncheckErrMsg:
            return cliUtil.RESULT_NOCHECK, ALL_CLI_RET, uncheckErrMsg

        return True, ALL_CLI_RET, errMsg

    except UnCheckException, unCheckException:
        LOGGER.logError(str(traceback.format_exc()))
        LOGGER.logInfo("UnCheckException, errMsg: %s" % unCheckException.errorMsg)
        if unCheckException.flag == False:
            return (cliUtil.RESULT_NOCHECK, unCheckException.cliRet, unCheckException.errorMsg)

        return (unCheckException.flag, unCheckException.cliRet, unCheckException.errorMsg)

    except:
        LOGGER.logError(str(traceback.format_exc()))
        return (cliUtil.RESULT_NOCHECK, ALL_CLI_RET, common.getMsg(LANG, "query.result.abnormal"))

def getQuorumServerLink(cli):
    """
    获取仲裁链路信息
    :param cli:
    :return:
    """
    global ALL_CLI_RET
    quorumPortIdDict = {}
    cmd = "show quorum_server_link general"
    flag, cliRet, errMsg = cliUtil.excuteCmdTimeOutInCliMode(cli, cmd, True, LANG, 3 * 60)
    ALL_CLI_RET = common.joinLines(ALL_CLI_RET, cliRet)
    LOGGER.logInfo("flag: %s" % flag)
    if flag is False:
        raise UnCheckException(errMsg, ALL_CLI_RET)

    if not cliUtil.hasCliExecPrivilege(cliRet):
        return quorumPortIdDict

    if cliUtil.queryResultWithNoRecord(cliRet):
        return quorumPortIdDict

    cliRetLinesList = cliUtil.getHorizontalCliRet(cliRet)
    for rec in cliRetLinesList:
        portId = rec.get("Local Port")
        linkId = rec.get("Link ID")
        if portId:
            linkIds = quorumPortIdDict.get(portId, [])
            linkIds.append(linkId)
            quorumPortIdDict[portId] = linkIds

    return quorumPortIdDict


def getDeviceLinkIds(linkMapList):
    """
    获取在远端设备里的链路
    :param linkMapList:
    :return:
    """
    linkIds = []
    for linkMap in linkMapList:
        if linkMap.get("In Remote Device") == "Yes":
            linkIds.append(linkMap.get("ID"))
    return linkIds


def getRemoteDeviceLink(cli):
    """
    获取远程复制链路信息
    :param cli:
    :return:
    """
    global ALL_CLI_RET
    fcLinkIds = []
    iscsiLinkIds = []
    cmd = "show remote_device link"
    resultStatus, cliRet, errMsg = cliUtil.excuteCmdTimeOutInCliMode(cli, cmd, False, LANG, 3 * 60)
    ALL_CLI_RET = common.joinLines(ALL_CLI_RET, cliRet)
    if resultStatus != True:
        raise UnCheckException(errMsg, ALL_CLI_RET, resultStatus)

    if not cliUtil.hasCliExecPrivilege(cliRet):
        return fcLinkIds, iscsiLinkIds

    if len(cliRet.splitlines()) <= 4 or "command executed successful" in cliRet.lower():
        return fcLinkIds, iscsiLinkIds

    fcLinkRet = cliRet[:cliRet.find("ISCSI Link:")]
    iscsiLinkRet = cliRet[cliRet.find("ISCSI Link:"):]
    fcLinkIds = getDeviceLinkIds(cliUtil.getHorizontalCliRet(fcLinkRet))
    iscsiLinkIds = getDeviceLinkIds(cliUtil.getHorizontalCliRet(iscsiLinkRet))
    return fcLinkIds, iscsiLinkIds


def getRepLinkPort(cli, linkType, linkIds):
    """
    获取远程复制端口信息
    :param cli:
    :param linkType:
    :param linkIds:
    :return:
    """
    global ALL_CLI_RET
    portInfoDict = {}
    failedLinkIdList = []
    for linkId in linkIds:
        localPortId = ''
        linkDetailCmd = "show remote_device link link_type=" + linkType + " link_id=" + linkId
        resultStatus, cliRet, errMsg = cliUtil.excuteCmdTimeOutInCliMode(cli, linkDetailCmd, True, LANG, 3 * 60)
        ALL_CLI_RET = common.joinLines(ALL_CLI_RET, cliRet)
        if resultStatus is False:
            failedLinkIdList.append(linkId)
            continue

        if resultStatus is not True:
            if not cliUtil.hasCliExecPrivilege(cliRet):
                return portInfoDict, failedLinkIdList

            failedLinkIdList.append(linkId)
            continue

        if "Local Port ID" not in cliRet:
            LOGGER.logNoPass("executed command to query linkID %s 's %s port id but failed." % (linkId, linkType))
            failedLinkIdList.append(linkId)
            continue

        for line in cliRet.splitlines():
            if "Local Port ID" in line and len(line.split(":")) > 1:
                localPortId = line.split(":")[1].strip()
                break

        if not localPortId or localPortId == "--":
            LOGGER.logNoPass("failed to parse link %s's local port id about %s" % (linkId, linkType))
            failedLinkIdList.append(linkId)
            continue

        linkIdList = portInfoDict.get(localPortId, [])
        linkIdList.append(linkId)
        portInfoDict[localPortId] = linkIdList

    return portInfoDict, failedLinkIdList


def getInitiatorInfoDict(cli, portType, portInfoDict):
    """
    获取端口占用情况信息
    :param cli:
    :param portType:
    :param portInfoDict:
    :return:
    """
    global ALL_CLI_RET
    occupiedPortInfoDict = {}
    failedPortList = []
    LOGGER.logInfo("getInitiatorInfoDict portInfoDict : %s, portType:%s" % (portInfoDict, portType))
    for portId in portInfoDict:
        portInitiatorCmd = "show port initiator port_type=" + portType + " port_id=" + portId
        resultStatus, cliRet, errMsg = cliUtil.excuteCmdTimeOutInCliMode(cli, portInitiatorCmd, True, LANG, 3 * 60)
        ALL_CLI_RET = common.joinLines(ALL_CLI_RET, cliRet)
        if resultStatus is False:
            failedPortList.append(portId)
            continue

        if resultStatus is not True:
            if not cliUtil.hasCliExecPrivilege(cliRet):
                return occupiedPortInfoDict, failedPortList

            failedPortList.append(portId)
            continue

        if not cliUtil.hasCliExecPrivilege(cliRet):
            return occupiedPortInfoDict, failedPortList

        portInitiatorDicts = cliUtil.getHorizontalCliRet(cliRet)
        occupiedPortInfoDict[portId] = False
        for portInitiatorDict in portInitiatorDicts:
            if portInitiatorDict.get("Free", "").lower() == "no":
                LOGGER.logInfo("found occupied port %s" % portId)
                occupiedPortInfoDict[portId] = True
                break

    return occupiedPortInfoDict, failedPortList
