# -*- coding: UTF-8 -*-
import cliUtil
import common

LANG = common.getLang(py_java_env)
LOGGER = common.getLogger(PY_LOGGER, __file__)

def execute(cli):
    '''
        远端LUN路径状态检查： 
        Status为Running，并且Path Priority取值非Unavailable时表示正常，其它情况均属于不正常状态。
    '''
    flag = True
    cliRet = ""
    errMsg = ""

    try:
        cmd = "show remote_lun path_status|filterRow column=Status predict=not predict2=equal_to value=Running logicOp=or column=Path\sPriority predict=equal_to value=Unavailable"
        LOGGER.logExecCmd(cmd)
        checkRet = cliUtil.excuteCmdInDeveloperMode(cli, cmd, True, LANG)
        if checkRet[0] != True:
            LOGGER.logSysAbnormal()
            return checkRet
        
        cliRet = checkRet[1]
        if cliUtil.queryResultWithNoRecord(cliRet):
            return (True, cliRet, errMsg)
        
        cliRetLinesList = cliUtil.getHorizontalCliRet(cliRet)
        if len(cliRetLinesList) == 0:
            flag = False
            errMsg = common.getMsg(LANG, "cannot.get.remote.lun.info")
            LOGGER.logNoPass("Cannot get information about remote LUN")
        
        elif len(cliRetLinesList) > 0:
            flag = False
            errMsg = common.getMsg(LANG, "remote.lun.path.status.abnormal")
            LOGGER.logNoPass("The path status of remote LUN is abnormal")
            
        if flag:
            LOGGER.logPass()
              
        return (flag, cliRet, errMsg)
        
    except Exception, exception:
        LOGGER.logException(exception)
        return (cliUtil.RESULT_NOCHECK, cliRet, common.getMsg(LANG, "query.result.abnormal"))
