# -*- coding: UTF-8 -*-
import cliUtil
import common

LANG = common.getLang(py_java_env)
LOGGER = common.getLogger(PY_LOGGER, __file__)

def execute(cli):
    '''
        远端LUN单链路状态检查：
                如果不存在LUN单链路的记录表示正常，否则属于不正常状态。
    '''
    flag = True
    cliRet = ""
    errMsg = ""

    try:
        cmd = "show remote_lun single_link|filterRow column=Is\sSingle\sLink predict=equal_to value=Yes"
        LOGGER.logExecCmd(cmd)
        checkRet = cliUtil.excuteCmdInDeveloperMode(cli, cmd, True, LANG)
        if checkRet[0] != True:
            LOGGER.logSysAbnormal()
            return checkRet
        
        cliRet = checkRet[1]
        if cliUtil.queryResultWithNoRecord(cliRet):
            return (True, cliRet, errMsg)
        
        cliRetLinesList = cliUtil.getHorizontalCliRet(cliRet)
        if len(cliRetLinesList) == 0:
            flag = False
            errMsg = common.getMsg(LANG, "cannot.get.remote.lun.info")
            LOGGER.logNoPass("Cannot get information about remote LUN")
        
        elif len(cliRetLinesList) > 0:
            flag = False
            errMsg = common.getMsg(LANG, "remote.lun.status.single")
            LOGGER.logNoPass("Cannot get information about Is Single Link")
            
        if flag:
            LOGGER.logPass()
            
        return (flag, cliRet, errMsg)
        
    except Exception, exception:
        LOGGER.logException(exception)
        return (cliUtil.RESULT_NOCHECK, cliRet, common.getMsg(LANG, "query.result.abnormal"))
