# -*- coding:utf-8 -*-
import cliUtil
import common
import traceback
from common import UnCheckException
from config import parallel_connected_3DC_version, parallel_connected_3DC_version_dorado, \
    parallel_connected_3DC_pass_version, DORADO_DEVS
from cbb.frame.cli import cli_with_cache

LANG = common.getLang(py_java_env)
LOGGER = common.getLogger(PY_LOGGER, __file__)
PY_JAVA_ENV = py_java_env
ALL_CLI_RET = ''
ALL_ERRMSG_NO_CHECK = ''
ALL_ERRMSG_NO_PASS = ''


def execute(cli):
    """
    步骤1：以admin用户登录设备；
    步骤2：执行show system general查看设备版本号；
    步骤3：执行show remote_replication general |filterRow column=Replication\sMode predict=match value=Synchronous |filterColumn include columnList=ID，记录同步远程复制ID LIST（PAIR ID）；
    步骤4：执行show remote_replication general remote_replication_id=PAIR ID|filterRow column=Is\sPrimary predict=equal_to value=Yes |filterColumn include columnList=Local\sLUN\sID，获取Local LUN ID的值(同步远程复制的主LUN ID)；
    步骤5：执行show lun general lun_id=LUN ID|filterColumn include columnList=Remote\sReplication\sID(s)，记录该LUN上远程复制的个数。
    检查标准：
    步骤2中如果是以下版本之一：
    V300R001C20SPC200+SPH211；
    V300R003C00SPC100+SPH110；
    V300R003C10SPC100+SPH118；
    V300R003C20SPC200+SPH213；
    V300R005C00SPC300+SPH308；
    V300R006C00SPC100+SPH111；
    V500R007C00SPC100+SPH105；
    V500R007C10+SPH005；
    Dorado V300R001C01SPC100+SPH105；
    Dorado V300R001C21SPC100+SPH107则检查通过，否则继续向下检查；
    步骤3中如果不存在同步远程复制配置则检查通过，否则继续向下检查；
    步骤4中如果不存在同步远程复制的主LUN，则检查通过，否则继续向下检查；
    步骤5中如果只有一个远程复制配置则检查通过，如果有两个远程复制则检查不通过。
    :param cli:
    :return:
    """
    global ALL_CLI_RET, ALL_ERRMSG_NO_CHECK, ALL_ERRMSG_NO_PASS
    try:
        # 刷新进度条
        common.refreshProcess(PY_JAVA_ENV, 1, LOGGER)
        flag, software_version, hot_patch_version, no_support_msg \
            = check_product_info(cli)
        LOGGER.logInfo('software_version : %s, hot_patch_version : %s' % (software_version, hot_patch_version))
        if not flag:
            return cliUtil.RESULT_NOSUPPORT, no_support_msg, ''
        common.refreshProcess(PY_JAVA_ENV, 10, LOGGER)
        flag = check_product_patch(software_version, hot_patch_version)
        if flag:
            return True, ALL_CLI_RET, ''
        common.refreshProcess(PY_JAVA_ENV, 20, LOGGER)
        flag, err_msg, remote_replication_ids = get_remote_replication_ids(cli)
        LOGGER.logInfo('remote_replication_ids : %s' % remote_replication_ids)
        if flag != True:
            return flag, ALL_CLI_RET, common.joinLines(err_msg, ALL_ERRMSG_NO_CHECK)
        common.refreshProcess(PY_JAVA_ENV, 30, LOGGER)
        local_lun_ids = get_local_lun_ids(cli, remote_replication_ids)
        LOGGER.logInfo('local_lun_ids : %s' % local_lun_ids)
        if not local_lun_ids:
            if ALL_ERRMSG_NO_CHECK:
                return cliUtil.RESULT_NOCHECK, ALL_CLI_RET, ALL_ERRMSG_NO_CHECK
            return True, ALL_CLI_RET, ''
        common.refreshProcess(PY_JAVA_ENV, 65, LOGGER)
        check_remote_replication_num(cli, local_lun_ids)
        if ALL_ERRMSG_NO_PASS:
            return False, ALL_CLI_RET, common.joinLines(ALL_ERRMSG_NO_PASS, ALL_ERRMSG_NO_CHECK)
        if ALL_ERRMSG_NO_CHECK:
            return cliUtil.RESULT_NOCHECK, ALL_CLI_RET, ALL_ERRMSG_NO_CHECK
        return True, ALL_CLI_RET, ''
    except UnCheckException, un_check_exception:
        LOGGER.logInfo(u'UnCheckException, err_msg: %s' % un_check_exception.errorMsg)
        return un_check_exception.flag, un_check_exception.cliRet, un_check_exception.errorMsg
    except:
        LOGGER.logError(traceback.format_exc())
        return cliUtil.RESULT_NOCHECK, ALL_CLI_RET, common.getMsg(LANG, 'query.result.abnormal')


def check_remote_replication_num(cli, local_lun_ids):
    """
    执行show lun general lun_id=LUN ID|filterColumn include columnList=Remote\sReplication\sID(s)，记录该LUN上远程复制的个数
    :param cli:
    :param local_lun_ids:
    :return:
    """
    global ALL_CLI_RET, ALL_ERRMSG_NO_CHECK, ALL_ERRMSG_NO_PASS
    step_process = 0
    current_process = 65
    if len(local_lun_ids) != 0:
        step_process = int((100 - current_process) / len(local_lun_ids))
    if step_process == 0:
        step_process = 1
    for local_lun_id in local_lun_ids:
        if current_process >= 99:
            common.refreshProcess(PY_JAVA_ENV, 99, LOGGER)
        else:
            current_process = common.refreshProcessByStep(current_process, step_process, PY_JAVA_ENV, LOGGER)
        cmd = "show lun general lun_id=%s" % local_lun_id
        flag, cli_ret, err_msg = cli_with_cache. \
            execute_cmd_in_cli_mode_with_cache(PY_JAVA_ENV, cli, cmd, LOGGER)
        ALL_CLI_RET = common.joinLines(ALL_CLI_RET, cli_ret)
        if cliUtil.queryResultWithNoRecord(cli_ret):
            continue
        if flag != True:
            LOGGER.logError('cmd [%s] execute failed!' % cmd)
            ALL_ERRMSG_NO_CHECK = common.joinLines(ALL_ERRMSG_NO_CHECK, err_msg)
            continue
        cli_ret_list = cliUtil.getVerticalCliRet(cli_ret)
        remote_replication_ids_str = ''
        for cli_ret_dict in cli_ret_list:
            remote_replication_ids_str = cli_ret_dict.get('Remote Replication ID(s)', '')
        if remote_replication_ids_str:
            remote_replication_ids = remote_replication_ids_str.strip().split(',')
            if len(remote_replication_ids) != 1:
                ALL_ERRMSG_NO_PASS = common.joinLines(ALL_ERRMSG_NO_PASS,
                                                      common.getMsg(LANG, 'lun.remote.replication.id.num.fault',
                                                                    local_lun_id))
        else:
            ALL_ERRMSG_NO_CHECK = common.joinLines(ALL_ERRMSG_NO_CHECK,
                                                   common.getMsg(LANG, 'get.lun.remote.replication.id.failed',
                                                                 local_lun_id))


def get_local_lun_ids(cli, remote_replication_ids):
    """
    执行show remote_replication general remote_replication_id=PAIR ID|filterRow column=Is\sPrimary predict=equal_to
    value=Yes |filterColumn include columnList=Local\sLUN\sID，获取Local LUN ID的值(同步远程复制的主LUN ID)
    :param cli:
    :param remote_replication_ids:
    :return:
    """
    global ALL_CLI_RET, ALL_ERRMSG_NO_CHECK
    current_process = 30
    step_process = 0
    if len(remote_replication_ids) != 0:
        step_process = int((60 - current_process) / len(remote_replication_ids))
    if step_process == 0:
        step_process = 1
    local_lun_ids = []
    get_failed_list = []
    for remote_replication_id in remote_replication_ids:
        if current_process >= 60:
            common.refreshProcess(PY_JAVA_ENV, 60, LOGGER)
        else:
            current_process = common.refreshProcessByStep(current_process, step_process, PY_JAVA_ENV, LOGGER)
        cmd = 'show remote_replication general remote_replication_id=%s|filterRow column=Is\sPrimary predict=equal_to value=Yes |filterColumn include columnList=Local\sLUN\sID' % remote_replication_id
        flag, cli_ret, err_msg = cliUtil.excuteCmdInCliMode(cli, cmd, True, LANG)
        ALL_CLI_RET = common.joinLines(ALL_CLI_RET, cli_ret)
        if cliUtil.queryResultWithNoRecord(cli_ret):
            continue
        if flag != True:
            LOGGER.logError('cmd [%s] execute failed!' % cmd)
            ALL_ERRMSG_NO_CHECK = common.joinLines(ALL_ERRMSG_NO_CHECK, err_msg)
            continue
        cli_ret_list = cliUtil.getVerticalCliRet(cli_ret)
        for cli_ret_dict in cli_ret_list:
            local_lun_id = cli_ret_dict.get('Local LUN ID', '')
            if not local_lun_id:
                get_failed_list.append(remote_replication_id)
                continue
            local_lun_ids.append(local_lun_id)
    if get_failed_list:
        ALL_ERRMSG_NO_CHECK = common.joinLines(ALL_ERRMSG_NO_CHECK,
                                               common.getMsg(LANG, 'get.local.lun.id.failed',
                                                             ','.join(get_failed_list)))
    return local_lun_ids


def get_remote_replication_ids(cli):
    """
    执行show remote_replication general |filterRow column=Replication\sMode predict=match value=Synchronous
    |filterColumn include columnList=ID，记录同步远程复制ID LIST（PAIR ID）
    :param cli:
    :return:
    """
    global ALL_CLI_RET, ALL_ERRMSG_NO_CHECK
    remote_replication_ids = []
    failed_flag = False
    cmd = 'show remote_replication general |filterRow column=Replication\sMode predict=match value=Synchronous |filterColumn include columnList=ID'
    flag, cli_ret, err_msg = cliUtil.excuteCmdInCliMode(cli, cmd, True, LANG)
    ALL_CLI_RET = common.joinLines(ALL_CLI_RET, cli_ret)
    if cliUtil.queryResultWithNoRecord(cli_ret):
        return True, '', remote_replication_ids
    if flag != True:
        return flag, err_msg, remote_replication_ids
    cli_ret_list = cliUtil.getHorizontalCliRet(cli_ret)
    for cli_ret_dict in cli_ret_list:
        remote_replication_id = cli_ret_dict.get('ID', '')
        if not remote_replication_id:
            failed_flag = True
            continue
        remote_replication_ids.append(remote_replication_id)
    if failed_flag:
        ALL_ERRMSG_NO_CHECK = common.joinLines(ALL_ERRMSG_NO_CHECK,
                                               common.getMsg(LANG, 'get.remote.replication.id.failed'))
    if not remote_replication_ids:
        return cliUtil.RESULT_NOCHECK, common.getMsg(LANG, 'query.result.abnormal'), remote_replication_ids
    return True, '', remote_replication_ids


def check_product_patch(software_version, hot_patch_version):
    """
    检查补丁信息
    :param software_version:
    :param hot_patch_version:
    :return:
    """
    if software_version in parallel_connected_3DC_pass_version and hot_patch_version >= parallel_connected_3DC_pass_version.get(
            software_version, ''):
        return True
    return False


def check_product_info(cli):
    """
    判断产品是否满足检查的版本及型号范围
    :param cli:
    :return:
    """
    global ALL_CLI_RET
    flag, cli_ret, err_msg, software_version, hot_patch_version = common.getVersion(cli, LANG)
    ALL_CLI_RET = common.joinLines(ALL_CLI_RET, cli_ret)
    if flag != True:
        raise UnCheckException(err_msg, ALL_CLI_RET, cliUtil.RESULT_NOCHECK)
    flag, product_model, cli_ret, err_msg = cliUtil.getProductModelWithCliRet(cli, LANG)
    ALL_CLI_RET = common.joinLines(ALL_CLI_RET, cli_ret)
    if flag != True:
        raise UnCheckException(err_msg, ALL_CLI_RET, cliUtil.RESULT_NOCHECK)

    return check_product_version(product_model, software_version,
                                 hot_patch_version)


def check_product_version(product_model, software_version,
                          hot_patch_version):
    """
    判断是否是风险版本
    :param product_model: 设备型号
    :param software_version: 设备版本
    :param hot_patch_version: 热补丁版本
    :return:
    """
    risk_version = parallel_connected_3DC_version
    if product_model in DORADO_DEVS:
        risk_version = parallel_connected_3DC_version_dorado

    if software_version in risk_version:
        return True, software_version, hot_patch_version, ""
    return False, '', '', common.version_no_support_msg(
        product_model, software_version, "",
        risk_version,
        LANG)
