# -*- coding: UTF-8 -*-
import cliUtil
import common
from common import UnCheckException
import common_cache
from cbb.frame.cli import cliUtil as cbb_cliUtil

LANG = common.getLang(py_java_env)
LOGGER = common.getLogger(PY_LOGGER, __file__)
PY_JAVA_ENV = py_java_env
NOSUPPORT_MODEL_LIST = (
    "OceanStor Dorado 2000",
    "OceanStor Dorado 2020"
)


def execute(cli):
    """
    @summary:
        步骤1 以admin用户登录设备；
        步骤2 执行命令：show remote_device smartmobility，获取smartmobility类型的远端设备列表；
        步骤3 执行命令：show remote_device smartmobility remote_device_id=ID（步骤2返回的ID），获取指定远端设备的详情；

        1 若步骤2中查询无远端设备，则检查结果为通过，否则继续检查；
        2 若步骤3中查询到的单个远端设备，满足Protocol字段值为s3且HTTPS Protocol字段值为HTTP，则检查结果为需要优化，否则检查结果为通过；
    """
    all_cli_ret = []
    notpasserrmsg = []

    product_model = str(PY_JAVA_ENV.get("devInfo").getDeviceType())
    LOGGER.logInfo("The product model is %s" % product_model)
    if product_model in NOSUPPORT_MODEL_LIST:
        return cliUtil.RESULT_NOSUPPORT, "", ""

    tmp_msg = common.getMsg(LANG, "check.pass")
    try:
        remote_device_id_list, all_cli_ret = get_remote_device_id_list(
            cli, all_cli_ret)
        LOGGER.logInfo("remote_device_id_list :%s" % remote_device_id_list)
        for device_id in remote_device_id_list:
            remote_device_info, all_cli_ret = get_remote_device_info_detail(
                cli, device_id, all_cli_ret)
            LOGGER.logInfo("remote_device_info:%s" % remote_device_info)
            if remote_device_info["Protocol"] == "S3" and remote_device_info["HTTPS Protocol"] == "HTTP":
                notpasserrmsg.append(remote_device_info["ID"])
            else:
                LOGGER.logInfo("Not S3 or not HTTP: Protocol(%s) HTTPS Protocol(%s)" % (
                    remote_device_info["Protocol"], remote_device_info["HTTPS Protocol"]))

        if notpasserrmsg:
            LOGGER.logInfo(notpasserrmsg)
            tmp_msg = common.getMsg(
                LANG, "check_rmtd_s3_https.warning", ','.join(notpasserrmsg))
            LOGGER.logInfo(tmp_msg)
            return cliUtil.RESULT_WARNING, "\n".join(all_cli_ret), tmp_msg

        # 检查通过
        return True, "\n".join(all_cli_ret), tmp_msg

    except Exception as exception:
        LOGGER.logException(exception)
        return (cliUtil.RESULT_NOCHECK, "\n".join(all_cli_ret),
                common.getMsg(LANG, "query.result.abnormal"))


def get_remote_device_id_list(cli, all_cli_ret):
    """
    获取smartmobility远端设备ID列表
    :param cli:
    :param remote_device_id_list:
    :return:
    """
    remote_device_id_list = []
    cmd = "show remote_device smartmobility"
    flag, cliret, errmsg = cliUtil.excuteCmdInCliMode(
        cli, cmd, True, LANG)
    LOGGER.logInfo(
        "show remote_device smartmobility flag:\n%s cliret:\n%s errmsg:\n%s" % (flag, cliret, errmsg))
    all_cli_ret.append(cliret)
    if flag is not True:
        LOGGER.logError(
            "Failed to get information about remote device. errMsg:%s" % errmsg)
        raise UnCheckException(
            common.getMsg(LANG, "cannot.get.info", {
                          "zh": u"远端设备", "en": "remote device"}.get(LANG)),
            '\n'.join(all_cli_ret))

    remote_device_list = cliUtil.getHorizontalCliRet(cliret)
    for remote_dev in remote_device_list:
        remotedeviceid = remote_dev.get("ID", '')
        remote_device_id_list.append(remotedeviceid)
    LOGGER.logInfo(
        "Success to get information about remote device. remote_device_id_list:%s" % remote_device_id_list)
    return remote_device_id_list, all_cli_ret


def get_remote_device_info_detail(cli, device_id, all_cli_ret):
    """
    获取smartmobility远端设备详情
    :param cli:
    :param device_id:
    :return:
    """
    cmd = "show remote_device smartmobility remote_device_id=%s" % device_id
    flag, cliret, errmsg = cliUtil.excuteCmdInCliMode(
        cli, cmd, True, LANG)
    all_cli_ret.append(cliret)
    if flag is not True:
        LOGGER.logError(
            "Failed to get information about remote device. errMsg:%s" % errmsg)
        raise UnCheckException(
            common.getMsg(LANG, "cannot.get.info", {
                          "zh": u"远端设备", "en": "remote device"}.get(LANG)),
            '\n'.join(all_cli_ret))

    remote_device_info = cliUtil.getVerticalCliRet(cliret)
    LOGGER.logInfo(
        "Success to get information about remote device. errMsg:%s" % remote_device_info)
    return remote_device_info[0], all_cli_ret
