# -*- coding: UTF-8 -*-
import cliUtil
import common

LANG = common.getLang(py_java_env)
LOGGER = common.getLogger(PY_LOGGER, __file__)

def execute(cli):
    '''
        @summary: CIFS  global recommended configuration check
        @return: (status, cliRet, errMsg)
    '''
    flag = True
    cliRet = ""
    errMsg = ""
    
    try:
        cmd = "show service cifs"
        LOGGER.logExecCmd(cmd)
        isQrySuccess, cliRet, errMsg = cliUtil.excuteCmdInCliMode(cli, cmd, True, LANG)
        echoMap = {}
        
        if not cliUtil.hasCliExecPrivilege(cliRet):
            return (cliUtil.RESULT_NOSUPPORT, cliRet, "")
        

        if not isQrySuccess or isQrySuccess == cliUtil.RESULT_NOSUPPORT or isQrySuccess == cliUtil.RESULT_NOCHECK :
            #if the command is not supported: 
            LOGGER.logInfo("this device failed in processing cifs global command: " + unicode(errMsg))
            
            if "^" in cliRet :
                isQryOk, isNasFeatureSupported, errorMsg = common.isNasFeatureSupported(cli, LANG, LOGGER)
                if not isQryOk and errorMsg:
                    return  cliUtil.RESULT_NOCHECK, cliRet, errorMsg
                
                if  isQryOk and not isNasFeatureSupported :
                    return cliUtil.RESULT_NOSUPPORT, cliRet, "" 
            if isCmdExecutedWithError(cliRet):
                errMsg = common.getMsg(LANG, "parse.cifs.global.configuration.failed")
                
            if not isQrySuccess:
                isQrySuccess = cliUtil.RESULT_NOCHECK
            return isQrySuccess, cliRet, errMsg
        
        if "successfully" in cliRet.lower():
                return True, cliRet, errMsg

        cliRetLinesList = cliUtil.getVerticalCliRet(cliRet)
        
        if len(cliRetLinesList) < 1:
            
            errMsg = common.getMsg(LANG, "parse.cifs.global.configuration.failed")
            LOGGER.logNoPass("Cannot get information of CIFS global configuration settings")
            return (cliUtil.RESULT_NOCHECK, cliRet, errMsg)
        
        
        echoMap = cliRetLinesList[0]
        
        isSigningRequired = echoMap.get("Signing Required", "")
        isSigningEnabled = echoMap.get("Signing Enabled", "")
        isNotifyEnabled = echoMap.get("Notify Enabled", "")
    
        if not isSigningRequired or not isSigningEnabled or not isNotifyEnabled:
            return  cliUtil.RESULT_NOCHECK, cliRet, common.getMsg(LANG, "parse.cifs.global.configuration.failed")
        
        needsOptimizeOption = ""
        flag = True

        if isSigningRequired.lower() != "no":
            LOGGER.logNoPass("checking whether the Signing Required setting is No failed.")
            flag = False
            needsOptimizeOption += common.getMsg(LANG, "show.service.cifs.isSigningRequired.not.pass", isSigningRequired)
            
        if isSigningEnabled.lower() != "no":
            LOGGER.logNoPass("checking whether the Signing Enabled switch is NO failed.")
            flag = False
            needsOptimizeOption += common.getMsg(LANG, "show.service.cifs.isSigningEnabled.not.pass", isSigningEnabled)
            
        if isNotifyEnabled.lower() != "yes":
            LOGGER.logNoPass("checking whether the Notify Enabled switch is YES failed.")  
            flag = False  
            needsOptimizeOption += common.getMsg(LANG, "show.service.cifs.isNotifyEnabled.not.pass", isNotifyEnabled)

        if not flag :
            return cliUtil.RESULT_WARNING, cliRet, needsOptimizeOption
        else :
            LOGGER.logPass()    
            return flag, cliRet, errMsg

        
    except Exception, exception:
        LOGGER.logException(exception)
        return (cliUtil.RESULT_NOCHECK, cliRet, common.getMsg(LANG, "query.result.abnormal"))

def isCmdExecutedWithError(cmdEcho):
    '''
    @summary: check whether the command has executed failed
    @return:  True or False
    '''
    if not cmdEcho:
        return False
    for cmdLine in cmdEcho.splitlines():
        if ("error:" in cmdLine.lower() or "error :" in cmdLine.lower()) and "license" not in cmdLine.lower():
            return True
        
    return False