#  coding=UTF-8
#  Copyright (c) Huawei Technologies Co., Ltd. 2019-2019. All rights reserved.
import cliUtil
import common
from cbb.business.checkitems import eth_toe_switch_check
from cbb.business.checkitems.eth_toe_switch_check import ToeCheckSceneMsgAdapter
from cbb.business.checkitems.eth_toe_switch_check import ToeCheckScene
from cbb.frame.base.constants import CheckStatus

"""
@version: Toolkit V200R006C00
@time: 2019/08/28 
@file: check_item_software_cli_eth_toe_switch.py 
@function: 
@modify: 
"""
LANG = common.getLang(py_java_env)
LOGGER = common.getLogger(PY_LOGGER, __file__)
'''
CBB执行结果-巡检执行结果映射：
CheckStatus.PASS:通过，
CheckStatus.NOTPASS: 不通过，
CheckStatus.NOCHECK: 检查执行失败，
CheckStatus.EXECUTING: 执行中，CBB该检查项是完整执行的,不应该有这种状态返回，若发现,视为检查执行失败
CheckStatus.SUCCEED: 成功，
CheckStatus.FAILED: 不成功
'''
CBBFLAG_TO_INSPECT_DICT = {CheckStatus.PASS: True,
                           CheckStatus.NOTPASS: False,
                           CheckStatus.NOCHECK: cliUtil.RESULT_NOCHECK,
                           CheckStatus.EXECUTING: cliUtil.RESULT_NOCHECK,
                           CheckStatus.SUCCEED: True,
                           CheckStatus.FAILED: False}


def execute(cli):
    '''
    检查步骤：
    步骤1.以admin用户登录设备，执行show upgrade package命令查看存储版本信息；
    步骤2.执行change user_mode current_mode user_mode=developer命令切换到developer模式；
    步骤3.执行show logical_port failover_switch service_type=SAN命令查询故障场景漂移开关；
    步骤4.执行show port general logic_type=Host_Port physical_type=ETH命令查看物理口，记录查询出来的端口号；
    步骤5.执行show port eth_toe_switch eth_port_id=?(?是步骤4查询出来的端口号)命令查看TOE功能开关状态；
    检查标准：
    1.如果当前版本不为V500R007C30SPC100/Dorado V300R002C00/Dorado V300R002C00SPC100其中的一个，则检查通过，否则继续检查；
    2.如果当前版本已安装特定补丁，则检查通过。否则继续检查；
      V500R007C30SPC100: V500R007C30SPH105及以后补丁版本;
    3.如果是Dorado V3存储，且端口漂移开关关闭（步骤3中Failover Switch字段值为Off），则检查通过，否则继续检查；
    4.如果步骤5中若所有端口eth_toe_switch字段值为No，则检查通过；否则检查不通过
    :param cli:
    :return:
    '''
    flag = True
    # 向CBB传入进入巡检检查分支，当前语言，ssh，日志
    toe_check_adapter = ToeCheckSceneMsgAdapter(ToeCheckScene.INSPECTION, LANG, cli, PY_LOGGER)
    # 启动CBB TOE巡检项检查
    cbb_flag, cliRet, errMsg = eth_toe_switch_check.execute(toe_check_adapter)
    # 将CBB检查结果转换为巡检检查结果
    if cbb_flag in CBBFLAG_TO_INSPECT_DICT:
        flag = CBBFLAG_TO_INSPECT_DICT.get(cbb_flag)
    else:
        flag = cliUtil.RESULT_NOCHECK
    return flag, cliRet, errMsg
