# -*- coding: UTF-8 -*-
import cliUtil
import common
from common import AsynProgress

LANG = common.getLang(py_java_env)
LOGGER = common.getLogger(PY_LOGGER, __file__)
PY_JAVA_ENV = py_java_env

def execute(cli):
    '''
        文件系统状态检查: 
        1 如果没有创建文件系统表示正常；
        2 Clone Split Status为Abnormal表示不正常；
        3 其它情况均属于正常状态。
    '''
    flag = True
    cliRet = ""
    errMsg = ""

    myPthread = AsynProgress(PY_JAVA_ENV, LOGGER)
    myPthread.start_thread()
    try:
        cmd = "show file_system general|filterColumn include columnList=ID,Clone\sSplit\sStatus"
        checkRet = cliUtil.excuteCmdInCliMode(cli, cmd, True, LANG)
        if checkRet[0] != True: 
            if not cliUtil.hasCliExecPrivilege(checkRet[1]):
                return (cliUtil.RESULT_NOSUPPORT, checkRet[1], "")
            if checkRet[0] == False:                
                return (cliUtil.RESULT_NOCHECK, checkRet[1], common.getMsg(LANG, "cannot.get.clone.info"))
            LOGGER.logSysAbnormal()
            return checkRet
        
        cliRet = checkRet[1]
        if cliUtil.queryResultWithNoRecord(cliRet):
            return (True, cliRet, errMsg)
        
        cliRetDictList = cliUtil.getHorizontalCliRet(cliRet)
        if len(cliRetDictList) == 0:
            errMsg = common.getMsg(LANG, "cannot.get.clone.info")
            LOGGER.logNoPass("Cannot get information about Clone File System")
            return (cliUtil.RESULT_NOCHECK, cliRet, errMsg)

        for cliRetDict in cliRetDictList:
            Id = cliRetDict.get("ID")
            splitStatus = cliRetDict.get("Clone Split Status")
            
            if splitStatus == common.STATUS_ABNORMAL:
                flag = False
                errMsg += common.getMsg(LANG, "filesystem.clone.split.status.abnormal", (Id, splitStatus))
                LOGGER.logNoPass("The Clone Split Status of File System [%s] is abnormal (Split Status: %s)" 
                     % (Id, splitStatus))
            
        if flag:
            LOGGER.logPass()
            
        return (flag, cliRet, errMsg)
        
    except Exception, exception:
        LOGGER.logException(exception)
        return (cliUtil.RESULT_NOCHECK, cliRet, common.getMsg(LANG, "query.result.abnormal"))

    finally:
        myPthread.setStopFlag(True)
        