# coding: UTF-8

import cliUtil
import common
import cli_util_cache as cache_util
from common_utils import get_err_msg

LANG = common.getLang(py_java_env)
LOGGER = common.getLogger(PY_LOGGER, __file__)
PY_JAVA_ENV = py_java_env

NORMAL_STATUS = ["Running", "Completed"]
STATUS_OK = "0"
STATUS_NOT_SUPPORT = "-1"


def execute(cli):
    all_ret = []
    all_ret_str = ""
    try:
        flag, msg = check_kubernetes_in_running_data(all_ret)
        all_ret_str = "\n".join(all_ret)
        return flag, all_ret_str, msg
    except Exception as e:
        LOGGER.logException(e)
        msg = common.getMsg(LANG, "query.result.abnormal")
        return cliUtil.RESULT_NOCHECK, msg, all_ret_str


def check_kubernetes_in_running_data(all_ret):
    dev_info = PY_JAVA_ENV.get("devInfo")
    p_version = str(dev_info.getProductVersion())
    sn = common.get_sn_from_env(PY_JAVA_ENV)
    obj_py = PY_JAVA_ENV.get("objectForPy")

    kb_data_dict_list = cache_util.get_kubernetes_data_info_from_config(
        obj_py, p_version, sn
    )
    LOGGER.logInfo("kb_data_dict_list is:{}".format(kb_data_dict_list))
    all_ret.append("Kubernetes Running Data:{}\n".format(kb_data_dict_list))
    if not kb_data_dict_list:
        return True, ""
    for kb_data_dict in kb_data_dict_list:
        if kb_data_dict.get("STATUS", "") not in NORMAL_STATUS:
            return (
                False,
                get_err_msg(LANG, "software.container.status.not.pass",),
            )

    return True, ""
