# -*- coding: UTF-8 -*-
import cliUtil
import common

LANG = common.getLang(py_java_env)
LOGGER = common.getLogger(PY_LOGGER, __file__)

def execute(cli):
    '''
        硬盘域状态检查: 
        1 如果硬盘域不存在表示正常；
        2 Health Status为Normal且Running Status为Online表示正常；
        3 其它情况均属于不正常状态。
    '''
    flag = True
    cliRet = ""
    errMsg = ""

    try:
        cmd = "show disk_domain general"
        LOGGER.logExecCmd(cmd)
        checkRet = cliUtil.excuteCmdInCliMode(cli, cmd, True, LANG)
        if checkRet[0] is not True:
            LOGGER.logSysAbnormal()
            return checkRet
        
        cliRet = checkRet[1]
        if cliUtil.queryResultWithNoRecord(cliRet):
            return (True, cliRet, errMsg)
        
        cliRetLinesList = cliUtil.getHorizontalCliRet(cliRet)
        if len(cliRetLinesList) == 0:
            errMsg = common.getMsg(LANG, "cannot.get.disk.domain.info")
            LOGGER.logNoPass("Cannot get information about disk domain")
            return (cliUtil.RESULT_NOCHECK, cliRet, errMsg)  # 修改备注：解析回显失败导致列表长度为0

        for line in cliRetLinesList:
            Id = line.get("ID")
            healthStatus = line.get("Health Status")
            runningStatus = line.get("Running Status")
            
            if healthStatus != common.STATUS_NORMAL:
                flag = False
                errMsg += common.getMsg(LANG, "disk.domain.health.status.abnormal", (Id, healthStatus))
                LOGGER.logNoPass("The Health Status of disk domain [%s] is abnormal (Health Status:%s)" 
                     % (Id, healthStatus))
            
            if runningStatus != common.STATUS_ONLINE:
                flag = False
                errMsg += common.getMsg(LANG, "disk.domain.running.status.abnormal", (Id, runningStatus))
                LOGGER.logNoPass("The Running Status of disk domain [%s] is abnormal (Running Status:%s)" 
                     % (Id, runningStatus))
                
        if flag:
            LOGGER.logPass()
            
        return (flag, cliRet, errMsg)
        
    except Exception, exception:
        LOGGER.logException(exception)
        return (cliUtil.RESULT_NOCHECK, cliRet, common.getMsg(LANG, "query.result.abnormal"))

