# -*- coding: UTF-8 -*-
"""
@version: Toolkit V200R006C00
@time: 2020/01/21
@file: check_item_software_disk_domain_change_dedup_mode.py
@function:
@modify:
"""
import cliUtil
import common
import common_cache

LANG = common.getLang(py_java_env)
LOGGER = common.getLogger(PY_LOGGER, __file__)


def execute(cli):
    all_cli_ret = ''
    # 获取版本回显
    version_flag, version, patch, version_ret, err_msg = \
        common_cache.get_version_and_patch_cache(
            py_java_env, cli, LOGGER)
    all_cli_ret = common.joinLines(all_cli_ret, version_ret)
    cmd = 'show event|filterRow column=ID ' \
          'predict=equal_to value=0x200F010A00CF'
    flag, cli_ret, err_msg = \
        cliUtil.excuteCmdInCliMode(cli, cmd, True, LANG)
    all_cli_ret = common.joinLines(all_cli_ret, cli_ret)
    if flag is not True:
        LOGGER.logSysAbnormal()
        return flag, all_cli_ret, err_msg
    if cliUtil.queryResultWithNoRecord(cli_ret):
        return True, all_cli_ret, ''
    cli_ret_lines_list = cliUtil.getHorizontalNostandardCliRet(cli_ret)
    if len(cli_ret_lines_list) > 0:
        return False, all_cli_ret, common.getMsg(
            LANG, 'disk.domain.change.dedup.mode')
    return True, all_cli_ret, ''
