# -*- coding: UTF-8 -*-

from com.huawei.ism.tool.obase.exception import ToolException

from common import UnCheckException
import cliUtil
import common
import common_cache
import re
import decimal
import config

LANG = common.getLang(py_java_env)
LOGGER = common.getLogger(PY_LOGGER, __file__)
PY_JAVA_ENV = py_java_env
ALL_CLI_RET = ''
CURRENT_PROCESS = 0
STEPPROCESS = 0
PASSED_HOT_VERSION_DICT = {
    "V300R003C20SPC200": "V300R003C20SPH210",
    "V300R006C00SPC100": "V300R006C00SPH105",
}


def execute(cli):
    """
    检查项名称：文件系统gang块检查
    检查方法：
        步骤1 以admin用户登录设备。
        步骤2 执行命令show upgrade package，获取系统软件版本以及补丁版本。
        步骤3 执行change user_mode current_mode user_mode=developer，进入developer模式。  # noqa
        步骤4 执行show file_system general 获取文件系统ID。
        步骤5 执行show file_system general file_system_id=ID(步骤4获取的文件系统ID)，获取文件系统的归属控制器Owner Controller和健康状态Health Status。  # noqa
        步骤6 若归属控制器是当前控制器，则继续向下执行；否则，执行minisystem命令，进入minisystem模式，再执行sshtoremoteExt命令心跳到对应的控制器，并进入developer模式。  # noqa
        步骤7 根据步骤4获取的文件系统ID及步骤5获取的文件系统归属控制器Owner Controller，执行show space statistic_info file_system_id=ID controller=Owner Controller， 获取File System Used字段、Snapshot Resvered Free 字段。   # noqa
        步骤8 执行debug命令，进入debug模式。
        步骤9 执行grain showGrainReq ID(步骤4获取的文件系统ID)，获取Gang used meta字段。   # noqa
    检查标准：
        1 若步骤2中系统软件版本和热补丁版本关系如下，则检查通过，否则继续检查；
        1) V300R003C20SPC200：V300R003C20SPH210及以后版本
        2) V300R006C00SPC100：V300R006C00SPH105及以后版本
        2.若步骤4中回显结果中不存在文件系统，则检查通过；否则继续向下检查。
        3.若步骤5中文件系统的健康状态Health Status是“Normal”，则继续向下检查；否则继续检查其他文件系统。    # noqa
        4.若步骤9中Gang used meta >= 10737418240，则检查不通过；否则继续向下检查。
        5.若步骤7和步骤9中获取的信息中，Gang used meta /(File System Used - Snapshot Resvered Free) >= 0.5%，则检查不通过；否则通过。  # noqa
    """
    global ALL_CLI_RET, CURRENT_PROCESS, STEPPROCESS

    try:

        # 检查版本号是否支持
        riskFileSysIdList = []
        supportVersionList = ["V300R003C00", "V300R003C00SPC100",
                              "V300R003C10", "V300R003C10SPC100",
                              "V300R003C20", "V300R003C20SPC100", "V300R003C20SPC200",
                              "V300R005C00", "V300R005C00SPC300",
                              "V300R006C00", "V300R006C00SPC100"]

        # 获取系统版本号
        flag, vr, h_vr, ret, err = common_cache.get_version_and_patch_cache(
            PY_JAVA_ENV, cli, LOGGER)
        ALL_CLI_RET = common.joinLines(ALL_CLI_RET, ret)
        if flag is not True:
            return flag, ALL_CLI_RET, err

        # # 支持  V300R003C20SPC200之后的版本
        if vr not in supportVersionList:
            return cliUtil.RESULT_NOSUPPORT, common.version_no_support_msg(
                "", vr, "",
                supportVersionList, LANG), ""

        # 直接通过的热补丁版本
        if is_passed_hot_ver(vr, h_vr):
            return True, ALL_CLI_RET, err

        # 是否超级管理员
        flag, cliRet = common.isSuperAdmin(cli, LANG)
        ALL_CLI_RET = common.joinLines(ALL_CLI_RET, cliRet)
        if flag is not True:
            errMsg = common.getMsg(LANG, 'user.level.not.super_admin')
            return cliUtil.RESULT_NOCHECK, ALL_CLI_RET, errMsg

        common.refreshProcess(PY_JAVA_ENV, 5, LOGGER)

        # 获取所有文件系统的ID列表
        fileSystemIDList = getFileSystemID(cli)
        if len(fileSystemIDList) == 0:
            return True, ALL_CLI_RET, ''

        # 刷新进度条
        CURRENT_PROCESS = 6
        STEPPROCESS = (0.15 / len(fileSystemIDList)) * (100 - CURRENT_PROCESS)

        # 获取文件系统和控制器的映射关系及文件系统
        ownCtrFSDict = checkFileSysOwnnerCtr(cli, fileSystemIDList)

        # 用于记录心跳失败的控制器ID
        engineIpListDict, engineContrIDListDict = getEngineInfo(cli, ownCtrFSDict)

        CURRENT_PROCESS = 23
        STEPPROCESS = (0.36 / len(fileSystemIDList)) * (100 - CURRENT_PROCESS)

        currentEngine = '0'
        connCli = cli
        currentConnIp = PY_JAVA_ENV.get("devInfo").getIp()
        connIp = currentConnIp
        # 如果是18000，当前引擎就需要关闭连接。其他引擎重新建立管理IP ssh连接。
        if common.is18000(PY_JAVA_ENV, cli):
            LOGGER.logInfo(u"current dev is 18000")
            flag, errMsg, connCli, connIp = common.getConnectionByContrIpWithConnIp(PY_JAVA_ENV, cli, engineIpListDict, currentEngine,
                                                                  LOGGER, LANG)
            if flag is False:
                raise UnCheckException(errMsg, ALL_CLI_RET, cliUtil.RESULT_NOCHECK)

        # 检查当前引擎
        (
            currentEngine,
            currentCtrlNodeId,
            currentEngineCtrlIdList,
            node_num,
        ) = getCurrentEngineCtrlNodeInfo(connCli)
        engineContrIDList = engineContrIDListDict.get(currentEngine, [])
        cliUtil.enterCliModeFromSomeModel(connCli, LANG)
        LOGGER.logInfo(
            u"current dev: currentEngine:%s, currentCtrlNodeId:%s, currentEngineCtrlIdList:%s" %
            (currentEngine, currentCtrlNodeId, currentEngineCtrlIdList))
        riskFileSysIdList.extend(
            checkCurrentEngine(
                engineContrIDList,
                ownCtrFSDict,
                connCli,
                currentCtrlNodeId,
                currentEngineCtrlIdList,
                node_num,
            )
        )

        # 检查其他引擎
        LOGGER.logInfo(u"start check other engine.")
        for engine in engineIpListDict:
            LOGGER.logInfo(u"start check other engine:%s" % engine)
            if engine == currentEngine:
                LOGGER.logInfo(
                    u"start check other engine:%s, engine is currentEngine:%s no need check." % (engine, currentEngine))
                continue

            engineContrIDList = engineContrIDListDict.get(engine, [])
            if len(engineContrIDList) == 0:
                continue

            info_tuple = common.getEngineCtrlNodeInfo(
                connCli, LOGGER, LANG)

            flag, ret, msg, new_cli, exits = common.enginesJump(connCli,
                                                                engine,
                                                                info_tuple[5],
                                                                info_tuple[3],
                                                                info_tuple[6],
                                                                PY_JAVA_ENV,
                                                                LOGGER,
                                                                LANG,
                                                                info_tuple[4])

            ALL_CLI_RET = common.joinLines(ALL_CLI_RET, ret)
            if flag is not True:
                raise UnCheckException(msg, ALL_CLI_RET)

            try:
                # 此处有重复检查的问题，将currentEngine修改为tmpCurrentEngine
                # 避免此问题。如果连接的是1号引擎就可能导致重复检查1、0、1.
                (
                    tmp_eng,
                    cur_node_id,
                    ctrl_list,
                    node_num,
                ) = getCurrentEngineCtrlNodeInfo(new_cli)
                LOGGER.logInfo(u"Engine:%s, NodeId:%s, CtrlList:%s" % (
                    tmp_eng, cur_node_id, ctrl_list))

                cliUtil.enterCliModeFromSomeModel(new_cli, LANG)
                riskFileSysIdList.extend(
                    checkCurrentEngine(engineContrIDList, ownCtrFSDict,
                                       new_cli, cur_node_id,
                                       ctrl_list, node_num))
            except UnCheckException, unCheckException:
                raise UnCheckException(unCheckException.errorMsg, ALL_CLI_RET)
            finally:
                common.enginesBack(new_cli, PY_JAVA_ENV, LOGGER, LANG, exits)
                LOGGER.logInfo("exit heart beat success.")

        if common.is18000(PY_JAVA_ENV, cli):
            if connIp != currentConnIp:
                common.closeSSH(connCli)
                LOGGER.logInfo("closeSSH success :[%s]" % connCli)
            else:
                LOGGER.logInfo("current ip is array ip: [%s]" % connCli)

        if len(riskFileSysIdList) != 0:
            common.sortListByInt(riskFileSysIdList, LOGGER)
            errMsg = common.getMsg(LANG, "gang.check.not.pass",
                                   ",".join(riskFileSysIdList))
            if vr in PASSED_HOT_VERSION_DICT and is_special_hot_ver(h_vr):
                ALL_CLI_RET += common.getMsg(
                    LANG, 'gang.disk_hot_patch_version').format(h_vr)
            return False, ALL_CLI_RET, errMsg
        return True, ALL_CLI_RET, ""
    except UnCheckException, unCheckException:
        LOGGER.logInfo(u"UnCheckException, errMsg: %s" % unCheckException.errorMsg)
        if not unCheckException.flag:
            return cliUtil.RESULT_NOCHECK, unCheckException.cliRet, unCheckException.errorMsg
        return unCheckException.flag, unCheckException.cliRet, unCheckException.errorMsg

    except (ToolException, Exception) as exception:
        LOGGER.logException(exception)
        return cliUtil.RESULT_NOCHECK, ALL_CLI_RET, common.getMsg(LANG, "query.result.abnormal")
    finally:
        # 退出到cli模式
        ret = cliUtil.enterCliModeFromSomeModel(cli, LANG)
        LOGGER.logInfo("enter cli mode from some model ret is %s" % str(ret))

        # 退出失败后为不影响后续检查项重新连接cli
        if not ret[0]:
            common.reConnectionCli(cli, LOGGER)


def is_special_hot_ver(hot_ver):
    # 特定版本补丁，一般SPHx60及以上
    return bool(re.search("V\d{3}R\d{3}C\d{2}SPH\d[6-9]\d", hot_ver))   # noqa


def is_passed_hot_ver(ver, hot_ver):
    if ver in PASSED_HOT_VERSION_DICT:
        low_ver = PASSED_HOT_VERSION_DICT.get(ver)
        if hot_ver >= low_ver and not is_special_hot_ver(hot_ver):
            LOGGER.logInfo("{} is the passed hot version".format(hot_ver))
            return True
    return False


def checkCurrentEngine(engineContrIDList, ownCtrFSDict, checkCli,
                       currentCtrlNodeId, currentEngineCtrlIdList, node_num):
    riskFileSysIdList = []
    for ownCtr in engineContrIDList:
        fsList = ownCtrFSDict.get(ownCtr)
        if len(fsList) == 0:
            continue
        # 获取单个控制器上所有文件系统的file system used - snapshot resvered free的值的字典
        fsScpValueDict = getStatisticValue(checkCli, fsList, ownCtr)

        # 获取单个控制器上所有文件系统的gangUsedMeta的值的字典
        gangUsedMetaDict = getGangUsedMetaValue(
            checkCli,
            fsList,
            ownCtr,
            currentCtrlNodeId,
            currentEngineCtrlIdList,
            node_num,
        )
        if len(gangUsedMetaDict) != 0:
            for ctrID in gangUsedMetaDict:
                gangUsedMeta = gangUsedMetaDict.get(ctrID, "")
                LOGGER.logInfo("gangUsedMetaDict:filesystem id:%s,gangUsedMeta:%s" % (ctrID, gangUsedMeta))
                if gangUsedMeta >= 10737418240:
                    riskFileSysIdList.append(ctrID)
                    continue

                fsScpValue = fsScpValueDict.get(ctrID, "")
                LOGGER.logInfo("fsGangValueCheck:filesystem:%s, fsScpValue:%s" % (ctrID, fsScpValue))
                if fsScpValue <= 0:
                    riskFileSysIdList.append(ctrID)
                    continue

                resValue = decimal.Decimal(gangUsedMeta) / decimal.Decimal(fsScpValue)
                LOGGER.logInfo("fsGangValueCheck:filesystem:%s, resValue:%s" % (ctrID, resValue))
                if resValue >= decimal.Decimal("0.005"):
                    riskFileSysIdList.append(ctrID)

    return riskFileSysIdList


def getCurrentEngineCtrlNodeInfo(cli):
    """
    @summary: 获取除当前节点外的引擎其他健康节点信息，当前节点信息。
    @param cli: cli连接
    @return: (currentCtrlNodeId, currentEngineCtrlIdList)
        currentNodeId: 当前节点ID
        currentEngineOtherCtrlIdList: 除当前节点外的引擎其他健康节点信息
    """
    node_num = 2
    cmd = 'sys showcls'
    # 当前节点
    currentCtrlNodeId = None
    currentEngine = None
    engineCtrlNodeMappingDict = {}

    flag, cliRet, errMsg = cliUtil.excuteCmdInDebugModel(cli, cmd, LANG)
    if flag != True:
        LOGGER.logInfo("get node info Failed. errMsg: %s" % errMsg)
        raise UnCheckException(common.getMsg(LANG, "chunk.check.get.controller.node.failed"), ALL_CLI_RET)

    ctrlInfoDictList = cliUtil.getVerticalCliRet(cliRet)
    engineInfoDictList = cliUtil.getHorizontalNostandardCliRet(cliRet)

    for ctrlInfo in ctrlInfoDictList:
        if ctrlInfo.get("local node id", "") != "":
            currentCtrlNodeId = ctrlInfo.get("local node id", "")
            break

    for engineInfo in engineInfoDictList:
        engine = engineInfo.get("engine", "")
        if engine == "":
            continue

        ctrlNodeId = engineInfo.get("id", "")
        if ctrlNodeId == "":
            continue

        tmpList = engineCtrlNodeMappingDict.get(engine, [])
        tmpList.append(ctrlNodeId)
        engineCtrlNodeMappingDict[engine] = tmpList

        if ctrlNodeId == currentCtrlNodeId:
            currentEngine = engine

    for eng_id in engineCtrlNodeMappingDict:
        node_num = max(len(engineCtrlNodeMappingDict.get(eng_id, [])),
                       node_num)
    # 当前引擎包含的控制器节点
    currentEngineCtrlIdList = engineCtrlNodeMappingDict.get(currentEngine, [])
    return (
        currentEngine,
        currentCtrlNodeId,
        currentEngineCtrlIdList,
        node_num
    )


def getFileSystemID(cli):
    """
    @summary: 获取文件系统的ID列表

    @return:
        idList:文件系统ID列表
    """
    global ALL_CLI_RET
    idList = []

    cmd = "show file_system general"
    isSuccess, cliRet, errMsg = cliUtil.excuteCmdInDeveloperMode(cli, cmd, True, LANG)
    ALL_CLI_RET = common.joinLines(ALL_CLI_RET, cliRet)

    if not cliUtil.hasCliExecPrivilege(cliRet):
        raise UnCheckException(errMsg, ALL_CLI_RET, cliUtil.RESULT_NOSUPPORT)

    if isSuccess is not True:
        errMsg = common.getMsg(LANG, "cannot.get.filesystem.info")
        raise UnCheckException(errMsg, ALL_CLI_RET, isSuccess)

    if cliUtil.queryResultWithNoRecord(cliRet):
        return []

    linesList = cliUtil.getHorizontalCliRet(cliRet)

    for line in linesList:
        idNum = line.get("ID").strip()
        idList.append(idNum)

    return idList


def getFileSysDetailInfo(cli, fileSysId):
    """
    @summary: 获取文件系统的归属控制器<controllerId>和健康状态<Health Status>
    fileSysId ：文件系统ID
    @return:
        idList:文件系统ID列表
    """
    global ALL_CLI_RET, CURRENT_PROCESS
    if CURRENT_PROCESS > 0:
        CURRENT_PROCESS = common.refreshProcessByStep(CURRENT_PROCESS, STEPPROCESS, PY_JAVA_ENV, LOGGER)
    cmd = "show file_system general file_system_id=%s" % fileSysId
    isSuccess, cliRet, errMsg = cliUtil.excuteCmdInDeveloperMode(cli, cmd, True, LANG)

    if isSuccess is not True:
        ALL_CLI_RET = common.joinLines(ALL_CLI_RET, cliRet)
        errMsg = common.getMsg(LANG, "cannot.get.filesystem.info")
        raise UnCheckException(errMsg, ALL_CLI_RET, isSuccess)

    if "Error:" in cliRet:
        ALL_CLI_RET = common.joinLines(ALL_CLI_RET, cliRet)
        errMsg = common.getMsg(LANG, "cannot.get.info.gang")
        raise UnCheckException(errMsg, ALL_CLI_RET, isSuccess)

    # 截图包含关键字的回显
    keyWordList = ["how file_system general file_system_id",
                   "Owner Controller",
                   "Health Status",
                   ":/>"]
    keyWordLines = getCliRetByLine(cliRet, keyWordList)
    ALL_CLI_RET = common.joinLines(ALL_CLI_RET, keyWordLines)

    fileSysDetailList = cliUtil.getVerticalCliRet(cliRet)
    if len(fileSysDetailList) == 0:
        ALL_CLI_RET = common.joinLines(ALL_CLI_RET, cliRet)
        errMsg = common.getMsg(LANG, "cannot.get.filesystem.info")
        raise UnCheckException(errMsg, ALL_CLI_RET, cliUtil.RESULT_NOCHECK)

    ownContr = fileSysDetailList[0].get("Owner Controller", "")
    helthStatus = fileSysDetailList[0].get("Health Status", "").lower()
    # TODO 判断条件改成or
    if ownContr == "" or helthStatus == "" or ownContr == "--" or helthStatus == "--":
        errMsg = common.getMsg(LANG, "cannot.get.filesystem.info")
        raise UnCheckException(errMsg, ALL_CLI_RET, cliUtil.RESULT_NOCHECK)
    return ownContr, helthStatus


def checkFileSysOwnnerCtr(cli, fileSystemIDList):
    """
    @summary: 文件系统归属控制器分类
    fileSysId ：文件系统ID
    @return:
        idList:文件系统ID列表
    """
    # 归属控制器是当前控制器的文件系统列表
    ownCtrFSDict = {}
    for fileSystemID in fileSystemIDList:

        ownContr, helthStatus = getFileSysDetailInfo(cli, fileSystemID)

        # 只对状态为normal的文件系统
        if helthStatus != "normal":
            continue
        ownCtrFSDict[ownContr] = ownCtrFSDict.get(ownContr, []) + [fileSystemID]

    LOGGER.logInfo("checkFileSysOwnnerCtr:ownCtrFSDict:%s" % str(ownCtrFSDict))
    return ownCtrFSDict


def getGangUsedMetaValue(cli, fsList, ownCtr, currentCtrlNodeId,
                         currentEngineCtrlIdList, node_num):
    """
    @summary: 获取文件系统的gangUsedMeta值
    ctrID ：文件系统ID
    @return:
        True/FALSE:获取值是否成功
        gangUsedMeta：gangUsedMeta的值
    """
    global ALL_CLI_RET, CURRENT_PROCESS
    gangUsedMetaDict = {}
    errMsg = ""
    # 获取控制器ID的节点ID
    LOGGER.logInfo(
        "ownCtr:%s, currentCtrlNodeId:%s, currentEngineCtrlIdList:%s" % (ownCtr, currentCtrlNodeId, currentEngineCtrlIdList))
    engineId = int(ownCtr[:-1])
    mapped_node_num = config.CONTROL_NODE_DICT.get(ownCtr[1], "0")
    targetNodeId = engineId * node_num + int(mapped_node_num)
    LOGGER.logInfo("heart beat targetNodeId:%s, currentCtrlNodeId:%s." % (targetNodeId, currentCtrlNodeId))
    # 非当前引擎的节点，无法跳过去。老检查项使用的是每个框都建立 IP
    # 的ssh连接来检查，有风险。
    if str(targetNodeId) not in currentEngineCtrlIdList:
        return gangUsedMetaDict
    heart_beat_succ = False
    try:
        if currentCtrlNodeId != str(targetNodeId):
            LOGGER.logInfo("current conn node is not checkNode, need to heartbeat.")
            flag, cliRet, errMsg = common.heartBeatToOtherCtrl(cli, targetNodeId, PY_JAVA_ENV, LOGGER, LANG)
            ALL_CLI_RET = common.joinLines(ALL_CLI_RET, cliRet)
            if flag is not True:
                raise UnCheckException(errMsg, ALL_CLI_RET, flag)
            heart_beat_succ = True
        else:
            LOGGER.logInfo("current conn node is checkNode!, no need to do heartbeat!")

        for ctrID in fsList:
            # 刷新进度条
            if CURRENT_PROCESS != 0:
                CURRENT_PROCESS = common.refreshProcessByStep(CURRENT_PROCESS, STEPPROCESS, PY_JAVA_ENV, LOGGER)

            cmd = "grain showGrainReq %s" % ctrID
            isSuccess, cliRet, errMsg = cliUtil.excuteCmdInDebugModel(cli, cmd, LANG)

            if isSuccess is not True:
                ALL_CLI_RET = common.joinLines(ALL_CLI_RET, cliRet)
                errMsg = common.getMsg(LANG, "cannot.get.info.gang")
                raise UnCheckException(errMsg, ALL_CLI_RET, isSuccess)

            if "Error:" in cliRet:
                ALL_CLI_RET = common.joinLines(ALL_CLI_RET, cliRet)
                errMsg = common.getMsg(LANG, "cannot.get.info.gang")
                raise UnCheckException(errMsg, ALL_CLI_RET, isSuccess)

            grainInfoList = cliRet.splitlines()
            for line in grainInfoList:
                if re.search("grain showGrainReq", line, re.I):
                    ALL_CLI_RET = common.joinLines(ALL_CLI_RET, line)

                if re.search("Gang used meta", line, re.I):
                    ALL_CLI_RET = common.joinLines(ALL_CLI_RET, line)
                    gangUsedMeta = int(re.search("[0-9]+", line).group())

                    if gangUsedMeta is None:
                        errMsg = common.getMsg(LANG, "cannot.get.info.gang")
                        raise UnCheckException(errMsg, ALL_CLI_RET, cliUtil.RESULT_NOCHECK)
                    gangUsedMetaDict[ctrID] = gangUsedMeta

                if re.search("\>", line, re.I):
                    ALL_CLI_RET = common.joinLines(ALL_CLI_RET, line)

        return gangUsedMetaDict
    except Exception, exception:
        LOGGER.logException(exception)
        raise UnCheckException(errMsg, ALL_CLI_RET, cliUtil.RESULT_NOCHECK)
    finally:
        if currentCtrlNodeId != str(targetNodeId) and heart_beat_succ:
            LOGGER.logInfo("current conn node is not checkNode!, need to do exit heartbeat!")
            # 退出心跳
            cliUtil.exitHeartbeatCli(cli, LANG)
            excuRet = cliUtil.excuteCmdCommon(cli, "exit", LANG)
            if "(y/n)" in excuRet[1]:
                cliUtil.excuteCmdCommon(cli, "y", LANG)
        else:
            LOGGER.logInfo("current conn node is checkNode!, no need to do exit heartbeat!")

def getStatisticValue(cli, ctrIList, ownContr):
    """
    @summary: 获取文件系统的file system used和snapshot resvered free值
    ctrID ：文件系统ID
    @return:
        True/FALSE:获取值是否成功
        gangUsedMeta：gangUsedMeta的值
    """
    global ALL_CLI_RET, CURRENT_PROCESS
    fsScpValueDict = {}
    cliUtil.enterCliModeFromSomeModel(cli, LANG)
    issucc, cliRet, errMsg = cliUtil.enterDeveloperMode(cli, LANG)
    if issucc is not True:
        raise UnCheckException(errMsg, ALL_CLI_RET, issucc)

    for ctrID in ctrIList:
        # 刷新进度条
        if CURRENT_PROCESS != 0:
            CURRENT_PROCESS = common.refreshProcessByStep(CURRENT_PROCESS, STEPPROCESS, PY_JAVA_ENV, LOGGER)
        cmd = "show space statistic_info file_system_id=%s controller=%s" % (ctrID, ownContr)
        isSuccess, cliRet, errMsg = cliUtil.excuteCmdInDeveloperMode(cli, cmd, True, LANG)

        if isSuccess is not True:
            ALL_CLI_RET = common.joinLines(ALL_CLI_RET, cliRet)
            errMsg = common.getMsg(LANG, "cannot.get.info.gang")
            raise UnCheckException(errMsg, ALL_CLI_RET, isSuccess)

        if "Error:" in cliRet:
            ALL_CLI_RET = common.joinLines(ALL_CLI_RET, cliRet)
            errMsg = common.getMsg(LANG, "cannot.get.info.gang")
            raise UnCheckException(errMsg, ALL_CLI_RET, isSuccess)

        # 截图包含关键字的回显
        keyWordList = ["show space statistic_info file_system_id=",
                       "File System Used",
                       "Snapshot Resvered Free",
                       ":/>"]
        keyWordLines = getCliRetByLine(cliRet, keyWordList)
        ALL_CLI_RET = common.joinLines(ALL_CLI_RET, keyWordLines)

        # 获取 File System Used和    Snapshot Resvered Free的值
        fileSysDetailList = cliUtil.getVerticalCliRet(cliRet)
        fsUsed = fileSysDetailList[0].get("File System Used", "")
        gangFreeMeta = fileSysDetailList[0].get("Snapshot Resvered Free", "")

        # 检查是否为空或者--
        if fsUsed == "" or gangFreeMeta == "" or fsUsed == "--" or gangFreeMeta == "--":
            errMsg = common.getMsg(LANG, "cannot.get.info.gang")
            raise UnCheckException(errMsg, ALL_CLI_RET, cliUtil.RESULT_NOCHECK)

        # 检查是否为数字
        if not (fsUsed.isdigit() and gangFreeMeta.isdigit()):
            errMsg = common.getMsg(LANG, "cannot.get.info.gang")
            raise UnCheckException(errMsg, ALL_CLI_RET, cliUtil.RESULT_NOCHECK)

        tempValue = int(fsUsed) - int(gangFreeMeta)
        fsScpValueDict[ctrID] = tempValue
        LOGGER.logInfo("getStatisticValue:ctrID:%s,tempValue:%s" % (ctrID, tempValue))

    return fsScpValueDict


def getEngineInfo(cli, ownCtrFSDict):
    """
    @summary: 获取engine和IP的映射的字典 及 engine和控制器ID的映射关系字典
    """

    engineIpListDict, cliRet = common.getEngineIps(cli, LANG)
    LOGGER.logInfo('controller management ip list in the engine is %s' % str(engineIpListDict))
    # 获取引擎和控制器的映射关系
    engineContrIDDict = {}
    for contrId in ownCtrFSDict:
        for engine in engineIpListDict:
            if engine == contrId[:1]:
                engineContrIDDict[engine] = engineContrIDDict.get(engine, []) + [contrId]
    return engineIpListDict, engineContrIDDict


def getCliRetByLine(cliRet, keyList):
    """
    @summary: 将cliRet回显按行分隔，只截取包含keyList中关键字的行
    @param cliRet:cli回显
    @param keyList: 关键字都是正则表达式的模式，列表中包含了命令和结束符
    @return:
        allCliRet：包含关键字的行的回显
    """
    allCliRet = ""
    cliRetList = cliRet.splitlines()
    if len(cliRetList) == 0:
        allCliRet = common.joinLines(allCliRet, cliRet)
        errMsg = common.getMsg(LANG, "cannot.get.info.gang")
        raise UnCheckException(errMsg, allCliRet)

    for line in cliRetList:
        for keyword in keyList:
            if keyword in line:
                allCliRet = common.joinLines(allCliRet, line)
    return allCliRet
