# coding:utf-8
import traceback

from com.huawei.ism.exception import IsmException

import checkByPortLink
import cliUtil
import common
from frameone.util import baseUtil
from frameone.util import contextUtil
from config import config_model_list

LANG = common.getLang(py_java_env)
LOGGER = common.getLogger(PY_LOGGER, __file__)


def execute(cli):
    keepAliveThread = ''
    allCliRet = ''
    context = contextUtil.getContext(py_java_env)
    try:
        cmd = 'show system config_model'
        devVersion = contextUtil.getCurVersion(context)
        if 'V500R007C60' in devVersion:
            return cliUtil.RESULT_NOSUPPORT, allCliRet, ''
        devType = contextUtil.getDevType(context)
        if devType in config_model_list:
            flag, cli_ret, err_msg = cliUtil.excuteCmdInCliMode(cli, cmd, True, LANG)
            allCliRet = common.joinLines(allCliRet, cli_ret)
            if flag != True:
                return cliUtil.RESULT_NOCHECK, allCliRet, err_msg
            if 'Single' in cli_ret:
                return True, allCliRet, ''
        keepAliveThread = common.AsynProgressExecuteCmd(cli, LOGGER, LANG)
        keepAliveThread.start_thread()
        LOGGER.logInfo("AsynProgressExecuteCmd keepAliveThread is start.")
        if baseUtil.isDoradoDev(devType):
            status, cli_ret, err_msg = checkByPortLink.execute(context)
            allCliRet = common.joinLines(allCliRet, cli_ret)
            keepAliveThread.setStopFlag(True)
            LOGGER.logInfo('status : %s, err_msg : %s' % (status, err_msg))
            return status, allCliRet, err_msg

        # V5R7C20及之后的版本走主机链路的方案
        if ("V3" in devVersion and devVersion >= "V300R006C30") \
                or ("V5" in devVersion and devVersion >= "V500R007C20"):
            status, cli_ret, err_msg = checkByPortLink.execute(context)
            allCliRet = common.joinLines(allCliRet, cli_ret)
            keepAliveThread.setStopFlag(True)
            LOGGER.logInfo('status : %s, err_msg : %s' % (status, err_msg))
            return status, allCliRet, err_msg

        # V5R7C20之前的版本走端口反查的方案
        status, cli_ret, err_msg = checkByPortLink.execute(context)
        allCliRet = common.joinLines(allCliRet, cli_ret)
        keepAliveThread.setStopFlag(True)
        LOGGER.logInfo('status : %s, err_msg : %s' % (status, err_msg))
        return status, allCliRet, err_msg
    except IsmException, ismException:
        LOGGER.logError(u"ismException :%s" % unicode(ismException.toString()))
        return cliUtil.RESULT_NOCHECK, allCliRet, common.getMsg(LANG, "query.result.abnormal")
    except:
        LOGGER.logError(traceback.format_exc())
        if keepAliveThread:
            keepAliveThread.setStopFlag(True)
        return cliUtil.RESULT_NOCHECK, allCliRet, common.getMsg(LANG, 'query.result.abnormal')
    finally:
        try:
            contextUtil.releaseRest(context)
            LOGGER.logInfo('conn close success.')
        except:
            LOGGER.logError('conn close except.')