# -*- coding: UTF-8 -*-
import common
import cliUtil
import config 


LANG = common.getLang(py_java_env)
LOGGER = common.getLogger(PY_LOGGER, __file__)
allCliRet = ""
def execute(cli):
    '''
            低端存储配置ip scale-out业务检查 
       1. 以admdin登录设备；
       2. 执行命令：show system general，查看设备型号；
       3. 执行命令：show upgrade package，查看控制器名称和系统补丁版本。
                若同时满足如下三个条件，检查不通过，否则检查通过：
       1. 设备型号"Product Model"，其值为2600 V3/2600F V3/5300 V5中一种；
       2. 控制器名称"Name"栏有xA/xB并且x>0；
       3. 补丁版本"Current Version"栏小于既定补丁版本(V300R005C00SPH308,V300R006C00SPH111,V300R006C10SPH105,V300R006C20SPH010,V500R007C00SPH105,V500R007C10SPH010，其它版本暂无热补丁，可忽略)。
    '''
    needInstallPatchVersion = {"V300R005C00SPC300":"V300R005C00SPH308",
                                "V300R006C00SPC100":"V300R006C00SPH111",
                                "V300R006C10SPC100":"V300R006C10SPH105",
                                "V500R007C00SPC100":"V500R007C00SPH105",
                                "V300R006C20":"V300R006C20SPH010",
                                "V500R007C10":"V500R007C10SPH010"
                               }
    global allCliRet
    flag = True
    errMsg = ""
    
    try:
        # 获取设备型号
        isQryOk, deviceType, cliRet, errMsg = cliUtil.getProductModelWithCliRet(cli, LANG)
        allCliRet = common.joinLines(allCliRet, cliRet)
        # 修改备注：getProductModelWithCliRet返回False是未检查
        if isQryOk != True:
            if not isQryOk:
                return cliUtil.RESULT_NOCHECK, allCliRet, errMsg
            return isQryOk, allCliRet, errMsg
        
        # 获取设备当前产品版本和补丁信息
        checkRet, currentVersionDictList, hotPatchVersionDictList = common.parse_upgradePackage(cli, LANG)
        allCliRet = common.joinLines(allCliRet, checkRet[1])
        if checkRet[0] != True:
            LOGGER.logSysAbnormal()
            return cliUtil.RESULT_NOCHECK, allCliRet, checkRet[2]

        result, currentVersion, errMsg = common.getCurrentVersion(currentVersionDictList, LANG)
        if not result:
            return cliUtil.RESULT_NOCHECK, allCliRet, errMsg  # 修改备注：getCurrentVersion返回False是未检查
        result, curHotPatchVer, errMsg = common.getCurrentVersion(hotPatchVersionDictList, LANG)
        if not result:
            return cliUtil.RESULT_NOCHECK, allCliRet, errMsg  # 修改备注：getCurrentVersion返回False是未检查
        result, engineList, errMsg = common.getEngineList(currentVersionDictList, LANG)
        if not result:
            return cliUtil.RESULT_NOCHECK, allCliRet, errMsg  # 修改备注：getCurrentVersion返回False是未检查
        LOGGER.logInfo("Get device info deviceType:%s currentVersion:%s curHotPatchVer%s engineList%s" % \
                       (deviceType, currentVersion, curHotPatchVer, str(engineList)))
        
        #判断是否涉及设备类型
        if deviceType not in config.ip_scale_out_model:
            return  (True, allCliRet, errMsg)
        #判断是否涉及版本
        if currentVersion not in config.ip_scale_out_version:
            return  (True, allCliRet, errMsg)
        #判断是否存在1号引擎
        if len(engineList) <= 1:
            return (True, allCliRet, errMsg)
        #判断是否打了对应的补丁
        if curHotPatchVer >= needInstallPatchVersion.get(currentVersion, "")\
         and curHotPatchVer != "--" and curHotPatchVer != "" and curHotPatchVer[-2:] != "99":
            return (True, allCliRet, errMsg)
        
        errMsg = common.getMsg(LANG, "ipscaleout.hotpatch.version.not.pass", curHotPatchVer)
        return (False, allCliRet, errMsg)
            
    except Exception, exception:
        LOGGER.logException(exception)
        return (cliUtil.RESULT_NOCHECK, allCliRet, common.getMsg(LANG, "query.result.abnormal"))

