# -*- coding: UTF-8 -*-
"""
@desc: 内存资源检查
@date: 2021.2.4
"""


from cbb.business.checkitems.software_memory_leakage_check import (
    MemoryLeakageCheck,
)
from cbb.frame.checkitem.context_adapter import InspectContext

import common
from cliUtil import RESULT_NOCHECK


PY_JAVA_ENV = py_java_env
JAVA_LOGGER = PY_LOGGER
LANG = common.getLang(PY_JAVA_ENV)
LOGGER = common.getLogger(JAVA_LOGGER, __file__)


def execute(cli):
    """
    内存资源检查
    :param cli:
    :return:
    """

    tool_context = InspectContext(PY_JAVA_ENV, cli)
    context_inspect = tool_context.get_context()
    context_inspect["logger"] = JAVA_LOGGER
    context_inspect["product_mode"] = str(PY_JAVA_ENV.get(
        "devInfo").getDeviceType())
    context_inspect["product_version"] = str(PY_JAVA_ENV.get(
        "devInfo").getProductVersion())
    item_check = MemoryLeakageCheck(context_inspect)

    try:
        flag, msg = item_check.check()
        LOGGER.logInfo("memory leakage check:{}".format(flag))
        res_flag, ret, msg = tool_context.get_result(
            flag, msg, item_check.get_origin_info())
        return res_flag, ret, msg

    except Exception as e:
        LOGGER.logError(str(e))
        return (
            RESULT_NOCHECK,
            item_check.get_origin_info(),
            common.getMsg(LANG, "query.result.abnormal"),
        )
