# -*- coding: UTF-8 -*-
import cliUtil
import common
import config
import traceback
from com.huawei.ism.tool.obase.exception import ToolException
PY_JAVA_ENV = py_java_env
LANG = common.getLang(PY_JAVA_ENV)
LOGGER = common.getLogger(PY_LOGGER, __file__)
allCliRet = ""
global allCliRet


productVersion2HotPatch = {"V500R007C00SPC100":"V500R007C00SPH105",
                           "V500R007C10":"V500R007C10SPH012",
                          }

def execute(cli):
    '''
        检查方法:
            步骤1 以admin用户登录设备；
步骤2 执行命令：show upgrade package，获取设备版本号和热补丁版本号；
步骤3 执行命令：show performance threshold，统计性能阈值条数。
        
        检查标准:
            
        1.如果步骤2设备为V5系列且版本号小于等于V500R007C10或设备为Dorado系列且版本号小于等于V300R001C21SPC100则继续检查，否则不涉及；
        2.如果步骤2设备版本为V500R007C00SPC100且安装V500R007C00SPH105及以后版本热补丁，或设备版本为V500R007C10且安装V500R007C10SPH012及以后版本热补丁，则检查通过，否则继续检查；
        3.如果步骤3设备为V5系列且性能阈值条数为6条则检查通过，否则检查不通过；
        4.如果步骤3设备为Dorado系列且性能阈值条数为4条则检查通过，否则检查不通过。
        
        修复建议:
        
        1.如果检查不通过，V5系列请安装V500R007C00SPH105或V500R007C10SPH012及以后版本补丁；
        2.其余版本建议联系技术工程师；
        3.如有任何疑问，请联系技术工程师。
    '''
    global allCliRet
    estimatedThresholdNum = None
    errMsg = ""
    try:
        #获取设备型号
        productModel = str(common.getProductModeFromContext(PY_JAVA_ENV))
        LOGGER.logInfo("Get product model from context :[%s]" % productModel)
        #获取设备当前产品版本
        checkRet, curProductVersionDictList, curHotPatchVersionDictList = common.parse_upgradePackage(cli, LANG)
        allCliRet = common.joinLines(allCliRet, checkRet[1])
        if checkRet[0] != True:
            LOGGER.logSysAbnormal()
            return (checkRet[0], allCliRet , checkRet[2])
        result, curProductVersion, errMsg = common.getCurrentVersion(curProductVersionDictList, LANG)
        if not result:
            return (cliUtil.RESULT_NOCHECK, allCliRet , errMsg)
        result, curHotPatchVersion, errMsg = common.getCurrentVersion(curHotPatchVersionDictList, LANG)
        if not result:
            return (cliUtil.RESULT_NOCHECK, allCliRet , errMsg)
        LOGGER.logInfo("Get product version :[%s] and hot patch version[%s]" % (curProductVersion, curHotPatchVersion))

        risk_map = {"dorado": ["V300R001C21SPC100", 4],
                    "V5": ["V500R007C10", 6]}
        version_key = common.get_product_key(productModel, curProductVersion)
        risk_version = risk_map.get(version_key, "")
        if not risk_version:
            return (
                cliUtil.RESULT_NOSUPPORT, common.version_no_support_msg_str(
                    productModel, curProductVersion, "",
                    "", LANG), "")

        if curProductVersion <= risk_version[0]:
            estimatedThresholdNum = risk_version[1]
        else:
            risky_version_msg = common.getMsg(
                LANG, "msg.less.than.or.equal", risk_version[0])
            no_support_msg = common.version_no_support_msg_str(
                "", curProductVersion, "",
                risky_version_msg, LANG)
            return (cliUtil.RESULT_NOSUPPORT, no_support_msg, "")
        
        solveProblemHotPatchVersion = productVersion2HotPatch.get(curProductVersion)
        if solveProblemHotPatchVersion and curHotPatchVersion >= solveProblemHotPatchVersion:
            return (True, allCliRet, "")
        
        (checkFLag, checkResult, errMsg) = checkPerfThresholdNum(cli, estimatedThresholdNum)
        if checkFLag != True:
            return (cliUtil.RESULT_NOCHECK, allCliRet, errMsg)
        if checkResult != True:
            errMsg = common.getMsg(LANG, "check.item.perf.threshold.nopass")
            return (cliUtil.RESULT_WARNING, allCliRet, errMsg)
        return (True, allCliRet, "")
            
    except ToolException:
        LOGGER.logError(str(traceback.format_exc()))
        return (cliUtil.RESULT_NOCHECK, allCliRet,
                common.getMsg(LANG, "query.result.abnormal"))
    except:
        LOGGER.logError(str(traceback.format_exc()))
        return (cliUtil.RESULT_NOCHECK, allCliRet, common.getMsg(LANG, "query.result.abnormal"))

def checkPerfThresholdNum(cli, estimatedThresholdNum):
    global allCliRet
    cmd = "show performance threshold"
    (flag, cliRet, errMsg) = cliUtil.excuteCmdInCliMode(cli, cmd, True, LANG)
    allCliRet = common.joinLines(allCliRet, cliRet)
    if flag != True:
        return (flag, "", errMsg)
    cliRetDictList = cliUtil.getHorizontalCliRet(cliRet)
    LOGGER.logInfo("performacce Num is [%s], estimatedThresholdNum is [%s]"%(len(cliRetDictList), estimatedThresholdNum))
    if len(cliRetDictList) != estimatedThresholdNum:
        return (True, False, "")
    return (True, True, "")
    
    