# -*- coding: UTF-8 -*-
import copy

from cbb.business.checkitems import SystemInnerCheck
from cbb.frame.cli import cliUtil
from cbb.frame.base import baseUtil
import common

PY_JAVA_ENV = py_java_env
LANG = common.getLang(py_java_env)
LOGGER = common.getLogger(PY_LOGGER, __file__)

# 界面状态 com.huawei.ism.tool.upgradeevalu.evalu.ResultFlag
STATUS_MAP_DICT = {
    "0": 7,  # 等待执行
    "1": 6,  # 执行中
    "2": 0,  # 执行成功
    "3": 1,  # 执行失败
    "4": 2,  # 执行错误
    "5": 3,  # 忽略
}


def execute(cli):
    data_dict = get_data_dict()
    common.refreshProcess(data_dict, 5, LOGGER)

    flag, cli_ret = is_super_admin(data_dict, cli)
    if not flag:
        return False, cli_ret, cliUtil.getMsg(LANG, "loginUser.name.level.must.be.super.admin")

    context = get_context(py_java_env, cli)
    observer = UiObserver(data_dict)
    context["checkType"] = "Inspection"
    context["observer"] = observer
    context["SFTP"] = py_java_env.get("SFTP")
    context["ignorePreCheckItems"] = data_dict.get("ignorePreCheckItems", "")
    context["supportItemsIgnore"] = data_dict.get('supportItemsIgnore', "")
    context["zone_ids"] = get_select_zone_ids()
    common.refreshProcess(data_dict, 99, LOGGER)
    LOGGER.info("start system inner check.")
    check_obj = SystemInnerCheck.UpgradeCheck(context)
    flag, err_msg, original_information = check_obj.execute()

    if flag:
        return True, original_information, ""
    return False, original_information, err_msg


def is_super_admin(data_dict, cli):
    check_dev = data_dict.get("checkDevNode")
    user_name = check_dev.getDevNode().getLoginUser().getUserName()
    # 判断是否为超级管理员权限；如果为域用户登录的设备，需要将 domain/ 标识去掉
    flag, is_super, cli_ret = cliUtil.is_super_administrator(cli, user_name.replace("domain/", ""), LANG)
    LOGGER.info("current user role is super admin:{}".format(is_super))
    if not flag or not is_super:
        return False, cli_ret
    return True, cli_ret


def get_data_dict():
    data_dict = PY_JAVA_ENV
    data_dict['checkType'] = "Inspection"
    data_dict["logger"] = LOGGER
    data_dict["lang"] = LANG
    return data_dict


def get_select_zone_ids():
    import com.huawei.ism.tool.inspect.utils.InspectUtils as InspectUtils
    return InspectUtils.getSelectZoneIDs()


def get_context(py_java_env, cli):
    # 测试时方便mock，在方法内import
    from cbb.frame.checkitem.context_adapter import InspectContext
    inspect_context = InspectContext(py_java_env, cli)
    return inspect_context.get_context()


class UiObserver():
    def __init__(self, data_dict):
        self.data_dict = data_dict
        self.logger = data_dict.get("logger")
        self.lang = data_dict.get("lang")
        self.ui_update_msg = {}
        self.dev = self.data_dict.get("checkDevNode")
        self.ui_observer = self.data_dict.get("uiObserver")

    def postMsg(self, inner_items):
        # 先移除所有老的内部检查项，再加上新的
        self.ui_update_msg["checkitems"] = inner_items
        # 更新巡检界面
        self.logger.info("update inspection interface.inner items:{}".format(inner_items))
        self.logger.info("ui_observer:{}".format(self.ui_observer))
        self.ui_observer.updateChildItems(self.dev, self.ui_update_msg)

    def toUiStatus(self, status):
        return STATUS_MAP_DICT.get(status, 7)

    def setProgress(self, progress):
        progress = int(progress * 0.9)
        # 执行下沉检查项的检查前，进度已经是1%了；int()是向下取整，可能会小于1；
        self.logger.info("propress:{}".format(progress))
