# -*- coding: UTF-8 -*-
import cliUtil
import common
import cli_util_cache
LANG = common.getLang(py_java_env)
LOGGER = common.getLogger(PY_LOGGER, __file__)


def execute(cli):
    '''
        硬盘状态检查：
        Health Status为Normal且Running Status为Online表示正常，其它情况均属于不正常状态。
    '''
    cliRet = ""

    try:
        disk_dict_list, cli_ret = cli_util_cache.get_disk_general_cache(
            py_java_env, cli, LOGGER)

        if not disk_dict_list:
            return True, cli_ret, ''

        err_msg_list = []
        for line in disk_dict_list:
            hel_status = line.get("Health Status")
            running_status = line.get("Running Status")
            if hel_status == "Normal" and running_status == "Online":
                continue

            disk_id = line.get("ID")
            e_label = line.get("Item") or 'Unknown'

            err_msg_list.append(common.getMsg(LANG,
                                              "disk.status.abnormal",
                                              disk_id))

            LOGGER.logNoPass("The Disk [%s] is abnormal" % disk_id)
            err_msg_list.append(common.getMsg(LANG, "disk.bom.info",
                                              (disk_id, e_label)))
            LOGGER.logNoPass("ID:[%s],BOMCode:%s" % (disk_id, e_label))

        if err_msg_list:
            return False, cli_ret, "".join(err_msg_list)
            
        return True, cli_ret, ""

    except common.UnCheckException as uncheck_except:
        LOGGER.logException(uncheck_except)
        return (cliUtil.RESULT_NOCHECK, uncheck_except.cliRet,
                uncheck_except.errorMsg)

    except Exception, exception:
        LOGGER.logException(exception)
        return (cliUtil.RESULT_NOCHECK, cliRet, common.getMsg(LANG, "query.result.abnormal"))
