# -*- coding: UTF-8 -*-
import cliUtil
import common
import expandconfig

lang = common.getLang(py_java_env)
logger = common.getLogger(PY_LOGGER, __file__)
expConfigObj = expandconfig.ExpandConfig(py_java_env)
VERSION_WHILE_STR = "V300R003C20SPC200"
VERSION_WHILE_LIST = ["V300R006", "V500R007"]

# 进度总剩余时间
LIMIT_TIME = 120
# 进度刷新间隔
INTERVAL = 2


def execute(cli):
    """
    硬盘容量截断检查
    """
    ret = run_check(cli)
    # 改结果用于RAID10存储层扩容检查
    py_java_env.update({
        "check_item_hardware_disk_capacity_cut.result": list(ret),
    })
    return ret


def run_check(cli):
    flag = True
    cliRetAll = ""
    errMsg = ""
    try:
        expDiskInfoDict = expConfigObj.getExpDiskInfo()
        logger.logInfo("The expDiskInfoDict is %s" % expDiskInfoDict)

        # 新建硬盘域,则检查通过
        if not expDiskInfoDict:
            return True, cliRetAll, errMsg

        # 进度条刷新
        common.threadUpProcess(py_java_env, LIMIT_TIME, INTERVAL, logger)
        # 进度开始
        common.inProcess(py_java_env)
        logger.logInfo("process Thread started!")

        # 获取设备型号
        devInfo = common.getCurDeviceInfo(py_java_env)
        productModel = str(devInfo.getDeviceType())

        # 获取系统版本和补丁版本
        cliRet, softwareVersion, hotPatchVersion = \
            common.getHotPatchVersionAndCurrentVersion(cli, lang)

        result, cliRet, allErrMsg = checkSmallDisk(cli, expDiskInfoDict)
        if result != True:      # noqa
            return result, cliRet, allErrMsg

        # 遍历扩容硬盘域
        for diskDomainId in expDiskInfoDict:
            # 获取扩容引擎硬盘类型-容量集合字典,例如 {0: {'SAS': set([700]), 'SSD': set([521])}}  # noqa
            expEngineDiskCapacityDic = \
                expConfigObj.getExpEngineDiskCapacityOnDD(diskDomainId)
            logger.logInfo(
                "The expEngineDiskCapacityDic is %s" % expEngineDiskCapacityDic
            )

            # 获取扩容引擎硬盘类型-数量集合字典,例如{0: {'SAS': 25, 'SSD': 12}
            expEngineDiskNumDic = expConfigObj.getExpEngineDiskNumOnDD(
                diskDomainId
            )
            logger.logInfo(
                "The expEngineDiskNumDic is %s" % expEngineDiskNumDic
            )

            # 获取指定硬盘域的信息
            checkRet = common.getDiskDomainInfoById(cli, diskDomainId, lang)
            cliRetAll += checkRet[1]
            if not checkRet[0]:
                logger.logError("fail to get the disks number")
                return cliUtil.RESULT_NOCHECK, cliRetAll, checkRet[2]
            # 获取系统扩容引擎硬盘类型-数量集合字典, 例如{0: {'SAS': 25, 'SSD': 12} # noqa
            sysCurEngDiskNumDic = common.getEngDiskNumByDD(
                cli,
                checkRet[3],
                lang,
                productModel
            )
            logger.logInfo(
                "The sysCurEngDiskNumDic is %s" % sysCurEngDiskNumDic
            )

            # 获取系统扩容引擎硬盘类型-容量集合字典,例如 {0: {'SAS': set([700]), 'SSD': set([521])}}    # noqa
            checkRet = common.getEngDiskCapByDD(
                cli, checkRet[3], lang, productModel
            )
            cliRetAll += checkRet[1]
            if not checkRet[0]:
                logger.logError("fail to get the disks capacity")
                return cliUtil.RESULT_NOCHECK, cliRetAll, checkRet[2]

            sysCurEngDiskCapDic = checkRet[3]
            # 遍历扩容引擎
            for engineId in expEngineDiskCapacityDic:

                pEngId = common.getDisplayEngId(engineId, productModel)
                # 系统当前硬盘类型-数量字典
                sysCurDiskTypeDic = sysCurEngDiskNumDic.get(engineId, {})
                logger.logInfo(
                    "The sysCurDiskTypeDic is %s" % sysCurDiskTypeDic
                )
                if not sysCurDiskTypeDic:
                    continue

                # 获取指定引擎硬盘类型容量字典 ,例如 {'SAS': set([700]), 'SSD': set([700,900])}     # noqa
                expDiskTypeCapacityDic = expEngineDiskCapacityDic.get(engineId)
                logger.logInfo(
                    "The expDiskTypeCapacityDic is %s" % expDiskTypeCapacityDic
                )

                # 获取引擎下新扩(新增层级)硬盘类型-容量集合字典
                expNewDiskTypeCapacityDic = {}
                # 获取引擎下扩容已有硬盘类型-容量集合字典
                expOldDiskTypeCapacityDic = {}
                for k, v in expDiskTypeCapacityDic.items():
                    if k not in sysCurDiskTypeDic.keys():
                        expNewDiskTypeCapacityDic[k] = v
                    else:
                        expOldDiskTypeCapacityDic[k] = v

                # 新增层级,容量不相同,检查不通过
                for expNewDiskType in expNewDiskTypeCapacityDic:
                    diskCapacitySet = expNewDiskTypeCapacityDic.get(
                        expNewDiskType, set())
                    diskCapacitySetBase50GB = \
                        common.getDiskCapListBaseOn50GBDiff(diskCapacitySet)
                    if len(set(diskCapacitySetBase50GB)) > 1:
                        logger.logNoPass(
                            "The diskCapacity of expand new disk "
                            "[diskDomainId:%s, engineId:CTE%s, diskType:%s] exceed 1" % (diskDomainId, engineId, expNewDiskType))   # noqa
                        flag = False
                        errMsg += common.getMsg(
                            lang,
                            "check.expand.engine.new.disk.capacity.not.pass",
                            (diskDomainId, pEngId, expNewDiskType)
                        )
                        continue

                # 系统当前硬盘类型-容量字典
                sysCurDiskTypeCapacityDic = sysCurEngDiskCapDic.get(
                    engineId, {}
                )
                logger.logInfo(
                    "The sysCurDiskTypeCapacityDic is %s" %
                    sysCurDiskTypeCapacityDic
                )
                if not sysCurDiskTypeCapacityDic:
                    continue

                allDiskTypeCapacityDic = {}
                for k in expOldDiskTypeCapacityDic:
                    allDiskTypeCapacityDic[k] = \
                        expOldDiskTypeCapacityDic.get(k) | \
                        sysCurDiskTypeCapacityDic.get(k)
                logger.logInfo(
                    "The allDiskTypeCapacityDic is %s" % allDiskTypeCapacityDic
                )

                for diskType in allDiskTypeCapacityDic:
                    diskCapacitySet = allDiskTypeCapacityDic.get(
                        diskType, set())
                    diskCapacitySetBase50GB = common.getDiskCapListBaseOn50GBDiff(diskCapacitySet)      # noqa
                    logger.logInfo(
                        "diskCapacitySetBase50GB: %s" % diskCapacitySetBase50GB
                    )
                    # 类型相同,容量超过两种,检查不通过
                    if len(set(diskCapacitySetBase50GB)) > 2:
                        logger.logNoPass(
                            "The diskCapacity of expand disk "
                            "[diskDomainId:%s, engineId:CTE%s, diskType:%s] exceed 2" % (diskDomainId, engineId, diskType))     # noqa
                        flag = False

                        errMsg += common.getMsg(
                            lang,
                            "check.expand.engine.disk.capacity1.not.pass",
                            (diskDomainId, pEngId, diskType)
                        )
                        continue

                    if len(set(diskCapacitySetBase50GB)) == 2:
                        # 计算硬盘阈值
                        checkRet = common.getDiskTruncationThreshold(
                            cli, diskDomainId, diskType, lang)
                        cliRetAll += checkRet[1]
                        if not checkRet[0]:
                            return (
                                cliUtil.RESULT_NOCHECK,
                                cliRetAll,
                                checkRet[2]
                            )
                        diskTruncationThreshold = checkRet[3]
                        logger.logInfo("The diskTruncationThreshold is %s" % diskTruncationThreshold)   # noqa

                        # 获取引擎下新扩硬盘类型数量字典
                        expDiskTypeNumDic = expEngineDiskNumDic.get(engineId)
                        logger.logInfo(
                            "The expDiskTypeNumDic is %s" % expDiskTypeNumDic
                        )

                        # 计算新扩硬盘数量
                        expDiskNum = expDiskTypeNumDic.get(diskType)
                        # VERSION_WHILE_LIST版本,新扩硬盘（同类型）数量大于等于"截断阈值"则检查通过，小于"截断阈值"则检查不通过    # noqa
                        checkRet = common.getSysVersion(cli, lang)
                        if not checkRet[0]:
                            return (
                                cliUtil.RESULT_NOCHECK,
                                checkRet[1],
                                checkRet[2]
                            )
                        sysVersion = checkRet[3]
                        if sysVersion == VERSION_WHILE_STR or filter(lambda x : sysVersion >= x, VERSION_WHILE_LIST):   # noqa
                            if expDiskNum < diskTruncationThreshold:
                                logger.logNoPass("The disk number of system exist disk [diskDomainId:%s, engineId:CTE%s, diskType:%s, diskNum:%s] is less than Threshold (Threshold:%s)" % (diskDomainId, engineId, diskType, expDiskNum, diskTruncationThreshold))     # noqa
                                flag = False
                                errMsg += common.getMsg(lang, "check.expand.engine.disk.number.less.threshold1.not.pass", (diskDomainId, pEngId, diskType, expDiskNum, diskTruncationThreshold))    # noqa
                            continue

                        # 现有盘数加上新扩盘数
                        sysCureDiskNum = sysCurDiskTypeDic.get(diskType)
                        allDiskNum = sysCureDiskNum + expDiskNum
                        if allDiskNum > 64:
                            logger.logNoPass("The total number of disks [diskDomainId:%s, engineId:CTE%s, diskType:%s, diskNum:%s] exceed 64" % (diskDomainId, engineId, diskType, expDiskNum))     # noqa
                            flag = False
                            errMsg += common.getMsg(lang, "check.expand.engine.disk.number.exceeded.not.pass", (diskDomainId, pEngId, diskType, sysCureDiskNum, expDiskNum))    # noqa
                            continue

                        # 现有盘数加上新扩盘数不超过64块
                        if allDiskNum <= 64:
                            if expDiskTypeNumDic.get(diskType) < diskTruncationThreshold:   # noqa
                                logger.logNoPass("The disk number of expand disk [diskDomainId:%s, engineId:CTE%s, diskType:%s, diskNum:%s] is less than Threshold (Threshold:%s)" % (diskDomainId, engineId, diskType, expDiskNum, diskTruncationThreshold))   # noqa
                                flag = False
                                errMsg += common.getMsg(lang, "check.expand.engine.disk.number.less.threshold2.not.pass", (diskDomainId, pEngId, diskType, expDiskNum, diskTruncationThreshold))    # noqa
                                continue

                        # 若系统版本为V300R003C10SPC100，
                        # 热补丁版本为V300R003C10SPH105及其往后版本
                        if sysVersion == "V300R003C10SPC100" \
                                and hotPatchVersion >= "V300R003C10SPH105":
                            if expDiskNum >= 30:
                                logger.logNoPass(
                                    "The disk number of expand disk "
                                    "[diskDomainId:%s, engineId:CTE%s, "
                                    "diskType:%s, diskNum:%s] exceed 30" % (
                                        diskDomainId, engineId, diskType,
                                        expDiskNum))
                                flag = False
                                errMsg += common.getMsg(
                                    lang,
                                    "check.expand.disk.number.exceed.30",
                                    (diskDomainId, pEngId, diskType,
                                     expDiskNum))
                            continue

        return flag, cliRetAll, errMsg
    except Exception as exception:
        logger.logException(exception)
        return cliUtil.RESULT_NOCHECK, cliRetAll, common.getMsg(
            lang, "query.result.abnormal")
    finally:
        common.finishProcess(py_java_env)
        logger.logInfo("finish process!")


def checkSmallDisk(cli, expDiskInfoDict):

    cliRetAll = ""
    allErrMsg = ""
    result = True
    devInfo = common.getCurDeviceInfo(py_java_env)
    productModel = str(devInfo.getDeviceType())

    for diskDomainId in expDiskInfoDict:
        # 获取硬盘域下的硬盘
        flag, cliRet, errMsg, diskInDomainList = common.getDiskDomainInfoById(
            cli, diskDomainId, lang)
        cliRetAll += cliRet
        if not flag:
            logger.logError(
                "fail to get the disks in diskdomain[ID:%s]" % diskDomainId)
            allErrMsg += errMsg
            return cliUtil.RESULT_NOCHECK, cliRetAll, allErrMsg

        expDisks = expDiskInfoDict.get(diskDomainId)
        # 获取当前硬盘域中最小容量盘信息字典
        get_flag, ori_disk_info, err_msg = get_ori_min_disk_cap(
            cli, diskInDomainList, productModel)
        if not get_flag:
            allErrMsg += err_msg
            return cliUtil.RESULT_NOCHECK, cliRetAll, allErrMsg

        for expDisk in expDisks:
            expType = expDisk.getDiskType()
            expCap = expDisk.getDiskCapacity()
            physicEng = expDisk.getDiskEngineId()
            logicEng = expDisk.getDiskLogicEngId()
            for exp_key in [(logicEng, expType), (physicEng, expType)]:
                if exp_key in ori_disk_info:
                    expOriCap = expDisk.getOriginDiskCapacity() + \
                                expDisk.getOriginDiskUnit()
                    fact_capacity = ori_disk_info.get(exp_key).get(
                        "fact_capacity")
                    e_capacity = ori_disk_info.get(exp_key).get("e_capacity")
                    if int(expCap) < int(fact_capacity):
                        result = False
                        pEngId = common.getDisplayEngId(exp_key[0],
                                                        productModel)
                        logger.logNoPass("The device has small disks,engine "
                                         "id=%s,disk type=%s,newcap=%s,"
                                         "oldcap=%s" % (pEngId, expType,
                                                        expCap, fact_capacity))
                        allErrMsg += common.getMsg(
                            lang,
                            "check.expand.engine.disk.is.small",
                            (pEngId, diskDomainId, expType, expOriCap,
                             e_capacity))

    return result, cliRetAll, allErrMsg


def get_ori_min_disk_cap(cli, diskInDomainList, productModel):
    """ 获取当前硬盘域中最小容量盘信息字典

    :param cli: cli连接
    :param diskInDomainList: 硬盘域中硬盘列表
    :param productModel: 产品型号
    :return:
    """
    ori_disk_info = dict()
    for disk in diskInDomainList:
        engId = common.getEngineIdByDiskId(disk.get("ID"), productModel)
        diskId = disk.get("ID")
        diskType = disk.get("Type")
        info_key = (engId, diskType)

        flag, elabeldiskCapacity, errMsg = common.getDiskCapacityByDiskId(
            cli, diskId, lang, isOrigin=True)
        if not flag:
            return False, {}, errMsg

        __, fact_capacity = common.changUnit2GB(elabeldiskCapacity,
                                                isLabelCap=True)
        # 硬盘最小容量信息，标签容量，实际容量
        capacity_dict = {
            "e_capacity": elabeldiskCapacity,
            "fact_capacity": fact_capacity
        }
        # 刷新同一硬盘域，同一引擎，同一类型的硬盘最小容量
        if info_key not in ori_disk_info \
                or ori_disk_info.get(info_key).get("fact_capacity") \
                > fact_capacity:
            ori_disk_info[info_key] = capacity_dict
    return True, ori_disk_info, ""
