# -*- coding: UTF-8 -*-
import cliUtil
import common
import decimal

LANG = common.getLang(py_java_env)
LOGGER = common.getLogger(PY_LOGGER, __file__)

def execute(cli):
    '''
        机框状态检查：
            1 若存在高密框（硬盘框类型为”4U 75 Slot 3.5 SAS Disks Enclosure“）则继续检查；否则检查通过。
            2 若高密框中存在10TB（容量大于等于8.7TB且小于等于9.3TB）的NearLine SAS硬盘，则检查结果为不通过；否则检查通过。
    '''
    flag = True
    allCliRet = ""
    errMsg = ""
    enclosureID4U = []
    bugDiskIdList = []
    BUG_DEVTYPE_DICT = {
    "S2600T":"SERIES_T",
    "S5500T":"SERIES_T",
    "S5600T":"SERIES_T",
    "S5800T":"SERIES_T",
    "S6800T":"SERIES_T",
    "2800 V3":"SERIES_V3",
    "5300 V3":"SERIES_V3",
    "5500 V3":"SERIES_V3",
    "5600 V3":"SERIES_V3",
    "5800 V3":"SERIES_V3",
    "6800 V3":"SERIES_V3",
    "6900 V3":"SERIES_V3",
    "18500":"SERIES_18000",
    "18800":"SERIES_18000",
    "18800F":"SERIES_18000",
    "HVS85T":"SERIES_18000",
    "HVS88T":"SERIES_18000",
    }
    BUG_DEVVES_DICT = {
    "SERIES_T":("V200R002C20SPC200","V200R002C30","V200R002C30SPC200"),
    "SERIES_18000":("V100R001C20SPC200","V100R001C30","V100R001C30SPC100","V100R001C30SPC200"),
    "SERIES_V3":("V300R001C10SPC100","V300R001C10SPC200","V300R001C20","V300R001C20SPC200","V300R002C10","V300R002C10SPC100","V300R002C10SPC200","V300R003C00SPC100","V300R003C10SPC100"),
    }
    try:
        #获取设备型号
        result, productModel, cliRet, errMsg = cliUtil.getProductModelWithCliRet(cli, LANG)
        if result != True:
            if not result:
                return cliUtil.RESULT_NOCHECK, cliRet, errMsg  # 修改备注：获取设备型号（getProductModelWithCliRet）失败
            return (result, cliRet, errMsg)
        if productModel not in BUG_DEVTYPE_DICT:
            return (cliUtil.RESULT_NOSUPPORT, cliRet, errMsg)

        series = BUG_DEVTYPE_DICT.get(productModel)
        #获取设备当前产品版本和补丁信息
        checkRet, currentVersionDictList, hotPatchVersionDictList = common.parse_upgradePackage(cli, LANG)
        allCliRet = cliRet + "\n" + checkRet[1]
        if checkRet[0] != True:
            return cliUtil.RESULT_NOCHECK, allCliRet, checkRet[2]

        result, currentVersion, errMsg = common.getCurrentVersionFilterBVer(currentVersionDictList, LANG)
        if not result:
            return (cliUtil.RESULT_NOCHECK, allCliRet, errMsg)  # 修改备注：无法获取产品版本信息（getCurrentVersionFilterBVer）返回False

        if currentVersion not in BUG_DEVVES_DICT.get(series):
            return (cliUtil.RESULT_NOSUPPORT, allCliRet, errMsg)

        cmd = "show enclosure |filterColumn include columnList=ID,Type"
        checkRet = cliUtil.excuteCmdInCliMode(cli, cmd, True, LANG)
        allCliRet = checkRet[1]
        if checkRet[0] != True:
            return (checkRet[0], allCliRet, checkRet[2])

        if cliUtil.queryResultWithNoRecord(checkRet[1]):
            return (True, allCliRet, checkRet[2])

        cliRetLinesList = cliUtil.getHorizontalCliRet(checkRet[1])
        if len(cliRetLinesList) == 0:
            errMsg = common.getMsg(LANG, "cannot.get.enclosure.info")
            LOGGER.logNoPass("Cannot get information about enclosure")
            return (cliUtil.RESULT_NOCHECK, allCliRet, errMsg)  # 修改备注：解析回显失败导致列表长度为0
     
        for line in cliRetLinesList:
            enclosureId = line.get("ID","")
            type = line.get("Type","")
            if enclosureId and "4U 75 Slot 3.5 SAS Disks Enclosure" == type:
                enclosureID4U.append(enclosureId)
        if not enclosureID4U:
            return (True, allCliRet, errMsg)

        cmd = "show disk general |filterColumn include columnList=ID,Type,Capacity"
        checkRet = cliUtil.excuteCmdInCliMode(cli, cmd, True, LANG)
        allCliRet += "\n" + checkRet[1]
        if checkRet[0] != True: 
            return checkRet[0], allCliRet, checkRet[2]

        cliRetLinesList = cliUtil.getHorizontalCliRet(checkRet[1])
        if len(cliRetLinesList) == 0:
            errMsg = common.getMsg(LANG, "cannot.get.diskinfo")
            LOGGER.logNoPass("Cannot get information about disk")
            return (False, allCliRet, errMsg)

        for line in cliRetLinesList:
            diskId = line.get("ID","")
            type = line.get("Type","")
            capcacity = line.get("Capacity","0TB")
            num = cliUtil.transferCapToTB(capcacity)
            if diskId and type == "NearLine SAS" and decimal.Decimal("8.7") <= decimal.Decimal(str(num)) <= decimal.Decimal("9.3"):
                bugDiskIdList.append(diskId)
        if bugDiskIdList:
            flag = False
            errMsg = common.getMsg(LANG, "disk.10TBNL-SAS.info",", ".join(bugDiskIdList))

        return (flag, allCliRet, errMsg)

    except Exception:
        return (cliUtil.RESULT_NOCHECK, allCliRet, common.getMsg(LANG, "query.result.abnormal"))
