# -*- coding: UTF-8 -*-
import cliUtil
import traceback
import common

from frameone.util import contextUtil
from frameone.rest import restData
from frameone.rest import restUtil
from common import UnCheckException
from com.huawei.ism.exception import IsmException
import re

LANG = common.getLang(py_java_env)
LOGGER = common.getLogger(PY_LOGGER, __file__)
PY_JAVA_ENV = py_java_env
allCliRet = ""
REST_CAN_NOT_CONNECT_CODE = "1073949185"
STATUS_ONLINE = "27"

REST_SAS_MODEL = ["67", "69"]


def execute(cli):
    """
    @summary: “开局巡检”场景中增加对SAS环路硬盘框级联深度的检查，检查用户的配置是否在推荐的范围内。
    """
    try:
        global allCliRet
        # 获取产品型号和版本
        ret = cliUtil.getProductModelAndVersion(cli, LANG)
        if ret[0] is not True:
            return (cliUtil.RESULT_NOCHECK, ret[1], ret[2])
        
        allCliRet = common.joinLines(allCliRet, ret[3])
        productModel = ret[1]
        productVersion = ret[2]
        
        # 获取硬盘信息
        disksInfo = getDisksInfo(cli)
        if not disksInfo:
            return (True, allCliRet, "")
        flag, enginesSasLoops, sasLoopsEnclosures, sasLoopsExpansionDepth, enclosuresHeight, enclosuresInfo, sasLoopsDiskTypes = getExpansionDepthByRest(disksInfo)

        if not flag:
            return (False, allCliRet, common.getMsg(LANG, "query.result.abnormal"))

        LOGGER.logInfo("All engines under the loop are %s" % str(enginesSasLoops))
        if not enginesSasLoops:
            # 没有sas环路(盘框一体设备)，无需检查
            return (True, allCliRet, "")
        LOGGER.logInfo("Depth of all loops are %s" % str(sasLoopsExpansionDepth))
        if not sasLoopsExpansionDepth:
            errMsg = common.getMsg(LANG, "cannot.get.cascading.depth")
            return (cliUtil.RESULT_NOCHECK, allCliRet, errMsg)
        if not sasLoopsDiskTypes:
            errMsg = common.getMsg(LANG, "cannot.get.disk.enclosure")
            return (cliUtil.RESULT_NOCHECK, allCliRet, errMsg)
        # 获取sas环路下的硬盘框
        LOGGER.logInfo("sas loop enc: {}, sas loop disktypes:{}".format(str(sasLoopsEnclosures), sasLoopsDiskTypes))
        if not sasLoopsEnclosures:
            errMsg = common.getMsg(LANG, "cannot.get.disk.enclosure")
            return (cliUtil.RESULT_NOCHECK, allCliRet, errMsg)

        # 获取所有硬盘框的高度
        LOGGER.logInfo("All enclosures height are %s" % str(enclosuresHeight))
        if not enclosuresHeight:
            errMsg = common.getMsg(LANG, "cannot.get.disk.enclosure")
            return (cliUtil.RESULT_NOCHECK, allCliRet, errMsg)
        
        # 检查sas环路下的级联深度是否在推荐的范围内
        errMsg = checkSasLoopExpansionDepth(sasLoopsExpansionDepth, sasLoopsDiskTypes, sasLoopsEnclosures, enclosuresHeight, productModel, productVersion)
        if errMsg:
            sugg = common.getMsg(LANG, "cascading.depth.exceeding.warning.suggest")
            return (cliUtil.RESULT_WARNING, allCliRet, errMsg + sugg)
        
        # 获取所有引擎下的SAS端口数量
        engIds = enginesSasLoops.keys()
        engineSasPortNumber = getEngineSasPortNumber(cli, productModel, engIds)
        LOGGER.logInfo("Sas ports of engines are %s." % str(engineSasPortNumber))
        if not engineSasPortNumber:
            return (True, allCliRet, "")
        
        # 检查引擎下级联框是否均衡
        flag, errMsg = checkSasLoopBalance(enginesSasLoops, sasLoopsExpansionDepth, sasLoopsDiskTypes, sasLoopsEnclosures, engineSasPortNumber, enclosuresInfo, productModel, productVersion)
        return (flag, allCliRet, errMsg)

    except UnCheckException, unCheckException:
        LOGGER.logException(unCheckException)
        return (cliUtil.RESULT_NOCHECK, unCheckException.cliRet, unCheckException.errorMsg)

    except Exception, exception:
        LOGGER.logException(exception)
        return (cliUtil.RESULT_NOCHECK, allCliRet, common.getMsg(LANG, "query.result.abnormal"))


def getDisksInfo(cli):
    """
    @summary: 获取设备上所有硬盘的信息
    @return: 硬盘信息字典组成的列表
    """
    global allCliRet

    cmd = "show disk general"
    flag, cliRet, errMsg = cliUtil.excuteCmdInCliMode(cli, cmd, True, LANG)
    allCliRet = common.joinLines(allCliRet, cliRet)
    
    if flag != True:
        errMsg = common.getMsg(LANG, "cannot.get.diskinfo")
        LOGGER.logNoPass("Get disk failed!")
        raise UnCheckException(errMsg, allCliRet)
    
    if cliUtil.queryResultWithNoRecord(cliRet):
        return []
    
    disksInfo = cliUtil.getHorizontalCliRet(cliRet)
    if len(disksInfo) == 0:
        errMsg = common.getMsg(LANG, "cannot.get.diskinfo")
        LOGGER.logNoPass("Parse disk failed!")
        raise UnCheckException(errMsg, allCliRet)
    
    return disksInfo

def getExpansionDepthByRest(disksInfo):
    """
    通过rest来查询组装数据
    :return:
    """
    global allCliRet
    # 引擎：环路号 例如{0: [1]}
    enginesSasLoops = {}
    #  #{(0, 1): [u'DAE010']} 引擎：环路号：硬盘框
    sasLoopsEnclosures = {}
    #{(0, 1): 1} （引擎：环路号）：级联深度
    sasLoopsExpansionDepth = {}
    #硬盘框高度
    enclosuresHeight = {}
    #硬盘框信息
    enclosuresInfo = []
    #获取硬盘类型
    sasLoopsDiskTypes = {}

    dataDict = contextUtil.getContext(PY_JAVA_ENV)
    cmdStr = "enclosure/"
    rest = contextUtil.getRest(dataDict)
    records = []
    try:
        records = restUtil.CommonRestService.get4Big(rest, cmdStr)
        LOGGER.logInfo("records :%s" % records)
        allCliRet = common.joinLines(allCliRet, str(records))
    except IsmException, ismException:
        LOGGER.logInfo(u"ismException :%s" % unicode(ismException.toString()))
        return False, enginesSasLoops, sasLoopsEnclosures, sasLoopsExpansionDepth, enclosuresHeight, enclosuresInfo
    except Exception, exception:
        if exception.args[0] == REST_CAN_NOT_CONNECT_CODE:
            try:
                if rest:
                    rest.close()
                    LOGGER.logInfo("conn close success!")
            except Exception, e:
                LOGGER.logInfo("conn close except: %s" % str(e))
        LOGGER.logException(exception)
        return False, enginesSasLoops, sasLoopsEnclosures, sasLoopsExpansionDepth, enclosuresHeight, enclosuresInfo



    for record in records:
        expansionDepth = int(record.get("EXPANDERDEPTH", 0))
        sasLoops = record.get("EXPANDERPORT", '')
        engine = record.get("visibleAreaId", '')
        enclosureName =  record.get("NAME", '')
        model =  record.get("MODEL", '')
        status =  record.get("RUNNINGSTATUS", '')
        height =  record.get("HEIGHT", '')

        if not engine or not enclosureName:
            LOGGER.logInfo("REST interface returns incorrect data.")
            return False, enginesSasLoops, sasLoopsEnclosures, sasLoopsExpansionDepth, enclosuresHeight, enclosuresInfo

        if model not in REST_SAS_MODEL or status != STATUS_ONLINE:
            LOGGER.logInfo("Abnormal state of hard enclosure" + str(record))
            continue

        sasLoop = (engine, sasLoops)
        #组装enginesSasLoops数据 {(0, 1): 1} （引擎：环路号）：级联深度
        buildData2Map(enginesSasLoops, engine, sasLoops)
        #组装sasLoopsEnclosures数据
        sasLoopsEnclosures[sasLoop] = enclosureName
        #组装sasLoopsExpansionDepth数据
        sasLoopsExpansionDepth[sasLoop] = expansionDepth
        #组装硬盘框高度
        enclosuresHeight[enclosureName] = height
        enclosureInfo = {}
        enclosureInfo["ID"] = enclosureName
        enclosureInfo["HEIGHT"] = height
        enclosuresInfo.append(enclosureInfo)
        # 获取sas环路下的硬盘类型
        sasLoopsDiskTypes = getSasLoopsDiskTypes(disksInfo, sasLoopsDiskTypes, engine, sasLoops, enclosureName)



    if rest:
        try:
            rest.close()
            LOGGER.logInfo("conn close success!")
        except Exception, e:
            LOGGER.logInfo("conn close except: %s" % str(e))

    return True, enginesSasLoops, sasLoopsEnclosures, sasLoopsExpansionDepth, enclosuresHeight, enclosuresInfo, sasLoopsDiskTypes


def buildData2Map(dictionaryData, sasLoop, enclosureName):
    """
    组装字典数据，sasLoop为字典的key，
    :param dictionaryData:
    :param sasLoop:
    :param enclosureName:
    :return:
    """
    enclosureNameList = dictionaryData.get(sasLoop, [])

    enclosureNameList.append(enclosureName)
    dictionaryData[sasLoop] = enclosureNameList




def getSasLoopsDiskTypes(disksInfo, sasLoopsDiskTypes, engineNumber, sasLoopNumber, enclosureName):
    """
    @summary: 获取sas环路的硬盘类型
    @return: 以sas环路(引擎id, sas环路号)为key，该sas环路包含的所有硬盘类型列表为value
    """
    sasLoopsDiskTypes = {}
    sasLoop = (engineNumber, sasLoopNumber)
    for diskInfo in disksInfo:
        diskID = diskInfo.get("ID", "")
        diskType = diskInfo.get("Type", "")
        if not diskType:
            continue

        if enclosureName == diskID.split(".")[0]:
            # 存储sas环路级联深度
            diskTypes = sasLoopsDiskTypes.get(sasLoop, [])
            if diskType not in diskTypes:
                diskTypes.append(diskType)
                sasLoopsDiskTypes[sasLoop] = diskTypes
    
    return sasLoopsDiskTypes




def isHighEnclosure(enclosureType):
    """
    @summary: 检查硬盘框是否为高密框
    """
    if enclosureType == common.OLD_HIGH_ENC_TYPE or  enclosureType == common.NEW_HIGH_ENC_TYPE:
        return True
    
    return False


def getOptimalSasLoopExpansionDepth(productModel, productVersion, sasLoopEnclosureType):
    """
    @summary: 获取最佳的级联深度配置
    """
    if productVersion in ["V500R007C60", "V500R007C60 Kunpeng"]:
        if productModel in ["5310 V5", "5510 V5", "5610 V5", "5810 V5"]:
            return 2
        if productModel in ["5310F V5", "5510F V5", "5610F V5", "5810F V5"]:
            return 1
          
    if productVersion in ["V500R007C00", "V500R007C10", "V500R007C20", "V500R007C30"]:
         if productModel in ["5300F V5", "5500F V5", "5600F V5", "5800F V5", "6800F V5", "18500F V5", "18800F V5"] and not isHighEnclosure(sasLoopEnclosureType):
             return 1
         if productModel in ["5300 V5", "5300 V5 Enhanced", "5500 V5 Elite", "5500 V5", "5600 V5", "5800 V5"]:
             return 2
         if productModel in ["2800 V5"] and not isHighEnclosure(sasLoopEnclosureType):
             return 3
         if productModel in ["6800 V5"] and isHighEnclosure(sasLoopEnclosureType):
             return 2
    
    # 未发现最佳级联深度配置
    return 0


def checkSasLoopExpansionDepth(sasLoopsExpansionDepth, sasLoopsDiskTypes, sasLoopsEnclosures,enclosuresHeight, productModel, productVersion):
    """
    @summary: 检查sas环路下的级联深度是否在推荐的范围内
    @return: errMsg
    """
    global allCliRet
    allErrMsg = ""
    
    for sasLoop in sasLoopsExpansionDepth:
        expansionDepth = int(sasLoopsExpansionDepth.get(sasLoop))
        sasLoopEnclosures = sasLoopsEnclosures.get(sasLoop)
        
        optimalExpansionDepth = getOptimalSasLoopExpansionDepth(productModel, productVersion, sasLoopEnclosures)
        LOGGER.logInfo("SAS loop (%s) expansion depth is %i, optimal expansion depth is %i." % (sasLoopEnclosures, expansionDepth, optimalExpansionDepth))
        if optimalExpansionDepth == 0:
            continue
        
        # 检查级联深度是否在最佳配置范围内
        if expansionDepth > optimalExpansionDepth:
            errMsg = common.getMsg(LANG, "cascading.depth.exceeding.5x10", (sasLoopEnclosures, expansionDepth, optimalExpansionDepth))
            allErrMsg += errMsg
        
    return allErrMsg

 
def getEngineSasPortNumber(cli, productModel, engIds):
    """
    @summary: 获取设备同一引擎下的可用SAS端口数
    """
    global allCliRet    
    engineSasPortNumber = {}
    
    cmd = "show port general physical_type=SAS"
    flag, cliRet, errMsg = cliUtil.excuteCmdInCliMode(cli, cmd, True, LANG)
    allCliRet = common.joinLines(allCliRet, cliRet)
    if flag != True: 
        raise UnCheckException(errMsg, allCliRet)
    
    for engId in engIds:
        portNumber = None
        if productModel in ["5310 V5", "5510 V5", "5610 V5", "5810 V5", "5310F V5","5510F V5","5610F V5", "5810F V5"]:
            aPortRe = re.compile(r"CTE%s\.A\.P\d" % engId)
            bPortRe = re.compile(r"CTE%s\.B\.P\d" % engId)
            aIOMPortRe = re.compile(r"CTE%s\.A\.IOM\d\.P\d" % engId)
            bIOMPortRe = re.compile(r"CTE%s\.B\.IOM\d\.P\d" % engId)
            aPortNum = len(aPortRe.findall(cliRet))
            bPortNum = len(bPortRe.findall(cliRet))
            aPortNumIOM = len(aIOMPortRe.findall(cliRet))
            bPortNumIOM = len(bIOMPortRe.findall(cliRet))
            portNumber = min(aPortNum,bPortNum)  + min(aPortNumIOM, bPortNumIOM)

        if portNumber:
            engineSasPortNumber[engId] = portNumber
       
    return engineSasPortNumber
        

def checkSasLoopBalance(enginesSasLoops, sasLoopsExpansionDepth, sasLoopsDiskTypes, sasLoopsEnclosures, enginesSasPortNumber, enclosuresInfo, productModel, productVersion):
    """
    @summary: 检查引擎下的sas环路是否均衡
              1，若同一引擎下的SAS环路之间的硬盘框级联深度之差大于1（包含SSD盘的SAS、高密框与普通框混插、老高密框与新高密框混插的环路除外），检查结果为建议优化。
              2，若同一引擎下SAS环路号个数小于SAS端口数且存在硬盘框级联深度大于等于2的SAS环路，检查结果为建议优化 。
    """
    allErrMsg = ""

    for engine in enginesSasLoops:
        #循环所有引擎
        engineSasLoops = enginesSasLoops.get(engine)
        if not engineSasLoops:
            continue
        
        # 引擎下是否存在级联深度大于1的环路
        isDepthGreat1 = False
        
        checkedSasLoops = []
        #循环引擎下的环路号
        for engineSasLoop in engineSasLoops:
            sasLoop = (engine, engineSasLoop)
            #获取环路的级联深度
            expansionDepth = sasLoopsExpansionDepth.get(sasLoop)
            if expansionDepth >= 2:
                isDepthGreat1 = True

            #获取环路的硬盘类型
            sasLoopDiskTypes = sasLoopsDiskTypes.get(sasLoop, [])
            
            # 包含SSD盘的SAS环路不检查均衡
            if "SSD" in sasLoopDiskTypes:
                continue
            
            for checkedSasLoop in checkedSasLoops:
                checkedSasLoopDepth = sasLoopsExpansionDepth.get(checkedSasLoop)
                differenceValue = abs(expansionDepth - checkedSasLoopDepth)

                if differenceValue > 1:
                    errMsg = common.getMsg(LANG, "expansion.depth.not.Balance", (int(engine), checkedSasLoop[1], sasLoop[1], differenceValue))
                    LOGGER.logInfo(errMsg)
                    allErrMsg += errMsg
               
            checkedSasLoops.append(sasLoop)
        
        # 引擎下的sas端口数量
        engineSasPortNumber = enginesSasPortNumber.get(engine)
        if engineSasPortNumber is None:
            continue
        # 弱引擎的端口数量为奇数，则报错
        if engineSasPortNumber % 2 != 0:
            errMsg = common.getMsg(LANG, "sas.port.number.abnormal",(engine, engineSasPortNumber))
            LOGGER.logInfo("Engine %s sas port number is %i." % (engine, engineSasPortNumber))
            return (False, errMsg)
        #同一引擎的环路数量
        engineSasLoopNumber = len(engineSasLoops)
        if engineSasLoopNumber == 0:
            continue
        
        LOGGER.logInfo("Engine %s sas port number is %i, sas loop number is %i, expansion depth is great 1:%s." % (engine, engineSasPortNumber, engineSasLoopNumber, str(isDepthGreat1)))
        #引擎下是否存在级联环路大于1的
        if engineSasLoopNumber < engineSasPortNumber and isDepthGreat1:
            errMsg = common.getMsg(LANG, "sasPortNum.greater.than.loopNum", (engine, len(enclosuresInfo), engineSasPortNumber))
            allErrMsg += errMsg
         
    if allErrMsg:
        return (cliUtil.RESULT_WARNING, allErrMsg)
    
    return (True, "") 
                
            
    
    

    
    