# -*- coding: UTF-8 -*-
import cliUtil
import common
import traceback
import re
import config
PY_JAVA_ENV = py_java_env
LANG = common.getLang(PY_JAVA_ENV)
LOGGER = common.getLogger(PY_LOGGER, __file__)

ALL_CLI_RET_LIST = []
RISK_DISK_DEEPTH = ['2', '3', '6', '7']
def execute(cli):
    """
    检查方法
        步骤1 以admin用户登录设备；
        步骤2 执行命令：show controller general |filterColumn include columnList=Controller，查看控制器数量;
        步骤3 执行命令：show disk general |filterColumn include columnList=ID,Manufacturer,Model,Firmware\sVersion|filterRow column=Model predict=match value=SDLL1DLR960G5CHS logicOp=or column=Model predict=match value=SDLL1CLR020T5CHS logicOp=or column=Model predict=match value=SDLL1MLR038T5CHS logicOp=or column=Model predict=match value=SDLL1HLR076T5CHS logicOp=and column=Firmware\sVersion predict=match value=HW08 logicOp=or column=Firmware\sVersion predict=match value=HW07 logicOp=or column=Firmware\sVersion predict=match value=HW05，查询硬盘级联环路信息；
        步骤4 执行命令：show disk general |filterColumn include columnList=ID,Manufacturer,Model,Firmware\sVersion，查询所有硬盘级联深度信息。
    检查标准
        1. 若步骤2中控制器数量小于3则检查结果通过，否则继续向下检查；
        2. 若步骤3中不存在记录则检查结果通过，否则继续向下检查；
        3. 若步骤3中硬盘所在环路，在步骤4中存在级联深度等于2/3/6/7之一，则检查结果为建议优化，否则检查结果通过。
        级联环路及级联深度判断方法如下：DAExyz.a 其中x表示所在引擎，y表示级联环路，z表示级联深度，a表示硬盘所在槽位号。
    修复建议
        若检查结果为建议优化，则说明硬盘固件版本过低，为了提升硬盘健壮性，请联系技术支持工程师协助将硬盘固件版本升级至合适版本。
    :param cli:
    :return:
    """
    try:

        productModel = str(PY_JAVA_ENV.get("devInfo").getDeviceType())
        if productModel not in config.RISK_PRODUCT_MODEL_ODYSSEY_DISK:
            return cliUtil.RESULT_NOSUPPORT, common.version_no_support_msg(
                productModel, "", config.RISK_PRODUCT_MODEL_ODYSSEY_DISK,
                "", LANG), ''

        ctrlNum = getCtrlNum(cli)

        # 若步骤2中控制器数量小于3则检查结果通过
        if ctrlNum < 3:
            return True, "\n".join(ALL_CLI_RET_LIST), ''

        riskDiskLoopList = getDiskExpLoop(cli)
        if not riskDiskLoopList:
            return True, "\n".join(ALL_CLI_RET_LIST), ''

        riskDiskIdList = getRiskDiskExpDeep(cli, riskDiskLoopList)
        if not riskDiskIdList:
            return True, "\n".join(ALL_CLI_RET_LIST), ''

        return cliUtil.RESULT_WARNING, "\n".join(ALL_CLI_RET_LIST), common.getMsg(LANG, "low.fmversion.disk.info", (",".join(riskDiskIdList)))

    except common.UnCheckException, unCheckException:
        LOGGER.logError(str(traceback.format_exc()))
        LOGGER.logInfo("UnCheckException, errMsg: %s" % unCheckException.errorMsg)
        return (cliUtil.RESULT_NOCHECK, unCheckException.cliRet, unCheckException.errorMsg)

    except Exception:
        LOGGER.logError(str(traceback.format_exc()))
        return (cliUtil.RESULT_NOCHECK, "\n".join(ALL_CLI_RET_LIST), common.getMsg(LANG, "query.result.abnormal"))


def getCtrlNum(cli):
    """
    获取控制器数量
    :param cli:
    :return:
    """
    global ALL_CLI_RET_LIST
    cmd = "show controller general |filterColumn include columnList=Controller"
    flag, cliRet, errMsg = cliUtil.excuteCmdInCliMode(cli, cmd, True, LANG)
    ALL_CLI_RET_LIST.append(cliRet)
    if flag!= True:
        raise common.UnCheckException(errMsg, "\n".join(ALL_CLI_RET_LIST))

    regx = re.compile(r"Controller\s*:\s*(\w+)")
    ctrlIdList = regx.findall(cliRet)
    LOGGER.logInfo("find ctrlIdList: %s" % str(ctrlIdList))
    return len(ctrlIdList)


def getDiskExpLoop(cli):
    """
    获取级联环路
    :param cli:
    :return:
    """
    global ALL_CLI_RET_LIST
    diskLoopDict = {}
    cmd = "show disk general |filterColumn include columnList=ID,Manufacturer,Model,Firmware\sVersion|filterRow column=Model predict=match value=SDLL1DLR960G5CHS logicOp=or column=Model predict=match value=SDLL1CLR020T5CHS logicOp=or column=Model predict=match value=SDLL1MLR038T5CHS logicOp=or column=Model predict=match value=SDLL1HLR076T5CHS logicOp=and column=Firmware\sVersion predict=match value=HW08 logicOp=or column=Firmware\sVersion predict=match value=HW07 logicOp=or column=Firmware\sVersion predict=match value=HW05"
    flag, cliRet, errMsg = cliUtil.excuteCmdInCliMode(cli, cmd, True, LANG)
    ALL_CLI_RET_LIST.append(cliRet)
    if flag != True:
        raise common.UnCheckException(errMsg, "\n".join(ALL_CLI_RET_LIST))

    if cliUtil.queryResultWithNoRecord(cliRet):
        return diskLoopDict

    cliRetLinesList = cliUtil.getHorizontalCliRet(cliRet)

    for diskInfo in cliRetLinesList:
        diskId = diskInfo.get("ID")
        if not diskId:
            continue

        regx = re.compile("DAE\w(\w)\w.*")
        retList = regx.findall(diskId)
        for ret in retList:
            diskIdList = diskLoopDict.get(ret, [])
            diskIdList.append(diskId)
            diskLoopDict[ret] = diskIdList

    LOGGER.logInfo("find diskLoopDict: %s" % str(diskLoopDict))
    return diskLoopDict


def getRiskDiskExpDeep(cli, diskLoopDict):
    """
    获取级联环路信息，并判断是否存在风险级联深度。
    :param cli:
    :return:
    """
    global ALL_CLI_RET_LIST
    cmd = "show disk general |filterColumn include columnList=ID,Manufacturer,Model,Firmware\sVersion"
    flag, cliRet, errMsg = cliUtil.excuteCmdInCliMode(cli, cmd, True, LANG)
    ALL_CLI_RET_LIST.append(cliRet)
    if flag != True:
        raise common.UnCheckException(errMsg, "\n".join(ALL_CLI_RET_LIST))

    if cliUtil.queryResultWithNoRecord(cliRet):
        return (True, cliRet, errMsg)

    cliRetLinesList = cliUtil.getHorizontalCliRet(cliRet)

    riskDiskIdList = []
    for diskInfo in cliRetLinesList:
        diskId = diskInfo.get("ID")
        if not diskId:
            continue

        # 获取和风险盘级联环路一样的级联深度，
        regx = re.compile("DAE\w(\w)\w.*")
        retList = regx.findall(diskId)
        if not retList:
            continue

        diskLoop = retList[0]
        if diskLoop in diskLoopDict:
            regx = re.compile("DAE\w\w(\w).*")
            retList = regx.findall(diskId)
            if not retList:
                continue

            deepth = retList[0]
            if deepth in RISK_DISK_DEEPTH:
                riskDiskIdList.extend(diskLoopDict.get(diskLoop))

    return list(set(riskDiskIdList))