# -*- coding: UTF-8 -*-
import cliUtil
import common
import traceback
import config
import decimal
from common import UnCheckException
import cli_util_cache

LANG = common.getLang(py_java_env)
LOGGER = common.getLogger(PY_LOGGER, __file__)
PY_JAVA_ENV = py_java_env
#无热补丁
NO_HOT_PATCH = 0
#当前热补丁版本大于等于问题解决版本
RESOLVED_ISSUE_HOT_PATCH = 1
#当前热补丁版本小于问题解决版本
UN_RESOLVED_ISSUE_HOT_PATCH = 2
#系统盘维保时间为6年（365天/年）
sysDiskShelfLife = 2190

def execute(cli):
    '''
        系统盘剩余寿命检查：
        1、 若设备型号为6800 V3、6800F V3、6900 V3，则检查结果为通过 。
        2、 若步骤4中的系统盘剩余寿命小于等于15%,则检查结果为不通过。
        3、 若步骤4中的系统盘剩余寿命查询不到,则检查结果为通过。
        4、 若步骤8中系统盘寿命大于等于6年且安装对应热补丁，则检查结果为通过，未安装对应热补丁，则检查结果建议优化。
        5、 若步骤10中优化后总剩余寿命大于等于6年且安装对应热补丁，则检查结果为通过，未安装热补丁，则检查结果为不通过。
        6、 若步骤10中优化后总剩余寿命小于6年且未安装对应热补丁，检查结果不通过。
    '''
    flag = True
    cliRet = ""
    allCliRet = ""
    errMsg = ""

    try:
        #查询系统型号，系统当前时间，系统版本，热补丁版本
        common.refreshProcess(PY_JAVA_ENV, 1, LOGGER)
        flag,  product_model, sysDate, cliRet, errMsg = common.getProductModelAndCurSysDate(cli, LANG)
        allCliRet = common.joinLines(allCliRet, cliRet)
        if flag != True:
            return (cliUtil.RESULT_NOCHECK, allCliRet, errMsg)
        #从框架获取设备型号，避免后续OEM场景
        productModel = common.getProductModeFromContext(py_java_env)
        if productModel:
            product_model = str(productModel)
        LOGGER.logInfo("productModel = %s" % product_model)
        #刷新进度条
        common.refreshProcess(PY_JAVA_ENV, 4, LOGGER)
        if not (product_model in config.diskOptimumAsModelMap):
            return (True, allCliRet, errMsg)
        
        #检查是否安装对应热补丁
        flag, result, suggesInstallHotPatch, currentVersion, cliRet, errMsg = checkInstallHotPatch(cli, LANG, product_model)
        LOGGER.logInfo("check patch result:%s ,suggesInstallHotPatch is %s" % (result, suggesInstallHotPatch))
        allCliRet = common.joinLines(allCliRet, cliRet)
        if flag != True:
            return (cliUtil.RESULT_NOCHECK, allCliRet, errMsg)
        
        if currentVersion >= "V300R006C10" or (product_model in config.DORADO_DEVS and currentVersion >= "V300R001C21"):
            return (True, allCliRet, errMsg)
        
        common.refreshProcess(PY_JAVA_ENV, 6, LOGGER)    
        #获取所有控制器的系统盘剩余寿命百分比
        flag, cliRet, contrSysDiskLifePercentageDict = getSysDiskLifeInfo(cli, LANG)
        allCliRet = common.joinLines(allCliRet, cliRet)
        if flag != True:
            #安装对应热补丁，巡检通过。
            if result == RESOLVED_ISSUE_HOT_PATCH:
                return (True, allCliRet, errMsg)
            return (cliUtil.RESULT_NOCHECK, allCliRet, contrSysDiskLifePercentageDict)
        
        common.refreshProcess(PY_JAVA_ENV, 8, LOGGER)
        LOGGER.logInfo("disk remaining life percentage is: %s." % str(contrSysDiskLifePercentageDict))
        
        notPassContrIdList = []
        flagResult = True
        for contrId in contrSysDiskLifePercentageDict:    
            #系统盘寿命<=15%巡检不通过，否则继续检查
            sysDiskLifePercentage = contrSysDiskLifePercentageDict.get(contrId)
            if not sysDiskLifePercentage:
                continue
            
            if sysDiskLifePercentage <= 0.15:
                flagResult = False
                errMsg += common.getMsg(LANG, "remaining.life.of.system.disk.is.too.low", contrId)
                notPassContrIdList.append(contrId)
        
        for contrId in notPassContrIdList:
            del contrSysDiskLifePercentageDict[contrId]
                 
        LOGGER.logInfo("disk remaining life percentage is: %s." % str(contrSysDiskLifePercentageDict))
        
        common.refreshProcess(PY_JAVA_ENV, 30, LOGGER)
        if len(contrSysDiskLifePercentageDict) == 0:
            return (False, allCliRet, errMsg)
        
        #硬盘剩余寿命大于15%，继续检查实际硬盘寿命（天）
        #计算控制器运行时间
        flag, controlRunTimeDict, cliRet, tmp_err = \
            common.getRunningTimeOfControllers(cli, LANG, sysDate, LOGGER)
        errMsg += tmp_err
        allCliRet = common.joinLines(allCliRet, cliRet)
        if flag != True:
            #安装对应热补丁，巡检通过。
            if result == RESOLVED_ISSUE_HOT_PATCH:
                return (True, allCliRet, errMsg)
            return (cliUtil.RESULT_NOCHECK, allCliRet, errMsg)
        LOGGER.logInfo("running time of controllers is %s." % str(controlRunTimeDict))
        
        common.refreshProcess(PY_JAVA_ENV, 35, LOGGER)
        #计算系统盘运行时间（天）
        flag, sysDiskRunTimeDict, cliRet, tmp_err = \
            getSysDiskRunTime(cli, controlRunTimeDict)
        errMsg += tmp_err
        allCliRet = common.joinLines(allCliRet, cliRet)
        if flag != True:
            #安装对应热补丁，巡检通过。
            if result == RESOLVED_ISSUE_HOT_PATCH:
                return (True, allCliRet, errMsg)
            return (cliUtil.RESULT_NOCHECK, allCliRet, errMsg)
        LOGGER.logInfo("system disk running time is %s." % str(sysDiskRunTimeDict))
        
        sysDiskRet = "System disk running time:\n%s" % str(convertListToStr(sysDiskRunTimeDict))
        allCliRet = common.joinLines(allCliRet, sysDiskRet)
        
        common.refreshProcess(PY_JAVA_ENV, 75, LOGGER)
        flagWaring = True
        flagFail = True       
        flagMsg = True
        
        sysDiskLifeDict = {}
        sysDiskLifeEstimationDict = {}       
        for contrId in contrSysDiskLifePercentageDict:
            common.refreshProcess(PY_JAVA_ENV, 85, LOGGER)
            sysDiskLifePercentage = contrSysDiskLifePercentageDict.get(contrId)
            if not sysDiskLifePercentage:
                continue
            
            sysDiskRunTime = sysDiskRunTimeDict.get(contrId, "")
            if not sysDiskRunTime:
                #系统盘运行时间获取不到场景，无控制器上电时间
                LOGGER.logInfo("ContrId:%s not exist Manufactured." % contrId)
                continue
            
            #安装对应热补丁，巡检通过。
            if result == RESOLVED_ISSUE_HOT_PATCH:
                continue
            
            #系统盘运行时间小于等于30天且剩余寿命大于等于99%或者剩余寿命等于100%，未安装对应热补丁场景。检查结果为：建议优化。
            if ((sysDiskRunTime <= 30 and sysDiskLifePercentage >= 0.99) or sysDiskLifePercentage == 1.0) and \
            result == UN_RESOLVED_ISSUE_HOT_PATCH:
                flagWaring = cliUtil.RESULT_WARNING
                #错误消息去重
                if flagMsg == True:
                    flagMsg = False
                    errMsg += common.getMsg(LANG, "sugges.install.the.hot.patch.warning", (suggesInstallHotPatch))
                continue
            
            #系统盘运行时间小于等于30天且剩余寿命大于等于99%或者剩余寿命等于100%，无热补丁场景。检查结果为：通过。
            if ((sysDiskRunTime <= 30 and sysDiskLifePercentage >= 0.99) or sysDiskLifePercentage == 1.0) and \
            result == NO_HOT_PATCH:
                continue
            
            if sysDiskLifePercentage == 1.0:
                continue
            
            #计算系统盘实际寿命
            sysDiskLife = getSysDiskLife(sysDiskRunTime, sysDiskLifePercentage)
            LOGGER.logInfo("ContrId:%s ,sysDiskLife is %s" % (contrId, str(sysDiskLife)))
            sysDiskLifeDict[contrId] = sysDiskLife
            
            #估算安装补丁后系统盘寿命    
            sysDiskLifeEstimation = getSysDiskLifeForInstalPatch(product_model, sysDiskRunTime, sysDiskLifePercentage)
            LOGGER.logInfo("Controller [%s] estimation system disk residual life is %s." %\
                            (contrId,sysDiskLifeEstimation))
            sysDiskLifeEstimationDict[contrId] = sysDiskLifeEstimation
                
            #系统盘寿命大于等于6年
            if sysDiskLife >= sysDiskShelfLife:
                if result == UN_RESOLVED_ISSUE_HOT_PATCH:
                    flagWaring = cliUtil.RESULT_WARNING
                    #错误消息去重
                    if flagMsg == True:
                        flagMsg = False
                        errMsg += common.getMsg(LANG, "sugges.install.the.hot.patch.warning", (suggesInstallHotPatch))
            
            if sysDiskLife < sysDiskShelfLife:
                #系统盘寿命小于6年且无补丁，建议优化（建议升级系统软件到最新推荐的版本）！
                if result == NO_HOT_PATCH:
                    flagWaring = cliUtil.RESULT_WARNING
                    #错误消息去重
                    if flag == True:
                        flag = False
                        errMsg += common.getMsg(LANG, "contact.technical.support.engineers")
                    continue
                
                #系统盘寿命小于6年未安装对应热补丁，控制器[%s]的系统盘使用率策略需要优化, 建议安装%s或之后版本热补丁。
                if result == UN_RESOLVED_ISSUE_HOT_PATCH:
                    flagFail = False
                    errMsg += common.getMsg(LANG, "sugges.install.the.hot.patch", (contrId, suggesInstallHotPatch))
        
        #构造系统盘剩余寿命到原始信息中
        if sysDiskLifeDict:
            sysDiskRet = "System disk info:\n%s" % str(convertListToStr(sysDiskLifeDict))
            allCliRet = common.joinLines(allCliRet, sysDiskRet)
        
        #构造系统盘预估剩余寿命到原始信息中    
        if sysDiskLifeEstimationDict:
            sysDiskRet = "-----------------\n%s" % str(convertListToStr(sysDiskLifeEstimationDict))
            allCliRet = common.joinLines(allCliRet, sysDiskRet)
        
        if (not flagResult) or (not flagFail):
            return (False, allCliRet, errMsg)
        
        return (flagWaring, allCliRet, errMsg)

    except UnCheckException as unCheckException:
        LOGGER.logInfo("UnCheckException: %s" % unCheckException.errorMsg)
        return (cliUtil.RESULT_NOCHECK, allCliRet + unCheckException.cliRet,
                unCheckException.errorMsg)

    except Exception:
        LOGGER.logError(str(traceback.format_exc()))
        return (cliUtil.RESULT_NOCHECK, allCliRet, common.getMsg(LANG, "query.result.abnormal"))

def getSystemDiskServiceLife(sysDiskinfoDict, sysDiskLifeInfoDictList):
    '''
    @summary: 获取系统盘剩余寿命百分比
    @param SysDiskinfoDict: 系统盘信息字典
    @param SysDiskLifeInfoDictList: 系统盘剩余寿命信息字典列表
    @return sysDiskLifePercentage：系统盘剩余寿命百分比
    '''
    #风险系统盘序列号列表
    riskSerialNumberList = ["FK001312142",
                           "FN001310053",
                           "FN021501169",
                           "FS001411132",
                           "FS021411097",
                           "FS021411210",
                           "FZ001311085",
                           "FZ021401085",
                           "FZ021402067",
                           "FZ021407135",
                           "FZ021408071",
                           "FZ021408094",
                           "FZ021409046",
                           "FZ021410016",
                           "FZ021410046",
                           ]
    #记忆科技
    MEMORY_TECHNOLOGY_TYPE = "RTMMA"
    deviceModel = sysDiskinfoDict.get("Device Model", "")
    firmwareVersion = sysDiskinfoDict.get("Firmware Version", "")
    serialNumber = sysDiskinfoDict.get("Serial Number", "")
    
    sysDiskLifePercentage = ""
    for sysDiskLifeInfoDict in sysDiskLifeInfoDictList:
        id = sysDiskLifeInfoDict.get("ID#", "")
        value = sysDiskLifeInfoDict.get("VALUE", "")
        raw_value = sysDiskLifeInfoDict.get("RAW_VALUE", "")
        
        #记忆科技系统盘寿命   
        if deviceModel.startswith(MEMORY_TECHNOLOGY_TYPE):
            if firmwareVersion == "A12" and serialNumber[:11] in riskSerialNumberList:
                if id == "173" and raw_value:
                    raw_value = int(raw_value)
                    sysDiskLifePercentage =  1 - float(int(hex(raw_value)[-4:-1], 16))/float(3000)
                    break
                continue
                
            else:
                if id == "231" and value:
                    sysDiskLifePercentage = float(decimal.Decimal(value)/100)
                    break
                continue
            
        #其他类型系统盘寿命    
        if id == "231" and value:
            LOGGER.logInfo("value is: %s" % value)
            sysDiskLifePercentage = float(decimal.Decimal(value)/100)
            break
            
    return sysDiskLifePercentage   

def getDiskRunTime2EngMaxDict(cli, lang): 
    '''
    @summary: 计算引擎下的硬盘最大运行时间（天）
    @return diskRunTime2EngMaxDict: 引擎下的硬盘最大运行时间
           计算规则：每个引擎最大查询25块盘（不满足25则全部查询），
           如果单个引擎内有201块盘，则一次查询行数8,16,24,32,…:间隔数为单个引擎盘数量/25向下取余
    '''
    allCliRet = ""
    diskRunTime2EngMaxDict = {}

    diskInfoDictList, cli_ret = cli_util_cache.get_disk_general_cache(
        py_java_env, cli, LOGGER)
    allCliRet += common.joinLines(allCliRet, cli_ret)

    diskIdList = []
    diskIdListForEngDict = {}
    for diskInfoDict in diskInfoDictList:
        diskId = diskInfoDict.get("ID","")
        if diskId:
            engId = diskId.split(".")[0][3]
            diskIdList = diskIdListForEngDict.get(engId, [])
            diskIdList.append(diskId)
            diskIdListForEngDict[engId] = diskIdList
    
    #每个引擎下获取随机25块硬盘详情
    LOGGER.logInfo("diskIdListForEngDict = %s" % (str(diskIdListForEngDict)))     
    for engId in diskIdListForEngDict:
        diskIdList = diskIdListForEngDict[engId]
        if len(diskIdList) <= 25:
            runTimeMax = common.getDiskLife(cli, LANG, diskIdList, LOGGER)
            diskRunTime2EngMaxDict.setdefault(engId, runTimeMax)
            continue
        
        quotient = len(diskIdList)/25
        LOGGER.logInfo("quotient = %s" % (str(quotient)))
        #取前25块盘
        temList = diskIdList[::quotient][:25]
        runTimeMax = common.getDiskLife(cli, LANG, temList, LOGGER)
        diskRunTime2EngMaxDict.setdefault(engId, runTimeMax)
        LOGGER.logInfo("engId: %s , before 25 hard disks:%s" % (str(engId), str(diskRunTime2EngMaxDict)))
        
    sysDiskRet = "Maximum running duration of disks in engines:\n%s" % str(convertListToStr(diskRunTime2EngMaxDict))
    allCliRet = common.joinLines(allCliRet, sysDiskRet)
    
    LOGGER.logInfo("diskRunTime2EngMaxDict = %s" % (str(diskRunTime2EngMaxDict)))        
    return (True, allCliRet, diskRunTime2EngMaxDict, '')
 
def getSysDiskRunTime(cli, controlRunTimeDict):    
    '''
    @summary: 计算系统盘运行时间（天）
    @param controlRunTimeDict: 控制器运行时间
    @return sysDiskRunTimeDict: 系统盘运行时间
    '''
    allCliRet = ""
    sysDiskRunTimeDict = {}
    
    #获取引擎下的硬盘最大运行时间
    flag, cliRet, diskRunTime2EngMaxDict, errMsg = getDiskRunTime2EngMaxDict(cli, LANG)
    allCliRet = common.joinLines(allCliRet, cliRet)
    if flag != True:
        return (flag, sysDiskRunTimeDict, allCliRet, errMsg) 
    
    for engId in diskRunTime2EngMaxDict:
        diskRunTime2Eng = diskRunTime2EngMaxDict[engId]
        
        for controlId in controlRunTimeDict:
            controlRunTime = controlRunTimeDict[controlId]
            
            if controlId[0] == engId:
                sysDiskRunTime = int(min(diskRunTime2Eng, controlRunTime))
                
                sysDiskRunTimeDict.setdefault(controlId, sysDiskRunTime)
                
    return (True, sysDiskRunTimeDict, allCliRet, errMsg) 

def getSysDiskLife(sysDiskRunTime, sysDiskLifePercentage):    
    '''
    @summary: 计算系统盘实际寿命（天）
    @param controlId: 控制器ID
    @param sysDiskRunTimeDict: 系统盘运行时间（天）
    @param sysDiskLifePercentage: 系统盘已经使用寿命百分比
    @return sysDiskLife: 系统盘实际寿命
    ''' 
    
    sysDiskLife = int(0.9/(1-sysDiskLifePercentage)*sysDiskRunTime)
    
    return sysDiskLife  
  
def getSysDiskLifeForInstalPatch(product_model, sysDiskRunTime, sysDiskLifePercentage):   
    '''
    @summary: 估算安装补丁系统盘寿命（天）
    @param sysDiskRunTimeDict: 系统盘运行时间
    @param sysDiskLifePercentage: 系统盘剩余寿命百分比
    @return flag: 是否查询成功
            : 控制器ID，控制器运行时间字典
            allCliRet: CLI回显
            errMsg: 错误消息
    eg: 当前已经消耗60%，运行时间300天，优化比20；优化后总寿命=300 + （0.85-0.6）*20/(0.6/300) = 300 + 2500 = 2800
    '''
    optimum = int(getDiskOptimum(product_model))
    
    LOGGER.logInfo("sysDiskRunTime=%s,sysDiskLifePercentage= %s,optimum=%s" % \
                   (sysDiskRunTime, sysDiskLifePercentage, optimum))
    sysDiskLifeEstimation = \
    sysDiskRunTime + (0.9-(1-sysDiskLifePercentage))*optimum/((1-sysDiskLifePercentage)/sysDiskRunTime)
    
    return int(sysDiskLifeEstimation) 
    
def getDiskOptimum(product_model):    
    '''
    @summary: 获取硬盘优化比
    @param product_model: 设备型号
    @return diskOptimum: 硬盘优化比
    '''
    
    diskOptimum = config.diskOptimumAsModelMap.get(product_model)
     
    return diskOptimum
 
def getSysDiskLifeInfo(cli, LANG):
    '''
    @summary: 获取所有控制器的系统盘剩余寿命百分比
    @param cli: cli对象
    @param lang: 语言lang
    @param contrIdList: 控制器列表
    @return flag: 是否查询成功
            : 控制器ID，控制器运行时间字典
            allCliRet: CLI回显
            errMsg: 错误消息
    '''
    allCliRet = ""
    contrSysDiskLifeDict = {}
    try:

        #获取引擎和管理IP关系，用于建立SSH通道
        flag, cliRet, errMsg, ipListDict = common.getContrIpListOfEngine(cli, LANG)
        if flag != True:
            return (cliUtil.RESULT_NOCHECK, cliRet, errMsg)

        flag, cliRet, engNodeInfoList = common.getEngNodeInfo(cli, LANG)
        allCliRet = common.joinLines(allCliRet, cliRet)
        if flag != True:
            return (cliUtil.RESULT_NOCHECK, allCliRet, engNodeInfoList)

        LOGGER.logInfo("engNodeInfoList is: %s." % str(engNodeInfoList))
        currentNodeId = ""
        eng_dict = {}
        for engNodeInfo in engNodeInfoList:
            if "currentNodeId" in engNodeInfo:
                currentNodeId = int(engNodeInfo.get("currentNodeId"))
                continue

            eng_dict.update(engNodeInfo)
        engineNum = len(eng_dict)
        currentNodeIdList = []
        currentEngId = ""
        for engId in eng_dict:
            if currentNodeId in eng_dict[engId]:
                #获取当前连接引擎的节点ID列表
                currentNodeIdList = eng_dict[engId]
                currentEngId = engId
                break

        LOGGER.logInfo("currentNodeId is: %s" % str(currentNodeId))

        #当前引擎场景
        flag, cliRet, disk_life_dict = geSysDiskLifeForSingleEnginfo(
            cli, LANG, currentNodeIdList, currentNodeId)
        allCliRet = common.joinLines(allCliRet, cliRet)
        if flag != True:
            return (flag, allCliRet, disk_life_dict)

        LOGGER.logInfo("contrSysDiskLifeFistDict is: %s" % str(disk_life_dict))
        if engineNum == 1:
            return (flag, allCliRet, disk_life_dict)

        #多引擎环境需要连接到每个引擎上的控制器进行检查
        ctrl_other_dict = {}

        for eng_id in eng_dict:
            if currentEngId == eng_id:
                continue

            node_id_List = eng_dict[eng_id]

            info_tuple = common.getEngineCtrlNodeInfo(
                cli, LOGGER, LANG)
            flag, ret, msg, new_cli, exits = common.enginesJump(cli,
                                                                eng_id,
                                                                info_tuple[5],
                                                                info_tuple[3],
                                                                info_tuple[6],
                                                                PY_JAVA_ENV,
                                                                LOGGER,
                                                                LANG,
                                                                info_tuple[4])

            allCliRet = common.joinLines(allCliRet, ret)
            if flag is not True:
                raise UnCheckException(msg, allCliRet)

            try:
                flag, cliRet, ctrl_other_dict = geSysDiskLifeForSingleEnginfo(
                    new_cli, LANG, node_id_List)
                allCliRet = common.joinLines(allCliRet, cliRet)
            except UnCheckException, unCheckException:
                raise UnCheckException(unCheckException.errorMsg, allCliRet)
            finally:
                common.enginesBack(new_cli, PY_JAVA_ENV, LOGGER, LANG, exits)
                LOGGER.logInfo("exit heart beat. engid:%s" % eng_id)

            LOGGER.logInfo("other dict is: %s" % str(ctrl_other_dict))
            if flag is not True:
                LOGGER.logError('This engine(Engine number:' + unicode(
                    engId) + '), check not PASS, check finished.')
                return (flag, allCliRet, ctrl_other_dict)

        contrSysDiskLifeDict = dict(disk_life_dict,
                                    **ctrl_other_dict)
        LOGGER.logInfo("Remaining Life successfully obtained")
        return (flag, allCliRet, contrSysDiskLifeDict)

    except UnCheckException, unCheckException:
        raise UnCheckException(unCheckException.errorMsg, allCliRet)
    except:
        LOGGER.logError("Failed disk %s" % str(traceback.format_exc()))
        return (False, allCliRet, contrSysDiskLifeDict)
    
    finally:
        cliUtil.enterCliModeFromSomeModel(cli, LANG)
        
def geSysDiskLifeForSingleEnginfo(cli, lang, nodeIdList, currentNodeId = None):
    '''
    @summary: 获取单个引擎下控制器的系统盘剩余寿命百分比
    @param cli: cli对象
    @param lang: 语言lang
    @param currentNodeId: 当前控制器节点ID
    @param nodeIdList: 控制器节点列表  eg：["0","1"]
    @return flag: 是否查询成功
            : 控制器ID，控制器运行时间字典
            allCliRet: CLI回显
            errMsg: 错误消息
    '''
    allCliRet = ""
    contrSysDiskLifeDict = {}
    if currentNodeId is None:
        flag, cliRet, currentNodeId = common.getCurrentNodeId(cli,lang)
        allCliRet = common.joinLines(allCliRet, cliRet)
        if flag != True:
            return (flag, cliRet, currentNodeId)
        LOGGER.logInfo("currentNodeIdOtherEng is %s" % str(currentNodeId))
                   
    flag, cliRet, sysDiskLifePercentage, errMsg = getSingleEnginfo(cli, lang)
    allCliRet = common.joinLines(allCliRet, cliRet)
    if flag != True:         
        return (flag, allCliRet, errMsg)
        
    contrId = common.nodeId2controlId(int(currentNodeId))
    contrSysDiskLifeDict.setdefault(contrId, sysDiskLifePercentage)
    
    LOGGER.logInfo("contrSysDiskLifeDict is %s" % str(contrSysDiskLifeDict))
    #心跳到对端查询系统盘剩余寿命
    LOGGER.logInfo("nodeIdList is %s" % str(nodeIdList))
    for nodeId in nodeIdList:
        #除去当前节点
        if int(nodeId) == int(currentNodeId):
            continue
        
        LOGGER.logInfo("Other nodeId is %s" % str(nodeId))
        contrId = common.nodeId2controlId(int(nodeId))
        flag, cliRet, errMsg = common.heartBeatToOtherCtrl(cli, nodeId, PY_JAVA_ENV, LOGGER, LANG)
        allCliRet = common.joinLines(allCliRet, cliRet)
        if flag != True:
            return (flag, allCliRet, errMsg)
        
        try:
            flag, cliRet, sysDiskLifePercentage, errMsg = getSingleEnginfo(cli, lang)
            allCliRet = common.joinLines(allCliRet, cliRet)
            if flag != True:
                return (flag, allCliRet, errMsg)
            contrSysDiskLifeDict.setdefault(contrId, sysDiskLifePercentage)
        except:
            LOGGER.logError("Failed to obtain the percentage of the remaining life of the system disk %s" % str(traceback.format_exc()))
            errMsg = common.getMsg(lang, "cannot.get.info", {"zh":u"系统盘", "en":"system disk"}.get(lang))
            return (False, allCliRet, errMsg)
        finally:
            LOGGER.logInfo("exit to node that SmartKit connection.")
            cliUtil.exitHeartbeatCli(cli, lang)
            
    return (flag, allCliRet, contrSysDiskLifeDict)

def getSingleEnginfo(cli, lang):
    '''
    @summary: 获取引擎下单个控制器的剩余寿命百分比
    @param cli: cli对象
    @param lang: 语言lang
    @param contrIdList: 控制器列表
    @return flag: 是否查询成功
            : 控制器ID，控制器运行时间字典
            allCliRet: CLI回显
            errMsg: 错误消息
    '''
    allCliRet = ""
    #风险系统盘符列表
    sysDiskLifePercentage = ""
    riskDiskList = ["/dev/sda","/dev/sdb"]       
    cmd = "disktool -s"
    
    flag, cliRet, errMsg = cliUtil.excuteCmdInMinisystemModel(cli, cmd, lang)
    allCliRet = common.joinLines(allCliRet, cliRet)
    if flag != True:         
        return (flag, allCliRet, sysDiskLifePercentage, errMsg)
        
    infoDictList = cliUtil.getCliRetDictForMinisystem(cliRet)
    if not infoDictList:
        return (flag, allCliRet, sysDiskLifePercentage, errMsg)
    
    sysDiskIdList = []
    for infoDict in infoDictList:
        deviceID = infoDict.get("Device","")
        if deviceID in riskDiskList:
            sysDiskIdList.append(deviceID)
            
    LOGGER.logInfo("deviceIdList is %s" % str(sysDiskIdList))
    #判断系统盘盘场景
    if len(sysDiskIdList) == 0:
        errMsg = common.getMsg(lang, "cannot.get.info", {"zh":u"系统盘", "en":"system disk"}.get(lang))
        return (False, allCliRet, sysDiskLifePercentage, errMsg)
           
    sysDiskLifePercentageList = []
    sysDiskinfoDict = {}
    sysDiskLifeInfoDictList = []
    for deviceId in sysDiskIdList:
        #查询系统盘剩余寿命详情
        cmd =  "disktool -S s %s" % deviceId
        flag, cliRet, errMsg = cliUtil.excuteCmdInMinisystemModel(cli, cmd, lang)
        allCliRet = common.joinLines(allCliRet, cliRet)
        if flag != True:         
            return (flag, allCliRet, sysDiskLifePercentage, errMsg)
        sysDiskLifeInfoDictList = cliUtil.getCliRetDictForMinisystem(cliRet)
        
        cmd = "disktool -f i %s" % deviceId
        flag, cliRet, errMsg = cliUtil.excuteCmdInMinisystemModel(cli, cmd, lang)
        allCliRet = common.joinLines(allCliRet, cliRet)
        if flag != True:         
            return (flag, allCliRet, sysDiskLifePercentage, errMsg)
        sysDiskinfoDict = cliUtil.getCliRetDict(cliRet)
        
        
    LOGGER.logInfo("sysDiskinfoDict = %s ,sysDiskLifeInfoDictList = %s" % (sysDiskinfoDict, sysDiskLifeInfoDictList))            
    sysDiskLifePercentage = getSystemDiskServiceLife(sysDiskinfoDict, sysDiskLifeInfoDictList)
    sysDiskLifePercentageList.append(sysDiskLifePercentage)
    
    #取系统盘最小剩余寿命                  
    sysDiskLifePercentage = min(sysDiskLifePercentageList)
    LOGGER.logInfo("system disk minimum residual life is %s." % sysDiskLifePercentage)
    
    return (True, allCliRet, sysDiskLifePercentage, errMsg)    
        
def checkInstallHotPatch(cli, LANG, product_model):
    """
    @summary: 检查是否安装已解决问题热补丁
    @return: (flag, result, suggesInstallHotPatch, cliRet ,errMsg)
        flag:
            True: 命令执行成功
            False: 命令执行失败
        result: 
            0: 无解决问题热补丁
            1: 当前热补丁版本大于等于问题解决版本
            2: 当前热补丁版本小于问题解决版本
        cliRet：CLI回文
        errMsg：错误信息
    """
    cliRet = ""
    #正常V3版本补丁配套关系
    riskFreeHotPatchDict = {"V300R005C00SPC300":"V300R005C00SPH306",
                            "V300R006C00SPC100":"V300R006C00SPH105",
                            "V300R003C10SPC100":"V300R003C10SPH115",
                            "V300R001C20SPC200":"V300R001C20SPH208",
                            "V300R003C20SPC200":"V300R003C20SPH208",
                            }
    
    #Dorado V3 版本补丁配套关系
    riskFreeHotPatchDoradoV3Dict = {"V300R001C01SPC100":"V300R001C01SPH101",
                                    "V300R001C00SPC100":"V300R001C00SPH101",
                                    }
    #获取设备当前产品版本和补丁信息
    currentVersion = ""
    suggesInstallHotPatch = ""
    checkRet, currentVersionDictList, hotPatchVersionDictList = common.parse_upgradePackage(cli, LANG)
    cliRet += checkRet[1]
    if checkRet[0] != True:
        LOGGER.logSysAbnormal()
        return (checkRet[0], "", suggesInstallHotPatch, currentVersion, cliRet, checkRet[2])
    
    flag, currentVersion, errMsg = common.getCurrentVersion(currentVersionDictList, LANG)
    if not flag:
        return (flag, "", suggesInstallHotPatch, currentVersion, cliRet, errMsg)
    
    flag, curHotPatchVer, errMsg = common.getCurrentVersion(hotPatchVersionDictList, LANG)
    if not flag:
        return (False, "", suggesInstallHotPatch, currentVersion, cliRet, errMsg)
    
    if product_model in config.DORADO_DEVS:
        suggesInstallHotPatch = riskFreeHotPatchDoradoV3Dict.get(currentVersion)
    else:    
        suggesInstallHotPatch = riskFreeHotPatchDict.get(currentVersion)
    if not suggesInstallHotPatch:
        return  (True, NO_HOT_PATCH, suggesInstallHotPatch, currentVersion, cliRet, errMsg)
    
    if curHotPatchVer >= suggesInstallHotPatch and curHotPatchVer != "--":
        return (True, RESOLVED_ISSUE_HOT_PATCH, suggesInstallHotPatch, currentVersion, cliRet, errMsg)
        
    return (True, UN_RESOLVED_ISSUE_HOT_PATCH, suggesInstallHotPatch, currentVersion, cliRet, errMsg)


def convertListToStr(info):
    """
    @summary: 将字典或列表转换为可视化回文内容
    """
    if type(info) == list:
        return '\n'.join([str(element) for element in info])
    
    elif type(info) == dict:
        return '\n'.join([ "%s : %s"% (key, info[key]) for key in info])
    
    else:
        return str(info).replace("u", '')
    